/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.event.job;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.event.job.AbstractEvent;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.util.StringUtils;

public class JobEvent
extends AbstractEvent {
    private static final long serialVersionUID = 1846424770472758893L;
    private JobStatus currentJobStatus;
    private String optionalMessage;

    public JobEvent(long timestamp, JobStatus currentJobStatus, String optionalMessage) {
        super(timestamp);
        this.currentJobStatus = currentJobStatus;
        this.optionalMessage = optionalMessage;
    }

    public JobEvent() {
        this.currentJobStatus = JobStatus.CREATED;
    }

    public JobStatus getCurrentJobStatus() {
        return this.currentJobStatus;
    }

    public String getOptionalMessage() {
        return this.optionalMessage;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.currentJobStatus = JobStatus.values()[in.readInt()];
        this.optionalMessage = StringUtils.readNullableString((DataInputView)in);
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        out.writeInt(this.currentJobStatus.ordinal());
        StringUtils.writeNullableString((String)this.optionalMessage, (DataOutputView)out);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof JobEvent) {
            JobEvent other = (JobEvent)obj;
            return super.equals(other) && this.currentJobStatus == other.currentJobStatus && this.optionalMessage == null ? other.optionalMessage == null : other.optionalMessage != null && this.optionalMessage.equals(other.optionalMessage);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return JobEvent.timestampToString(this.getTimestamp()) + ":\tJob execution switched to status " + (Object)((Object)this.currentJobStatus);
    }
}

