/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.event.job;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.event.job.AbstractEvent;
import org.apache.flink.runtime.event.job.ManagementEvent;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public final class ExecutionStateChangeEvent
extends AbstractEvent
implements ManagementEvent {
    private static final long serialVersionUID = 1L;
    private JobVertexID vertexId;
    private int subtask;
    private ExecutionAttemptID executionAttemptId;
    private ExecutionState newExecutionState;

    public ExecutionStateChangeEvent(long timestamp, JobVertexID vertexId, int subtask, ExecutionAttemptID executionAttemptId, ExecutionState newExecutionState) {
        super(timestamp);
        Preconditions.checkNotNull((Object)vertexId);
        Preconditions.checkArgument((subtask >= 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)executionAttemptId);
        Preconditions.checkNotNull((Object)((Object)newExecutionState));
        this.vertexId = vertexId;
        this.subtask = subtask;
        this.executionAttemptId = executionAttemptId;
        this.newExecutionState = newExecutionState;
    }

    public ExecutionStateChangeEvent() {
        this.vertexId = new JobVertexID();
        this.executionAttemptId = new ExecutionAttemptID();
        this.newExecutionState = ExecutionState.CREATED;
    }

    public JobVertexID getVertexId() {
        return this.vertexId;
    }

    public int getSubtaskIndex() {
        return this.subtask;
    }

    public ExecutionAttemptID getExecutionAttemptID() {
        return this.executionAttemptId;
    }

    public ExecutionState getNewExecutionState() {
        return this.newExecutionState;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.vertexId.read(in);
        this.executionAttemptId.read(in);
        this.subtask = in.readInt();
        this.newExecutionState = ExecutionState.values()[in.readInt()];
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        this.vertexId.write(out);
        this.executionAttemptId.write(out);
        out.writeInt(this.subtask);
        out.writeInt(this.newExecutionState.ordinal());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ExecutionStateChangeEvent) {
            ExecutionStateChangeEvent other = (ExecutionStateChangeEvent)obj;
            return other.newExecutionState == this.newExecutionState && other.executionAttemptId.equals(this.executionAttemptId) && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ 127 * this.newExecutionState.ordinal() ^ this.executionAttemptId.hashCode();
    }

    @Override
    public String toString() {
        return String.format("ExecutionStateChangeEvent %d at %d , executionAttempt=%s, newState=%s", new Object[]{this.getSequenceNumber(), this.getTimestamp(), this.executionAttemptId, this.newExecutionState});
    }
}

