/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.jobgraph.JobID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlobConnection
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(BlobConnection.class);
    private final Socket clientSocket;
    private final BlobServer blobServer;

    BlobConnection(Socket clientSocket, BlobServer blobServer) {
        super("BLOB connection for " + clientSocket.getRemoteSocketAddress().toString());
        this.clientSocket = clientSocket;
        this.blobServer = blobServer;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[UNCONDITIONALDOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void get(InputStream inputStream, OutputStream outputStream, byte[] buf) throws IOException {
        File blob = null;
        int contentAdressable = inputStream.read();
        if (contentAdressable < 0) {
            throw new EOFException("Expected GET header");
        }
        if (contentAdressable == 0) {
            BlobServer.readFully(inputStream, buf, 0, 16);
            ByteBuffer bb = ByteBuffer.wrap(buf);
            JobID jobID = JobID.fromByteBuffer(bb);
            String key = BlobConnection.readKey(buf, inputStream);
            blob = this.blobServer.getStorageLocation(jobID, key);
        } else {
            BlobKey key = BlobKey.readFromInputStream(inputStream);
            blob = this.blobServer.getStorageLocation(key);
        }
        if (!blob.exists()) {
            BlobServer.writeLength(-1, buf, outputStream);
            return;
        }
        BlobServer.writeLength((int)blob.length(), buf, outputStream);
        FileInputStream fis = null;
        try {
            int read;
            fis = new FileInputStream(blob);
            while ((read = fis.read(buf)) >= 0) {
                outputStream.write(buf, 0, read);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(InputStream inputStream, OutputStream outputStream, byte[] buf) throws IOException {
        JobID jobID = null;
        String key = null;
        MessageDigest md = null;
        int contentAdressable = inputStream.read();
        if (contentAdressable < 0) {
            throw new EOFException("Expected PUT header");
        }
        if (contentAdressable == 0) {
            BlobServer.readFully(inputStream, buf, 0, 16);
            ByteBuffer bb = ByteBuffer.wrap(buf);
            jobID = JobID.fromByteBuffer(bb);
            key = BlobConnection.readKey(buf, inputStream);
        } else {
            md = BlobUtils.createMessageDigest();
        }
        File incomingFile = null;
        FileOutputStream fos = null;
        try {
            int bytesExpected;
            incomingFile = this.blobServer.getTemporaryFilename();
            fos = new FileOutputStream(incomingFile);
            do {
                if ((bytesExpected = BlobServer.readLength(buf, inputStream)) > 4096) {
                    throw new IOException("Unexpected number of incoming bytes: " + bytesExpected);
                }
                BlobServer.readFully(inputStream, buf, 0, bytesExpected);
                fos.write(buf, 0, bytesExpected);
                if (md == null) continue;
                md.update(buf, 0, bytesExpected);
            } while (bytesExpected >= 4096);
            fos.close();
            fos = null;
            if (contentAdressable == 0) {
                File storageFile = this.blobServer.getStorageLocation(jobID, key);
                incomingFile.renameTo(storageFile);
                incomingFile = null;
            } else {
                BlobKey blobKey = new BlobKey(md.digest());
                File storageFile = this.blobServer.getStorageLocation(blobKey);
                incomingFile.renameTo(storageFile);
                incomingFile = null;
                blobKey.writeToOutputStream(outputStream);
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (incomingFile != null) {
                incomingFile.delete();
            }
        }
    }

    private void delete(InputStream inputStream, byte[] buf) throws IOException {
        BlobServer.readFully(inputStream, buf, 0, 16);
        ByteBuffer bb = ByteBuffer.wrap(buf);
        JobID jobID = JobID.fromByteBuffer(bb);
        String key = null;
        int r = inputStream.read();
        if (r < 0) {
            throw new EOFException();
        }
        if (r > 0) {
            key = BlobConnection.readKey(buf, inputStream);
            File blob = this.blobServer.getStorageLocation(jobID, key);
            blob.delete();
        } else {
            this.blobServer.deleteJobDirectory(jobID);
        }
    }

    static void closeSilently(Socket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String readKey(byte[] buf, InputStream inputStream) throws IOException {
        int keyLength = BlobServer.readLength(buf, inputStream);
        if (keyLength > 64) {
            throw new IOException("Unexpected key length " + keyLength);
        }
        BlobServer.readFully(inputStream, buf, 0, keyLength);
        return new String(buf, 0, keyLength, BlobUtils.DEFAULT_CHARSET);
    }
}

