/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateDBInstanceReadReplicaRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String dBInstanceIdentifier;
    private String sourceDBInstanceIdentifier;
    private String dBInstanceClass;
    private String availabilityZone;
    private Integer port;
    private Boolean autoMinorVersionUpgrade;
    private Integer iops;
    private String optionGroupName;
    private Boolean publiclyAccessible;
    private ListWithAutoConstructFlag<Tag> tags;
    private String dBSubnetGroupName;

    public CreateDBInstanceReadReplicaRequest() {
    }

    public CreateDBInstanceReadReplicaRequest(String dBInstanceIdentifier, String sourceDBInstanceIdentifier) {
        this.setDBInstanceIdentifier(dBInstanceIdentifier);
        this.setSourceDBInstanceIdentifier(sourceDBInstanceIdentifier);
    }

    public String getDBInstanceIdentifier() {
        return this.dBInstanceIdentifier;
    }

    public void setDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
    }

    public CreateDBInstanceReadReplicaRequest withDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
        return this;
    }

    public String getSourceDBInstanceIdentifier() {
        return this.sourceDBInstanceIdentifier;
    }

    public void setSourceDBInstanceIdentifier(String sourceDBInstanceIdentifier) {
        this.sourceDBInstanceIdentifier = sourceDBInstanceIdentifier;
    }

    public CreateDBInstanceReadReplicaRequest withSourceDBInstanceIdentifier(String sourceDBInstanceIdentifier) {
        this.sourceDBInstanceIdentifier = sourceDBInstanceIdentifier;
        return this;
    }

    public String getDBInstanceClass() {
        return this.dBInstanceClass;
    }

    public void setDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
    }

    public CreateDBInstanceReadReplicaRequest withDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public CreateDBInstanceReadReplicaRequest withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public CreateDBInstanceReadReplicaRequest withPort(Integer port) {
        this.port = port;
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public CreateDBInstanceReadReplicaRequest withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        return this;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Integer getIops() {
        return this.iops;
    }

    public void setIops(Integer iops) {
        this.iops = iops;
    }

    public CreateDBInstanceReadReplicaRequest withIops(Integer iops) {
        this.iops = iops;
        return this;
    }

    public String getOptionGroupName() {
        return this.optionGroupName;
    }

    public void setOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
    }

    public CreateDBInstanceReadReplicaRequest withOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
        return this;
    }

    public Boolean isPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public void setPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    public CreateDBInstanceReadReplicaRequest withPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
        return this;
    }

    public Boolean getPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public CreateDBInstanceReadReplicaRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public CreateDBInstanceReadReplicaRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String getDBSubnetGroupName() {
        return this.dBSubnetGroupName;
    }

    public void setDBSubnetGroupName(String dBSubnetGroupName) {
        this.dBSubnetGroupName = dBSubnetGroupName;
    }

    public CreateDBInstanceReadReplicaRequest withDBSubnetGroupName(String dBSubnetGroupName) {
        this.dBSubnetGroupName = dBSubnetGroupName;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDBInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: " + this.getDBInstanceIdentifier() + ",");
        }
        if (this.getSourceDBInstanceIdentifier() != null) {
            sb.append("SourceDBInstanceIdentifier: " + this.getSourceDBInstanceIdentifier() + ",");
        }
        if (this.getDBInstanceClass() != null) {
            sb.append("DBInstanceClass: " + this.getDBInstanceClass() + ",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: " + this.getAvailabilityZone() + ",");
        }
        if (this.getPort() != null) {
            sb.append("Port: " + this.getPort() + ",");
        }
        if (this.isAutoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: " + this.isAutoMinorVersionUpgrade() + ",");
        }
        if (this.getIops() != null) {
            sb.append("Iops: " + this.getIops() + ",");
        }
        if (this.getOptionGroupName() != null) {
            sb.append("OptionGroupName: " + this.getOptionGroupName() + ",");
        }
        if (this.isPubliclyAccessible() != null) {
            sb.append("PubliclyAccessible: " + this.isPubliclyAccessible() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.getDBSubnetGroupName() != null) {
            sb.append("DBSubnetGroupName: " + this.getDBSubnetGroupName());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDBInstanceIdentifier() == null ? 0 : this.getDBInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getSourceDBInstanceIdentifier() == null ? 0 : this.getSourceDBInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceClass() == null ? 0 : this.getDBInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.isAutoMinorVersionUpgrade() == null ? 0 : this.isAutoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getIops() == null ? 0 : this.getIops().hashCode());
        hashCode = 31 * hashCode + (this.getOptionGroupName() == null ? 0 : this.getOptionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.isPubliclyAccessible() == null ? 0 : this.isPubliclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getDBSubnetGroupName() == null ? 0 : this.getDBSubnetGroupName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDBInstanceReadReplicaRequest)) {
            return false;
        }
        CreateDBInstanceReadReplicaRequest other = (CreateDBInstanceReadReplicaRequest)obj;
        if (other.getDBInstanceIdentifier() == null ^ this.getDBInstanceIdentifier() == null) {
            return false;
        }
        if (other.getDBInstanceIdentifier() != null && !other.getDBInstanceIdentifier().equals(this.getDBInstanceIdentifier())) {
            return false;
        }
        if (other.getSourceDBInstanceIdentifier() == null ^ this.getSourceDBInstanceIdentifier() == null) {
            return false;
        }
        if (other.getSourceDBInstanceIdentifier() != null && !other.getSourceDBInstanceIdentifier().equals(this.getSourceDBInstanceIdentifier())) {
            return false;
        }
        if (other.getDBInstanceClass() == null ^ this.getDBInstanceClass() == null) {
            return false;
        }
        if (other.getDBInstanceClass() != null && !other.getDBInstanceClass().equals(this.getDBInstanceClass())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() == null ^ this.isAutoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() != null && !other.isAutoMinorVersionUpgrade().equals(this.isAutoMinorVersionUpgrade())) {
            return false;
        }
        if (other.getIops() == null ^ this.getIops() == null) {
            return false;
        }
        if (other.getIops() != null && !other.getIops().equals(this.getIops())) {
            return false;
        }
        if (other.getOptionGroupName() == null ^ this.getOptionGroupName() == null) {
            return false;
        }
        if (other.getOptionGroupName() != null && !other.getOptionGroupName().equals(this.getOptionGroupName())) {
            return false;
        }
        if (other.isPubliclyAccessible() == null ^ this.isPubliclyAccessible() == null) {
            return false;
        }
        if (other.isPubliclyAccessible() != null && !other.isPubliclyAccessible().equals(this.isPubliclyAccessible())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getDBSubnetGroupName() == null ^ this.getDBSubnetGroupName() == null) {
            return false;
        }
        return other.getDBSubnetGroupName() == null || other.getDBSubnetGroupName().equals(this.getDBSubnetGroupName());
    }
}

