/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.glacier.model.ListVaultsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListVaultsRequestMarshaller
implements Marshaller<Request<ListVaultsRequest>, ListVaultsRequest> {
    @Override
    public Request<ListVaultsRequest> marshall(ListVaultsRequest listVaultsRequest) {
        if (listVaultsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListVaultsRequest> request = new DefaultRequest<ListVaultsRequest>(listVaultsRequest, "AmazonGlacier");
        String target = "Glacier.ListVaults";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults?marker={marker};limit={limit}";
        uriResourcePath = uriResourcePath.replace("{accountId}", listVaultsRequest.getAccountId() == null ? "" : StringUtils.fromString(listVaultsRequest.getAccountId()));
        uriResourcePath = uriResourcePath.replace("{marker}", listVaultsRequest.getMarker() == null ? "" : StringUtils.fromString(listVaultsRequest.getMarker()));
        uriResourcePath = uriResourcePath.replace("{limit}", listVaultsRequest.getLimit() == null ? "" : StringUtils.fromString(listVaultsRequest.getLimit()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        return request;
    }
}

