/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client;

import org.apache.flink.client.web.WebInterfaceServer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebFrontend {
    private static final Logger LOG = LoggerFactory.getLogger(WebFrontend.class);

    public static void main(String[] args) {
        try {
            String configDir = null;
            if (args.length >= 2 && args[0].equals("-configDir")) {
                configDir = args[1];
            }
            if (configDir == null) {
                System.err.println("Error: Configuration directory must be specified.\nWebFrontend -configDir <directory>\n");
                System.exit(1);
                return;
            }
            GlobalConfiguration.loadConfiguration(configDir);
            Configuration config = GlobalConfiguration.getConfiguration();
            config.setString("flink.base.dir.path", configDir + "/..");
            int port = config.getInteger("webclient.port", 8080);
            WebInterfaceServer server = new WebInterfaceServer(config, port);
            LOG.info("Starting web frontend server on port " + port + '.');
            server.start();
            server.join();
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception: " + t.getMessage(), t);
        }
    }
}

