/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume;

import org.apache.flume.EventDrivenSource;
import org.apache.flume.PollableSource;
import org.apache.flume.Source;
import org.apache.flume.lifecycle.LifecycleAware;
import org.apache.flume.source.EventDrivenSourceRunner;
import org.apache.flume.source.PollableSourceRunner;

public abstract class SourceRunner
implements LifecycleAware {
    private Source source;

    public static SourceRunner forSource(Source source) {
        SourceRunner runner = null;
        if (source instanceof PollableSource) {
            runner = new PollableSourceRunner();
            runner.setSource((PollableSource)source);
        } else if (source instanceof EventDrivenSource) {
            runner = new EventDrivenSourceRunner();
            ((EventDrivenSourceRunner)runner).setSource((EventDrivenSource)source);
        } else {
            throw new IllegalArgumentException("No known runner type for source " + source);
        }
        return runner;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }
}

