/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.flume;

import java.util.List;
import org.apache.flink.streaming.connectors.ConnectorSource;
import org.apache.flink.streaming.connectors.util.DeserializationSchema;
import org.apache.flink.util.Collector;
import org.apache.flume.Context;
import org.apache.flume.channel.ChannelProcessor;
import org.apache.flume.source.AvroSource;
import org.apache.flume.source.avro.AvroFlumeEvent;
import org.apache.flume.source.avro.Status;

public class FlumeSource<OUT>
extends ConnectorSource<OUT> {
    private static final long serialVersionUID = 1L;
    String host;
    String port;
    volatile boolean finished = false;
    MyAvroSource avroSource;

    FlumeSource(String host, int port, DeserializationSchema<OUT> deserializationSchema) {
        super(deserializationSchema);
        this.host = host;
        this.port = Integer.toString(port);
    }

    public void configureAvroSource(Collector<OUT> collector) {
        this.avroSource = new MyAvroSource();
        this.avroSource.collector = collector;
        Context context = new Context();
        context.put("port", this.port);
        context.put("bind", this.host);
        this.avroSource.configure(context);
        ChannelProcessor cp = new ChannelProcessor(null);
        this.avroSource.setChannelProcessor(cp);
    }

    public void invoke(Collector<OUT> collector) throws Exception {
        this.configureAvroSource(collector);
        this.avroSource.start();
        while (!this.finished) {
            ((Object)((Object)this)).wait();
        }
    }

    public class MyAvroSource
    extends AvroSource {
        Collector<OUT> collector;

        public Status append(AvroFlumeEvent avroEvent) {
            this.collect(avroEvent);
            return Status.OK;
        }

        public Status appendBatch(List<AvroFlumeEvent> events) {
            for (AvroFlumeEvent avroEvent : events) {
                this.collect(avroEvent);
            }
            return Status.OK;
        }

        private void collect(AvroFlumeEvent avroEvent) {
            byte[] b = avroEvent.getBody().array();
            Object out = FlumeSource.this.schema.deserialize(b);
            if (FlumeSource.this.schema.isEndOfStream(out)) {
                FlumeSource.this.finished = true;
                this.stop();
                ((Object)((Object)FlumeSource.this)).notifyAll();
            } else {
                this.collector.collect(out);
            }
        }
    }
}

