/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.db;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.apache.flink.streaming.connectors.db.CustomSerializationDBState;
import org.apache.flink.streaming.connectors.db.DBSerializer;
import org.apache.flink.streaming.connectors.db.DBStateIterator;
import org.apache.flink.streaming.connectors.db.DBStateWithIterator;
import org.apache.flink.streaming.connectors.db.DefaultDBSerializer;
import redis.clients.jedis.Jedis;

public class RedisState<K extends Serializable, V extends Serializable>
extends CustomSerializationDBState<K, V>
implements DBStateWithIterator<K, V> {
    private Jedis jedis = new Jedis("localhost");

    public RedisState(DBSerializer<K> keySerializer, DBSerializer<V> valueSerializer) {
        super(keySerializer, valueSerializer);
    }

    public RedisState() {
        this(new DefaultDBSerializer(), new DefaultDBSerializer());
    }

    @Override
    public void close() {
        this.jedis.close();
    }

    @Override
    public void put(K key, V value) {
        this.jedis.set(this.keySerializer.write(key), this.valueSerializer.write(value));
    }

    @Override
    public V get(K key) {
        return (V)this.valueSerializer.read(this.jedis.get(this.keySerializer.write(key)));
    }

    @Override
    public void remove(K key) {
        this.jedis.del(this.keySerializer.write(key));
    }

    @Override
    public DBStateIterator<K, V> getIterator() {
        return new RedisStateIterator();
    }

    private class RedisStateIterator
    extends DBStateIterator<K, V> {
        private Set<byte[]> set;
        private Iterator<byte[]> iterator;
        private byte[] currentKey;

        public RedisStateIterator() {
            this.set = RedisState.this.jedis.keys(new byte[0]);
            RedisState.this.jedis.keys("*".getBytes()).iterator();
            this.iterator = this.set.iterator();
            this.currentKey = this.iterator.next();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K getNextKey() {
            return RedisState.this.keySerializer.read(this.currentKey);
        }

        @Override
        public V getNextValue() {
            return RedisState.this.jedis.get(this.currentKey);
        }

        @Override
        public void next() {
            this.currentKey = this.iterator.next();
        }
    }
}

