/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.text.NumberFormat;
import kafka.api.OffsetRequest$;
import kafka.utils.Range;
import kafka.utils.SystemTime$;
import kafka.utils.Time;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;

public final class Log$ {
    public static final Log$ MODULE$;
    private final String LogFileSuffix;
    private final String IndexFileSuffix;

    static {
        new Log$();
    }

    public String LogFileSuffix() {
        return this.LogFileSuffix;
    }

    public String IndexFileSuffix() {
        return this.IndexFileSuffix;
    }

    public <T extends Range> Option<T> findRange(T[] TArray, long l, int n) {
        if (Predef$.MODULE$.refArrayOps((Object[])TArray).size() < 1) {
            return None$.MODULE$;
        }
        if (l < TArray[0].start()) {
            return None$.MODULE$;
        }
        int n2 = 0;
        int n3 = n - 1;
        while (n2 < n3) {
            int n4 = (int)package$.MODULE$.ceil((double)(n3 + n2) / 2.0);
            T t = TArray[n4];
            if (t.start() == l) {
                return new Some(t);
            }
            if (l < t.start()) {
                n3 = n4 - 1;
                continue;
            }
            n2 = n4;
        }
        return new Some(TArray[n2]);
    }

    public <T extends Range> Option<T> findRange(T[] TArray, long l) {
        return this.findRange((Range[])TArray, l, TArray.length);
    }

    public String filenamePrefixFromOffset(long l) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumIntegerDigits(20);
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setGroupingUsed(false);
        return numberFormat.format(l);
    }

    public File logFilename(File file, long l) {
        return new File(file, new StringBuilder().append((Object)this.filenamePrefixFromOffset(l)).append((Object)this.LogFileSuffix()).toString());
    }

    public File indexFilename(File file, long l) {
        return new File(file, new StringBuilder().append((Object)this.filenamePrefixFromOffset(l)).append((Object)this.IndexFileSuffix()).toString());
    }

    public Seq<Object> getEmptyOffsets(long l) {
        return l == OffsetRequest$.MODULE$.LatestTime() || l == OffsetRequest$.MODULE$.EarliestTime() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})) : Nil$.MODULE$;
    }

    public int $lessinit$greater$default$4() {
        return Integer.MAX_VALUE;
    }

    public long $lessinit$greater$default$5() {
        return Long.MAX_VALUE;
    }

    public int $lessinit$greater$default$7() {
        return 0xA00000;
    }

    public int $lessinit$greater$default$8() {
        return 4096;
    }

    public Time $lessinit$greater$default$9() {
        return SystemTime$.MODULE$;
    }

    public int $lessinit$greater$default$10() {
        return 0;
    }

    private Log$() {
        MODULE$ = this;
        this.LogFileSuffix = ".log";
        this.IndexFileSuffix = ".index";
    }
}

