/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.relational;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.operators.AggregateOperator;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple4;

public class TPCHQuery3 {
    private static String lineitemPath;
    private static String customerPath;
    private static String ordersPath;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!TPCHQuery3.parseParameters(args)) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        FilterOperator lineitems = TPCHQuery3.getLineitemDataSet(env);
        FilterOperator orders = TPCHQuery3.getOrdersDataSet(env);
        FilterOperator customers = TPCHQuery3.getCustomerDataSet(env);
        customers = customers.filter((FilterFunction)new FilterFunction<Customer>(){

            public boolean filter(Customer c) {
                return c.getMktsegment().equals("AUTOMOBILE");
            }
        });
        orders = orders.filter((FilterFunction)new FilterFunction<Order>(){
            private final DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            private final Date date = this.format.parse("1995-03-12");

            public boolean filter(Order o) throws ParseException {
                return this.format.parse(o.getOrderdate()).before(this.date);
            }
        });
        lineitems = lineitems.filter((FilterFunction)new FilterFunction<Lineitem>(){
            private final DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            private final Date date = this.format.parse("1995-03-12");

            public boolean filter(Lineitem l) throws ParseException {
                return this.format.parse(l.getShipdate()).after(this.date);
            }
        });
        JoinOperator.EquiJoin customerWithOrders = customers.join((DataSet)orders).where(new int[]{0}).equalTo(new int[]{1}).with((JoinFunction)new JoinFunction<Customer, Order, ShippingPriorityItem>(){

            public ShippingPriorityItem join(Customer c, Order o) {
                return new ShippingPriorityItem(o.getOrderKey(), 0.0, o.getOrderdate(), o.getShippriority());
            }
        });
        AggregateOperator result = customerWithOrders.join((DataSet)lineitems).where(new int[]{0}).equalTo(new int[]{0}).with((JoinFunction)new JoinFunction<ShippingPriorityItem, Lineitem, ShippingPriorityItem>(){

            public ShippingPriorityItem join(ShippingPriorityItem i, Lineitem l) {
                i.setRevenue(l.getExtendedprice() * (1.0 - l.getDiscount()));
                return i;
            }
        }).groupBy(new int[]{0, 2, 3}).aggregate(Aggregations.SUM, 1);
        result.writeAsCsv(outputPath, "\n", "|");
        env.execute("TPCH Query 3 Example");
    }

    private static boolean parseParameters(String[] programArguments) {
        if (programArguments.length > 0) {
            if (programArguments.length != 4) {
                System.err.println("Usage: TPCHQuery3 <lineitem-csv path> <customer-csv path> <orders-csv path> <result path>");
                return false;
            }
        } else {
            System.err.println("This program expects data from the TPC-H benchmark as input data.\n  Due to legal restrictions, we can not ship generated data.\n  You can find the TPC-H data generator at http://www.tpc.org/tpch/.\n  Usage: TPCHQuery3 <lineitem-csv path> <customer-csv path> <orders-csv path> <result path>");
            return false;
        }
        lineitemPath = programArguments[0];
        customerPath = programArguments[1];
        ordersPath = programArguments[2];
        outputPath = programArguments[3];
        return true;
    }

    private static DataSet<Lineitem> getLineitemDataSet(ExecutionEnvironment env) {
        return env.readCsvFile(lineitemPath).fieldDelimiter('|').includeFields("1000011000100000").tupleType(Lineitem.class);
    }

    private static DataSet<Customer> getCustomerDataSet(ExecutionEnvironment env) {
        return env.readCsvFile(customerPath).fieldDelimiter('|').includeFields("10000010").tupleType(Customer.class);
    }

    private static DataSet<Order> getOrdersDataSet(ExecutionEnvironment env) {
        return env.readCsvFile(ordersPath).fieldDelimiter('|').includeFields("110010010").tupleType(Order.class);
    }

    public static class ShippingPriorityItem
    extends Tuple4<Long, Double, String, Long> {
        public ShippingPriorityItem() {
        }

        public ShippingPriorityItem(Long o_orderkey, Double revenue, String o_orderdate, Long o_shippriority) {
            this.f0 = o_orderkey;
            this.f1 = revenue;
            this.f2 = o_orderdate;
            this.f3 = o_shippriority;
        }

        public Long getOrderkey() {
            return (Long)this.f0;
        }

        public void setOrderkey(Long orderkey) {
            this.f0 = orderkey;
        }

        public Double getRevenue() {
            return (Double)this.f1;
        }

        public void setRevenue(Double revenue) {
            this.f1 = revenue;
        }

        public String getOrderdate() {
            return (String)this.f2;
        }

        public Long getShippriority() {
            return (Long)this.f3;
        }
    }

    public static class Order
    extends Tuple4<Long, Long, String, Long> {
        public Long getOrderKey() {
            return (Long)this.f0;
        }

        public Long getCustKey() {
            return (Long)this.f1;
        }

        public String getOrderdate() {
            return (String)this.f2;
        }

        public Long getShippriority() {
            return (Long)this.f3;
        }
    }

    public static class Customer
    extends Tuple2<Long, String> {
        public Long getCustKey() {
            return (Long)this.f0;
        }

        public String getMktsegment() {
            return (String)this.f1;
        }
    }

    public static class Lineitem
    extends Tuple4<Long, Double, Double, String> {
        public Long getOrderkey() {
            return (Long)this.f0;
        }

        public Double getDiscount() {
            return (Double)this.f2;
        }

        public Double getExtendedprice() {
            return (Double)this.f1;
        }

        public String getShipdate() {
            return (String)this.f3;
        }
    }
}

