/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.relational;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.RichFilterFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class EmptyFieldsCountAccumulator {
    private static final String EMPTY_FIELD_ACCUMULATOR = "empty-fields";
    private static String filePath;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!EmptyFieldsCountAccumulator.parseParameters(args)) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple> file = EmptyFieldsCountAccumulator.getDataSet(env);
        FilterOperator filteredLines = file.filter((FilterFunction)new EmptyFieldFilter());
        if (outputPath == null) {
            filteredLines.print();
        } else {
            filteredLines.writeAsCsv(outputPath);
        }
        JobExecutionResult result = env.execute("Accumulator example");
        List emptyFields = (List)result.getAccumulatorResult(EMPTY_FIELD_ACCUMULATOR);
        System.out.format("Number of detected empty fields per column: %s\n", emptyFields);
    }

    private static boolean parseParameters(String[] programArguments) {
        if (programArguments.length >= 3) {
            System.err.println("Usage: FilterAndCountIncompleteLines [<input file path> [<result path>]]");
            return false;
        }
        if (programArguments.length >= 1) {
            filePath = programArguments[0];
            if (programArguments.length == 2) {
                outputPath = programArguments[1];
            }
        }
        return true;
    }

    private static DataSet<Tuple> getDataSet(ExecutionEnvironment env) {
        DataSource source = filePath == null ? env.fromCollection(EmptyFieldsCountAccumulator.getExampleInputTuples()) : env.readCsvFile(filePath).fieldDelimiter(';').types(String.class, String.class, String.class);
        return source;
    }

    private static Collection<Tuple3<String, String, String>> getExampleInputTuples() {
        ArrayList<Tuple3<String, String, String>> inputTuples = new ArrayList<Tuple3<String, String, String>>();
        inputTuples.add(new Tuple3((Object)"John", (Object)"Doe", (Object)"Foo Str."));
        inputTuples.add(new Tuple3((Object)"Joe", (Object)"Johnson", (Object)""));
        inputTuples.add(new Tuple3(null, (Object)"Kate Morn", (Object)"Bar Blvd."));
        inputTuples.add(new Tuple3((Object)"Tim", (Object)"Rinny", (Object)""));
        inputTuples.add(new Tuple3((Object)"Alicia", (Object)"Jackson", (Object)"  "));
        return inputTuples;
    }

    public static class VectorAccumulator
    implements Accumulator<Integer, List<Integer>> {
        private final List<Integer> resultVector = new ArrayList<Integer>();

        public void add(Integer position) {
            this.updateResultVector(position, 1);
        }

        private void updateResultVector(int position, int delta) {
            while (this.resultVector.size() <= position) {
                this.resultVector.add(0);
            }
            int component = this.resultVector.get(position);
            this.resultVector.set(position, component + delta);
        }

        public List<Integer> getLocalValue() {
            return this.resultVector;
        }

        public void resetLocal() {
            this.resultVector.clear();
        }

        public void merge(Accumulator<Integer, List<Integer>> other) {
            List otherVector = (List)other.getLocalValue();
            for (int index = 0; index < otherVector.size(); ++index) {
                this.updateResultVector(index, (Integer)otherVector.get(index));
            }
        }

        public void write(DataOutputView out) throws IOException {
            out.writeInt(this.resultVector.size());
            for (Integer component : this.resultVector) {
                out.writeInt(component.intValue());
            }
        }

        public void read(DataInputView in) throws IOException {
            int size = in.readInt();
            for (int numReadComponents = 0; numReadComponents < size; ++numReadComponents) {
                int component = in.readInt();
                this.resultVector.add(component);
            }
        }
    }

    public static final class EmptyFieldFilter
    extends RichFilterFunction<Tuple> {
        private final VectorAccumulator emptyFieldCounter = new VectorAccumulator();

        public void open(Configuration parameters) throws Exception {
            super.open(parameters);
            this.getRuntimeContext().addAccumulator(EmptyFieldsCountAccumulator.EMPTY_FIELD_ACCUMULATOR, (Accumulator)this.emptyFieldCounter);
        }

        public boolean filter(Tuple t) {
            boolean containsEmptyFields = false;
            for (int pos = 0; pos < t.getArity(); ++pos) {
                String field = (String)t.getField(pos);
                if (field != null && !field.trim().isEmpty()) continue;
                containsEmptyFields = true;
                this.emptyFieldCounter.add(pos);
            }
            return !containsEmptyFields;
        }
    }
}

