/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.examples.java.graph.util.EnumTrianglesData;
import org.apache.flink.examples.java.graph.util.EnumTrianglesDataTypes;
import org.apache.flink.util.Collector;

public class EnumTrianglesOpt {
    private static boolean fileOutput = false;
    private static String edgePath = null;
    private static String outputPath = null;

    public static void main(String[] args) throws Exception {
        if (!EnumTrianglesOpt.parseParameters(args)) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<EnumTrianglesDataTypes.Edge> edges = EnumTrianglesOpt.getEdgeDataSet(env);
        ReduceOperator edgesWithDegrees = edges.flatMap((FlatMapFunction)new EdgeDuplicator()).groupBy(new int[]{0}).sortGroup(1, Order.ASCENDING).reduceGroup((GroupReduceFunction)new DegreeCounter()).groupBy(new int[]{0, 1}).reduce((ReduceFunction)new DegreeJoiner());
        MapOperator edgesByDegree = edgesWithDegrees.map((MapFunction)new EdgeByDegreeProjector());
        MapOperator edgesById = edgesByDegree.map((MapFunction)new EdgeByIdProjector());
        JoinOperator.EquiJoin triangles = edgesByDegree.groupBy(new int[]{0}).sortGroup(1, Order.ASCENDING).reduceGroup((GroupReduceFunction)new TriadBuilder()).join((DataSet)edgesById).where(new int[]{1, 2}).equalTo(new int[]{0, 1}).with((JoinFunction)new TriadFilter());
        if (fileOutput) {
            triangles.writeAsCsv(outputPath, "\n", ",");
        } else {
            triangles.print();
        }
        env.execute("Triangle Enumeration Example");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean parseParameters(String[] args) {
        if (args.length <= 0) {
            System.out.println("Executing Enum Triangles Opt example with built-in default data.");
            System.out.println("  Provide parameters to read input data from files.");
            System.out.println("  See the documentation for the correct format of input files.");
            System.out.println("  Usage: EnumTriangleOpt <edge path> <result path>");
            return true;
        }
        fileOutput = true;
        if (args.length == 2) {
            edgePath = args[0];
            outputPath = args[1];
            return true;
        }
        System.err.println("Usage: EnumTriangleBasic <edge path> <result path>");
        return false;
    }

    private static DataSet<EnumTrianglesDataTypes.Edge> getEdgeDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(edgePath).fieldDelimiter(' ').includeFields(new boolean[]{true, true}).types(Integer.class, Integer.class).map((MapFunction)new TupleEdgeConverter());
        }
        return EnumTrianglesData.getDefaultEdgeDataSet(env);
    }

    private static class TriadFilter
    implements JoinFunction<EnumTrianglesDataTypes.Triad, EnumTrianglesDataTypes.Edge, EnumTrianglesDataTypes.Triad> {
        private TriadFilter() {
        }

        public EnumTrianglesDataTypes.Triad join(EnumTrianglesDataTypes.Triad triad, EnumTrianglesDataTypes.Edge edge) throws Exception {
            return triad;
        }
    }

    private static class TriadBuilder
    implements GroupReduceFunction<EnumTrianglesDataTypes.Edge, EnumTrianglesDataTypes.Triad> {
        private final List<Integer> vertices = new ArrayList<Integer>();
        private final EnumTrianglesDataTypes.Triad outTriad = new EnumTrianglesDataTypes.Triad();

        private TriadBuilder() {
        }

        public void reduce(Iterable<EnumTrianglesDataTypes.Edge> edgesIter, Collector<EnumTrianglesDataTypes.Triad> out) throws Exception {
            Iterator<EnumTrianglesDataTypes.Edge> edges = edgesIter.iterator();
            this.vertices.clear();
            EnumTrianglesDataTypes.Edge firstEdge = edges.next();
            this.outTriad.setFirstVertex(firstEdge.getFirstVertex());
            this.vertices.add(firstEdge.getSecondVertex());
            while (edges.hasNext()) {
                Integer higherVertexId = edges.next().getSecondVertex();
                for (Integer lowerVertexId : this.vertices) {
                    this.outTriad.setSecondVertex(lowerVertexId);
                    this.outTriad.setThirdVertex(higherVertexId);
                    out.collect((Object)this.outTriad);
                }
                this.vertices.add(higherVertexId);
            }
        }
    }

    private static class EdgeByIdProjector
    implements MapFunction<EnumTrianglesDataTypes.Edge, EnumTrianglesDataTypes.Edge> {
        private EdgeByIdProjector() {
        }

        public EnumTrianglesDataTypes.Edge map(EnumTrianglesDataTypes.Edge inEdge) throws Exception {
            if (inEdge.getFirstVertex() > inEdge.getSecondVertex()) {
                inEdge.flipVertices();
            }
            return inEdge;
        }
    }

    private static class EdgeByDegreeProjector
    implements MapFunction<EnumTrianglesDataTypes.EdgeWithDegrees, EnumTrianglesDataTypes.Edge> {
        private final EnumTrianglesDataTypes.Edge outEdge = new EnumTrianglesDataTypes.Edge();

        private EdgeByDegreeProjector() {
        }

        public EnumTrianglesDataTypes.Edge map(EnumTrianglesDataTypes.EdgeWithDegrees inEdge) throws Exception {
            this.outEdge.copyVerticesFromEdgeWithDegrees(inEdge);
            if (inEdge.getFirstDegree() > inEdge.getSecondDegree()) {
                this.outEdge.flipVertices();
            }
            return this.outEdge;
        }
    }

    private static class DegreeJoiner
    implements ReduceFunction<EnumTrianglesDataTypes.EdgeWithDegrees> {
        private final EnumTrianglesDataTypes.EdgeWithDegrees outEdge = new EnumTrianglesDataTypes.EdgeWithDegrees();

        private DegreeJoiner() {
        }

        public EnumTrianglesDataTypes.EdgeWithDegrees reduce(EnumTrianglesDataTypes.EdgeWithDegrees edge1, EnumTrianglesDataTypes.EdgeWithDegrees edge2) throws Exception {
            this.outEdge.copyFrom(edge1);
            if (edge1.getFirstDegree() == 0 && edge1.getSecondDegree() != 0) {
                this.outEdge.setFirstDegree(edge2.getFirstDegree());
            } else if (edge1.getFirstDegree() != 0 && edge1.getSecondDegree() == 0) {
                this.outEdge.setSecondDegree(edge2.getSecondDegree());
            }
            return this.outEdge;
        }
    }

    private static class DegreeCounter
    implements GroupReduceFunction<EnumTrianglesDataTypes.Edge, EnumTrianglesDataTypes.EdgeWithDegrees> {
        final ArrayList<Integer> otherVertices = new ArrayList();
        final EnumTrianglesDataTypes.EdgeWithDegrees outputEdge = new EnumTrianglesDataTypes.EdgeWithDegrees();

        private DegreeCounter() {
        }

        public void reduce(Iterable<EnumTrianglesDataTypes.Edge> edgesIter, Collector<EnumTrianglesDataTypes.EdgeWithDegrees> out) {
            Iterator<EnumTrianglesDataTypes.Edge> edges = edgesIter.iterator();
            this.otherVertices.clear();
            EnumTrianglesDataTypes.Edge edge = edges.next();
            Integer groupVertex = edge.getFirstVertex();
            this.otherVertices.add(edge.getSecondVertex());
            while (edges.hasNext()) {
                edge = edges.next();
                Integer otherVertex = edge.getSecondVertex();
                if (this.otherVertices.contains(otherVertex) || otherVertex == groupVertex) continue;
                this.otherVertices.add(otherVertex);
            }
            int degree = this.otherVertices.size();
            for (Integer otherVertex : this.otherVertices) {
                if (groupVertex < otherVertex) {
                    this.outputEdge.setFirstVertex(groupVertex);
                    this.outputEdge.setFirstDegree(degree);
                    this.outputEdge.setSecondVertex(otherVertex);
                    this.outputEdge.setSecondDegree(0);
                } else {
                    this.outputEdge.setFirstVertex(otherVertex);
                    this.outputEdge.setFirstDegree(0);
                    this.outputEdge.setSecondVertex(groupVertex);
                    this.outputEdge.setSecondDegree(degree);
                }
                out.collect((Object)this.outputEdge);
            }
        }
    }

    private static class EdgeDuplicator
    implements FlatMapFunction<EnumTrianglesDataTypes.Edge, EnumTrianglesDataTypes.Edge> {
        private EdgeDuplicator() {
        }

        public void flatMap(EnumTrianglesDataTypes.Edge edge, Collector<EnumTrianglesDataTypes.Edge> out) throws Exception {
            out.collect((Object)edge);
            edge.flipVertices();
            out.collect((Object)edge);
        }
    }

    public static class TupleEdgeConverter
    implements MapFunction<Tuple2<Integer, Integer>, EnumTrianglesDataTypes.Edge> {
        private final EnumTrianglesDataTypes.Edge outEdge = new EnumTrianglesDataTypes.Edge();

        public EnumTrianglesDataTypes.Edge map(Tuple2<Integer, Integer> t) throws Exception {
            this.outEdge.copyVerticesFromTuple2(t);
            return this.outEdge;
        }
    }
}

