/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.EditsVisitor;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.Tokenizer;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class BinaryEditsVisitor
extends EditsVisitor {
    private final DataOutputStream out;

    public BinaryEditsVisitor(String filename, Tokenizer tokenizer) throws IOException {
        this(filename, tokenizer, false);
    }

    public BinaryEditsVisitor(String filename, Tokenizer tokenizer, boolean printToScreen) throws IOException {
        super(tokenizer);
        this.out = new DataOutputStream(new FileOutputStream(filename));
    }

    @Override
    void start() throws IOException {
    }

    @Override
    void finish() throws IOException {
        this.close();
    }

    @Override
    void finishAbnormally() throws IOException {
        System.err.println("Error processing EditLog file.  Exiting.");
        this.close();
    }

    private void close() throws IOException {
        this.out.close();
    }

    @Override
    void visitEnclosingElement(Tokenizer.Token value) throws IOException {
    }

    @Override
    void leaveEnclosingElement() throws IOException {
    }

    @Override
    Tokenizer.Token visit(Tokenizer.Token value) throws IOException {
        value.toBinary(this.out);
        return value;
    }
}

