/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.web.URLUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HsftpFileSystem
extends HftpFileSystem {
    private static final long MM_SECONDS_PER_DAY = 86400000L;
    private volatile int ExpWarnDays = 0;

    @Override
    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        HsftpFileSystem.setupSsl(conf);
        this.ExpWarnDays = conf.getInt("ssl.expiration.warn.days", 30);
    }

    private static void setupSsl(Configuration conf) throws IOException {
        HdfsConfiguration sslConf = new HdfsConfiguration(false);
        sslConf.addResource(conf.get("dfs.client.https.keystore.resource", "ssl-client.xml"));
        FileInputStream fis = null;
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            KeyManager[] kms = null;
            TrustManager[] tms = null;
            if (sslConf.get("ssl.client.keystore.location") != null) {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                KeyStore ks = KeyStore.getInstance(sslConf.get("ssl.client.keystore.type", "JKS"));
                char[] ksPass = sslConf.get("ssl.client.keystore.password", "changeit").toCharArray();
                fis = new FileInputStream(sslConf.get("ssl.client.keystore.location", "keystore.jks"));
                ks.load(fis, ksPass);
                kmf.init(ks, sslConf.get("ssl.client.keystore.keypassword", "changeit").toCharArray());
                kms = kmf.getKeyManagers();
                fis.close();
                fis = null;
            }
            if (sslConf.getBoolean("ssl.client.do.not.authenticate.server", false)) {
                tms = new DummyTrustManager[]{new DummyTrustManager()};
            } else {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
                KeyStore ts = KeyStore.getInstance(sslConf.get("ssl.client.truststore.type", "JKS"));
                char[] tsPass = sslConf.get("ssl.client.truststore.password", "changeit").toCharArray();
                fis = new FileInputStream(sslConf.get("ssl.client.truststore.location", "truststore.jks"));
                ts.load(fis, tsPass);
                tmf.init(ts);
                tms = tmf.getTrustManagers();
            }
            sc.init(kms, tms, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            throw new IOException("Could not initialize SSLContext", e);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    @Override
    protected int getDefaultPort() {
        return this.getDefaultSecurePort();
    }

    @Override
    protected InetSocketAddress getNamenodeSecureAddr(URI uri) {
        return this.getNamenodeAddr(uri);
    }

    @Override
    protected URI getNamenodeUri(URI uri) {
        return this.getNamenodeSecureUri(uri);
    }

    @Override
    protected HttpURLConnection openConnection(String path, String query) throws IOException {
        query = this.addDelegationTokenParam(query);
        URL url = new URL("https", this.nnUri.getHost(), this.nnUri.getPort(), path + '?' + query);
        HttpsURLConnection conn = (HttpsURLConnection)URLUtils.openConnection(url);
        conn.setHostnameVerifier(new DummyHostnameVerifier());
        conn.setRequestMethod("GET");
        conn.connect();
        int warnDays = this.ExpWarnDays;
        if (warnDays > 0) {
            this.ExpWarnDays = 0;
            long expTimeThreshold = (long)warnDays * 86400000L + System.currentTimeMillis();
            X509Certificate[] clientCerts = (X509Certificate[])conn.getLocalCertificates();
            if (clientCerts != null) {
                for (X509Certificate cert : clientCerts) {
                    long expTime = cert.getNotAfter().getTime();
                    if (expTime >= expTimeThreshold) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append("\n Client certificate " + cert.getSubjectX500Principal().getName());
                    int dayOffSet = (int)((expTime - System.currentTimeMillis()) / 86400000L);
                    sb.append(" have " + dayOffSet + " days to expire");
                    LOG.warn((Object)sb.toString());
                }
            }
        }
        return conn;
    }

    protected static class DummyTrustManager
    implements X509TrustManager {
        protected DummyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    protected static class DummyHostnameVerifier
    implements HostnameVerifier {
        protected DummyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

