/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class MBeans {
    private static final Log LOG = LogFactory.getLog(MBeans.class);

    public static ObjectName register(String serviceName, String nameName, Object theMbean) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = MBeans.getMBeanName(serviceName, nameName);
        try {
            mbs.registerMBean(theMbean, name);
            LOG.debug((Object)("Registered " + name));
            return name;
        }
        catch (Exception e) {
            LOG.warn((Object)("Error registering " + name), (Throwable)e);
            return null;
        }
    }

    public static void unregister(ObjectName mbeanName) {
        LOG.debug((Object)("Unregistering " + mbeanName));
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (mbeanName == null) {
            LOG.debug((Object)"Stacktrace: ", new Throwable());
            return;
        }
        try {
            mbs.unregisterMBean(mbeanName);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error unregistering " + mbeanName), (Throwable)e);
        }
    }

    private static ObjectName getMBeanName(String serviceName, String nameName) {
        ObjectName name = null;
        String nameStr = "Hadoop:service=" + serviceName + ",name=" + nameName;
        try {
            name = DefaultMetricsSystem.newMBeanName(nameStr);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error creating MBean object name: " + nameStr), (Throwable)e);
        }
        return name;
    }
}

