/*
	utility.h

	Kernel mode driver utility header
	Copyright (C) 2003 Kenji Kato
*/

#ifndef _UTILITY_H_
#define _UTILITY_H_

VOID
StoreCurrentOsVersion();

PVOID
MmGetSystemAddressForMdlPrettySafe(
	IN PMDL				Mdl,
	IN MM_PAGE_PRIORITY	Priority);

#if DBG
VOID
DBG_IOCTL_STATUS(
	ULONG				ctrl_code,
	NTSTATUS			statuss);

PCSTR
IoControlCodeToStr(
	ULONG 				ctrl_code);

PCSTR
NtStatusToStr(
	NTSTATUS 			status);
#else
#define DBG_IOCTL_STATUS(a, b)
#endif	// DBG

#endif	// _UTILITY_H_
