/*
	imports.h

	Imported elements from various sources
	Copyright (C) 2003 Kenji Kato

	This file contains:

	a) 	Stuff imported from newer DDKs so that the driver for all versions
		of Windows can be compiled with the Windows NT 4.0 DDK.

	b) 	Stuff imported from ntifs.h (http://www.acc.umu.se/~bosse/) so that
		the driver can be compiled with only the DDK.

	c) 	Prototypes of standard functions which are exported from ntoskrnl.exe
		but not declared in regular DDK header files.
*/

#ifndef	_IMPORTS_H_
#define _IMPORTS_H_

#include <ntddft.h>

#if (VER_PRODUCTBUILD >= 2195)
#include <mountdev.h>
#else	// (VER_PRODUCTBUILD < 2195)
//
// Imports from Windows 2000 DDK
//

//
// from new <ntddk.h>
//
#define FILE_ATTRIBUTE_ENCRYPTED			0x00004000

//
// from new <ntddft.h>
//
#define FT_CLUSTER_SET_MEMBER_STATE 		CTL_CODE(				\
												FTTYPE,				\
												11,					\
												METHOD_BUFFERED,	\
												FILE_ANY_ACCESS)

#define FT_CLUSTER_GET_MEMBER_STATE 		CTL_CODE(				\
												FTTYPE,				\
												12,					\
												METHOD_BUFFERED, 	\
												FILE_ANY_ACCESS)

//
// from new <ntddstor.h>
//
#define FILE_DEVICE_MASS_STORAGE			0x0000002d

#define IOCTL_STORAGE_CHECK_VERIFY2 		CTL_CODE(				\
												IOCTL_STORAGE_BASE,	\
												0x0200, 			\
												METHOD_BUFFERED, 	\
												FILE_ANY_ACCESS)

//
// from <mountmgr.h> and <mountdev.h>
//
#define MOUNTDEVCONTROLTYPE  				((ULONG) 'M')

#define IOCTL_MOUNTDEV_QUERY_UNIQUE_ID		CTL_CODE(					\
												MOUNTDEVCONTROLTYPE,	\
												0,						\
												METHOD_BUFFERED,		\
												FILE_ANY_ACCESS)

#define IOCTL_MOUNTDEV_UNIQUE_ID_CHANGE_NOTIFY							\
											CTL_CODE(					\
												MOUNTDEVCONTROLTYPE,	\
												1,						\
												METHOD_BUFFERED,		\
												FILE_ANY_ACCESS)

#define IOCTL_MOUNTDEV_QUERY_DEVICE_NAME	CTL_CODE(					\
												MOUNTDEVCONTROLTYPE,	\
												2,						\
												METHOD_BUFFERED,		\
												FILE_ANY_ACCESS)

#define IOCTL_MOUNTDEV_QUERY_SUGGESTED_LINK_NAME						\
											CTL_CODE(					\
												MOUNTDEVCONTROLTYPE,	\
											 	3,						\
											 	METHOD_BUFFERED,		\
											 	FILE_ANY_ACCESS)

#define IOCTL_MOUNTDEV_LINK_CREATED 		CTL_CODE(					\
												MOUNTDEVCONTROLTYPE,	\
												4,						\
												METHOD_BUFFERED,		\
												FILE_ANY_ACCESS)

#define IOCTL_MOUNTDEV_LINK_DELETED 		CTL_CODE(					\
												MOUNTDEVCONTROLTYPE, 	\
												5, 						\
												METHOD_BUFFERED, 		\
												FILE_ANY_ACCESS)

//
// Output structure for IOCTL_MOUNTDEV_QUERY_UNIQUE_ID.
// Input structure for IOCTL_MOUNTDEV_UNIQUE_ID_CHANGE_NOTIFY.
//

typedef struct _MOUNTDEV_UNIQUE_ID {
	USHORT	UniqueIdLength;
	UCHAR	UniqueId[1];
} MOUNTDEV_UNIQUE_ID, *PMOUNTDEV_UNIQUE_ID;

//
// Output structure for IOCTL_MOUNTDEV_UNIQUE_ID_CHANGE_NOTIFY.
//

typedef struct _MOUNTDEV_UNIQUE_ID_CHANGE_NOTIFY_OUTPUT {
	ULONG	Size;
	USHORT	OldUniqueIdOffset;
	USHORT	OldUniqueIdLength;
	USHORT	NewUniqueIdOffset;
	USHORT	NewUniqueIdLength;
} MOUNTDEV_UNIQUE_ID_CHANGE_NOTIFY_OUTPUT,
*PMOUNTDEV_UNIQUE_ID_CHANGE_NOTIFY_OUTPUT;

//
// MOUNTDEV_NAME
//
// Input structure for IOCTL_MOUNTDEV_LINK_CREATED.
// Input structure for IOCTL_MOUNTDEV_LINK_DELETED.
// Output structure for IOCTL_MOUNTDEV_QUERY_DEVICE_NAME.
//

typedef struct _MOUNTDEV_NAME {
	USHORT	NameLength;
	WCHAR	Name[1];
} MOUNTDEV_NAME, *PMOUNTDEV_NAME;


//
// Output structure for IOCTL_MOUNTDEV_QUERY_SUGGESTED_LINK_NAME
//

typedef struct _MOUNTDEV_SUGGESTED_LINK_NAME {
	BOOLEAN UseOnlyIfThereAreNoOtherLinks;
	USHORT	NameLength;
	WCHAR	Name[1];
} MOUNTDEV_SUGGESTED_LINK_NAME, *PMOUNTDEV_SUGGESTED_LINK_NAME;

#endif	// (VER_PRODUCTBUILD < 2195)

//
// Stuff from Windows XP DDK
//

#if (VER_PRODUCTBUILD < 2600)

#define IOCTL_DISK_GET_PARTITION_INFO_EX	CTL_CODE( 				\
												IOCTL_DISK_BASE, 	\
												0x0012, 			\
												METHOD_BUFFERED, 	\
												FILE_ANY_ACCESS)

#define IOCTL_DISK_GET_LENGTH_INFO			CTL_CODE( 				\
												IOCTL_DISK_BASE,	\
												0x0017,				\
												METHOD_BUFFERED, 	\
												FILE_READ_ACCESS)

typedef enum _PARTITION_STYLE {
	PARTITION_STYLE_MBR,
	PARTITION_STYLE_GPT
} PARTITION_STYLE;

typedef unsigned __int64 ULONG64, *PULONG64;

typedef struct _PARTITION_INFORMATION_MBR {
	UCHAR	PartitionType;
	BOOLEAN BootIndicator;
	BOOLEAN RecognizedPartition;
	ULONG	HiddenSectors;
} PARTITION_INFORMATION_MBR, *PPARTITION_INFORMATION_MBR;

typedef struct _PARTITION_INFORMATION_GPT {
	GUID	PartitionType;
	GUID	PartitionId;
	ULONG64 Attributes;
	WCHAR	Name[36];
} PARTITION_INFORMATION_GPT, *PPARTITION_INFORMATION_GPT;

typedef struct _PARTITION_INFORMATION_EX {
	PARTITION_STYLE PartitionStyle;
	LARGE_INTEGER	StartingOffset;
	LARGE_INTEGER	PartitionLength;
	ULONG			PartitionNumber;
	BOOLEAN 		RewritePartition;
	union {
		PARTITION_INFORMATION_MBR Mbr;
		PARTITION_INFORMATION_GPT Gpt;
	};
} PARTITION_INFORMATION_EX, *PPARTITION_INFORMATION_EX;

typedef struct _GET_LENGTH_INFORMATION {
	LARGE_INTEGER Length;
} GET_LENGTH_INFORMATION, *PGET_LENGTH_INFORMATION;

#endif // (VER_PRODUCTBUILD < 2600)

//
// Stuff from ntifs.h
//

#define TOKEN_SOURCE_LENGTH 8

typedef enum _TOKEN_TYPE {
	TokenPrimary = 1,
	TokenImpersonation
} TOKEN_TYPE;

typedef struct _TOKEN_SOURCE {
	CCHAR	SourceName[TOKEN_SOURCE_LENGTH];
	LUID	SourceIdentifier;
} TOKEN_SOURCE, *PTOKEN_SOURCE;

typedef struct _TOKEN_CONTROL {
	LUID			TokenId;
	LUID			AuthenticationId;
	LUID			ModifiedId;
	TOKEN_SOURCE	TokenSource;
} TOKEN_CONTROL, *PTOKEN_CONTROL;

typedef struct _SECURITY_CLIENT_CONTEXT {
	SECURITY_QUALITY_OF_SERVICE SecurityQos;
	PACCESS_TOKEN				ClientToken;
	BOOLEAN 					DirectlyAccessClientToken;
	BOOLEAN 					DirectAccessEffectiveOnly;
	BOOLEAN 					ServerIsRemote;
	TOKEN_CONTROL				ClientTokenControl;
} SECURITY_CLIENT_CONTEXT, *PSECURITY_CLIENT_CONTEXT;

#define PsDereferenceImpersonationToken(T)	\
{											\
	if (ARGUMENT_PRESENT(T)) { 				\
		(ObDereferenceObject((T)));			\
	}										\
	else {									\
		;									\
	}										\
}

#define PsDereferencePrimaryToken(T) (ObDereferenceObject((T)))

NTKERNELAPI
VOID
PsRevertToSelf (
	VOID
);

NTKERNELAPI
NTSTATUS
SeCreateClientSecurity (
	IN PETHREAD 					Thread,
	IN PSECURITY_QUALITY_OF_SERVICE QualityOfService,
	IN BOOLEAN						RemoteClient,
	OUT PSECURITY_CLIENT_CONTEXT	ClientContext
);

#define SeDeleteClientSecurity(C)							\
{															\
	if (SeTokenType((C)->ClientToken) == TokenPrimary) {	\
		PsDereferencePrimaryToken((C)->ClientToken);		\
	}														\
	else {													\
		PsDereferenceImpersonationToken((C)->ClientToken);	\
	}														\
}

NTKERNELAPI
VOID
SeImpersonateClient (
	IN PSECURITY_CLIENT_CONTEXT ClientContext,
	IN PETHREAD 				ServerThread OPTIONAL
);

NTKERNELAPI
TOKEN_TYPE
SeTokenType (
	IN PACCESS_TOKEN Token
);

//
// Functions exported by ntoskrnl.exe
//
int swprintf(wchar_t *, const wchar_t *, ...);

#endif	// _IMPORTS_H_
