/*
	aboutdlg.c

	Virtual Floppy Disk drive control panel
    Copyright (C) 2003 Kenji Kato
*/

#include "sysincl.h"
#include "vfdutil.h"
#include "vfdwin.h"
#include "resource.h"

//
//	local functions
//
static void OnAboutInitDialog(HWND hDlg);

//
//	About dialog message dispatcher
//
BOOL CALLBACK AboutProc(
	HWND hDlg,
	UINT msg,
	WPARAM wParam,
	LPARAM lParam) 
{ 
	UNREFERENCED_PARAMETER(wParam);
	UNREFERENCED_PARAMETER(lParam);

    switch (msg) {
	case WM_INITDIALOG:
		OnAboutInitDialog(hDlg);
		break;
    } 

    return 0; 
}

//
//	initialize about tab dialog
//
void OnAboutInitDialog(HWND hDlg)
{
	char buf[1024];
	DWORD ret;

	// load usage explanation text

	if (!LoadString(hAppInstance, IDS_ABOUT_USAGE, buf, sizeof(buf))) {
		ret = GetLastError();

		DEBUG_TRACE1("AboutProc : LoadString(IDS_ABOUT_USAGE) - %s", ErrMsg(ret));
		ShowErrorMessage(ret, IDS_ERR_APP_INIT);
		return;
	}

	//	show usage explanation text

	if (!SetDlgItemText(hDlg, IDC_ABOUT_USAGE, buf)) {
		ret = GetLastError();

		DEBUG_TRACE1("AboutProc : SetDlgItemText(IDC_ABOUT_USAGE) - %s", ErrMsg(ret));

		ShowErrorMessage(ret, IDS_ERR_APP_INIT);
	}

	return;
}

//	End Of File
