/*
	vfdutil.h

	Virtual FD utility functions
	Copyright (C) 2003 Kenji Kato
*/

#ifndef _VFDUTIL_H_
#define _VFDUTIL_H_

#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus

typedef BOOL (*ENSURE_CALLBACK)(DWORD param);

//	Unmounts current image
DWORD EnsureUnmount(
	ENSURE_CALLBACK retry_cb,
	ENSURE_CALLBACK cont_cb,
	DWORD param);

//	Choose first available drive letter
char ChooseDriveLetter();

#ifdef _DEBUG

//	Get error message string
const char *ErrMsg(DWORD err);

//	Format and output debug string
void DebugTrace(LPCTSTR file, int line, LPCTSTR format, ...);

#define DEBUG_TRACE0(msg)							\
	DebugTrace(__FILE__, __LINE__, "%s", msg)

#define DEBUG_TRACE1(msg, arg1)						\
	DebugTrace(__FILE__, __LINE__, msg, arg1)

#define DEBUG_TRACE2(msg, arg1, arg2)				\
	DebugTrace(__FILE__, __LINE__, msg, arg1, arg2)

#define DEBUG_TRACE3(msg, arg1, arg2, arg3)			\
	DebugTrace(__FILE__, __LINE__, msg, arg1, arg2, arg3)

#else // _DEBUG
#define DEBUG_TRACE0(msg)
#define DEBUG_TRACE1(msg, arg1)
#define DEBUG_TRACE2(msg, arg1, arg2)
#define DEBUG_TRACE3(msg, arg1, arg2, arg3)
#endif	// _DEBUG

#ifdef __cplusplus
}
#endif	// __cplusplus
#endif	// _VFDUTIL_H_
