static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*
 *	akxsEList.c
 *
 *		coded   by A.Kobayashi 2004.4.18
 *
 *
 */
#include "akxcommon.h"

tdtUCHAIN *akxs_uchain_new(iMAX)
int iMAX;
{
	tdtUCHAIN *pUC;
	int *p;

	if (iMAX <= 0) return NULL;
	if (!(pUC = (tdtUCHAIN *)Malloc(sizeof(tdtUCHAIN)))) return NULL;
	if (!(p = (int *)Malloc(sizeof(int)*(iMAX+1)))) {
		Free(pUC);
		return NULL;
	}
	memset(pUC,0,sizeof(tdtUCHAIN));
	memset(p,0,sizeof(int)*(iMAX+1));
	pUC->uc_entry_size = iMAX;
	pUC->uc_uchain = p;
	return pUC;
}

int akxs_uchain_free(pUC)
tdtUCHAIN *pUC;
{
	int *p;

	if (!pUC) return -1;
	if (p=pUC->uc_uchain) Free(p);
	Free(pUC);
	return 0;
}

int akxs_uchain_get(pUC,opt)
tdtUCHAIN *pUC;
int opt;
{
	int *iUChain,next,i,j;

	if (!pUC) return -1;
	if (!(iUChain=pUC->uc_uchain)) return -1;
	if (next = pUC->uc_used_top) {
		if (opt) {
			j = i = 0;
			while (next) {
				j = i;
				i = next;
				next = iUChain[i];
			}
			if (j) iChain[j] = 0;
			else pUC->uc_used_top = 0;
			next = i;
		}
		else {
			pUC->uc_used_top = iChain[next];
			iChain[next] = 0;
		}
	}
	return next;
}

int akxs_uchain_set(iMax,iUChain,iSet)
int iMax,iUChain[],iSet;
{
	/* iUChain[0]: First Used Point */
	int i,next;

	if (!iUChain) return -1;
	if (iSet<1 || iSet>iMax) return -2;
	i = 0;
	next = iUChain[i];
	while (next) {
		if (next == iSet) return iSet;
		i = next;
		next = iUChain[i];
	}
	iUChain[i] = iSet;

printf("akxs_uchain_set: iSet=%d i=%d\n",iSet,i);

	return 0;
}

int akxs_uchain_del(iMax,iUChain,iDel)
int iMax,iUChain[],iDel;
{
	/* iUChain[0]: First Used Point */
	int i,next;
/*
printf("akxs_uchain_del: iMax=%d iDel=%d\n",iMax,iDel);
*/
	if (!iUChain) return -1;
	if (iDel<1 || iDel>iMax) return -2;
	i = 0;
	next = iUChain[i];
	while (next) {
/*
printf("akxs_uchain_del: next=%d\n",next);
*/
		if (next == iDel) break;
		i = next;
		next = iUChain[i];
	}
	if (!next) return -3;
	iUChain[i] = iUChain[next];
	iUChain[next] = 0;

printf("akxs_uchain_del: iDel=%d i=%d\n",iDel,i);

	return 0;
}

int akxs_uchain_setAll(iMax,iUChain)
int iMax,iUChain[];
{
	int i;

	if (!iUChain) return -1;

	iMax--;
	for (i=0;i<iMax;i++) {
		iUChain[i] = i + 1;
	}
	iUChain[iMax] = 0;

	return 0;
}

int akxs_uchain_delAll(iMax,iUChain)
int iMax,iUChain[];
{
	if (!iUChain) return -1;
	memset(iUChain,0,iMax*sizeof(int));

	return 0;
}
