static    char    sccsid[]="@(#) akxams.c 1.1 97/08/28 14:12:33";
/*
 *	akxams.c
 *
 *		coded   by A.Kobayashi 95.3.5
 *
 *
 */
#include "akxcommon.h"

#define DEBUG(x)

#define MAXSEGSIZE	65536

static int _getblno();
static int _putblno();
static int _ms_bcget();
static int _ms_bcrel();

static tdtMS_S	 MS={'M','S','\0','\0',0};
static tdtMS_INODE Inode[InodeSize];
static tdtMSBC	 BC[MsBCSize];

/********************************************
int main()
{
	int ret,i;
	int ibuf[4096];
	int lh;

	ret = akxa_ms_create("MemSpace");
	printf("akxa_ms_create ret = %d\n",ret);
	if (ret) exit(1);
	lh = akxa_ms_alloc("TestABC");
	printf("akxa_ms_alloc ret = %d\n",lh);
	for (i=0;i<4096;i++) ibuf[i]=i;
	ret = akxa_ms_write(lh,ibuf,0,4096*4);
	printf("akxa_ms_write ret = %d\n",ret);
	for (i=0;i<4096;i++) ibuf[i]=0;
	ret = akxa_ms_read(lh,ibuf,0,4096*4);
	printf("akxa_ms_read ret = %d\n",ret);
	akxaxdump("buf",ibuf,4096*4);
	ret = akxa_ms_free(lh);
	printf("akxa_ms_free ret = %d\n",ret);
	exit(0);
}
********************************************/
int akxa_ms_create(msname)
char *msname;
{
	int i;
	char *p;
	int ret;

	if (!msname) {
		printf("akxa_ms_create:msname is NULL pointer.\n");
		return (-1);
	}
	if (!*msname) {
		printf("akxa_ms_create:msname is NULL string.\n");
		return (-2);
	}

	MS.ms_fnap = msname;
	if ((MS.ms_fh = open(MS.ms_fnap,O_CREAT|O_RDWR,
	                     S_IWRITE|S_IREAD))<0) {
		printf("akxa_ms_create:file (%s) open error = %d\n",MS.ms_fnap,errno);
		return (-3);
	}

	MS.ms_fmbl = 0;
	MS.ms_crbn = -1;
	MS.ms_blsz = MsBlockSize;
	MS.ms_insz = InodeSize;
	MS.ms_fmbl = 0;
	MS.ms_mxbl = 0;
	MS.ms_stBL = NULL;
	MS.ms_BC   = &BC[0];
/*
	for (i=0;i<InodeSize;i++) Inode[i].in_opct = 0;
	for (i=0;i<MsBCSize;i++) {
		BC[i].bc_blkn = 0;
		BC[i].bc_bufp = NULL;
	}
*/
	memset(&Inode[0],0,sizeof(tdtMS_INODE)*InodeSize);
	memset(&BC[0],0,sizeof(tdtMSBC)*MsBCSize);

	return (0);
}

int akxa_ms_drop()
{
	tdtMSBC *pBC;
	tdtBLOCK_LIST *pBL, *next;
	int i;
	int len;

	if (!MS.ms_fh) {
		printf("akxa_ms_drop:MS not initilized.\n");
		return (-1);
	}
	close(MS.ms_fh);

	for (i=0;i<MsBCSize;i++) {
		if (BC[i].bc_bufp) Free(BC[i].bc_bufp);
	}

	pBL = MS.ms_stBL;
	while (pBL) {
		next = pBL->bl_next;
		Free(pBL);
		pBL = next;
	}
	return (0);
}

int akxa_ms_alloc(name)
char *name;
{
	int i, aki, ret;
	char w[16];

#if 1
printf("akxa_ms_alloc:name = [%s]\n",name);
#endif
	aki = -1;
	for (i=0;i<InodeSize;i++) {
		if (!Inode[i].in_opct) aki = i;
		if (!strncmp(Inode[i].in_name,name,16)) {
/* 2000.6.22 Koba
			return -1;
*/
			ret = akxa_ms_free(i+1);
			if (ret) return ret;
			aki= i;
			break;
		}
	}
	if (aki >= 0) {
		i = aki;
		strncpy(Inode[i].in_name,name,16);
		Inode[i].in_stML = 0;
		Inode[i].in_crML = 0;
		Inode[i].in_opct = 1;
	}
	else i = -1;
	return i + 1;
}

static int _ms_mlfree(mlblno)
int mlblno;
{
	int i, rc;
	int blno, bcn;
	tdtMEM_LIST *pML;

	if (!mlblno) return 0;

	if ((bcn = _ms_bcget(mlblno))<0) return bcn;
	pML = (tdtMEM_LIST *)BC[bcn].bc_bufp;
	for (i=0;i<pML->ml_used;i++)
		if (blno=pML->ml_no[i]) {
			 _putblno(blno);
			 if ((rc=_ms_bcrel(blno))<0) return -1;
		}
	if ((rc=_ms_mlfree(pML->ml_next))<0) return rc;
	_putblno(mlblno);
	if ((rc=_ms_bcrel(mlblno))<0) return rc;
	return 0;
}

int akxa_ms_free(iHandle)
int iHandle;
{
	tdtMS_INODE *pIn;
	int rc;

#if 1
printf("akxa_ms_free:hand = %d\n",iHandle);
#endif
	if (iHandle<=0 || iHandle>MS.ms_insz) {
		return -1;
	}

	pIn = &Inode[iHandle-1];
	if (pIn->in_opct <= 0) {
		return -2;
	}
	rc = _ms_mlfree(pIn->in_stML);
	if (!rc) memset(pIn,0,sizeof(tdtMS_INODE));
	return rc;
}

int akxa_ms_read(iHandle, cpBuff, lPos, lLen)
int iHandle, lPos, lLen;
char *cpBuff;
{
	tdtMS_INODE *pIn;
	tdtMSBC *pBC;
	char *p;
	int bcn,ac_bln,is,in;
	int rlen;

	if (iHandle<=0 || iHandle>MS.ms_insz) {
		return -1;
	}

	pIn = &Inode[iHandle-1];
	if (!pIn->in_opct) {
		return -2;
	}

	if (lPos >= pIn->in_size) return (0);
	if (lPos+lLen > pIn->in_size) lLen = pIn->in_size - lPos;
	rlen = 0;
	ac_bln = (lPos+MsBlockSize)/MsBlockSize;
	is = lPos % MsBlockSize;
#if 1
printf("akxa_ms_read:hand=%d pos=%d len=%d ac_bln=%d is=%d\n",
iHandle,lPos,lLen,ac_bln,is);
#endif
	while (lLen>0) {
		if ((bcn = _msbnget(&pIn->in_stML,ac_bln,0))<0) break;
		pBC = &BC[bcn];
		if (is+lLen > (int)(pBC->bc_dats))
			in = pBC->bc_dats - is;
		else
			in = (short)lLen;
		p = pBC->bc_bufp;
#if 0
printf("akxa_ms_read:bcn=%d is=%d in=%d\n",bcn,is,in);
#endif
		memcpy(cpBuff,p+is,in);
		cpBuff += in;
		rlen += in;
		lLen -= in;
		ac_bln++;
		is = 0;
	}
	return (rlen);
}

int akxa_ms_write(iHandle, cpBuff, lPos, lLen)
int iHandle, lPos, lLen;
char *cpBuff;
{
	tdtMS_INODE *pIn;
	tdtMSBC *pBC;
	char *p;
	short bcn,ac_bln,is,in;
	int  wlen,ie;

	if (iHandle<=0 || iHandle>MS.ms_insz) {
		return -1;
	}

	pIn = &Inode[iHandle-1];
	if (!pIn->in_opct) {
		return -2;
	}

	if (lPos > pIn->in_size) return (0);

	wlen = 0;
	ac_bln = (lPos+MsBlockSize)/MsBlockSize;
	is = lPos % MsBlockSize;
#if 1
printf("akxa_ms_write:hand=%d pos=%d len=%d ac_bln=%d is=%d\n",
iHandle,lPos,lLen,ac_bln,is);
#endif
	while (lLen>0) {
		if ((bcn = _msbnget(&pIn->in_stML,ac_bln,1))<0) break;
		pBC = &BC[bcn];
		if (is+lLen > MsBlockSize)
			in = MsBlockSize - is;
		else
			in = (short)lLen;
		p = pBC->bc_bufp;
#if 0
printf("akxa_ms_write:bcn=%d is=%d in=%d\n",bcn,is,in);
#endif
		memcpy(p+is,cpBuff,in);
		pBC->bc_updt = 1;
		if ((is+=in)>pBC->bc_dats) pBC->bc_dats = is;
#if 0
printf("akxa_ms_write:is=%d bc_dats=%d\n",is,pBC->bc_dats);
#endif
		cpBuff += in;
		wlen += in;
		lLen -= in;
		ac_bln++;
		is = 0;
	}
	if ((ie=lPos+wlen) > pIn->in_size) pIn->in_size = ie;
	return (wlen);
}

static int _ms_mlset(p,blno)
tdtMEM_LIST *p;
int     blno;
{
	memcpy(p->ml_id,"ML",2);
	p->ml_max  = MemListSize;
	p->ml_used = 0;
	p->ml_next = 0;
	p->ml_myno = blno;
	memset(&p->ml_no[0],0,sizeof(int)*MemListSize);
	return 0;
}

int _msbnget(pmlblno,msbn,flag)
int *pmlblno, msbn;
int  flag;	/* 0/1=read/write */
{
	int blno, bcn, mlblno;
	tdtMEM_LIST *pML;

	mlblno = *pmlblno;
	if (mlblno <= 0) {
		if (flag) {
			if ((mlblno=_getblno())<=0) return -5;
			if ((bcn = _ms_bcget(mlblno))<0) return bcn;
			pML = (tdtMEM_LIST *)BC[bcn].bc_bufp;
			_ms_mlset(pML,mlblno);
			*pmlblno = mlblno;
		}
		else return -3;
	}
	if ((bcn = _ms_bcget(mlblno))<0) return bcn;
	pML = (tdtMEM_LIST *)BC[bcn].bc_bufp;
	if (msbn >= MemListSize) {
		return _msbnget(&pML->ml_next,msbn-MemListSize,flag);
	}
	blno = pML->ml_no[msbn];
	if (blno <= 0) {
		if (flag) {
			if ((blno=_getblno())<=0) return -5;
			pML->ml_no[msbn] = blno;
			if (msbn >= pML->ml_used) pML->ml_used = msbn + 1;
		}
		else return -4;
	}
	return _ms_bcget(blno);
}

static int _getblno()
{
	tdtBLOCK_LIST *pBL, *pn;
	int i,m;

	pBL = MS.ms_stBL;
	pn = pBL;
	while (pn) {
		pBL = pn;
		if (pBL->bl_rem) {
#if 1
printf("getblno: bl_rem = %d blno = %d\n",pBL->bl_rem,pBL->bl_no[pBL->bl_rem-1]);
#endif
			return pBL->bl_no[--pBL->bl_rem];
		}
		pn = pBL->bl_next;
	}
	if (!(pn = (tdtBLOCK_LIST *)Malloc(sizeof(tdtBLOCK_LIST)))) {
		return -1;
	}
	if (!MS.ms_stBL) MS.ms_stBL = pn;
	else pBL->bl_next = pn;
	memcpy(pn->bl_id,"BL",2);
	pn->bl_next = NULL;
	i = pn->bl_rem = pn->bl_max = BlockListSize;
	m = pn->bl_myno = ++MS.ms_mxbl;
	while (i>=0) pn->bl_no[--i] = ++m;
	MS.ms_mxbl = m;
	return _getblno(pn);
}

static int _putblno(blno)
int blno;
{
	tdtBLOCK_LIST *pBL, *pn;
	int i,m;

	pBL = MS.ms_stBL;
	pn = pBL;
	while (pn) {
		pBL = pn;
		if (pBL->bl_rem < pBL->bl_max) {
#if 1
printf("putblno: bl_rem = %d blno = %d\n",pBL->bl_rem,blno);
#endif
			return pBL->bl_no[pBL->bl_rem++] = blno;
		}
		pn = pBL->bl_next;
	}
	return -1;
}

static int _ms_bcget(ac_bln)
int ac_bln;
{
	int next_bfn,bfn,i,aki_flg;
	int ret;
	int pos;

	bfn = -1;
	next_bfn = MS.ms_crbn;
#if 1
printf("_ms_bcget:start ac_bln=%d next_bfn=%d\n",ac_bln,next_bfn);
#endif
	while (next_bfn>=0) {
#if 0
printf("_ms_bcget:next_bfn=%d bc_blkn=%d ac_bln=%d\n",
next_bfn,BC[next_bfn].bc_blkn,ac_bln);
#endif
		if (BC[next_bfn].bc_blkn == ac_bln) {
			if (bfn>=0)
				BC[bfn].bc_next = BC[next_bfn].bc_next;
			if (next_bfn != MS.ms_crbn) {
				BC[next_bfn].bc_next = MS.ms_crbn;
				MS.ms_crbn = next_bfn;
			}
#if 1
printf("_ms_bcget:return next_bfn=%d\n",next_bfn);
#endif
			return (next_bfn);
		}
		bfn = next_bfn;
		next_bfn = BC[bfn].bc_next;
	}
	aki_flg = 0;
	for (i=0;i<MsBCSize;i++) {
		if (BC[i].bc_blkn == 0) {
			aki_flg = 1;
			break;
		}
	}
	if (!aki_flg) {
		if (BC[bfn].bc_updt) {
			pos = (BC[bfn].bc_blkn-1)*MsBlockSize;
#if 1
printf("_ms_bcget:write lseek pos=%d\n",pos);
#endif
			if (lseek(MS.ms_fh,pos,SEEK_SET)<0)
				return (-1);
			if ((ret=write(MS.ms_fh,BC[bfn].bc_bufp,BC[bfn].bc_dats))!=BC[bfn].bc_dats)
				return (-1);
			if (BC[bfn].bc_blkn > MS.ms_fmbl) MS.ms_fmbl = BC[bfn].bc_blkn;
#if 1
printf("_ms_bcget:write end bfn=%d ret=%d\n",bfn,ret);
#endif
		}
		i = bfn;
	}
#if 1
printf("_ms_bcget:aki_flg=%d i=%d bfn=%d\n",aki_flg,i,bfn);
#endif
	BC[i].bc_dats = 0;
	if (ac_bln <= MS.ms_fmbl) {
		pos = (ac_bln-1)*MsBlockSize;
#if 1
printf("_ms_bcget:read  lseek pos=%d\n",pos);
#endif
		if (lseek(MS.ms_fh,pos,SEEK_SET)<0)
			return (-1);
		if ((ret=read(MS.ms_fh,BC[i].bc_bufp,MsBlockSize))<0)
			return (-1);
#if 1
printf("_ms_bcget:read end ac_bln=%d ret=%d\n",ac_bln,ret);
#endif
		BC[i].bc_dats = (unsigned short)ret;
	}
	BC[i].bc_updt=0;
	BC[i].bc_blkn=ac_bln;
	BC[i].bc_indn = 0;
	BC[i].bc_msbn = 0;
	if (aki_flg) {
		if (!(BC[i].bc_bufp = (char *)Malloc(MsBlockSize))) return -1;
		BC[i].bc_next = MS.ms_crbn;
		MS.ms_crbn = i;
	}
	else {
		i = _ms_bcget(ac_bln);
	}
#if 1
printf("_ms_bcget:return i=%d\n",i);
#endif
	return (i);
}

static int _ms_bcrel(ac_bln)
int ac_bln;
{
	int next_bfn,bfn;

	bfn = -1;
	next_bfn = MS.ms_crbn;
#if 1
printf("_ms_bcrel:start ac_bln=%d next_bfn=%d\n",ac_bln,next_bfn);
#endif
	while (next_bfn>=0) {
#if 0
printf("_ms_bcrel:next_bfn=%d bc_blkn=%d ac_bln=%d\n",
next_bfn,BC[next_bfn].bc_blkn,ac_bln);
#endif
		if (BC[next_bfn].bc_blkn == ac_bln) {
			if (bfn >= 0)
				BC[bfn].bc_next = BC[next_bfn].bc_next;
			else
				MS.ms_crbn = BC[next_bfn].bc_next;
#if 1
printf("_ms_bcrel:return next_bfn=%d\n",next_bfn);
#endif
			return (next_bfn);
		}
		bfn = next_bfn;
		next_bfn = BC[bfn].bc_next;
	}
	return -1;
}
