static    char    sccsid[]="%Z% %M% %I% %D% %T%";
/*************************************************
 *
 *  akasys.c
 *
 *        coded by A.Kobayashi 2000.8.11
 *
 *************************************************/
#include "akacommon.h"

#define AKAS_REPLY_WAIT_TIMER_NAME		"?REPLY_WAIT:procno=%d"
#define AKAS_REPLY_WAIT_WAKEUP_EVENT	100

extern char version[];
extern char make_date[];

tdtMSG_CTL      tMsgCtl = {-1};
static tdtSTATISTICS  tStatistics;
/*
static tdtCLASS_CTL    tClass;
static tdtINSTANCE    tInst;
*/
static tdtMSG_COM      tRecvMsg;
static char          *cppFilev[256];
static char          *nullname="(null)";

static int (**_pCommandClass)();
int (*_pHPToEntry)();
static int _command_class();
static int sys_watch_class();
static int sys_log_class();
static int sys_statistics_class();
extern int aka_sys_password_class();
static int _statistics_fileout();
static int _statistics_edit();

/********************************************************/
/*                                                      */
/********************************************************/
int aka_initialize(iSd,iProcNumber,iMaxThreadTotal,
                  pRbRCtl,pRbWCtl,pRbWWCtl,ReadQue,WriteQue,iQueMax,
                  pCommandClass,pHPToEntry)
int  iSd           ;    /* ڑ\Pbg̔ԍ */
int  iProcNumber   ;    /* vZXԍ */
int  iMaxThreadTotal;   /* NX̃bZ[W鑽dx̍vől
                           ÔƂ́ANX̐ݒɏ] */
tdtRB_CTL *pRbRCtl, *pRbWCtl, *pRbWWCtl;
tdtRW_QUE ReadQue[], WriteQue[];
int    iQueMax;
int (*pCommandClass[])();
int (*pHPToEntry)();
{
	int iRc;
	tdtMSG_COM tRecvMsg;

	iRc = aka_get_regist_pid();
	if (iRc <= 0) aka_set_regist_pid(iProcNumber);
	else if (iRc != iProcNumber) return -1;

	/* bZ[W\ */
	memset(&tMsgCtl,0,sizeof(tdtMSG_CTL));
	tMsgCtl.sd       = iSd;
	tMsgCtl.proc     = iProcNumber;
	tMsgCtl.my_host_id = aka_get_my_host_id();
	if (!(tMsgCtl.host_id = aka_get_pr_host_id()))
		tMsgCtl.host_id = tMsgCtl.my_host_id;
	if ((iRc = akb_get_my_apsys_id())<0) return -1;
	tMsgCtl.apsys_id = iRc;
	tMsgCtl.timer_ctl = akxe_timer_new(); /* ^C}[\ */
	tMsgCtl.send_msg_time_out = 30000;    /* milli second */
	tMsgCtl.send_msg_min_wait = -1;   /* milli second */
	if (!(tMsgCtl.spool_dir = akb_akb_home(0))) tMsgCtl.spool_dir = "";

	tMsgCtl.rb_rctl  = pRbRCtl;
	tMsgCtl.rb_wctl  = pRbWCtl;
	tMsgCtl.rb_wwctl = pRbWWCtl;

	tMsgCtl.read_que  = ReadQue;
	tMsgCtl.write_que = WriteQue;
	tMsgCtl.iReadQueMax  = iQueMax;
	tMsgCtl.iWriteQueMax = iQueMax;

	_pCommandClass = pCommandClass;
	_pHPToEntry    = pHPToEntry;

#if 0
	/* NX̏ */
	memset(&tRecvMsg,0,sizeof(tdtMSG_COM));
	tRecvMsg.msg_disp = AKA_REGIST_CLASS;
	sys_watch_class(AKA_CLASS_WATCH,NULL,&tRecvMsg);
	sys_log_class(AKA_CLASS_LOG,NULL,&tRecvMsg);
	sys_statistics_class(AKA_CLASS_STATISTICS,NULL,&tRecvMsg);
	aka_sys_password_class(AKA_CLASS_PASSWORD,NULL,&tRecvMsg);
#else
	if (iRc = aka_registerClass2(_command_class,2,0,10,0,
	                        "CommandClass")) return iRc;
	if (iRc = aka_registerClass2(sys_watch_class,AKA_CLASS_WATCH,0,1,1,
	                        AKA_CLASS_NAME_WATCH)) return iRc;
	if (iRc = aka_registerClass2(sys_log_class,AKA_CLASS_LOG,0,1,1,
                            AKA_CLASS_NAME_LOG)) return iRc;
	if (iRc = aka_registerClass2(sys_statistics_class,AKA_CLASS_STATISTICS,0,2,0,
	                            AKA_CLASS_NAME_STATISTICS)) return iRc;
	if (iRc = aka_registerClass2(aka_sys_password_class,AKA_CLASS_PASSWORD,0,1,1,
	                                AKA_CLASS_NAME_PASSWORD)) return iRc;
#endif

	/* v񐧌\ */
	memset(&tStatistics,0,sizeof(tdtSTATISTICS));
/*
	memset(&tInst,0,sizeof(tdtINSTANCE));
*/
	return 0;
}

#if 0
/********************************************************/
/*                                                      */
/********************************************************/
int aka_dispatch(pNew)
pRcPacketTable  pNew;
{
	tdtCOMM_PACK_HEAD   *pHead,tHead;
	pCOMM_PACK_HEADB   pHeadB;
	int iCh, iThread, iRc=0, i;
	short sCmd;
	char *cpPacket, cver, *cpToFree, *cpInst;
	ushort usClassId;
	int (*pFuncName)();
	long wrk[sizeof(tdtCOMM_PACK_HEAD)/4+4],len;

	cpPacket = pNew->sp_content;
	pHead = (pCOMM_PACK_HEAD)cpPacket;
	sCmd  = ntohs(pHead->cph_prt.prt_cmnd);
DEBUGOUTL3(AKA_LOG_GROUP|250,
"aka_dispatch: cmnd=%d thread=%d classid=%d",sCmd,pHead->cph_sinf.ind_thrd,
ntohs(pHead->cph_dinf.ind_clid));
	if (sCmd != AKB_CMD_SEND) {
		memcpy(wrk,pHead,sizeof(tdtCOMM_PACK_HEAD));
		len = ntohl(pHead->cph_plen);
		i = sizeof(tdtCOMM_PACK_HEAD)/4;
		if (len > 0) {
			if (len > 8) len = 8;
			memcpy(&wrk[i+1],cpPacket+sizeof(tdtCOMM_PACK_HEAD),len);
		}
		wrk[i] = htons(sCmd)<<16;
		len += 4;
		cpPacket = (char *)wrk;
		pHead = (pCOMM_PACK_HEAD)cpPacket;
		pHead->cph_plen = htonl(len);
	}
	pHeadB = (pCOMM_PACK_HEADB)pHead;
	cver = pHead->cph_prt.prt_ver;
	if ((cver=='C' && pHead->cph_dinf.ind_thrd == 0) ||
	    (cver=='B' && pHeadB->phb_dind.inb_pkid == 0)) {
		/* MpPbg */
		if (pHead->cph_dinf.ind_pano != 0) {
			if (iRc) {
				ERROROUT("*** aka_dispatch:Dropped Error Packet ");
				if (pNew->sp_content) Free(pNew->sp_content);
				Free(pNew);
				return -1;
			}
		}
	}

	iRc = 0;
	usClassId = ntohs(pHead->cph_dinf.ind_clid);
	pFuncName = NULL;
	switch (usClassId) {
		case 0:
		case 1:
		case 2:
			pFuncName = _command_class;
			break;

		case AKA_CLASS_WATCH:
			pFuncName = sys_watch_class;
			break;
		
		case AKA_CLASS_LOG:
			pFuncName = sys_log_class;
			break;

		case AKA_CLASS_STATISTICS:
			pFuncName = sys_statistics_class;
			break;

		case AKA_CLASS_PASSWORD:
			pFuncName = aka_sys_password_class;
			break;

		default:
	/***
			if ((iCmd = AKA_CLASS_BASE - ucClassId) < 256) {
				if (!(pFuncName = ppClassFunc[iCmd])) iRc = -1;
			}
	***/
			iRc = D_ERR_UNKNOWN_CLASS;
			ERROROUT1("*** aka_dispatch:no class = %d",usClassId);
	}

	if (!pFuncName) {
		iRc = D_ERR_UNKNOWN_CLASS;
	}
	if (!iRc) {
		cpToFree = NULL;
		memset(&tRecvMsg,0,sizeof(tdtMSG_COM));
		if (pHead->cph_sinf.ind_thrd) {	/* command packet */
			tInst.pack_head = pHead;
		}
		else {
			len = ntohl(pHead->cph_plen);
if (DEBUGOUTCHECK(AKA_LOG_GROUP|252))
akxaxdump("Dispatch:cpPacket",cpPacket,sizeof(tdtCOMM_PACK_HEAD)+len);
			memcpy(&tHead,cpPacket+len,sizeof(tdtCOMM_PACK_HEAD));
			tInst.pack_head = &tHead;
			len -= sizeof(tdtCOMM_PACK_HEAD);
			pHead->cph_plen = htonl(len);
		}
		iRc = akb_set_recv_msg(cpPacket,&tRecvMsg,cppFilev,&cpToFree);
		if (iRc) {
			ERROROUT1("*** aka_dispatch:akb_set_recv_msg rc = %d",iRc);
		}
		else {
			aka_statistics_count(2,0);
			if (tRecvMsg.msg_mlen > 0)
				*(tRecvMsg.msg_pmsg+tRecvMsg.msg_mlen) = '\0';
			iThread = 1;
			tRecvMsg.msg_seqn = cpPacket;
			pFuncName(iThread<<16|usClassId,NULL,&tRecvMsg);
		}
		if (cpToFree) Free(cpToFree);
	}
	if (iRc) {
		iCh = _pHPToEntry(ntohl(pHead->cph_sinf.ind_hoid),
		                  ntohs(pHead->cph_sinf.ind_prid));
		if (iCh >= 0) {
			if (akb_set_rb_pack_err_cd(iCh,pNew->sp_content,tMsgCtl.rb_wctl,iRc)) {
				ERROROUT("*** aka_dispatch:Dropped Packet -- repry error");
			}
			else {
				akb_trace_out(2,pNew->sp_content);
				pNew->sp_content = NULL;
			}
		}
		else ERROROUT("*** aka_dispatch:Dropped Packet -- Src no entry");
	}

	if (pNew->sp_content) Free(pNew->sp_content);
	Free(pNew);
	return 0;
}
#endif

/********************************************************/
/*                                                      */
/********************************************************/
static int _statistics_timer(iTimerId, cpTimerName, cpParm, tptime)
int iTimerId;
char *cpTimerName;
char *cpParm;
struct timeval *tptime;
{
	int n;
	char buf[128];
/*
printf("_statistics_timer:called\n");
*/
	_statistics_fileout(tptime->tv_sec,0,
            tMsgCtl.rb_rctl->rb_used,tMsgCtl.rb_wctl->rb_used,
            0);
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _statistics(buf,iopt,mcat)
char *buf;
int  iopt[];
MCAT *mcat;
{
	static char *stat[]={"start","stop "};
	int len,ret=0,i,n;
	tdtTIMER_CTL *next;
	char *p;
	struct timeval tval;
	struct tm t;

	if (!(p=akb_log_get_proc_name())) p = nullname;
	aka_getm_sec(&tval);
	akxe_edit_elapse_time(tval.tv_sec,&t);
	sprintf(buf,"ProcName : %s    ElapseTime : %d(day) %02d:%02d:%02d\n\nTimerId  WaitTime(msec)  Status  Name\n",p,t.tm_mday,t.tm_hour,t.tm_min,t.tm_sec);
	if ((ret = akxtmcats(mcat,buf))<0) return ret;

	next = tMsgCtl.timer_ctl->th_ptimer;
	while (next) {
		if (next->tc_pfunc) {
			if (next->tc_status == AKX_TIMER_START) p = stat[0];
			else p = stat[1];
			sprintf(buf,"%7d  %8d         %s  %s\n",
			        next->tc_tmrid,
			        next->tc_watime, p,
			        next->tc_tmrname);
			if ((ret = akxtmcats(mcat,buf))<0) return ret;
		}
		next = next->tc_tmrnext;
	}

	sprintf(buf,"\nQUE   :R=%d W=%d\n",
	        tMsgCtl.rb_rctl->rb_used,
	        tMsgCtl.rb_wctl->rb_used);
	if ((ret = akxtmcats(mcat,buf))<0) return ret;

	ret = _statistics_edit(buf,mcat);
	return ret;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_shut_control(iopt,msg)
int iopt;
char *msg;
{
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_reply_msg(lInstanceHandle,tpReplyMsg)
long lInstanceHandle;
tdtMSG_COM *tpReplyMsg;
{
	pCOMM_PACK_HEAD    pHead;
	int iCh, iThread, iRc=0, len;
	char *cpPacket,*cpW,procname[16];
	ushort usClassId;
	tdtINSTANCE     *tpIns;
	tdtINST_HNDL     tInstHndl;

	if (!tpReplyMsg) return -1;
	if (tpReplyMsg->msg_mlen < 0) return -1;
#if 0
	pHead = tInst.pack_head;
#else
	/* NXƃXbhm̎o */
	if (lInstanceHandle) {
		if (iRc = aka_conv_inst_hndl(lInstanceHandle,&tInstHndl))
			return iRc - 18506502;
	/*
		iThread  = tInstHndl.thread;
		iClassId = tInstHndl.class_id;
		tpClass  = tInstHndl.class;
	*/
		tpIns    = tInstHndl.instance;
	}
	else return -18506504;

	pHead = tpIns->pack_head;
#endif

	iCh = _pHPToEntry(ntohl(pHead->cph_sinf.ind_hoid),
	                  ntohs(pHead->cph_sinf.ind_prid));
	if (iCh < 0) {
		ERROROUT("*** aka_reply_msg:Dropped Packet -- Src no entry");
		return iCh;
	}

	pHead->cph_dinf.ind_disp = 0;
	if (!(cpPacket=Malloc(sizeof(tdtCOMM_PACK_HEAD)+tpReplyMsg->msg_mlen)))
			return -1;
	pHead->cph_plen = htonl(tpReplyMsg->msg_mlen);
	pHead->cph_prt.prt_send = 0x00;
	memcpy(cpPacket,pHead,sizeof(tdtCOMM_PACK_HEAD));
	if (tpReplyMsg->msg_mlen && tpReplyMsg->msg_pmsg)
		memcpy(cpPacket+sizeof(tdtCOMM_PACK_HEAD),tpReplyMsg->msg_pmsg,
		       tpReplyMsg->msg_mlen);

	if (tMsgCtl.proc == AKB_PRID_PRMN || iCh == 0) {
		sprintf(procname,"P%d",tMsgCtl.proc);
		len=akb_mem_to_indir_f(procname,cpPacket,
		                   cpPacket+sizeof(tdtCOMM_PACK_HEAD),&cpW);
		if (len<0) {
			Free(cpPacket);
			ERROROUT1("aka_reply_msg:Dropped Packet -- akb_mem_to_indir_f error=%d",
			          len);
			return len;
		}
		else if (len>0) {
			Free(cpPacket);
			cpPacket = cpW;
		}
	}
	iRc = akb_set_rb_pack_err_cd(iCh,cpPacket,tMsgCtl.rb_wctl,0);
	if (iRc) {
		ERROROUT1("aka_reply_msg:Dropped Packet -- repry error=%d",iRc);
	}
	else akb_trace_out(2,cpPacket);

	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _cmd_conv(usClassId,cpMsg,pi_dlen,tpCmdCnv)
ushort usClassId;
char *cpMsg;
long pi_dlen;
tdtCMD_CNV *tpCmdCnv;
{
	static struct {
		char *name;
		short cmd;
	} tCmd[]={
		"START"			,AKB_CMD_START,
		"SHUT"			,AKB_CMD_SHUT,
		"FSHUT"			,AKB_CMD_FSHUT,
		"KILL"			,AKB_CMD_KILL,
		"TRACE"			,AKB_CMD_TRACE,
		"LOG"			,AKB_CMD_LOG,
		"QUERY"			,AKB_CMD_QUERY,
		"REQUEST"		,AKB_CMD_REQUEST,
	/*	"STATISTICS"	,AKB_CMD_STATISTICS,	*/
		"VER"			,AKB_CMD_VERSION,
		"VERSION"		,AKB_CMD_VERSION,
		"PASSWORD"		,AKB_CMD_PASSWORD,
		NULL,0};
	static char parm[129];
	char *argv[11],buf[129],*cpRec,*p;
	int n,len,i,iRecLen,m;
	long w[4];
	short s=0,sW;
	unsigned short us=0, usW;
	unsigned char uc=0;
	SSP_S ssp;

	memset(tpCmdCnv,0,sizeof(tdtCMD_CNV));
	if (usClassId < 2) {
		sW  = *(short *)cpMsg;
		s   = ntohs(sW);
		usW = *(unsigned short *)(cpMsg+2);
		us  = ntohs(usW);
		uc = us >> 8;
		tpCmdCnv->cmc_scmd = s;
		tpCmdCnv->cmc_prno = us;
		tpCmdCnv->cmc_ccmd    = uc;
		tpCmdCnv->cmc_mode   = us & 0x00ff;
	}
	else {
		memset(w,0,sizeof(w));
		tpCmdCnv->cmc_spec = 1;
		ssp.sp = 0;
		while ((iRecLen=akxtmgetline(cpMsg,pi_dlen,&ssp))>=0) {
			cpRec = ssp.wd;
			*(cpRec+iRecLen) = '\0';
			n = akxtgetargv2(cpRec,argv,11,parm,sizeof(parm),1);
			if (n > 0) {
				if ((m=n) > 4) m = 4;
				for (i=1;i<m;i++) {
				/*	if (akxcgcvn(argv[i],strlen(argv[i]),&w[i])) return -1;	*/
					akxcgcvn(argv[i],strlen(argv[i]),&w[i]);
				}
				if (!stricmp(argv[0],"C")) {
					if (n < 2) return -1;
					tpCmdCnv->cmc_scmd = w[1];
					tpCmdCnv->cmc_prno = w[2];
					tpCmdCnv->cmc_ccmd    = w[3];
					tpCmdCnv->cmc_mode   = w[2];
					tpCmdCnv->cmc_nprm = n - 1;
				/*
					memcpy(tpCmdCnv->cmc_parm,&argv[1],tpCmdCnv->cmc_nprm*sizeof(char *));
				*/
					memcpy(tpCmdCnv->cmc_parm,&argv[1],10*sizeof(char *));
					break;
				}
				else {
					tpCmdCnv->cmc_prno = w[1];
					tpCmdCnv->cmc_ccmd    = w[2];
					tpCmdCnv->cmc_mode   = w[1];
					tpCmdCnv->cmc_nprm = n;
				/*
					memcpy(tpCmdCnv->cmc_parm,argv,tpCmdCnv->cmc_nprm*sizeof(char *));
				*/
					memcpy(tpCmdCnv->cmc_parm,argv,11*sizeof(char *));
					for (i=0;p=tCmd[i].name;i++) {
/*
printf("_cmd_conv;i=%d name=[%s]\n",i,p);
*/
						if (!stricmp(argv[0],p)) {
							tpCmdCnv->cmc_scmd = tCmd[i].cmd;
							return 0;
						}
					}
					return -1;
				}
			}
		}
	}
/*
printf("s = 0x%04x, us = 0x%04x, uc = 0x%02x\n",s,us,uc);
*/
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _getverdate(p,pd)
char *p,**pd;
{
	int i=0;

	*pd = p;
	while (*p && *p!='[') p++;
	if (*p) {
		*pd = ++p;
		while (*p && *p!=']') {
			p++;
			i++;
		}
	}
	return i;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _verdate(tpRecvMsg,tpCmdCnv)
AKAMSGCOM *tpRecvMsg;
tdtCMD_CNV *tpCmdCnv;
{
	char *p,*pver,*pdate;
	int  vrlen,dtlen;

	vrlen = _getverdate(version,&pver);
	dtlen = _getverdate(make_date,&pdate);

	/* tCmdCnv.pi_dataɃf[^Ƃ́ASoCgJ */
	p = Malloc(4+vrlen+dtlen+3);
	if (p) {
		tpCmdCnv->pi_data = p;
	}
	else {
		ERROROUT("_verdate:Malloc Error");
		return D_ERR_MEM_ALLOC;
	}
	p += 4;
	memcpy(p,pver,vrlen);
	p += vrlen;
	*p++ = '\n';
	memcpy(p,pdate,dtlen);
	p += dtlen;
	*p++ = '\n';
	*p = '\0';
	tpCmdCnv->cmc_dlen = vrlen + dtlen + 7;
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _command_class(lInstanceHandle,cpInstanceData,tpRecvMsg)
long lInstanceHandle;
char *cpInstanceData;
AKAMSGCOM *tpRecvMsg;
{
	int   iRc, iReply, l, iwRc;
	short sCommand;
	ushort usProcId,usClassId;
	char  *cpRecvMsg,*cpSendMsg;
	uchar ucCmd, ucFlg, ucReply;
	long pi_dlen, lw;
	tdtCMD_CNV tCmdCnv;
	char *pAlloc,buf[32],msg[256],wait_name[40];
	AKAMSGCOM tReplyMsg;
	int (*pCommandFunc)();
	int iParm[10];

DEBUGOUTL2(AKA_LOG_GROUP|250,
"_command_class: Dispos=%d PackRet=%d",
tpRecvMsg->msg_disp,tpRecvMsg->msg_pret);
	if (tpRecvMsg->msg_disp == AKA_REGIST_CLASS ||
	    tpRecvMsg->msg_pret < 0) {
		return 0;
    }
	iwRc = iRc = 0;
	pAlloc = NULL;
	memset(&tCmdCnv,0,sizeof(tdtCMD_CNV));
	pi_dlen  = tpRecvMsg->msg_mlen;
	cpRecvMsg = tpRecvMsg->msg_pmsg;
  switch (tpRecvMsg->msg_disp) {
  case 0:
	ucReply = tpRecvMsg->msg_resv;
	if (cpRecvMsg) {
		usClassId = lInstanceHandle & 0xffff;
		_cmd_conv(usClassId,cpRecvMsg,pi_dlen,&tCmdCnv);
		sCommand = tCmdCnv.cmc_scmd;
		usProcId = tCmdCnv.cmc_prno;
		if (sCommand >= 0 && sCommand <= 255)
			pCommandFunc = _pCommandClass[sCommand];
		else
			pCommandFunc = NULL;
		if (pCommandFunc &&
		    (sCommand==AKB_CMD_START || sCommand==AKB_CMD_SHUT ||
		     sCommand==AKB_CMD_FSHUT || sCommand==AKB_CMD_KILL ||
		     sCommand==AKB_CMD_TRACE ||
		     sCommand==AKB_CMD_LOG   || sCommand==AKB_CMD_REQUEST) &&
		    aka_sys_password_check(tpRecvMsg->msg_prid)) {
			iRc = D_ERR_NO_PASSWORD;
		}
		else {
			switch( sCommand ) {
				case AKB_CMD_START:
				case AKB_CMD_QUERY:
				case AKB_CMD_REQUEST:
				case AKB_CMD_SHUT:
				case AKB_CMD_FSHUT:
				case AKB_CMD_KILL:
				case AKB_CMD_NOTIFY:
			/*	case AKB_CMD_BROADCAST:	*/
					if (pCommandFunc) iRc = pCommandFunc(tpRecvMsg,&tCmdCnv);
					else iRc = D_ERR_UNDEF_CMDEXEC;
					break ;
				case AKB_CMD_TRACE:
				case AKB_CMD_LOG:
				  if (sCommand ==AKB_CMD_TRACE) {
					if (usClassId == 2) {
						sprintf(buf,"%d",D_LOG_NO_TRACE);
						tCmdCnv.cmc_parm[0] = buf;
						if (tCmdCnv.cmc_nprm <= 2) {
							tCmdCnv.cmc_nprm = 3;
							tCmdCnv.cmc_parm[2] = "0";
						}
						akb_log_set_parm(tCmdCnv.cmc_nprm,tCmdCnv.cmc_parm,iParm);
						sprintf(msg+4,"CommandClass: Set trace usMode=0x%x ucCmd=%d sizemax=%d filemax=%d option=%d",iParm[1],iParm[2],iParm[3],iParm[4],iParm[5]);
					}
					else {
						ucCmd = tCmdCnv.cmc_ccmd;
						akb_trace_flg(ucCmd,tCmdCnv.cmc_mode);
						sprintf(msg+4,"CommandClass: Set trace usMode=0x%x, ucCmd=%d",tCmdCnv.cmc_mode,ucCmd);
					}
				  }
			/**********
					PRINTOUT(msg+4);
					tCmdCnv.cmc_spec |= 0x80;
					tCmdCnv.pi_data = msg;
					tCmdCnv.cmc_dlen   = 5 + strlen(msg+4);
					break ;
				case AKB_CMD_LOG:
			*********/
				  else {
					if (usClassId == 2) {
						akb_log_set_parm(tCmdCnv.cmc_nprm-1,&tCmdCnv.cmc_parm[1],iParm);
						sprintf(msg+4,"CommandClass: Set log logno=%d flg=%d level=%d sizemax=%d filemax=%d option=%d",iParm[0],iParm[1],iParm[2],iParm[3],iParm[4],iParm[5]);
					}
					else {
						ucFlg = tCmdCnv.cmc_ccmd;
						ucCmd = tCmdCnv.cmc_mode;
						if (ucCmd <= 3) akb_log_flg(ucCmd,ucFlg);
						sprintf(msg+4,"CommandClass: Set log logno = %d, flg = %d",ucCmd,ucFlg);
					}
				  }
					PRINTOUT(msg+4);
					tCmdCnv.cmc_spec |= 0x80;
					tCmdCnv.pi_data = msg;
					tCmdCnv.cmc_dlen   = 5 + strlen(msg+4);
					break ;
				case AKB_CMD_VERSION:
					iRc = _verdate(tpRecvMsg,&tCmdCnv);
					break ;
				case AKB_CMD_PASSWORD:
					tpRecvMsg->msg_pmsg = tCmdCnv.cmc_parm[1];
					tpRecvMsg->msg_mlen = strlen(tpRecvMsg->msg_pmsg);
					aka_sys_password_class(lInstanceHandle,cpInstanceData,tpRecvMsg);
					ucReply = 0;
					break ;
				default:
					iRc = D_ERR_UNKNOWN_CMD;
			}
		}
	}
	else {
		iRc = D_ERR_LESS_DATA;
	}
	if (ucReply && tCmdCnv.cmc_dlen >= 0) {
		if ((iwRc = iRc) == D_ERR_REPLY_WAIT) iwRc = 0;
		if ((tCmdCnv.cmc_spec & 0x01)== 0) {
			lw = htonl(iwRc);
			/* tCmdCnv.pi_dataɃf[^Ƃ́ASoCgJĂ */
			if (tCmdCnv.cmc_dlen > 4) {
				cpSendMsg = tCmdCnv.pi_data;
				pi_dlen  = tCmdCnv.cmc_dlen;
			}
			else {
				cpSendMsg = buf;
				pi_dlen  = 4;
			}
			memcpy(cpSendMsg,&lw,4);
		}
		else {
			sprintf(buf,"R %d\n",iwRc);
			l = strlen(buf);
			if (tCmdCnv.cmc_dlen > 4) {
				tCmdCnv.cmc_dlen -= 4;
				pi_dlen = l + tCmdCnv.cmc_dlen + 1;
				if (pAlloc = Malloc(pi_dlen)) {
					cpSendMsg = pAlloc;
					memcpy(cpSendMsg,buf,l);
					memcpy(cpSendMsg+l,tCmdCnv.pi_data+4,tCmdCnv.cmc_dlen);
					*(cpSendMsg+l+tCmdCnv.cmc_dlen) = '\0';
				}
				else {
					iRc = D_ERR_MEM_ALLOC;
					sprintf(buf,"R %d\n",iRc);
					cpSendMsg = buf;
					pi_dlen  = strlen(buf) + 1;
				}
			}
			else {
				cpSendMsg = buf;
				pi_dlen  = l + 1;
			}
		}
		memset(&tReplyMsg,0,sizeof(AKAMSGCOM));
		tReplyMsg.msg_pmsg   = cpSendMsg;
		tReplyMsg.msg_mlen = pi_dlen;
		if (iRc == D_ERR_REPLY_WAIT) {
			iwRc = tCmdCnv.cmc_wait;
			tReplyMsg.msg_disp = 1;
			sprintf(wait_name,AKAS_REPLY_WAIT_TIMER_NAME,usProcId);
			iRc = aka_set_wait(lInstanceHandle,&tReplyMsg,iwRc,wait_name);
DEBUGOUTL2(AKA_LOG_GROUP|250,
"_command_class: aka_set_wait() ret=%d",iRc);
			if (iRc) iwRc = 0;
		}
		else iwRc = 0;
		if (iwRc == 0) aka_reply_msg(lInstanceHandle,&tReplyMsg);
	}
	if (pAlloc) Free(pAlloc);
	if (!(tCmdCnv.cmc_spec & 0x80) && tCmdCnv.pi_data) Free(tCmdCnv.pi_data);
	break;
  case 1:
		memset(&tReplyMsg,0,sizeof(AKAMSGCOM));
		tReplyMsg.msg_pmsg   = cpRecvMsg;
		tReplyMsg.msg_mlen = pi_dlen;
		aka_reply_msg(lInstanceHandle,&tReplyMsg);
		iwRc = 0;
  }
	return iwRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_set_inst_comment(lInstanceHandle, cpText)
long lInstanceHandle;
char *cpText;
{
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_del_reply_wait(usProcId)
ushort usProcId;
{
	tdtWAIT_PACKET *tpWait;
	int procno;
	char wrk[40];

	procno = usProcId;

DEBUGOUTL1(AKA_LOG_GROUP|250,"aka_del_reply_wait: procno=%d",procno);
	sprintf(wrk,AKAS_REPLY_WAIT_TIMER_NAME,procno);
	aka_wake_up_timer(2,wrk,AKAS_REPLY_WAIT_WAKEUP_EVENT);
	return 0;
}

#if 0
/********************************************************/
/*                                                      */
/********************************************************/
static int _wait_msg_timer(iTimerId, cpTimerName, cpParm, tptime, iEvent)
int iTimerId;
char *cpTimerName;
char *cpParm;
struct timeval *tptime;
int iEvent;
{
	tdtWAIT_PACKET *tpWait,*pRc;
	int pid,i;

DEBUGOUTL4(AKA_LOG_GROUP|250,
"_wait_msg_timer:called TimerId=%d Name=[%s] Parm=%08x Event=%d",
iTimerId,cpTimerName, cpParm,iEvent);

	if (akb_set_rb_pack_err_cd(0,cpParm,tMsgCtl.rb_rctl,iEvent)<0) {
		ERROROUT1("_wait_msg_timer: name=[%s] resend error",cpTimerName);
		Free(cpParm);
	}
DEBUGOUTL1(AKA_LOG_GROUP|250,"_wait_msg_timer:exit Name=[%s]",cpTimerName);
	return -1;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_set_wait(lInstanceHandle,tpWaitMsg,iWaitTime,cpWaitName)
long lInstanceHandle;   /* CX^Xʔԍ */
AKAMSGCOM *tpWaitMsg;
int  iWaitTime;    /* >=0 :bZ[W̃^CAEg(msec) */
char *cpWaitName;
{
	tdtCOMM_PACK_HEAD tHead;
	char *cpParm,*p,wrk[40];
	uchar  ucThread;
	int    iRc,len;
	ushort usClassId,usWrk;

	if (!tpWaitMsg || !cpWaitName) return -1;
	if (tMsgCtl.sd<0) return -1;

	usClassId = lInstanceHandle & 0x0000ffff;
	ucThread  = (lInstanceHandle>>16) & 0x000000ff;
	memset(&tHead,0,sizeof(tdtCOMM_PACK_HEAD));
	tHead.cph_prt.prt_ver        = 'C';
	tHead.cph_prt.prt_cmnd    = htons(AKB_CMD_SEND);
	tHead.cph_sinf.ind_hoid      = htonl(tMsgCtl.host_id);
	tHead.cph_sinf.ind_disp     = tpWaitMsg->msg_disp;
	tHead.cph_sinf.ind_thrd     = ucThread;
	usWrk  = tMsgCtl.proc;
	tHead.cph_sinf.ind_prid  = htons(usWrk);
	tHead.cph_sinf.ind_clid    = htons(usClassId);
	len = sizeof(tdtCOMM_PACK_HEAD)+tpWaitMsg->msg_mlen;
	tHead.cph_plen            = htonl(len);

	if (!(cpParm=Malloc(sizeof(tdtCOMM_PACK_HEAD)+len))) {
		return -1;
	}
	memcpy(cpParm,&tHead,sizeof(tdtCOMM_PACK_HEAD));
	p = cpParm + sizeof(tdtCOMM_PACK_HEAD);
	memcpy(p,tpWaitMsg->msg_pmsg,tpWaitMsg->msg_mlen);
	p += tpWaitMsg->msg_mlen;
	memcpy(p,tInst.pack_head,sizeof(tdtCOMM_PACK_HEAD));
if (DEBUGOUTCHECK(AKA_LOG_GROUP|252))
akxaxdump("aka_set_wait:cpParm",cpParm,len+sizeof(tdtCOMM_PACK_HEAD));
	if (!(p=cpWaitName)) {
		sprintf(wrk,"WAIT_MSG%x",cpParm);
		p = wrk;
	}
	iRc = aka_register_timer(p,_wait_msg_timer,iWaitTime,cpParm);
	if (iRc <= 0) {
		if (cpParm) Free(cpParm);
		return -1;
	}
DEBUGOUTL3(AKA_LOG_GROUP|250,
"aka_set_wait: TimerId=%d name=[%s] time=%d",iRc,p,iWaitTime);
	return 0;
}
#else

/********************************************************/
/*                                                      */
/********************************************************/
static tdtWAIT_PACKET *new_wait_packet(tpIns)
tdtINSTANCE *tpIns;
{
	tdtWAIT_PACKET *tpWait,*tpNext;
	char *cpWaitPacket;

	/* Xg̖T */
	tpWait = tpIns->wait_next;
	while (tpWait) {
		tpNext = tpWait;
		tpWait = tpNext->wait_next;
	}

	/* V\̂쐬 */
	if (!(tpWait=(tdtWAIT_PACKET *)Malloc(sizeof(tdtWAIT_PACKET)))) return NULL;
	memset(tpWait,0,sizeof(tdtWAIT_PACKET));

	/* V\̂Xg̖ɂȂ */
	if (tpIns->wait_next) tpNext->wait_next = tpWait;
	else                   tpIns->wait_next  = tpWait;

	return tpWait;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _wait_msg_timer(iTimerId, cpTimerName, cpParm, tptime, iEvent)
int iTimerId;
char *cpTimerName;
char *cpParm;
struct timeval *tptime;
int iEvent;
{
	tdtWAIT_PACKET *tpWait,*pRc;
	int pid,i;

DEBUGOUTL4(AKA_LOG_GROUP|250,
"_wait_msg_timer:called TimerId=%d Name=[%s] Parm=%08x Event=%d",
iTimerId,cpTimerName, cpParm,iEvent);

	aka_wake_up_msg(cpParm,iEvent);
DEBUGOUTL1(AKA_LOG_GROUP|250,"_wait_msg_timer:exit Name=[%s]",cpTimerName);
	return -1;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_set_wait(lInstanceHandle,tpWaitMsg,iWaitTime,cpWaitName)
long lInstanceHandle;   /* CX^Xʔԍ */
AKAMSGCOM *tpWaitMsg;
int  iWaitTime;    /* >=0 :bZ[W̃^CAEg(msec) */
char *cpWaitName;
{
	tdtCOMM_PACK_HEAD tHead;
	char *cpParm,*p,wrk[40];
	uchar  ucThread;
	int    iRc,len;
	ushort usClassId,usWrk;
	char   *cpPacket;
	tdtINST_HNDL     tInstHndl;
	tdtINSTANCE     *tpIns;
	tdtWAIT_PACKET   *tpWait;
	long            lmsec;
	struct timeval  ttime;

	if (!tpWaitMsg || !cpWaitName) return -1;
	if (tMsgCtl.sd<0) return -1;

	/* NXƃXbhm̎o */
	if (iRc = aka_conv_inst_hndl(lInstanceHandle,&tInstHndl))
		return iRc - 18506402;	/* iRc:-1 ... -4 */
	ucThread  = tInstHndl.thread;
	usClassId = tInstHndl.class_id;
/*	tpClass   = tInstHndl.tpClass;	*/
	tpIns     = tInstHndl.instance;

	memset(&tHead,0,sizeof(tdtCOMM_PACK_HEAD));
	tHead.cph_prt.prt_ver        = 'C';
	tHead.cph_prt.prt_cmnd    = htons(AKB_CMD_SEND);
	tHead.cph_sinf.ind_hoid      = htonl(tMsgCtl.host_id);
	tHead.cph_sinf.ind_disp     = tpWaitMsg->msg_disp;
	tHead.cph_sinf.ind_thrd     = ucThread;
	usWrk  = tMsgCtl.proc;
	tHead.cph_sinf.ind_prid  = htons(usWrk);
	tHead.cph_sinf.ind_clid    = htons(usClassId);
	len = tpWaitMsg->msg_mlen;
	tHead.cph_plen            = htonl(len);

	if (!(cpPacket=Malloc(sizeof(tdtCOMM_PACK_HEAD)+len))) {
		return -1;
	}
	memcpy(cpPacket,&tHead,sizeof(tdtCOMM_PACK_HEAD));
	p = cpPacket + sizeof(tdtCOMM_PACK_HEAD);
	memcpy(p,tpWaitMsg->msg_pmsg,tpWaitMsg->msg_mlen);

	if (lInstanceHandle && tHead.cph_sinf.ind_disp) {
		/* ^CAEgݒ */
		if ((lmsec=aka_getm_sec(&ttime))<0) return -18506409;
		if (iWaitTime < 0) iWaitTime = tMsgCtl.send_msg_time_out;
		akxe_timer_addmsec(&ttime,&ttime,iWaitTime);
		if (tMsgCtl.send_msg_min_wait < 0 ||
		    iWaitTime < tMsgCtl.send_msg_min_wait)
			tMsgCtl.send_msg_min_wait = iWaitTime;

		/* vpPbg\̒ǉ */
		if (!(tpWait=new_wait_packet(tpIns))) return -18506410;
		akxe_timer_set(&tpWait->time_out,&ttime);
		tpWait->status |= AKA_WMSG_NULL_CLASS;
		tpWait->wait_packet=cpPacket;
	}

	if (!(p=cpWaitName)) {
		sprintf(wrk,"WAIT_MSG%d",lInstanceHandle);
		p = wrk;
	}
	iRc = aka_register_timer(p,_wait_msg_timer,iWaitTime,lInstanceHandle);
	if (iRc <= 0) {
		return -1;
	}
DEBUGOUTL3(AKA_LOG_GROUP|250,
"aka_set_wait: TimerId=%d name=[%s] time=%d",iRc,p,iWaitTime);
	return 0;
}
#endif
#include "akaclass.c"
#include "akaclass.c"
