/*static char sccsid[]="%Z% %M% %I% %E% %U%";*/
/************************************************************************/
/*																		*/
/*		akxlib.h														*/
/*																		*/
/*			Coded by Akito Kobayashi	2010.5.28						*/
/*																		*/
/************************************************************************/
#ifndef _AKXLIB_H
#define _AKXLIB_H

#define AKX_TRIM_SPACE	" \t\r\n"
#define AKX_TRIM_SPACE2	" \t\r\n@"

typedef struct _SSP_S {
	int  sp;
	char *wd;
	uchar attr[4];
} SSP_S;

typedef struct _SSPL_S {
	int  sp;
	char *wd;
	uchar attr[4];
	short wdmax;
	uchar code;
	uchar resv;
} SSPL_S;

int akxtgwsp(/*buf, ssp*/);
int akxtgwnsl(/*buf, len, sspl, sep, opt*/);
int akxtgwns(/*buf, len, ssp, sep, opt*/);
int akxtgwse(/*buf, ssp, sep, opt*/);
int akxtpknsl(/*s, slen, ssp, sep, opt*/);
int akxtpkns(/*s, slen, ssp, sep, opt*/);
extern int akxafxdmp();
extern int akxaxdump();

#if 1	/* 2020.3.30 <-- cllocal.h */
typedef struct ParList {		/*** p[^Xg ***/
	int  parlen;
	char *par;
} ParList;
#endif

#if 1	/* 2022.5.11 */
typedef struct ParList2 {		/*** p[^Xg2 ***/
	int  option;
	int  parlen;
	char *par;
} ParList2;
#endif
#if 1	/* 2022.6.20 */
typedef struct ParList3 {		/*** p[^Xg3 ***/
	int  option;
	int  parlen;
	int  parlen2;
	char *par;
} ParList3;
#endif

typedef struct {
	int ac_opt;
	char *(*ac_malloc)();
	tdtCONSTCT *ac_constct;
	char *ac_aux;
} tdtAllocCtl;

/*****************************************
	nbVǗ
*****************************************/
/*#define AKX_HASX_OPT_NO_USE_ALL	1	*/
#define AKX_HASX_OPT_CASE_KEY	1
#define AKX_HASX_OPT_IGN_KANJ	2
#define AKX_HASX_OPT_NO_NEXT	4
#define AKX_HASX_OPT_USE_MALLOC	8
#define AKX_HASX_OPT_TMP_MALLOC	0x10
#define AKX_HASX_OPT_RESET_MEM	0x20
#define AKX_HASX_ID_NO_USE_ALL	'U'
#define AKX_HASX_ID_NO_NEXT		'N'
#define AKX_HASX_MULTIPLIER1	31
#define AKX_HASX_MULTIPLIER2	37

typedef struct {
	char	ha_id[2];
	short	ha_keylen;
	int 	ha_maxreg;
	int 	ha_prereg;
	char	*ha_reg;
	int 	*ha_next;
	char	*ha_key;
	int 	ha_aux;
	int 	ha_hix;
} HASHB;

HASHB *akxs_hasxm_new2(/*sKeyLen,lMaxReg,lPreReg,iOpt,m_alloc,pConstCt*/);
HASHB *akxs_hasx_new2();	/* (short xha_keylen,long xha_maxreg,long xha_prereg,int iOpt);	*/
HASHB *akxs_hasx_new();		/* (short xha_keylen,long xha_maxreg,long xha_prereg);	*/
int akxs_free_reg(/*maxreg,datlen,reg*/);
int akxs_hasx_free();		/* (HASHB *tph);	*/
int akxs_hasx_pre_reg();	/* (long xha_maxreg);	*/

HASHB *akxs_seqs_new();		/* (sKeyLen,lMaxReg) */
HASHB *akxs_sram_new(/*sKeyLen,opt*/);
int akxs_sram_free(/*tph*/);
int akxs_sram(/*func,hp*/);

typedef struct {
	long hc_flag;
	long hc_hkey;
	long hc_next;
	int  *hc_datp;
} tdtHASL_CELL;

typedef struct {
	long hc_flag;
	long hc_hkey;
	long hc_next;
	int  *hc_datp;
	ulong hc_akey[4];
} tdtHASL_CELL4;

HASHB *akxs_hasl_new();	/* (short xha_keylen,long xha_maxreg,long xha_prereg);	*/
int  akxs_hasl_free();	/* (HASHB *tph);	*/

HASHB *akxs_hasl2_new();	/* (short xha_keylen,long xha_maxreg,long xha_prereg);	*/
int  akxs_hasl2_free();	/* (HASHB *tph);	*/

HASHB *akxs_hasl_new2();	/* (short xha_keylen,long xha_maxreg,long xha_prereg,int iOpt);	*/
HASHB *akxs_hasl2_new2();	/* (short xha_keylen,long xha_maxreg,long xha_prereg,int iOpt);	*/

int akxshasli(/*hp*/);
int akxshasls(/*hp,key*/);
int akxshaslr(/*hp,key*/);
int akxshasld(/*hp,key*/);
int akxshaslk(/*hp,keyp*/);
int akxshaslp(/*hp*/);
int akxshaslu(/*hp*/);
int akxs_hasl_free(/*tph*/);
int akxshasl(/*func,hp*/);

int akxshasl2k(/*hp,key*/);
int akxshasl2(/*func,hp*/);

int akxs_xhasl(/*tpxhashb,cCmnd,key,ippDat*/);
int akxs_xhasl_free(/*tpxhashb*/);

int akxs_xhasl2(/*tpxhashb,cCmnd,key,ippDat*/);
int akxs_xhasl2_free(/*tpxhashb*/);

/*****************************************
	gnbVǗ
*****************************************/
typedef struct XHASHB {
	char	xha_id[2];
	short	xha_keylen;
	int 	xha_maxreg;
	int 	xha_prereg;
	int 	xha_xhix;
	HASHB	*xha_hashb;
	struct XHASHB *xha_xhnext;
#if 1
	short	xha_datlen;
	short	xha_option;
#else
	int		xha_datlen;
#endif
	char	*xha_datreg;
#if 1	/* 2021.9.9 */
	char    *(*xha_malloc)();
	tdtCONSTCT *xha_constct;
#endif
} XHASHB;

XHASHB *akxs_xhashm_new2(/*sKeyLen,lMaxReg,lPreReg,lDatLen,iOpt,m_alloc,pConstCt*/);
XHASHB *akxs_xhash_new2(/*sKeyLen,lMaxReg,lPreReg,lDatLen*/);
XHASHB *akxs_xhash_new(/*xha_keylen,xha_maxreg,xha_prereg*/);
XHASHB *akxs_xhash_init(/*xha_keylen,xha_maxreg,xha_prereg*/);
int akxs_xhash_free(/*tpxhashb*/);
int akxs_xhashn2(/*tpxhashb,cCmnd,cpKey,aux_klen,cppDat*/);
int akxs_xhash2(/*tp_xhashb,cCmd,cpKey,cpDat*/);
int akxs_xhashn(/*tpxhashb,cCmd,cpKey,aux_len*/);
int akxs_xhash();		/* (tp_xhashb,cCmd,cpKey) */
int akxs_dreg_proc(/*tpX,cCmd,i,cppDat*/);
int akxs_xhash_reset(/*tpxhashb*/);
int akxs_sram(/*func,hp*/);
HASHB *akxs_sram_new(/*sKeyLen,opt*/);
int akxs_sram_free(/*tph*/);

int akxshasl2(/*func,hp*/);
int akxs_xhasl(/*tpxhashb,cCmnd,key,ippDat*/);
int akxs_xhasl_free(/*tpxhashb*/);

/*****************************************
	Sequencal search
*****************************************/
HASHB *akxs_seqsm_new(/*sKeyLen,lMaxReg,iOpt,m_alloc,pConstCt*/);
HASHB *akxs_seqs_new();	/* (sKeyLen,lMaxReg) */
int   akxs_seqs_free();	/* (HASHB *tph);	*/

XHASHB *akxs_xseqsm_new2(/*sKeyLen,lMaxReg,lDatLen,iOpt,m_alloc,pConstCt*/);
XHASHB *akxs_xseqs_new2();	/* (sKeyLen,lMaxReg,lDatLen) */
XHASHB *akxs_xseqs_new();	/* (sKeyLen,lMaxReg,lPreReg) */
int akxs_xseqs_free(/*tp_xseqsb*/);
int akxs_xseqs2(/*tp_xseqsb,cCmnd,cpKey,cppDat*/);
int akxs_xseqs(/*tp_xseqsb,cCmd,cpKey*/);
int akxs_seqr_str(/*stra,max_stra,str,opt*/);
int akxs_seqr_str_num(/*stra,max_stra,str,opt*/);
int akxs_seqr_ptr(/*ptra,max_ptra,ptr*/);
int akxs_seqr_str_grp(/*stra,max_stra,str,opt,posa*/);
int akxs_seqr_str2(/*stra,max_stra,str,opt*/);
int akxs_iseq_opt(/*ia,max_ia,val,opt*/);
int akxs_iseq(/*ia,max_ia,val*/);
int akxs_ins_sseq(/*da,d_pos,max_da,s_val,size*/);
int akxs_ins_sseq_array(/*da,d_pos,max_da,sa,s_pos,n_sa,size,opt*/);
int akxs_ins_shseq(/*da,d_pos,max_da,s_val*/);
int akxs_ins_shseq_array(/*da,d_pos,max_da,sa,s_pos,n_sa,opt*/);
int akxs_sseq_mline(/*pat,patlen,mem,memlen*/);
XHASHB *akxs_xseqlm_new(/*max_reg,m_alloc,pConstCt*/);
HASHB *akxs_seqlm_new(/*max_reg,m_alloc,pConstCt*/);
int akxs_seql_i(/*ha,max_reg*/);
int akxs_seql_r(/*ha,lVal*/);
int akxs_seql_s(/*ha,lVal*/);
int akxs_seql_d(/*ha,lVal*/);

/*****************************************
	Binary Tree
*****************************************/
typedef struct _BINS_LEAF {
	char *keyp;
	char *datp;
	struct _BINS_LEAF *left;
	struct _BINS_LEAF *right;
	int  count_a;
	int  count_l;
	int  count_r;
} tdtBINS_LEAF;

HASHB *akxs_bins_new();	/* (short xha_keylen,long xha_maxreg);	*/
int    akxs_bins_free();	/* (HASHB *tph);	*/

/*****************************************
	B-Tree
*****************************************/
#define BTREE_MAX_CELL	4
typedef struct _BTREE_CELL {
	struct _BTREE_NODE *next;
	int  key;
	char *keyp;
	char *datp;
} tdtBTREE_CELL;

typedef struct _BTREE_NODE {
	int max_cell;
	int used_cell;
	struct _BTREE_CELL node_cell[BTREE_MAX_CELL+1];
	struct _BTREE_NODE *next;
	struct _BTREE_NODE *prev;
} tdtBTREE_NODE;

HASHB *akxsbtree_new();	/* (short xha_keylen,long xha_maxreg);	*/
int    akxsbtree_free();	/* (HASHB *tph);	*/

/*****************************************
	GAgA
*****************************************/
typedef struct {
	char   mc_id[2];
	ushort mc_extlen;
	ushort mc_maxcnt;
	ushort mc_extcnt;
	int    mc_alclen;
	char  *mc_bufp;
	int    mc_ipos;
} MCAT;

typedef struct {
	char   mc_id[2];
	ushort mc_extlen;
	ushort mc_maxcnt;
	ushort mc_extcnt;
	int    mc_alclen;
	char  *mc_bufp;
	int    mc_ipos;
	char *(*mc_malloc)();
	tdtCONSTCT *mc_constct;
	short  mc_mlen;
	short  mc_resv;
} MCAT2;

typedef struct {
	char   mc_id[2];
	ushort mc_extlen;
	ushort mc_maxcnt;
	ushort mc_extcnt;
	int    mc_alclen;
	char  *mc_bufp;
	int    mc_ipos;
	char *(*mc_malloc)();
	tdtCONSTCT *mc_constct;
	tdtCMBCTL *mc_cmb;
	tdtCMBCTL *mc_cur;
} MCAT3;

int akxtmmanfunc(/*cmd,pM,s,len,_opt_malloc*/);
int akxtmman(/*cmd,pM,s,len*/);
int akxtmcat(/*pM,s,len*/);
int akxtmset(/*pM,c,len*/);
int akxtmexp(/*pM,len*/);
int akxtmcatz(/*pM,s,len*/);
int akxtmcats(/*pM,s*/);
int akxtmcat2(/*pM,s,len*/);
int akxtmcats2(/*pM,s*/);
int akxtmcatz2(/*pM,s,len*/);
int akxtmcat3(/*pM,s,len*/);
int akxtmcats3(/*pM,s*/);
int akxtmcatz3(/*pM,s,len*/);

/*****************************************
	Xy[X
*****************************************/
#define InodeSize	128
#define MsBCBufSize	65536
/*	#define MsBlockSize	4096	*/
#define MsBlockSize	512
#define BlockListSize	(MsBlockSize-16)/4
#define MemListSize	(MsBlockSize-16)/4
#define MsBCSize	MsBCBufSize/MsBlockSize

typedef struct {
	unsigned char  bc_updt;
	unsigned char  bc_indn;
	unsigned short bc_dats;
	int 	bc_msbn;
	int 	bc_blkn;
	short	bc_next;
	char	*bc_bufp;
} tdtMSBC;

typedef struct _BLOCK_LIST {
	char	bl_id[2];
	char	bl_dum[2];
	short	bl_max;
	short	bl_rem;
	struct _BLOCK_LIST *bl_next;
	int 	bl_myno;
	int 	bl_no[BlockListSize];
} tdtBLOCK_LIST;

typedef struct {
	char	ms_id[2];
	char	ms_dum1;
	char	ms_dum2;
	int		ms_fh;
	char	*ms_fnap;
	ushort	ms_blsz;
	ushort	ms_insz;
	int 	ms_fmbl;
	int 	ms_crbn;
	int 	ms_mxbl;
	tdtBLOCK_LIST *ms_stBL;
	tdtMSBC	*ms_BC;
} tdtMS_S;

typedef struct {
	char	ml_id[2];
	char	ml_dum[2];
	short	ml_max;
	short	ml_used;	/* 0 to (MemListSize-1) */
	int 	ml_next;
	int 	ml_myno;
	int 	ml_no[MemListSize];
} tdtMEM_LIST;

typedef struct {
	char	in_name[16];
	int 	in_stML;
	int 	in_crML;
	int 	in_size;
	int 	in_opct;	/* open count */
} tdtMS_INODE;

extern int akxa_ms_create();
extern int akxa_ms_open();
extern int akxa_ms_cloce();
extern int akxa_ms_drop();
extern int akxa_ms_alloc();
extern int akxa_ms_free();
extern int akxa_ms_read();
extern int akxa_ms_write();

/*****************************************
	Oobt@Ǘ
*****************************************/
typedef struct _RB_CHAIN {
	struct _RB_CHAIN *rbc_next;
	char *rbc_buf;
} tdtRB_CHAIN;

typedef struct {
	int rb_bfsz;
	int rb_max;
	int rb_num;
	int rb_used;	/* add 2000.6.10 Koba */
	tdtRB_CHAIN *rb_raddr;
	tdtRB_CHAIN *rb_waddr;
	tdtRB_CHAIN *rb_wpriv;
	int rb_pos;	/* add 2001.4.6 Koba */
	tdtRB_CHAIN *rb_cur;	/* add 2001.4.6 Koba */
	char *(*rb_malloc)();
	tdtCONSTCT *rb_constct;
} tdtRB_CTL;

extern tdtRB_CTL *akxs_rb_new();
extern tdtRB_CTL *akxs_rb_new2();
extern tdtRB_CTL *akxs_rb_init();
extern char *akxs_rb_get();
extern char *akxs_rb_get_n();
extern char *akxs_rb_set_n();
extern char *akxs_rb_srch(/*tdtRB_CTL *,char *,int (*)()*/);
extern char *akxs_rb_read(/*tdtRB_CTL *,int*/);
char *akxs_rb_set_t(/*pCt, addr*/);

extern tdtRB_CHAIN *akxs_xhasl_new();	/* (short xha_keylen,long xha_maxreg,long xha_prereg,int iOpt);	*/
extern tdtRB_CHAIN *akxs_xhasl2_new();	/* (short xha_keylen,long xha_maxreg,long xha_prereg,int iOpt);	*/

tdtRB_CTL *akxs_list_new();
tdtRB_CTL *akxs_elist_new();
tdtRB_CHAIN *akxs_xhasl_new(/*sKeyLen,lMaxReg,lPreReg,iOpt*/);
int akxs_rb_all_free(/*pCt*/);
int akxs_list_free(/*pCt,free_func*/);
int akxs_list_get(/*pCt,pp*/);
int akxs_list_set(/*pCt, addr*/);
int akxs_list_srch(/*pCt, addr, compar, opt*/);
int akxs_list_read(/*pCt, cmd, pp*/);
int akxs_rb_used(/*pCt*/);
int akxs_rb_free(/*pCt*/);

int akxs_stack_init(SSPL_S *stack,int max_stack);
SSPL_S *akxs_stack_new(int max_stack);
int akxs_stack_free(SSPL_S *stack);
int akxs_stack_push(SSPL_S *stack,char *val);
int akxs_stack_pop(SSPL_S *stack,char **val);
int akxs_stack_peek(SSPL_S *stack,char **val);
int akxs_stack_srch(SSPL_S *stack,char *val,int opt);

MCAT2 *akxs_layer_new(/*imax,m_alloc,pConstCt*/);
int akxs_layer_i(/*mcat*/);
int akxs_layer_set(/*mcat,ilay,lVal*/);
int akxs_layer_r(/*mcat,ilay,lVal*/);
int akxs_layer_s(/*mcat,lVal*/);

MCAT2 *akxs_mseq_new(/*mlen,imax,m_alloc,pConstCt*/);
int akxs_mseq_i(/*mcat*/);
int akxs_mseq_set(/*mcat,ilay,mem*/);
int akxs_mseq_r(/*mcat,mem*/);
int akxs_mseq_s(/*mcat,mem*/);
int akxs_mseq_get(/*mcat,ilay,mem*/);

/*****************************************
	L[Ǘ
*****************************************/
#define QUE_PUT_TOP 	10	/* TOPɒǉ */
#define QUE_PUT_BOT 	11	/* BOTTOMɒǉ */
#define QUE_PUT_CUR		12	/* CURRENTɒǉ */
#define QUE_GET_TOP 	20	/* TOPo */
#define QUE_GET_BOT 	21	/* BOTTOMo */
#define QUE_GET_CUR 	22	/* CURRENTo */
#define QUE_PEEK_TOP 	30	/* TOP𒲂ׂ */
#define QUE_PEEK_BOT 	31	/* BOTTOM𒲂ׂ */
#define QUE_PEEK_CUR 	32	/* CURRENT𒲂ׂ */
#define QUE_PEEK_NEXT	33	/* CURRENT𒲂ׁACURRENTɈړ */
#define QUE_PEEK_PREV	34	/* CURRENT𒲂ׁACURRENTOɈړ */
#define QUE_MOVE_PEEK_NEXT	35	/* CURRENTɈړACURRENT𒲂ׂ */
#define QUE_MOVE_PEEK_PREV	36	/* CURRENTOɈړACURRENT𒲂ׂ */
#define QUE_MOVE_TOP	40	/* TOPCURRENTړ */
#define QUE_MOVE_BOT	41	/* BOTTOMCURRENTړ */
#define QUE_MOVE_NEXT	43	/* CURRENTړ */
#define QUE_MOVE_PREV	44	/* OCURRENTړ */
#define QUE_MOVE_TOPP	45	/* TOP̑OCURRENTړ */
#define QUE_MOVE_BOTN	46	/* BOTTOM̎CURRENTړ */
#define QUE_GET 	QUE_GET_TOP
#define QUE_PUT 	QUE_PUT_BOT
#define QUE_PEEK	QUE_PEEK_TOP
#define QUE_MOVE	QUE_MOVE_NEXT

#define QUE_DFLT	99	/*  */
#define QUE_TOP 	100	/* TOP𑀍삷 */
#define QUE_BOT 	101	/* BOTTOM𑀍삷 */
#define QUE_CUR		102	/* CURRENT𑀍삷 */
#define QUE_AFT_NEXT	103	/* CURRENT𑀍삵ACURRENTɈړ */
#define QUE_AFT_PREV	104	/* CURRENT𑀍삵ACURRENTOɈړ */
#define QUE_NEXT	105	/* CURRENTɈړACURRENT */
#define QUE_PREV	106	/* CURRENTOɈړACURRENT */
#define QUE_TOP_PREV	107	/* TOP̑OCURRENTړ */
#define QUE_BOT_NEXT	108	/* BOTTOM̎CURRENTړ */

typedef struct _QUE_CHAIN {
	struct _QUE_CHAIN *qc_next;
	struct _QUE_CHAIN *qc_prev;
	char *qc_buf;
} tdtQUE_CHAIN;

typedef struct {
	int qct_bfsz;
	int qct_max;
	int qct_num;
	int qct_used;	/* add 2000.6.10 Koba */
	tdtQUE_CHAIN *qct_top;
	tdtQUE_CHAIN *qct_bot;
	tdtQUE_CHAIN *qct_cur;
	tdtQUE_CHAIN *qct_fre;
} tdtQUE_CTL;

extern tdtQUE_CTL *akxs_que_init();
extern tdtQUE_CTL *akxs_que_new();
int akxs_que_ctl(/*pCt,iOpt,cppBuff*/);
extern int akxs_que_get();
extern int akxs_que_put();
int akxs_que_peek(/*pCt,iOpt,cppBuff*/);
int akxs_que_move(/*pCt,iOpt*/);
extern int akxs_que_free();
int akxs_que_buf_free(/*pCt*/);
int akxs_que_all_free(/*pCt*/);

/*****************************************
	LbVǗ
*****************************************/
#define AKX_CACHE_EXTENT	10
#define AKX_CACHE_FIXEDKEYL	0x01
#define AKX_CACHE_MEMCMP	0x02
#define AKX_CACHE_DATASAVE	0x04
#define AKX_CACHE_IGNCHKERR	0x08
#define AKX_CACHE_NOAUTOEXT	0x10
#define CACHE_EXTENT		AKX_CACHE_EXTENT

typedef struct _CACHE_CTL {
	char *ca_key;
	char *ca_cmp1;
	char *ca_cmp2;
	char *ca_data;
	int   ca_cmpnext;
	int   ca_chktime;	/* Check time */
	struct timeval ca_tval;
	int   ca_locktime;	/* Lock to time */
} tdtCACHE_CTL;

typedef struct _LIST_CHAIN {
	struct _LIST_CHAIN *lc_next;
	struct _LIST_CHAIN *lc_prev;
	tdtCACHE_CTL *lc_cactl;
	int lc_count;
} tdtLIST_CHAIN;

typedef struct {
#ifdef CACHE_QUE
#else
#ifdef CACHE_XHAS
#else
#ifdef CACHE_LIST
#else
#endif
#endif
#endif
	ushort        ch_imax;
	ushort        ch_smax;
	unsigned char ch_opt;
	unsigned char ch_kind;
	short         ch_keylen;
	int           ch_cmplen;
	int           ch_cshlen;
	short         ch_interval;
	ushort        ch_entry;
	tdtCACHE_CTL     *ch_pentry;
	tdtCACHE_CTL     *ch_prls;
	tdtQUE_CTL       *ch_pque;
	XHASHB        *ch_pxhas;
    int           *ch_pchktime;
	tdtLIST_CHAIN    *ch_pltop;
	tdtLIST_CHAIN    *ch_plbot;
	tdtLIST_CHAIN    *ch_plprev;
	tdtCACHE_CTL     **ch_ppcache;
	struct timeval ch_tctval;
	char *(*ch_malloc)();
	tdtCONSTCT *ch_constct;
} tdtCACHE_CTL_HEAD;

#ifdef SUNOS
tdtCACHE_CTL_HEAD *akxs_cache_new2(/*iMax,m_alloc,pConstCt*/);
extern tdtCACHE_CTL_HEAD *akxs_cache_new();	/*	(int);	*/
extern int akxs_cache_set();	/*	(tdtCACHE_CTL_HEAD *,tdtCACHE_CTL *);	*/
extern int akxs_cache_chk();	/*	(tdtCACHE_CTL_HEAD *,char *,tdtCACHE_CTL *);	*/
int akxs_cache_get(/*pCH, iEntry, pCt0*/);
extern int akxs_cache_del();	/*	(tdtCACHE_CTL_HEAD *,char *);	*/
extern int akxs_cache_free();	/*	(tdtCACHE_CTL_HEAD *);	*/
#else
tdtCACHE_CTL_HEAD *akxs_cache_new2(int,char *(*)(),tdtCONSTCT *);
extern tdtCACHE_CTL_HEAD *akxs_cache_new(int);
extern int akxs_cache_set(tdtCACHE_CTL_HEAD *,tdtCACHE_CTL *);
extern int akxs_cache_chk(tdtCACHE_CTL_HEAD *,char *,tdtCACHE_CTL *);
int akxs_cache_get(tdtCACHE_CTL_HEAD *,int,tdtCACHE_CTL *);
extern int akxs_cache_del(tdtCACHE_CTL_HEAD *,char *);
extern int akxs_cache_free(tdtCACHE_CTL_HEAD *);
#endif

extern tdtCACHE_CTL_HEAD *akxs_cache_new_list();	/*	(int);	*/
extern tdtCACHE_CTL_HEAD *akxs_cache_new_que();	/*	(int);	*/
extern tdtCACHE_CTL_HEAD *akxs_cache_new_xhas();	/*	(int);	*/

/*****************************************
	^C}[Ǘ
*****************************************/
#define AKX_TIMER_UNUSED	0
#define AKX_TIMER_START		1
#define AKX_TIMER_STOP		2

#define AKX_TIME_BASE		1970
#define AKX_TM_YEAR_BASE	1900

typedef struct _TIMER_CTL {
	uchar  tc_status;	/* 0/1/2=unused/start/stop */
	uchar  tc_resv2;
	uchar  tc_resv3;
	uchar  tc_resv4;
	int    (*tc_pfunc)();
	int    tc_tmrid;
	char   *tc_tmrname;
	int    tc_watime;
	char   *tc_parm;
	struct timeval tc_timeout;
	struct _TIMER_CTL *tc_tmrnext;
	int    tc_event;
} tdtTIMER_CTL;

typedef struct _TIMER_CTL_HEAD {
	struct timeval th_tmbase;
	int th_minwait;
	tdtTIMER_CTL *th_ptimer;
	int th_mwtext;
	struct timeval th_latest;
} tdtTIMER_CTL_HEAD;

int akxe_timer_set(/*ptvalo,ptvali*/);
int akxe_timer_add(/*ptvalo,ptvali,ptval2*/);
int akxe_timer_set_msec(/*ptval,msec*/);
int akxe_timer_add_msec(/*ptvalo,ptvali,msec*/);
int akxe_timer_sub(/*ptvalo,ptvali,ptval2*/);
int akxe_timer_cmp(/*ptval1,ptval2*/);
tdtTIMER_CTL_HEAD *akxe_timer_new();
int akxe_get_msec(/*pTC,ptval*/);
int akxe_timer_sub(/*ptvalo,ptvali,ptval2*/);

/*****************************************
	M_File
*****************************************/
#define AKX_MFP_SETSIZE	20
#define AKX_MFILE_FIXED_MAX_NO	4
#define AKX_MFILE_FLAG_HDOC	0x0100

typedef struct {	/**** FILE\ ****/
	char m_id[2];	/* 'F','P' */
	short m_fd;
	FILE *m_fp;		/* fp */
	char *m_name;	/* t@C */
	MCAT *m_mcat;	/* MCAT */
	long m_flag;	/* Open[h 0x0f:r=0/w=1/a=2 0xf0:text=0/binary=1 */
} tdtM_FILE;
typedef tdtM_FILE M_FILE;

int m_file_valid(M_FILE *mfp);
int m_file_init();
M_FILE *m_fopen(char *name,char *mode);
int m_fclose(M_FILE *mfp);
M_FILE *m_popen(char *name,char *mode);
int m_pclose(M_FILE *mfp);
M_FILE *m_opendir(char *name);
int m_closedir(M_FILE *mfp);
int m_fread(char *p1,int n,int size,M_FILE *mfp);
int m_fwrite(char *p2,int len2,int n,M_FILE *mfp);
int m_ferror(M_FILE *mfp);
int m_fileno(M_FILE *mfp);
int m_fflush(M_FILE *mfp);
M_FILE *m_heredoc_open(char *name);

/************************
	OǗ
*************************/
#define D_LOG_FLG_CHECK		-1
#define D_LOG_FLG_NONE		0
#define D_LOG_FLG_STDOUT	0x01
#define D_LOG_FLG_FILE		0x02
#define D_LOG_FLG_STDERR	0x04
#if 1	/* V6 */
#define D_LOG_FLG_SYSLOG	0x08
#define D_LOG_FLG_NO_SRC	0x10
#define D_LOG_FLG_NO_PROC	0x20
#define D_LOG_FLG_NO_TIME	0x40
#define D_LOG_FLG_PRIORITY	0x80
#else	/* V5 */
#define D_LOG_FLG_NO_SRC    0x08
#define D_LOG_FLG_NO_PROC   0x10
#define D_LOG_FLG_NO_TIME   0x20
#endif
#define D_LOG_FLG_LOG_CLEAR	0x0100
#define D_LOG_FLG_OUT_INFO	0x0200
#define D_LOG_FLG_CHK_PRI	0x0400
#define D_LOG_FLG_NOT_LF	0x1000
#define D_LOG_FLG_PUT_CR	0x2000
#define D_LOG_FLG_CNV_LF	0x4000	/* o̓bZ[WLFϊΏۂƂ */
#define D_LOG_FLG_STACK		0x8000
#define D_LOG_FLG_CD_OPT	0x1FF0000
#define D_LOG_FLG_USE_CODE_CONV	0x1000000
#define D_LOG_FLG_STDOUT2MEM	0x40000000
#define D_LOG_LEVEL_CHECK	-1

#define D_LOG_ROT_ROT_FILE	0x01
#define D_LOG_ROT_NO_HEAD	0x02
#define D_LOG_ROT_SIZE_LINE	0x04
#define D_LOG_ROT_NO_LINCR	0x08

#define AKX_LOG_EMERG		250
#define AKX_LOG_ALERT		210
#define AKX_LOG_CRIT		180
#define AKX_LOG_ERR			150
#define AKX_LOG_WARNING		120
#define AKX_LOG_NOTICE		90
#define AKX_LOG_INFO		60
#define AKX_LOG_DEBUG		30

#define AKX_NEWLINE_NOT_LF	0x01
#define AKX_NEWLINE_PUT_CR	0x02
#define AKX_NEWLINE_CNV_LF	0x04	/* o̓bZ[WLFϊΏۂƂ */

#define AKX_LOG_MAX_BITS	32

typedef struct {
	int  lgi_level;
	int  lgi_line;
	int  lgi_pri;
	char *lgi_file;
	char *lgi_format;
	char *lgi_a1;
	char *lgi_a2;
	char *lgi_a3;
	char *lgi_a4;
	char *lgi_a5;
} tdtLOG_INFO;

typedef struct _ROTATE_CTL {
	int   rot_size_max;
	int   rot_size;
	int   rot_file_max;
	int   rot_file_no;
	int   rot_option;
	int   rot_check_point;
	int   rot_count;
} tdtROTATE_CTL;

typedef struct _LOG_FILE_LINE {
	short  lfl_ope;
	ushort lfl_no;
	int    lfl_line[2];
	char   lfl_file_name[1];
} tdtLOG_FILE_LINE;

typedef struct _LOG_CTL {
	int   log_flg;
	int   log_level;
	int   log_grp_mask;
	char *log_file;
	tdtRB_CTL *rb_file;
	tdtRB_CTL *rb_srch;
	tdtROTATE_CTL log_rot;
	char *log_file_path;
	XHASHB *log_info;
	int   log_priority;
	MCAT  *mcat_file;
	MCAT  *mcat_out;
	uchar log_lvll[AKX_LOG_MAX_BITS];
} tdtLOG_CTL;

typedef struct _LOG_CTL_HEAD {
	int log_max;
	char *cur_dir;
	char *log_dir;
	char *proc_name;
	tdtLOG_CTL *log_ctl;
	tdtRB_CTL *rb_ct_w;
	char *log_ecnv;
	int log_max_resv;
} tdtLOG_CTL_HEAD;

int   akx_get_log_time(/* buf,len,format */);
char *akx_log_time();
tdtLOG_CTL_HEAD *akxa_log_new(/* iMax */);
int akxa_log_free(tdtLOG_CTL_HEAD *tlh);
tdtLOG_CTL *akxa_log_get_ctl(/*tlh,i*/);
int akxa_rot_size(/*rot,n,parm*/);
int akxa_log_size(/*tlh,log_no,n,parm*/);
char *akxa_rotate(/*rot,fname*/);
int akxa_log_flag_check(tdtLOG_CTL *tlc);
int akxa_log_level_check(tdtLOG_CTL *tlc,int group_level);
int akxa_log_out_check(/*tlc,level,file,line*/);
int akxa_flog_out_level_pri_main
    (/*tlh,log_no,level,file,line,pri,fp,format,a1,a2,a3,a4,a5*/);
int akxa_log_out_level_pri_main
    (/*tlh,log_no,level,file,line,pri,format,a1,a2,a3,a4,a5*/);
int akxa_log_out_level_main
    (/*tlh,log_no,level,file,line,format,a1,a2,a3,a4,a5*/);
int akxa_flog_out_pri
    (/*cpPath,iLogFlg,cpProc,file,line,pri,fo,format,a1,a2,a3,a4,a5*/);
int akxa_log_out_pri(/*cpPath,iLogFlg,cpProc,file,line,pri,format,a1,a2,a3,a4,a5*/);
int akxa_log_str_conv(/*iParm,n,argv0,argv,opt*/);
int akxa_log_out(/*cpPath,iLogFlg,cpProc,file,line,format,a1,a2,a3,a4,a5*/);
int   akxa_log_flg(/* tlh,i,f */);
int   akxa_log_set_proc_name(/* tlh,cpName */);
char *akxa_log_get_proc_name(/* tlh */);
int akxa_log_file_path_free_all(/*tlh*/);
char *akxa_log_set_file_name(/* tlh, i, cpFile */);
char *akxa_log_set_dir(/* tlh,cpDir */);
int   akxa_log_group_level(/*tlh, log_no, flg, iLevel*/);
int   akxa_log_level(/* tlh, i,level */);
char *akxa_rotate(tdtROTATE_CTL *rot,char *fname);
char *akxa_log_file_path(/* tlh,log_no,opt */);
int akxa_log_grp_mask(/*tlh,i,levelbitc*/);
int akxa_log_set_src_file(/*tlh,pCtChg,logno,ope,setno,file,line1,line2*/);
int akxa_log_src_file(/*tlh,pCtChg,argc,argv*/);
int akxa_log_set_parm2(/*tlh,argc_i,argv,nParm,iParm_i*/);
int akxa_log_set_parm(/*tlh,argc_i,argv,nParm,iParm_i*/);
int akxa_log_clear(/*tlh,log_no,option*/);
int akxa_log_set_command_parm(/*tlh,nset,logno_set,opt_string,parm_string,iOption*/);
int akxa_line_count(/*file, opt*/);
int akxa_log_printf_len(/*buf,max_len,format,argc,argv*/);
int akxa_log_group_priority(tdtLOG_CTL_HEAD *tlh,int i,int flg,int iPriority);
int akxa_log_priority(tdtLOG_CTL_HEAD *tlh, int i, int priority);
int akxa_log_new_line_str(char *s, int iFlg);
int akxa_log_new_line(FILE *fp, int iFlg);
int akxa_log_new_line_m(M_FILE *mfp, int iFlg);

/* akxlog.c */
int akx_print_out_level(/*level,file,line,format,a1,a2,a3,a4,a5*/);
int akx_error_out_level(/*level,file,line,format,a1,a2,a3,a4,a5*/);
int akx_debug_out_level(/*level,file,line,format,a1,a2,a3,a4,a5*/);
int akx_log_level(/*i,level*/);

/*****************************************
	Data Code Type
*****************************************/
#define CD_TYPE_SYSTEM	0
#define CD_TYPE_EUC		1
#define CD_TYPE_SJIS	2
#define CD_TYPE_JIS		3
#define CD_TYPE_EBCDIC	4
#define CD_TYPE_UTF8	5
#define CD_TYPE_UNICODE	6
#define CD_TYPE_EBCDIK	8
#define CD_TYPE_UPPER	0x0100	/*  256 啶 */
#define CD_TYPE_LOWER	0x0200	/*  512  */
#define CD_TYPE_PROPER	0x0300	/*  768 擪啶͏ */
#define CD_TYPE_WIDE	0x0400	/* 1024 Sp */
#define CD_TYPE_NARROW	0x0800	/* 2048 p */
#define CD_TYPE_HEBON	0x1000	/* 4096 SpJiw{[} */
#define CD_TYPE_KTKANA	0x2000	/* 8192 SpЂ炪ȂJ^Ji */
#define CD_TYPE_HRGANA	0x4000	/* 16384 SpJ^JiЂ炪Ȃ */
#define CD_TYPE_CODE	0x000f
#define CD_TYPE_FACEMRK	0xff00	/* */
#define CD_TYPE_FACE	0xff00	/* */

#define CD_SJIS_H_STA1	0x20	/* Hankaku Start 1 */
#define CD_SJIS_H_END1	0x7e	/* Hankaku End   1 */
#define CD_SJIS_H_STA2	0xa1	/* Hankaku Start 2 */
#define CD_SJIS_H_END2	0xdf	/* Hankaku End   2 */

#define CD_SJIS_HK_STA	0xa1	/* pJi Start */
#define CD_SJIS_HK_END	0xdf	/* pJi End   */

#define CD_SJIS_Z_STA1	0xa1	/* Zenkaku Start 1 */
#define CD_SJIS_Z_END1	0xfe	/* Zenkaku End   1 */
#define CD_SJIS_Z_STA2	0xa1	/* Zenkaku Start 2 */
#define CD_SJIS_Z_END2	0xfe	/* Zenkaku End   2 */

#define CD_EUC_SS2		0x8e	/* Hankaku Kana */
#define CD_EUC_SS3		0x8f	/* G3 AREA      */
#define	CD_EUC_Z_BEGIN	0xa1	/* Zenkaku Start */
#define	CD_EUC_Z_END	0xfe	/* Zenkaku End */

#define CD_UTF8_HK_STA1	0xEFBDA1	/* pJi Start 1 */
#define CD_UTF8_HK_END1	0xEFBDBF	/* pJi End   1 */
#define CD_UTF8_HK_STA2	0xEFBE80	/* pJi Start 2 */
#define CD_UTF8_HK_END3	0xEFBE9F	/* pJi End   2 */

/* XNvg//o͂̓{R[h */
#define CD_USE_CODE_CONV	0x10000	/* use akxc_code_conv() */
#define CD_FILE_CODE_CONV	0x20000	/* file */
#define CD_NOT_ERROR_7E		0x40000	/* iconv():from UTF-80x7eG[ɂȂ */
#define CD_NOT_CHECK_YEN	0x80000	/* "\" `FbNȂ */
#define CD_DFLT_SJIS	0x0000	/* S-JIS */
	/* XNvg */
#define CD_SCRIPT_MASK	0xFF0000	/* MASK */
#define CD_SCRIPT_SJIS	0x020000	/* S-JIS */
#define CD_SCRIPT_UTF8	0x050000	/* UTF-8 */
	/* ̓f[^ */
#define CD_INPUT_MASK	0xFF00	/* MASK */
#define CD_INPUT_SJIS	0x0200	/* SJIS */
#define CD_INPUT_UTF8	0x0500	/* UTF-8 */
	/* o̓f[^ */
#define CD_OUTPUT_MASK	0x00FF	/* MASK */
#define CD_OUTPUT_SJIS	0x0002	/* SJIS */
#define CD_OUTPUT_UTF8	0x0005	/* UTF-8 */

/* optcode_type */
#define CD_TYPE_OPT_MASK	0x7F000000	/* code_type opt MASK */
#define GET_TYPE_OPT(opt)	((opt & CD_TYPE_OPT_MASK)>>24)
#define SET_TYPE_OPT(code_type)	(code_type<<24)

typedef struct {
	int cc_type_s;
	int cc_type_d;
	int (*cc_qlen1)();
	int (*cc_qlen2)();
	int (*cc_func1)();
	int (*cc_func2)();
	int cc_opt[2];
	short cc_dlen[2];
} tdtCodeConv;

int akxq_code_type_cmp(/*type1,type2*/);
int akxc_get_code_num2(/*code_str,pospa*/);
int akxc_get_code_num(/*code_str*/);
int akxt_set_code_type(/*ucCodeType*/);
int akxt_get_code_type();
char *akxc_get_code_str();
int akxqissjis(/*c*/);
int akxqkanjilen1(/*c1*/);
int akxqmbslen1(/*code_type,c1*/);
int akxqkanjilen(/*p*/);
int akxqkanjilen2(/*p,len*/);
int akxqmbsnelen(/*code_type,p,len*/);
int akxqmbsnlen(/*code_type,p,len*/);
int akxqmbslen(/*code_type,p*/);
int akxqiskanji1(/*c1*/);
int akxqismbs1(/*code_type,c1*/);
int akxqismbyte(/*code_type,p,len0*/);
int akxqiskanji(/*p*/);
int akxqismbs(/*code_type,p*/);
int akxqisank_type(int type, char c);
int akxqisank(char c);
char akxctoank_type(int type, char c);
char akxctoank(char c);
int akxqis_hankaku_kana(/*p,mlen*/);
int akxqmbsnwidth(/*code_type,p,len*/);
int akxqkanjiw2(/*p,len*/);
int akxqmbsnalen(/*p,len,attr*/);
int akxtmget(/*p,len,ssp*/);
int akxtmput(/*p,len,ssp*/);

int akxcstou81(/*sjis,utf8*/);
int akxcu8tos1(/*utf8,sjis*/);
int akxcstoj1(/*sjis,jis*/);
int akxcjtos1(/*jis,sjis*/);
int akxc_set_utf8_file(/*file*/);
int akxctohan_type(/*n, inc, outc, from_type*/);
int akxctohan_type_opt(/*n, inc, outc, from_type, opt*/);
int akxctohan_opt(/*n, inc, outc, opt*/);
int akxctozen2_type_opt(/*n, inc, outc, inba, from_type, opt*/);
int akxctozen_type_opt(/*ltar,inc,outc,code_type,opt_type*/);
int akxctozen_type(/*n, inc, outc, from_type*/);
int akxctozen1(/*n, inc, outc, nn*/);
int akxctozen1_type(/*n, inc, outc, nn, from_type*/);
int akxctozen1_type_opt(/*n, inc, outc, nn, from_type, opt*/);
int akxctokhkana_type(/*n,inc,outc,code_opt*/);
int akxt_get_lang_type(/*key,opt,buf,buflen*/);
int akxt_code_trans(/*pParm, pParmd*/);
int akxc_sj_to_utf8(/*sjis,utf8c,ucs4*/);
int akxc_utf8_to_sj(/*utf8c,sjis,ucs4*/);
int akxcstou8(/*n, inc, outc*/);
int akxcu8tos(/*n, inc, outc*/);
int akxc_str_conv_native(/*pAns,tr_dtypea,p1,len,opt*/);
int akxc_str_conv_iconv(/*pAns,tr_code,p1,len,opt*/);
int akxc_str_conv(/*pAns,tr_dtypea,tr_code,p1,len*/);
int akxc_file_code_conv(/*pAns,p1,len,inout*/);
int akxc_to_hebon(/*par,s,s_len,opt*/);
char *to_hebon(/*s,opt*/);
int akxc_jisho_regist(/*par,dat,hebon,opt*/);
int akxc_jisho_henkan(/*par,s,s_len,opt*/);

int akxqmlen_type(/*ps,lstr,code_type*/);
int akxqmlen(/*s,slen*/);
int akxqm2len_type(/*s,slen,mlen,code_type*/);
int akxqm2len(/*s,slen,mlen*/);
int akxqstrlen(/*s*/);
char **akxc_get_code_str_addr();
int akxctohan(/*n, inc, outc*/);
int akxctozen2(/*n, inc, outc, inba*/);
int akxctozen(/*n, inc, outc*/);
int akxqu8nelen(/*p_str, len*/);
int akxqu8nlen(/*p_str, len*/);
int akxqu8elen(/*c*/);
int akxqu8len(/*c*/);
int akxcuppern(/*d,s,len*/);
int akxcuppern_type(/*d,s,len,type*/);
int akxclowern(/*d,s,len*/);
int akxclowern_type(/*d,s,len,type*/);
int akxcuplwn(/*opt,d,s,len*/);
int akxcuplwn_type(/*opt,d,s,len,type*/);
int akxcuplw(/*pd,ps,opt*/);
int akxcuplw_type(/*pd,ps,opt,type*/);

/*****************************************
	Data Code Replace
*****************************************/
typedef struct {
	uint rr_scmp;
	uint rr_ecmp;
	uint rr_srep;
	int  rr_intval;
} tdtREP_RANGE;

typedef struct {
	int rs_ext;
	XHASHB *rs_xh;
	int rs_max;
	char **rs_pprep;
	int rs_range_ext;
	int rs_range_max;
	int rs_range_used;
	tdtREP_RANGE *rs_range;
	XHASHB *rs_xh2;
	int rs_max2;
	char **rs_pprep2;
	char rs_bytes[4];
} tdtREP_STR;

extern tdtREP_STR *akxc_rep_str_new(/* char *tfile, int iExt */);
int akxc_rep_str(/*tpRep,opt,in_cod,out_cod*/);
int akxc_rep_add_rep(/*tpRep,argc,argv,argl*/);
int akxc_rep_add_range(/*tpRep,argc,argv,argl*/);

/*****************************************
	Compile and Execute
*****************************************/
typedef struct {
	int ns_maxcolm;
	int ns_maxobj;
	int ns_maxda;
	int ns_maxstack;
	int ns_nobj;
	int *ns_obj;
	char **ns_da;
	int  *ns_dstk;
	int  *ns_stack;
} tdtSTPL_SQL;

extern tdtSTPL_SQL *akxs_stpl_sql_new(/* nparm,iParm */);
int akxcecvn(/*ppNS,expbuf,len,pnum*/);

/*********************************
		f[^
*********************************/
#define AKX_NUM_U	0x10
#define AKX_NUM_L	0x20
#define AKX_NUM_I	0x40
#define AKX_NUM_UL	(AKX_NUM_U | AKX_NUM_L)
#define AKX_NUM_ULI	(AKX_NUM_UL | AKX_NUM_I)

#define AKX_ZOK_MASK	0x0f	/* DATA ATTR MASK	*/
#define AKX_ZOK_DTYP	0x07	/* DATA TYPE MASK	*/
#define AKX_ZOK_USMASK	AKX_NUM_U	/* unsigned MASK	*/
#define AKX_ZOK_CHAR	1		/*   			*/
#define AKX_ZOK_BINA	2		/*   Qi			*/
#define AKX_ZOK_LONG	2		/*   Qi			*/
#define AKX_ZOK_FLOA	3		/*   		*/
#define AKX_ZOK_DECI	4		/*   POi		*/
#define AKX_ZOK_BULK	5		/*   BULK^			*/
#define AKX_ZOK_DATE	6		/*   t^			*/
#define AKX_ZOK_VARI	7		/*   oAg^	*/
#define AKX_ZOK_KANS	8		/*   Ԑ			*/
#define AKX_ZOK_UINT	AKX_NUM_U | AKX_ZOK_BINA	/*   unsigned int	*/
#define AKX_ZOK_ULNG	AKX_NUM_U | AKX_ZOK_LONG	/*   unsigned long	*/
#define AKX_ZOK_DATA	0x80	/*   			*/

#define AKX_TYPE_ARRAY	17		/* 0x11 TYPE ARRAY		*/
#define AKX_TYPE_MAPPED	18		/* 0x12 TYPE MAPPEDARRAY*/
#define AKX_TYPE_STRUCT	19		/* 0x13 TYPE STRUCT		*/

#define AKX_DATA_MALLOC		0x80	/* malloc data		*/
#define AKX_DATA_LPOSDATA	0x40	/* data to lResv	*/

/*****************************************
	ėpf[^\
*****************************************/
typedef struct  {
	uchar   gd_id;		/* f[^hc */
	uchar   gd_attr;	/*        */
	uchar   gd_scale;	/* x       */
	uchar   gd_code;	/* R[h */
	int     gd_dlen;	/* f[^   */
	char   *gd_data;	/* f[^     */
	int     gd_resv;
} tdtGENERAL_DATA;

/*****************************************
	message
*****************************************/
typedef struct {
	int   mm_msgno;
	char *mm_msg[3];
} tdtMESSAGES;

typedef struct {
	short cmh_try;
	short cmh_langmax;
	int   cmh_no_max;
	tdtMESSAGES *cmh_messages;
	tdtMESSAGES **cmh_index;
	tdtRB_CHAIN *cmh_xhp;
} tdtCONV_MSG_HEAD;

tdtCONV_MSG_HEAD *akxc_conv_msg_new(/* tdtMESSAGES *mesg */);
char *akxc_conv_msg(/* tdtMESSAGES message[],int no,int kind */);

/*******************************
	read_line
********************************/
#define AKX_RECORD_BUFSIZE	256

/*****************************************
	getargv
*****************************************/
#define AKX_ARGV_TERM_IGE			0x01	/* '#'ȍ~𖳎 */
#define AKX_ARGV_IGNR_EQU			0x02	/* Q[hڂA'='̂Ƃ͖ */
#define AKX_ARGV_DELM_COM			0x04	/* ','؂Ƃ */
#define AKX_ARGV_DELM_CLN1			0x08
#define AKX_ARGV_DELM_CLN			0x10
#define AKX_ARGV_QUOT_IPV6			0x20
#define AKX_ARGV_DELM_EQU			0x40
#define AKX_ARGV_COM_NOT_IGNR_EQU	0x80
#define AKX_GSFOPEN_CACHE_INVALID	0x0100
#define AKX_GSFOPEN_NO_CACHE		0x0200
#define AKX_GSSTPLX_CACHE_INVALID	0x0400
#define AKX_ARGV_NOT_CUT_QUOT		0x010000
#define AKX_ARGV_USE_ATTR2_SEP		0x020000
#define AKX_ARGV_FOR_CSV			0x040000
#define AKX_ARGV_USE_ICMP			0x100000
#define AKX_ARGV_USE_AKXICMP		0x200000
#define AKX_ARGV_NO_CASE_CMP		0x400000

/*******************************
	trim
********************************/
#define AKX_TRIM_BACKWARD		0x01	/*  */
#define AKX_TRIM_FORWARD		0x02	/* O */
#define AKX_TRIM_SET_NULL		0x10
#define AKX_TRIM_DEL_TAB		0x20
#define AKX_TRIM_DEL_SPACE		0x40

/*****************************************
	Virtual Area Access
*****************************************/
typedef struct _VAA_S {
	int     opt;
	FILE   *fp;
	SSP_S  *ssp;
	char   *buf;
	size_t  fsize;
} tdtVAA_S;

/*****************************************
	Like
*****************************************/
#define AKX_LIKE_IGN_CASE	0x01	/* ignore case */
#define AKX_LIKE_IGN_HAZE	0x02	/* ignore hankaku zenkaku */
#define AKX_LIKE_REVERSE	0x10	/* reverse */
#define AKX_LIKE_LNGMATCH	0x20	/* longest match */

typedef struct {
	uchar stp;
	uchar len;
	uchar mpn;
	uchar und;
} tdtLIKE_MASK;

typedef struct {
	short lmc_nptn;
	short lmc_slptn;
#if 1	/* 2020.11.08 */
	short lmc_pat_n;
	short lmc_resv;
	int *lmc_pat;
#else
	ushort *lmc_pat;
#endif
	tdtLIKE_MASK *lmc_mask;
} tdtLIKE_MASK_CTL;

typedef struct {
	short lk_max_pat;
	uchar lk_escape;
	char  lk_pad;
	int   lk_option;
#if 1	/* 2020.11.08 */
	int *lk_usap;
#else
	ushort *lk_usap;
#endif
	int   lk_alen;
	int   lk_la;
	tdtLIKE_MASK_CTL *lk_maskctl;
	short lk_nlike;
	short lk_next_like;
/*	int   *lk_pos;	*/	/* del 2022.3.28 */
	char  *lk_inba;		/* add 2022.3.25 */
} tdtLIKE;

extern tdtLIKE *akxs_xlike_new(/* int max_pat,option */);
void akxs_xlike_free(/*plike*/);
int akxs_like_escape(/*escape*/);
int akxs_xlike_set_line(/*plike,s,len*/);
int akxs_xlike_set_pat(/*plike,bp,lbp*/);
int akxs_pxlike(/*plike,bp,lbp*/);
int akxs_str_like(/*ap,bp*/);
int akxs_xlike_pos(/*ap,lap,bp,lbp,opt,pos*/);
int akxs_xlike(/*ap,lap,bp,lbp,opt*/);

/*****************************************
	Free & Used Chain List
*****************************************/
typedef struct {
	int uc_entry_size;
	int uc_used_top;
	int uc_used_bot;
	int *uc_uchain;
} tdtUCHAIN;

/*****************************************
	GetSectionStruct
*****************************************/
typedef struct _KEY_INFO {
	int   argc;
	char **argv;
	int  *arglen;
	int   resv;
} tdtKEY_INFO;

typedef struct {
	int          maxkey;
	int          nkey;
	tdtKEY_INFO **pkeyinfo;
} tdtKEY_INFOS;

/*****************************************
	MPA
*****************************************/
/* POi(Œ)_̂O\	*/
#define	AKX_MPA_NODISP_SYO_NOSYO	0x00	/* _ȉȂƂɏ_ȉ\ȂB	*/
#define AKX_MPA_NODISP_ZERO_LESS1	0x01	/* P̂Ƃɍŏ̂O\ȂB			*/
#define	AKX_MPA_DISP_PIRIOD_NOSYO	0x02	/* _ȉȂƂɏ_\B		*/
#define	AKX_MPA_DISP_SYOZERO_NOSYO	0x04	/* _ȉȂƂɏPʂ̂O\B*/
#define	AKX_MPA_DISP_COMMA			0x20	/* RɃJ}tB						*/

/* POiŒ菬_̈ʎ薢̏	*/
#define	AKX_MPA_4SHA5NYU	0x00	/* ľܓ	*/
#define	AKX_MPA_KIRIAGE		0x01	/* ؎̂	*/
#define	AKX_MPA_KIRISUTE	0x02	/* ؏グ	*/

#define	AKX_MPA_IGNO_SCALE	0x1000	/* M_PACKSCALE𖳎	*/
/*
		NMPA1 = NMPA + 1
		NMPA2 = NMPA1 * 2
		NMPA_INT = (NMPA1+12)/4
*/
/*
#define		NMPA10		51
#define		NMPA101		52
#define		NMPA102		104
#define		NMPA_INT10	16
*/
#define		NMPA10		54
#define		RADIX10		10
#define		RADIX10_2	5		/* = RADIX / 2 */
#define		RADIX102	100		/* = RADIX ^ 2 */
#define		NMPA		27
#define		NMPA1		28
#define		NMPA2		56
#if defined(_LP64)	/* 2021.6.20 */
#define		NMPA_LONG	5
#else
#define		NMPA_LONG	10
#endif
#define		NMPA_INT	10
#define		MIN_NMPA10	2

#define		RADIXBITS	15
#define		RADIX		100
#define		RADIX_2		50		/* = RADIX / 2 */
#define		RADIX2		10000	/* = RADIX ^ 2 */
#define		MAXEXP		32767
#define		MINEXP		-32768
/* 2020.5.24
#define		MAX_LONG	0x7FFFFFFFL
#define		MIN_LONG	0x80000000L
*/
#define		MAXEXPLOOP	20
#define		MAXDBLPRE	16
#define		MAXDOUBLE	 1.7976931348623157e+308	/* IEEE double */
#define		MINDOUBLE	-1.7976931348623157e+308
#define		MINREGDBL	 2.2250738585072014e-308	/* ̍ŏ̐K */
#define		MINNRGDBL	 4.9406564584124654e-324	/* ̍ŏ̔񐳋K */
#define		MAX_K		180				/* < (sqrt(4 * RADIX + 1) - 1) * 0.5 */
#define		MPA_ME_STR	"2.718281828459045235360287471352662497757247093699959574966967627724076630353547594571382178525166427"
#define		MPA_PI_STR	"3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117068"
#define		MPA_LOG2_STR	"0.693147180559945309417232121458176568075500134360255254120680009493393621969694715605863326996418688"
/*#define		MPA_LOG10_STR	"2.302585092994045684017515870599420447449918457320608157"*/
#define		MPA_LOG10_STR	"2.3025850929940456840179914546843642076011014886288"
/*#define		MPA_1DLOG10_STR	"0.434294481903251827651218619637938040445973309092839801"*/
#define		MPA_1DLOG10_STR	"0.43429448190325182765112891891660508229439700580366"		
#define		MPA_UINT_MAX_STR	"4294967295"
#if defined(_LP64)
#define		MPA_ULONG_MAX_STR	"18446744073709551615"
#else
#define		MPA_ULONG_MAX_STR	"4294967295"
#endif
#define		MPA_LONG_MIN	(-9223372036854775807L-1L)

#define     MPA_ERR_NULL_ADDR	-1
#define     MPA_ERR_MALLOC		-2
#define     MPA_ERR_ZERODIVIDE	-10
#define     MPA_ERR_OVERFLOW	 11
#define     MPA_ERR_UNDERFLOW	-12
#define     MPA_ERR_A_LT_B		-13
#define     MPA_ERR_SIZE_OVER	-14
#define     MPA_ERR_INVALID		-15
#define     MPA_ERR_OVERFLOW_I	-16

#define MPA_DATA_MALLOC		0x80		/* malloc data        */

#define     MPA_ID	"MP"
#define     MPA_ID1	'M'
#define     MPA_ID2	'P'
/*
#define     m_i2mpa	m_l2mpa
*/
typedef struct {
	char   id[2];	/* MP */
	short  opt;
	ushort alen;
	ushort len;
	short exp;
	char sign;
	char zero;
	char num[NMPA1];
} MPA;	/* int[NMPA_INT] */

typedef struct {
	int exp;
	ushort len;
	char sign;
	char zero;
	char num[NMPA2];
} MPA10W;

typedef struct {
	char   id[2];	/* MV */
	short  opt;
	ushort alen;
	ushort len;
	short exp;
	char sign;
	char zero;
	char *num;
} MPAV;

int m_set_nmpa10(int m);
int m_get_nmpa10();
int sizeofMPA();
int sizeofMPA10W();
MPA *get_tmpMPA(/*MPA **sa,MPA *az*/);
MPA10W *get_tmpMPA10W(/*MPA10W **sw,MPA10W *wz*/);
MPA *m_get_i(int i);
MPA *m_get_mmax();
MPA *m_get_INTMAX(int sign);
MPA *m_get_UINTMAX();
MPA *m_get_LONGMAX(int sign);
MPA *m_get_ULONGMAX();
int m_set_a(MPA *a, char *s);
MPA *m_cpy(MPA *d,MPA *s,int iCPY);
int m_is_mpa0(MPA *a);
int m_set_an_opt(MPA *a, char *s, int len_s, int opt);
int m_set_an(MPA *a, char *s, int len);
MPA *m_pset_a(MPA *a, char *s);
MPA *m_pset_an(MPA *a, char *s, int len);
int m_10to100(MPA *a, MPA10W *w);
int m_100to10(MPA *a, MPA10W *w);
int m_normalize(MPA *a);
int m_chk_over_under(MPA *a, int exp);
int m_add(MPA *c, MPA *a, MPA *b);
int m_sub(MPA *c, MPA *a, MPA *b);
int m_add_a(MPA *ans, MPA *a, MPA *b);
int m_sub_a(MPA *ans, MPA *a, MPA *b);
int m_add1(MPA *a, MPA *b);
int m_sub1(MPA *a, MPA *b);
int m_add1_a(MPA *a, MPA *b);
int m_sub1_a(MPA *a, MPA *b);
int m_mul(MPA *ans, MPA *a, MPA *b);
int m_div(MPA *ans, MPA *aa, MPA *bb);
int m_mul1(MPA *a, MPA *b);
int m_div1(MPA *a, MPA *b);
int m_cmp(MPA *a, MPA *b);
int m_cmp_a(MPA *aa, MPA *bb);
void m_print(char *s, MPA *a, int _short);
void m10w_print(char *s, MPA10W *a, int _short);
int m_pack(char *a, int precision, int scale, int opt, MPA *b);
#if 1	/* 2021.1.2 */
int m_pack_size(char *a, MPA *b, int dec_size, int scale);
#else
int m_pack_size(char *a, int dec_size, MPA *b);
#endif
int m_unpack(MPA *a, char *b, int size, int scale);
int m_mpa2i(MPA *a, int *val);
int m_mpa2l(MPA *a, long *val);
int m_mpa2d(MPA *a, double *dval);
int m_dset(double *dval, MPA *a);
int m_mpa2an(MPA *a, char *s, int len_s, int opt);
int m_i2mpa(int val, MPA *a);
int m_l2mpa(long val, MPA *a);
int m_ll2mpa(off_t val, MPA *a);
int m_d2mpa(double a, MPA *m);
int m_scale(MPA *mpa,int precision,int scale,int opt);
int m_precision(MPA *a, int pre, int opt);
MPA *m_cpy(MPA *d,MPA *s,int iCPY);
char *m_mpa2str(MPA *a, char *s, int len_s, int opt);
char *m_mpa2str_exp(MPA *a, int pre, int inx, int opt);
int m_mpa2an_exp(MPA *a, char *s, int len_s, int pre, int inx, int opt);
int m_an_to_mpa10_opt(MPA10W *w, char *s, int len_s, int opt);
int m_precision_10(MPA10W *w10, int pre, int opt);
int m_mpa10_to_exp(MPA10W *w10, char *s, int len_s, int pre, int inx, int opt);
int m_mpa10_to_an(MPA10W *w, char *s, int len_s, int opt);
int m_set_array(MPA *a_ary, MPA *val, int n);
void m_print(char *s, MPA *a, int _short);
void m10w_print(char *s, MPA10W *a, int _short);
void m_print_exp2(char *s, MPA *a, int pre, int inx, int opt, int val1, int val2);
void m_print_exp(char *s, MPA *a, int pre, int inx, int opt);
int m_mod(MPA *ans, MPA *aa, MPA *bb);
int m_sqrt(MPA *x, MPA *b);
int m_cbrt(MPA *x, MPA *b);
int m_log10(MPA *xx, MPA *b);
int m_ln(MPA *xx, MPA *b);
int m_ln_sub(MPA *xx, MPA *b);
int m_l2mpau(long val, MPA *a, int iU);
int m_mpa2ul(MPA *a, ulong *val);
int m_l2mpa(long val, MPA *a);
int m_ul2mpa(ulong val, MPA *a);
int m_ui2mpa(uint val, MPA *a);
char *m_mpa2scastr(MPA *a, char *s, int len_s, int scale, int opt);
int m_mpa2ansca(MPA *a, char *s, int len_s, int scale, int opt);

MPAV *mv_pset_a(MPAV *a, char *s);
MPAV *mv_pset_an(MPAV *a, char *s, int len);
MPAV *mv_get_i(int i);
MPAV *mv_get_MMAX();
void mv_print(char *s, MPAV *a, int _short);

/*****************************************
	lϊ
*****************************************/
#define  AKX_CNVN_OPT_NOT_NUM	0x0010			/*   */
#define  AKX_CNVN_OPT_COMMA		0x0020			/*   */
#define  AKX_CNVN_OPT_MSIGN		0x0040			/*   */
#define  AKX_CNVN_OPT_FU_MPA	0x0080			/* +123+01 ̎w`MPAƂ */
#define  AKX_CNVN_OPT_NOT_U		0x1000			/*   */
#define  AKX_CNVN_OPT_NOT_I		0x2000			/*   */
#define  AKX_CNVN_OPT_DIGIT		0x4000			/*   */
#define  AKX_CNVN_OPT_DOUBLE	0x8000			/*   */

/*****************************************
	STACK
*****************************************/
typedef struct {	/**** StackǗ\ ****/
	int st_max_reg;		/* őo^ */
	int st_sp;				/* X^bNʒu */
	long *st_reg;			/* stack */
	char *(*st_malloc)();
	tdtCONSTCT *st_constct;
} tdtStack;

/*****************************************
	Date
*****************************************/
#define AKX_LEN_DATE	14
#define AKX_UNX_DATE_FORMAT	"%Y/%m/%d %H:%M:%S"
#define AKX_SQL_DATE_FORMAT	"YYYY/MM/DD HH24:MI:SS"

int akxc_chk_date_type(/*d,s,code_type*/);
int akxc_chk_date(/*d,s*/);
int akxc_tm2mpa(/*ma,stm,usec*/);
int akxc_mpa2tm(/*stm,ma*/);
int akxc_date2uxstr(/*p2,len,p1,ma*/);
char akxc_get_term_char(/*index*/);
int akxc_date_add(MPA *ma, long lValue, int n);
int akxc_date_add_term(MPA *ma, long lValue, int n);
int akxc_date_diff_sub(/*ptt,n,ma1,ma2*/);
int akxc_is_leap_year(/*y*/);
int akxc_days_of_month(/*yyyy,mm*/);
int akxc_date2str(/*p2,len2,s0,slen0,ma*/);
int akxc_str2date(/*p2,len2,s0,slen0,ma*/);

/*****************************************
	Etc
*****************************************/
#define AKX_NULL_PRINT	"(null)"

/* These function names are used on Windows and perhaps other systems.  */
#ifndef SUNOS
#ifndef strcmpi
#define strcmpi strcasecmp
#endif
#ifndef stricmp
#define stricmp strcasecmp
#endif
#ifndef strncmpi
#define strncmpi strncasecmp
#endif
#ifndef strnicmp
#define strnicmp strncasecmp
#endif
#endif

/***************************
	prot type
************************/
/* akxaxdmp.c */
int akxafxdmp_optv(FILE *fp, char *msg, char *p_str, int str_len, int argc, char *argv[]);
int akxafxdmp_opt(FILE *fp, char *msg, char *p_str, int str_len, char *opt);
int akxafixdmp_opt(char *out_file, char *msg, char *p_str, int str_len, char *opt);
int make_xdline(char *pw, char *pw2, char *p, int iend, int isave[]);
int akxafxdmp_type(/*fp,msg,dat,len,type*/);
int akxafxdmp(/*fp,msg,dat,len*/);
int akxaxdump_type(/*msg,dat,len,type*/);
int akxaxdump(/*msg,dat,len*/);
int akxafixdmp(/*file,msg,dat,len*/);

/* akxcrepcode.c */
int akxcreplace_opt2(/*d,d_len,s,s_len,str_old,str_new,opt*/);
int akxcreplace_opt(/*d,s,str_old,str_new,opt*/);
int akxcreplace_char2(/*d,d_len,s,s_len,c_old,c_new*/);
int akxcreplace_char(/*d,s,c_old,c_new*/);
int akxcreplace_chars_opt2(/*d,d_len,s,s_len,c_old,c_new,opt*/);

/* akxdatebas.c */
int   axConvDate(/*ymd,ymda,max_ymda,dlma,max_dlma*/);
int   axAddToDate(/*ymda,max_ymda,term,add,dlm*/);
int   axAddToDateSub(/*ymda,term,add,dlm*/);
int   axAddToTimeDay(/*hnsa,term,add*/);
int   axSetDatePart(/*ymda,term,val,dlm*/);
int   axSetTimePart(/*hmsa,term,val*/);
int   axCheckDate(/*v_Year,v_Month,v_Day,ymda*/);
int   axCheckTime(/*hh,mi,ss,hmsa*/);
int   ConvYM_D(/*in_YM,in_D,ymda*/);
char *axDateToChar(/*ymda,max_ymda,dlm*/);
char *axTimeToChar(/*hnsa,dlm*/);
char *axYM_DToDate(/*in_YM,in_D,dlm*/);
char *axDateTimeToChar(char *buf,int buflen,int ymda[],char *ymd_form);
int   axToDate(/*ymda,ymdhns,ymd_form*/);
int   anal_date_format(/*ymd_form,max_nymd,nymda,kymda,mymda*/);
char *edit_date_by_anal_format(/*ymda,inymd,nymda,kymda,mymda*/);
int   get_date_term_no(char *term);
char *get_sysdate_ymd(/*ymda,term*/);
char *axGetSysDate(/*term*/);
double axDateDiff(/*term,ymda1,ymda2*/);
char *get_str_diff_time(/*term,tt,hmsa,day*/);
int   get_day_num(/*yyyy,mm,dd*/);
int   axLastDay(/*ymda*/);

/* akxlib.c */
int memicmp(/*sa,sb,len*/);
int memrngcmp_opt(/*sa,len,sb,n_min,n_max,opt*/);
int memrngcmp(/*sa,len,sb,n_min,n_max*/);
int memirngcmp(/*sa,len,sb,n_min,n_max*/);
int memncpy(/*d, s, len, n*/);
int memzcpy(/*d, s, len*/);
int memnzcpy(/*d, s, len, n*/);
int memcat(/*d, s, len*/);
#if !defined(SUNOS5) && !defined(SUNOS) && !defined(LINUX)
int stricmp(/*sa,sb*/);
#endif
#if defined(SUNOS) || defined(AIX)
char *strerror(/*err*/);
#endif
char *strnzcpy(/* char *d, char *s, int n */);
int akxmemwork(/*len,pp1,pp0,work,w_len*/);
char *stristr(/* char *target,char *str */);
char *strmem(/* char *s,int len */);
char *memaddv0(/*argc,argv,argl,pp0*/);
char *memaddv(/*argc,argv,argl*/);
char *memadd0(/* a,alen,b,blen,pp0 */);
char *memadd(/* a,alen,b,blen */);
char *straddv(/*argc,argv */);
char *stradd(/* a,b */);
char *stradd5(/* a,b,c,d,e */);
int akxstrnlen(/*s,len*/);
char akxcupper(/* char ci */);
int akxqupper(/*cc*/);
int akxcctox(/*puc,len,pux*/);
int akxcxtoc(/*s,len,d*/);
int akxcxtocn(/*s,len,d,mlen,interval0*/);
int akxtsrepc(/*s,cs,cd*/);
char *akxt_get_last_name(/* char *delm, char *path */);
char *akxt_add_dir2(/* char *cpDir, char *cpFile, char **cppPath */);
int akxt_set_bits(/*ipBits,iMask,iSet*/);
int akxs_in_mem_opt(/*target,ltar,str,lstr,opt*/);
int akxs_in_mem_chars(/*target,ltar,str,lstr,opt*/);
int akxs_in_str_opt(/*target,str,opt*/);
int instr(/*target,str*/);
int inmemstr(/*target,lt,str*/);
int instrchar_opt(/*target,c,opt*/);
int instrchar(/*target,c*/);
int instrichar(/*target,c*/);
int inmemchars(/*buf,len,ptn*/);
int inmemichars(/*buf,len,ptn*/);
int instrchars(/*buf,ptn*/);
int instrichars(/*buf,ptn*/);
int inistr(/*target,str*/);
char *stristr(/*target,str*/);
int akxt_get_gep_data(/*klen,p,kpp,plalen*/);
int akxt_cmp_gep_data_opt(/*klen,kp,lklen,p,opt*/);
int akxt_cmp_gep_data(/*klen,kp,lklen,p*/);
char *akxc_conv_msg(/* tdtMessages message[],int no,int kind */);
int akx_get_gen_int_data(/*p*/);
UINT4 akxcmb2ul(/*s,len*/);
int akxcul2mb(/*s,ul*/);
int akxmbcmp(/*s1,m1,s2,m2*/);
int akxmbncmp_type_opt(/*pstr1,nstr1,pstr2,nstr2,code_type,opt*/);
int akxmbncmp_opt(/*pstr1,nstr1,pstr2,nstr2,opt*/);
int akxstrcmp(/*s1,s2*/);
int akxstricmp(/*s1,s2*/);
int akxmemcmp(/*s1,s2,len*/);
int akxmemicmp(/*s1,s2,len*/);
int akxmemcmp2(/*s1,len1,s2,len2*/);
int akxmemicmp2(/*s1,len1,s2,len2*/);
int akxstrcmp2(/*s1,len1,s2,len2*/);
int akxstricmp2(/*s1,len1,s2,len2*/);
int akx_mem_chr_opt(/*pm1,pm2,len,opt*/);
int akxn_skip_opt(/*buf,len,ptn,ptn_len,opt*/);
int akx_skip_opt(/*buf,len,ptn,opt*/);
int akxnskipin(/*buf,len,ptn*/);
int akxnrskipin(/*buf,len,ptn*/);
int akxnskipto(/*buf,len,ptn*/);
int akxnrskipto(/*buf,len,ptn*/);
int akxnskipin2(/*buf,len,ptn,lptn*/);
int akxnskipto2(/*buf,len,ptn,lptn*/);
int akx_conv_yen1(/*s,len,ssp*/);
int akxtstrim(/*opt,pData,len,ptn*/);
int akxtstrim2(/*opt,pData,len,pa_dat,ptn*/);
int akxtsapb(/*opt,pData,len*/);
char *akxttrim2(/*opt,pData,plen*/);
int akxttrim(/*opt,pData,len*/);
void  printtx();
int mem_set_int(/*a,val,n*/);
int mem_cpy_int(/*d,s,n*/);
int mem_sum_byte(/*s,n*/);
int mem_sum_int(/*s,n*/);
int mem_set_long(/*a,val,n*/);
int mem_cpy_long(/*d,s,n*/);
int mem_sum_long(/*s,n*/);
int mem_set_addr(/*d,val,n*/);
int mem_cpy_addr(/*d,s,n*/);
int akxq_char_kind(/*s,s_len,opt*/);
char *nval(/*p,p1*/);
char *nval1(/*p*/);
char *nvalid(/*p,p1*/);
int mem_cmp_int(/*p1,p2,n*/);
int mem_cmp_int_n(/*p1,n1,p2,n2*/);
int akxtnsplit(/*buf,buf_len,argv,maxargv,parm,parm_len,sep,sep_len,opt*/);
int akxnmstrsort_opt(/*sel_str,max_sel,mlen,opt*/);
int akxnstrsort_opt(/*sel_str,max_sel,opt*/);
int akxstrsort_inx_vdat(/*dat,nDat,inx,vdat,iOpt*/);
long *get_bit32_array();
int get_bit_number(/*bit*/);
int akxs_mleft(/*s,s_len,m_len,opt*/);
int akxs_mright(/*s,s_len,m_len,opt*/);
void akxqsort_r(/*a,nmenb,size,_compar,arg*/);

/* akxgetstpl.c */
int akxtgetwnspl(/*p, len, sspl, opt*/);
int akxtgetwspl(/*p, sspl, opt*/);
int akxa_get_line(/*line,linemax,fp,opt*/);
int akxa_read_line_opt(/*buf, size, fp, opt*/);
int akxa_read_line(/*buf, size, fp*/);
int akxa_get_line_mcat_opt(/*mcat,fp,opt*/);
int akxa_get_line_mcat(/*mcat,fp*/);
int akxtgetw(/*p, ppos, wd, lmax*/);
int akxagetstplix(/*file,colm,name,argv,maxargc,parm,len,opt*/);
int akxagetstpli(/*file,colm,name,argv,maxargc,parm,len*/);
int akxagetstplx(/*file,name,argv,maxargc,parm,len,opt*/);
int akxagetstpl(/*file,name,argv,maxargc,parm,len*/);
int akxtgetnvsep(/*buf,argv,maxargc,sep,opt*/);
int akxs_opt_strcmp(/*s1,s2,opt*/);
int akxtmgetline(/*cpMem, iMemLen, ssp*/);
int akxtmgetline2(/*cpMem, iMemLen, ssp*/);
int akxs_opt_memcmp(/*s1,s2,len,opt*/);

FILE *akxa_gs_fopen(char *file,char *section,char **argv,int maxargc,
                  char *parm,int ha_keylen,int opt,int pret[]);
int akxa_gs_fopen_free();
int akxa_gs_stplix(/*file,block,colm,name,argv,maxargc,parm,len,opt*/);
int akxtgetargvn2(/*buf,buflen,argv,maxargcs,parm,len,opt*/);
int akxtgetargvns2(/*buf,buflen,argv,maxargcs,parm,len,sep,opt*/);
int akxtgetargv2(/*buf,argv,maxargcs,parm,len,opt*/);
int akxtgetargv(/*buf,argv,maxargc,parm,len*/);
int akxwdmax_chkm(/*pwd,pattr,lmax,l,s,m*/);
int akxwdmax_chk(/*pwd,pattr,lmax,l,ch*/);

/* akxconvn.c */
int akxqsign(char *s, int len_s, int parm[], char *sep, int opt);
int akxccvl(/*rad,ss,len,pnum*/);
int akxccvd(/*ss,len,dpnum*/);
int akxcgcvlu(/*wd0,len0,pnum,iU*/);
int akxcgcvl(/*wd0,len0,pnum*/);
int akxcgcvnu(/*wd0,len0,pnum,iU*/);
int akxcgcvn(/*wd0,len0,pnum*/);
int akxccvx(/*wd0,len0,pnum*/);
int akxccvlx(/*wd0,len0,pnum*/);
int akxccvo(/*wd0,len0,pnum*/);
int akxccvlo(/*wd0,len0,pnum*/);
int akxccvb(/*wd0,len0,pnum*/);
int akxccvlb(/*wd0,len0,pnum*/);
int akxccvn(/*rad,ss,len,pnum*/);
int akxccvn2(/*rad,ss,len,pnum,ppos*/);
int akxcltoa(/*value,str,radix,str_len*/);
int akxcitoa(/*value,str,radix,str_len*/);
int akxcultoa(/*value,str,radix,str_len*/);
int akxcuitoa(/*value,str,radix,str_len*/);
int akxtreverse(/*str,len*/);
int akxqnumUL(/*buf,buf_len,*piUL*/);
int akxqnumber(/*buf,buf_len,opt,iParm*/);
int akxccvdotn(/*rad,ss,len,pnum*/);
char *itoa(/* int n */);
int akx_chk_int_over(/*lnum,pnum*/);
int akx_chk_uint_over(/*lnum,pnum*/);
int atoi2(/*p,len*/);

/* akxsregex.c */
int akxs_regex(char *regex,char *string,size_t nmatch,regmatch_t pmatch[],
               int flags[],size_t errbuf_size,char *errbuf);

/* akxgmath.c */
int akxg_sosu_tbl(/*pi*/);
int akxg_sosu_chk(/*l*/);

/***************************
	macro
************************/
#define X_MAX(a,b) ((a)>(b)?(a):(b))
#define X_MIN(a,b) ((a)<(b)?(a):(b))
#define X_DIFF(a,b) ((a)>(b)?(a)-(b):(b)-(a))
#define X_ABS(a) ((a)>=0?(a):-(a))
#define X_OFFSET(struc, field)	((int)&(((struc *)0)->field))
#define X_HTONL(x) ((x<<24)&0xff000000 | (x<<8)&0x00ff0000 |\
                    (x>>8)&0x0000ff00 | (x>>24)&0x000000ff)
#define X_HTONS(x) ((x<<8)&0xff00 | (x>>8)&0x00ff)
#define X_NTOHL(x) X_HTONL(x)
#define X_NTOHS(x) X_HTONS(x)

/***********************
	error
************************/
#define XA_ERR		-1000
#define XC_ERR		-1600
#define XE_ERR		-2200
#define XG_ERR		-2800
#define XJ_ERR		-3700
#define XM_ERR		-4600
#define XQ_ERR		-5800
#define XS_ERR		-6400
#define XT_ERR		-6700
#define XX_ERR		-7900

#endif	/* _AKXLIB_H */
