static  char    sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************************************/
/* <clprexec.c>                                                     */
/*      exec command  process                                       */
/********************************************************************/

#include "colmn.h"

extern condList CLcList;      /* 񃊃Xg */
extern CLNCB    CLSTCB;          /*  */
extern CLPRTBL  *pGLprocTable;
extern CLPRTBL  *pCLprocTable;
extern GlobalCt *pGlobTable;
extern int giOptions[];

/**************************************/
/* _save_scr_and_set_imp_scr_const_ct */
/**************************************/
static int _save_scr_and_set_imp_scr_const_ct(scrprct,procct,nodeleaf)
ScrPrCT *scrprct;
ProcCT  *procct;
Leaf    *nodeleaf;
{
	int rc;
	ScrConstCt *scrconst,*imp_scrconst;

printf("_save_scr_and_set_imp_scr_const_ct:Enter scrprct=%08x procct=%08x nodeleaf=%08x\n",scrprct,procct,nodeleaf);
	rc = 0;
	if (imp_scrconst = cl_get_scr_const_ct(pGLprocTable->CurScr,nodeleaf)) {
		if (!scrprct->pListImport) {
			if (!(scrprct->pListImport=akxs_list_new(0,0))) return ECL_EX_IMPORT;
		}
		if (!(scrconst=_mk_scr_const(scrprct))) return ECL_SYSTEM_ERROR;
		scrconst->NodeLeaf = nodeleaf;
		akxs_list_set(scrprct->pListImport, scrconst);
		procct->Nodeleaf = nodeleaf;
		scrprct->ConstCt     = imp_scrconst->ConstCt;
		scrprct->LeafConstCt = imp_scrconst->LeafConstCt;
		rc = 1;
printf("_save_scr_and_set_imp_scr_const_ct: set imp LeafConstCt=%08x\n",imp_scrconst->LeafConstCt);
	}
	else procct->Nodeleaf = NULL;
	return rc;
}

/**************************************************************/
/* cl_execute_scr_proc                                        */
/**************************************************************/
int cl_execute_scr_proc(pprmp,prmnum,pProc,scrprct,name)
parmList **pprmp;
int  prmnum;
ProcCT  *pProc;
ScrPrCT *scrprct;
char *name;
{
	ProcCT  *procct;
	Leaf    *wkleaf,*nodeleaf;
	int   rc;
	ScrConstCt *scrconst,*imp_scrconst;

DEBUGOUTL4(110,"cl_execute_scr_proc:Enter pprmp=%08x prmnum=%d pProc=%08x scrprct=%08x",pprmp,prmnum,pProc,scrprct);

	rc = 0;
	if (!scrprct || !name) return ECL_SYSTEM_ERROR;

DEBUGOUTL1(110,"cl_execute_scr_proc: name=[%s]",name);

	nodeleaf = NULL;
	wkleaf = cl_search_proc_leaf_and_inner(scrprct,pProc,name,&nodeleaf);
	if (wkleaf == NULL) {
		ERROROUT1(FORMAT(331),name);	/* 葱(%s)L܂B */
		return ECL_NOT_FOUND_PROC;
	}

	if (pprmp && pProc) {
		if (rc = cl_set_exec_parm(pprmp,prmnum,pProc)) return rc;
	}
	procct = cl_mk_lk_proc_ct(); /* Make Linked Proc Control Table */
	if (procct == NULL) return ECL_SYS_PRCT_NULL;

DEBUGOUTL1(120,"cl_execute_scr_proc: procct=%08x",procct);

	procct->ProcTop = wkleaf;
	procct->Curleaf = wkleaf;
	procct->Nextleaf = wkleaf;
	cmn_set_stat(SCR_PR,&procct->ptype,L_ON);
	cl_set_proc_nm(procct,name);
#if 1
printf("cl_execute_scr_proc:Start name=[%s]\n",name);
	if ((rc=_save_scr_and_set_imp_scr_const_ct(scrprct,procct,nodeleaf)) < 0) return rc;
#else
	procct->Nodeleaf = nodeleaf;
	cl_set_scr_const_ct(scrprct,nodeleaf);
#endif
	if (!(procct->Obj=cl_mk_obj0(cl_get_obj0_used(procct,NULL),0))) {
		ERROROUT("Error occured set procct->Obj");
		rc = -1;
	}

DEBUGOUTL1(110,"cl_execute_scr_proc:Exit rc=%d",rc);

	return rc;
}

/**************************************************************/
/* cl_execute_proc                                            */
/**************************************************************/
int cl_execute_proc(pprmp,prmnum,pProc,name)
parmList **pprmp;
int prmnum;
ProcCT *pProc;
char *name;
{
	return cl_execute_scr_proc(pprmp,prmnum,pProc,cl_search_src_ct(),name);
}

/**************************************************************/
/* cl_exec_proc_name                                          */
/**************************************************************/
int cl_exec_proc_name(name)
char *name;
{
	ProcCT  *proc;
	Leaf    *leaf;
	int   rc;

	rc = 0;
	if (!name) return ECL_SYSTEM_ERROR;

	proc = cl_search_proc_ct();
DEBUGOUTL2(110,"cl_exec_proc_name: name=%s proc=%08x",name,proc);
	leaf = proc->Curleaf;
	if (rc = cl_execute_proc(NULL,0,proc,name)) return rc;
	/* return information set process */
	proc->Curleaf = leaf;
DEBUGOUTL1(200,"cl_process_loop: push [ %s ]",cl_get_pcmd_line(leaf));
	cl_ret_leaf_push(proc,leaf);
	cmn_set_stat(RTN_PR,&proc->ptype,L_ON);
	return rc;
}

/**************************************************************/
/* _msg_proc	                                              */
/**************************************************************/
int _msg_proc()
{
	long lInstanceHandle=pCLprocTable->lInstanceHandle;
	tdtColToDb *pDTD;		/* MpPbg ʕ   */
	AKAMSGCOM *tpMsgCom;
	AKAMSGCOM *tpRecvMsg;
	int iRc,iWaitTime;
#ifdef D_FOR_AKB
	tdtCOM_OBJECT  *tpComObject;
#else
	tdtINSTANCE tInst;
#endif
/*
printf("_msg_proc: called\n");
*/
	tpMsgCom = (AKAMSGCOM *)pCLprocTable->WrPacketp;
	if (tpMsgCom->msg_pmsg) {
#ifdef D_FOR_AKB
		if (iRc = aka_new_com_object(lInstanceHandle,&tpComObject)) {
			ERROROUT1("aka_new_com_object ret=%d",iRc);
			return iRc;
		}
#else
		if (iRc = aka_instance_init(0,&tInst,0)) {
			ERROROUT1("_msg_proc: aka_instance_init ret=%d",iRc);
			return iRc;
		}
#endif
		pDTD = (tdtColToDb *)tpMsgCom->msg_pmsg;
		iWaitTime = ntohl(pDTD->lret);
		tpMsgCom->msg_disp = 1;
		pDTD->lret = 0;
#ifdef D_FOR_AKB
		if (iWaitTime < 0) iWaitTime = aka_set_msg_time_out(-1);
		tpMsgCom->msg_aopt |= AKA_AKO_COMOBJECT;
		iRc = aka_send_msg_wait_time(tpComObject,tpMsgCom,iWaitTime);
		if (iRc >= 0) {
			if (iRc = aka_recv_msg(lInstanceHandle,tpComObject,iWaitTime*2,0)) {
				ERROROUT1("aka_recv_msg ret=%d",iRc);
				return iRc;
			}
			tpRecvMsg = tpComObject->recv_ins->recv_msg_com;
#else
		iRc = aka_send_msg_wait_time(lInstanceHandle,tpMsgCom,iWaitTime);
		if (iRc >= 0) {
			if (iRc = aka_recv_msg(lInstanceHandle,&tInst,iWaitTime*2,0)) {
				ERROROUT1("aka_recv_msg ret=%d",iRc);
				return iRc;
			}
			tpRecvMsg = tInst.recv_msg_com;
#endif
/*
printf("_msg_proc: tpRecvMsg=%08x\n",tpRecvMsg);
*/
			pCLprocTable->PrPacketp = (char *)tpRecvMsg;
			cl_packet_error_check(tpRecvMsg);
			iRc = 0;
		}
		else {
			ERROROUT1("SendMsg rc=%d",iRc);
		}
		Free(tpMsgCom->msg_pmsg);
		tpMsgCom->msg_pmsg = NULL;
	}
	else iRc = -1;
	return iRc;
}

/************************************************************/
/* _check_path												*/
/************************************************************/
static int _check_path(pxh,buf,w)
XHASHB *pxh;
char *buf;
Leaf ***w;
{
	int i,j,n,m,nb,pos,ln;
	int  buflen;
	char *argvb[128],parmb[256],*pb;
	char parm[128],*path,*p;
	uchar *up,*pl;
	int  len, opt;

	nb = akxtgetargvns2(buf,strlen(buf),argvb,128,parmb,256,".",AKX_ARGV_USE_ATTR2_SEP);

DEBUGOUTL2(151,"_check_path: nb=%d buf=[%s]",nb,buf);

	m = akxs_xhash(pxh,'M',NULL);
	for (i=1;i<=m;i++) {
		pxh->xha_xhix = i;
		if (akxs_xhash2(pxh,'P',&up,w) > 0) {
			len = up[0];
			n = up[len+1];
			pl = up + len + 2*n + 1;

DEBUGOUTL3(151,"_check_path: i=%2d n=%d path=[%s]",i,n,strtemp(up+1,len-1));

			if (n == nb) {
				for (j=nb-1;j>=0;j--) {
					len = *pl--;
					pos = *pl--;
					p = parm;
					memzcpy(p,up+pos,len);
					pb = argvb[j];
					if (pb[1]!=':' && p[1]==':') p += 2;

DEBUGOUTL5(151,"_check_path:      j=%d p=[%s] pd=[%s] pos=%d len=%d",j,p,pb,pos,len);

					if (strcmp(p,pb)) break;
				}
DEBUGOUTL1(151,"_check_path:      j=%d",j);
				if (j < 0) return 1;
			}
		}
	}
	return 0;
}

/************************************************************/
/* cl_search_leaf_and_inner									*/
/************************************************************/
Leaf *cl_search_leaf_and_inner(kind,scrct,proc,name,pnodeleaf)
char kind;
ScrPrCT *scrct;
ProcCT  *proc;
char *name;
Leaf **pnodeleaf;
{
	Leaf **w,*wkleaf;
	char *wrk,*path,*buf,*p,*key,c,FP[4],*procPath;
	int i,pos,len;

	if (proc) {
		if (!proc->ProcPath) procPath = "";
		else procPath = proc->ProcPath;
	}
	else procPath = "";
	len = strlen(name) + 4;
	pos = strlen(procPath) + 2;
	wrk  = cl_tmp_const_malloc(len*3+pos*2);
	key  = wrk + len;
	path = key + len;
	buf  = path + pos;
	FP[0] = '.';
	FP[1] = kind;
	FP[2] = ':';
	FP[3] = '\0';
	wkleaf = NULL;

DEBUGOUTL1(151,"cl_search_leaf_and_inner:0: name=[%s]",name);

	if ((c=*name)=='$') name++;
	len = strlen(name);
	pos = akxnrskipto(name,len,".");
	if (pos > 0) {
		memzcpy(wrk,name,pos-1);
		strcat(wrk,FP);
		strcat(wrk,name+pos);
		pos = akxnskipto(name,len,".");

DEBUGOUTL2(151,"cl_search_leaf_and_inner:1: len=%d pos=%d",len,pos);

		memnzcpy(key,name,pos);
	}
	else {
		strcpy(wrk,&FP[1]);
		strcat(wrk,name);
		strcpy(key,wrk);
	}

DEBUGOUTL2(151,"cl_search_leaf_and_inner:1: key=[%s] wrk=[%s]",key,wrk);

	if (*procPath) {
		strcpy(path,procPath);
		/* ŏ͎̒𒲂ׂ */
		sprintf(buf,"%s.%s",path,wrk);

DEBUGOUTL1(151,"cl_search_leaf_and_inner:2: buf=[%s]",buf);

		if (_check_path(scrct->ProcIndex,buf,&w) > 0) {
			memcpy(&wkleaf,&w[0],sizeof(Leaf *));
			if (pnodeleaf) memcpy(pnodeleaf,&w[1],sizeof(Leaf *));
			return wkleaf;
		}
		/* ɒׂ */
		for (i=0;i<3;i++) {
			len = strlen(path);
			pos = akxnrskipto(path,len,".");

DEBUGOUTL2(151,"cl_search_leaf_and_inner:3: pos=%d [%s]",pos,path+pos);

			p = path + pos;
			if (key[1]!=':' && p[1]==':') p += 2;
			if (!strcmp(p,key)) {
				if (pos > 0) {
					path[pos-1] = '\0';
					sprintf(buf,"%s.%s",path,wrk);
					p = buf;
				}
				else {
					*path = '\0';
					p = wrk;
				}

DEBUGOUTL1(151,"cl_search_leaf_and_inner:3: p=[%s]",p);

				if (_check_path(scrct->ProcIndex,p,&w) > 0) {
					memcpy(&wkleaf,&w[0],sizeof(Leaf *));
					if (pnodeleaf) memcpy(pnodeleaf,&w[1],sizeof(Leaf *));
					return wkleaf;
				}
			}
			else {
				if (pos > 0) path[pos-1] = '\0';
				else *path = '\0';
			}
			if (pos > 0) pos--;
			else break;
		}
	}

DEBUGOUTL1(151,"cl_search_leaf_and_inner:9: wrk=[%s]",wrk);

	if (_check_path(scrct->ProcIndex,wrk,&w) > 0) {
		memcpy(&wkleaf,&w[0],sizeof(Leaf *));
		if (pnodeleaf) memcpy(pnodeleaf,&w[1],sizeof(Leaf *));
	}
	return wkleaf;
}

#if 1	/* 2021.2.20 */
/************************************************************/
/* _search_method_leaf_and_inner							*/
/************************************************************/
static Leaf *_search_method_leaf_and_inner(org_scrct,proc,name,pnodeleaf,id,kind)
ScrPrCT *org_scrct;
ProcCT  *proc;
char *name;
Leaf **pnodeleaf;
char id;
int kind;
{
	ScrPrCT *scrct;
	Leaf *wkleaf;
	int  i,iINNER;

	iINNER = cl_get_option(8,0) & 0x02;
	scrct = org_scrct;
	for (i=0;i<2;i++) {
		if (pnodeleaf) *pnodeleaf = NULL;
		wkleaf = cl_search_method_leaf(scrct->TreeTop,name,pnodeleaf,kind);
		if (!wkleaf && iINNER) wkleaf = cl_search_leaf_and_inner(id,scrct,proc,name,pnodeleaf);
		if (wkleaf) break;
		scrct = pGLprocTable->CurScr;
	}
	return wkleaf;
}
#endif
/************************************************************/
/* cl_search_func_leaf_and_inner							*/
/************************************************************/
Leaf *cl_search_func_leaf_and_inner(org_scrct,proc,name,pnodeleaf)
ScrPrCT *org_scrct;
ProcCT  *proc;
char *name;
Leaf **pnodeleaf;
{
#if 1	/* 2021.2.20 */
	return _search_method_leaf_and_inner(org_scrct,proc,name,pnodeleaf,'F',CTAG_FUNC);
#else
	ScrPrCT *scrct;
	Leaf *wkleaf;
	int  i;

	scrct = org_scrct;
	for (i=0;i<2;i++) {
		if (pGlobTable->options[7] & 0x02)
			wkleaf = cl_search_leaf_and_inner('F',scrct,proc,name,pnodeleaf);
		else
			wkleaf = cl_search_func_leaf(scrct->TreeTop,name,pnodeleaf);
		if (wkleaf) break;
		scrct = pGLprocTable->CurScr;
	}
	return wkleaf;
#endif
}

/************************************************************/
/* cl_search_proc_leaf_and_inner							*/
/************************************************************/
Leaf *cl_search_proc_leaf_and_inner(org_scrct,proc,name,pnodeleaf)
ScrPrCT *org_scrct;
ProcCT  *proc;
char *name;
Leaf **pnodeleaf;
{
#if 1	/* 2021.2.20 */
	return _search_method_leaf_and_inner(org_scrct,proc,name,pnodeleaf,'P',CTAG_PROC);
#else
	ScrPrCT *scrct;
	Leaf *wkleaf;
	int  i;

	scrct = org_scrct;
	for (i=0;i<2;i++) {
		if (pGlobTable->options[7] & 0x02)
			wkleaf = cl_search_leaf_and_inner('P',scrct,proc,name,pnodeleaf);
		else
			wkleaf = cl_search_proc_leaf(scrct->TreeTop,name,pnodeleaf);
		if (wkleaf) break;
		scrct = pGLprocTable->CurScr;
	}
	return wkleaf;
#endif
}

/************************************************************/
/* cl_search_class_leaf_and_inner							*/
/************************************************************/
Leaf *cl_search_class_leaf_and_inner(org_scrct,proc,name,pnodeleaf)
ScrPrCT *org_scrct;
ProcCT  *proc;
char *name;
Leaf **pnodeleaf;
{
#if 1	/* 2021.2.20 */
	return _search_method_leaf_and_inner(org_scrct,proc,name,pnodeleaf,'C',CTAG_CLASS);
#else
	ScrPrCT *scrct;
	Leaf *wkleaf;
	int  i;

	scrct = org_scrct;
	for (i=0;i<2;i++) {
		if (pGlobTable->options[7] & 0x02)
			wkleaf = cl_search_leaf_and_inner('C',scrct,proc,name,pnodeleaf);
		else
			wkleaf = cl_search_class_leaf(scrct->TreeTop,name,pnodeleaf);
		if (wkleaf) break;
		scrct = pGLprocTable->CurScr;
	}
	return wkleaf;
#endif
}

/************************************************************/
/* cl_exec_function											*/
/************************************************************/
int cl_exec_function(name,pInfoParmW,nparm,ppParm)
char *name;
tdtINFO_PARM *pInfoParmW;
int  nparm;
tdtINFO_PARM *ppParm[];
{
	ScrPrCT *scrprct;
	ProcCT  *cur_procct;
	Leaf    *wkleaf,*nodeleaf;
	int     rc;
	char    str[Pr_NM_MAX+2],buf[16];

	if (!name) return ECL_SYSTEM_ERROR;

	scrprct = cl_search_src_ct();
	if (!scrprct) return ECL_SYS_SCCT_NULL;

	cur_procct = cl_search_proc_ct();

	if (*name == '{') {
		if (!cur_procct) {
			/* %s: ֐(%s)͎gpł܂B */
			ERROROUT2(FORMAT(334),"cl_exec_function",name);
			return ECL_SCRIPT_ERROR;
		}
		wkleaf = cl_set_func_body(scrprct,cur_procct,name,&nodeleaf,NULL);
		if (wkleaf) {
			name = buf;
			strcpy(name,"NO_NAME_FUNC");
		}
	}
	else {
		wkleaf = cl_search_func_leaf_and_inner(scrprct,cur_procct,name,&nodeleaf);
	}
	if (!wkleaf) {
	/*	ERROROUT1("֐(%s)L܂B",name);	*/
		return ECL_NOT_FOUND_FUNC;
	}
	else if (!cur_procct) {
		/* %s: ֐(%s)͎gpł܂B */
		ERROROUT2(FORMAT(334),"cl_exec_function",name);
		return ECL_SCRIPT_ERROR;
	}
	rc = cl_exec_func_setup_proc(name,pInfoParmW,nparm,ppParm,wkleaf,nodeleaf,0,NULL);
	if (rc) return rc;
	return cl_exec_func_execute(cur_procct);
}

/************************************************************/
/* cl_exec_func_setup_proc									*/
/************************************************************/
int cl_exec_func_setup_proc(name,pInfoParmW,nparm,ppParm,wkleaf,nodeleaf,opt,class_proc)
char *name;
tdtINFO_PARM *pInfoParmW;
int  nparm;
tdtINFO_PARM *ppParm[];
Leaf *wkleaf,*nodeleaf;
int opt;
ProcCT  *class_proc;
{
	ScrPrCT *scrprct;
	ProcCT  *procct,*prepct,*nextpct;
	int     rc,i,*pSize,gid;
	tdtINFO_PARM *pInfoParm;
	char c;

	scrprct = cl_search_src_ct();
	if (!scrprct) return ECL_SYS_SCCT_NULL;

DEBUGOUTL4(101,"cl_exec_func_setup_proc: name=[%s] nparm=%d opt=%08x class_proc=%08x",
name,nparm,opt,class_proc);

	if (class_proc) {
		procct = cl_mk_lk_class_method(NULL);
		if (!procct) return ECL_SYS_PRCT_NULL;
		gid = procct->ProcGid;
		prepct = procct->prePCT;
		nextpct = procct->nextPCT;
		*procct = *class_proc;
		procct->prePCT = prepct;
		procct->nextPCT = nextpct;
		procct->ProcGid = gid;
/*
printf("cl_exec_func_setup_proc: ptype=%02x\n",procct->ptype);
*/
		procct->ptype = 0;
		cl_tmp_const_ct_set(procct->pTmpConstCt);
	}
	else {
		procct = cl_mk_lk_proc_ct(); /* Make Linked Proc Control Table */
		if (!procct) return ECL_SYS_PRCT_NULL;
		procct->ProcTop = wkleaf;
		if (!(procct->Obj=cl_mk_obj0(cl_get_obj0_used(procct,NULL),0))) return -1;
		if (rc=cl_mk_pr_var_set(procct)) return rc;
	}

DEBUGOUTL1(102,"cl_exec_func_setup_proc: new_proc=%08x",procct);

	if (procct == NULL) return ECL_SYS_PRCT_NULL;
	procct->pFlag |= opt;
	procct->ProcTop = wkleaf;
	procct->Curleaf = wkleaf;
	procct->Nextleaf = wkleaf;
	procct->ProcNM = Strdup(name);
	procct->Retval = pInfoParmW;
	procct->Nodeleaf = nodeleaf;
	cmn_set_stat(SCR_PR|UFN_PR,&procct->ptype,L_ON);
#if 1
printf("cl_exec_func_setup_proc:Start name=[%s]\n",name);
	if ((rc=_save_scr_and_set_imp_scr_const_ct(scrprct,procct,nodeleaf)) < 0) return rc;
#else
	cl_set_scr_const_ct(scrprct,nodeleaf);
#endif
	for (i=0;i<nparm;i++)  {
		pInfoParm = cl_get_var_ent(procct->pTBL_pasento,i+1);
		if (cl_gx_rep_info_set(pInfoParm,ppParm[i],1)) {
			cl_er_lk_proc_ct();
			return ECL_SCRIPT_ERROR;
		}
		if ((c=pInfoParm->pi_id) == 'A' || c == 'R') {
			pInfoParm->pi_scale &= ~0x20;
		}
DEBUGOUT_InfoParm(194,"cl_exec_func_setup_proc: i=%d pScCT=%08x",
pInfoParm,i,pInfoParm->pi_len);
	}
	procct->varnam_pasento = nparm;
	pSize = (int *)procct->pTBL_pasento[0];
	pSize[7] = nparm;
	cl_set_parm_bin(cl_var_size_parm(pSize),nparm);
/*
printf("cl_exec_func_setup_proc:EXIT: ptype=%02x pSize[7]=%d\n",procct->ptype,pSize[7]);
*/
	return 0;
}

/************************************************************/
/* cl_exec_func_execute										*/
/************************************************************/
int cl_exec_func_execute(cur_procct)
ProcCT *cur_procct;
{
	ScrPrCT *scrprct;
	ProcCT  *procct;
	int     rc;
	char *msg;

	scrprct = cl_search_src_ct();
	if (!scrprct) return ECL_SYS_SCCT_NULL;
	rc = 0;

DEBUGOUTL1(151,"cl_exec_func_execute: cur_procct=%08x",cur_procct);

	while (!rc && cmn_chk_stat(SCR_ED,&pCLprocTable->ScrSt)==L_OFF) {
		rc = cl_execute_script();
		if ((procct=cl_search_proc_ct()) == cur_procct) break;
DEBUGOUTL1(151,"cl_exec_func_execute: pCLprocTable->PrSt=%02x",pCLprocTable->PrSt);
		if (cmn_chk_stat(RTN_PR,&pCLprocTable->PrSt) != L_OFF) {
			if (rc = _msg_proc()) {
				/* SQL/SLEEP/MSGsG[(rc=%d)A֐̎sI܂B */
				ERROROUT1(FORMAT(332),rc);
				cmn_set_stat(RTN_PR,&pCLprocTable->PrSt,L_OFF);
				rc = ECL_SCRIPT_ERROR;
				rc = clerrdisp(rc,procct->Curleaf);
				msg = "cl_exec_function: Erase executing %s in function!!";
				if (scrprct->nextScCT) {
					ERROROUT1(msg,"script");
					cl_scr_clear(scrprct->nextScCT);
					scrprct->nextScCT = NULL;
				}
				if (cur_procct->nextPCT) {
					ERROROUT1(msg,"proc");
					cl_prc_clear(cur_procct->nextPCT);
					cur_procct->nextPCT = NULL;
				}
				break;
			}
		}
	}
DEBUGOUTL2(151,"cl_exec_func_execute: cur_procct=%08x rc=%d",cur_procct,rc);
	if (rc < 0) {
		if (!pGlobTable->exception) pGlobTable->exception = cl_mk_exception_code(ETC_EXCEPTION,rc);
		pGlobTable->error = rc;
	}
printf("cl_exec_func_execute:End scrprct=%08x cur_procct=%08x\n",scrprct,cur_procct);
	cl_set_scr_const_ct(scrprct,cur_procct->Nodeleaf,NULL);
	return rc;
}

/************************************************************/
/* cl_set_func_body											*/
/************************************************************/
Leaf *cl_set_func_body(scrprct,proc,name,ppTopleaf,procPath)
ScrPrCT *scrprct;
ProcCT  *proc;
char    *name;
Leaf **ppTopleaf;
char *procPath;
{
	static MCAT CLcList_mcat={'M','C',512,0,0,0,NULL,0};
	int len,ret,ln,opt_in,dtype;
	char *p,*argv[2];
	uchar *up;
	Leaf *leaf,*leafTop;
	tdtINFO_PARM InfoParm;
	SSP_S ssp;

	if (!proc) return NULL;
	len = strlen(name);
	ret = 0;
	p = name;
	if (len<2 || *p!='{' || *(p+len-1)!='}') {
		ERROROUT("direct script error");
		return NULL;
	}
	if (!(InfoParm.pi_data = cl_const_malloc(len))) {
		ERROROUT("script area malloc error");
		return NULL;
	}
	p++;
	if (len > 2) InfoParm.pi_dlen = len - 2;
	else InfoParm.pi_dlen = 0;
	memzcpy(InfoParm.pi_data,p,InfoParm.pi_dlen);
	CLcList.mcat = &CLcList_mcat;
	ssp.sp = 0;
	InfoParm.pi_paux = (char *)&ssp;
	CLcList.fp = (FILE *)&InfoParm;
	CLcList.line = 0;
	CLcList.option = D_SCRPT_MEMORY | D_SCRPT_NEW_LEX;
#if 1	/* 2021.5.18 */
	dtype = akxt_get_code_type();
/*	if (opt_in = (cl_get_option(21,0)>>16) & 0x0f) dtype = opt_in;	*/
	CLcList.option |= D_CLST_OPT_USE_DTYPE | (dtype<<16);
#endif
	CLcList.fname = "MEM:";
	CLcList.fullname = CLcList.fname;

	if (!(CLcList.ConstCt=cl_const_ct_new())) {
		ERROROUT("Malloc ConstCt");
		return NULL;
	}

	CLSTCB.TopStack = NULL;
	leaf = proc->Curleaf;
	if (leaf->leftleaf) {
		cl_leaf_clear(leaf->leftleaf);
		leaf->leftleaf = NULL;
	}
	if (ret=cl_lex()) return NULL;
	if (!(leafTop = search_top_leaf())) return NULL;
	if (!procPath) procPath = proc->ProcPath;
	argv[0] = procPath;
	ln = strlen(procPath);
	len = ln + 1;
	if (!(up=(uchar *)cl_scr_malloc(len+5))) return NULL;
	up[0] = len;
	memcpy(up+1,procPath,ln);
	up[len] = '.';
	up[len+1] = 1;
	up[len+2] = 1;
	up[len+3] = ln;
	up[len+4] = '\0';
	argv[1] = (char *)up;
/*
printf("cl_set_func_body: up=%d [%s] %d %d %d\n",up[0],strname(up+1,ln+1),up[len+1],up[len+2],up[len+3]);
*/
	argv[1] = up;
	_set_node_path(scrprct,leafTop,argv,NULL);
	leaf->leftleaf = leafTop;
	CLSTCB.TopStack = NULL;
	cl_search_func_leaf(scrprct->TreeTop,scrprct->pId,ppTopleaf);
	return leafTop;
}
