static char sccsid[]="%Z% %M% %I% %D% %T%";
/*****************************************************/
/*                                                   */
/*       Database Interface Program for FILE         */  
/*                                                   */
/*           coded by A.Kobayashi  94.06.11          */  
/*         updated by A.Kobayashi  96.05.28          */  
/*         updated by A.Kobayashi  97.07.08          */  
/*         updated by A.Kobayashi  97.11.10          */  
/*                                                   */
/*===================================================*/
/*  int fil_prepare(sql,cp)                          */
/*  int fil_optimize(cp)                             */
/*****************************************************/
#include "somn.h"

extern SQLCA_FIL sqlca_fil;

static int   obj[FIL_MAX_OBJ];
static short nnest,nest[FIL_MAX_NEST],nest_flg[FIL_MAX_NEST];
static WHERE_TREE tree[FIL_MAX_TREE];

int fil_prepare(sql,cp)
char *sql;
CURSOR *cp;
{
	SQLDA_FIL *selp, *bndp;
	SSP_S ssp,sspw;
	FILE *fp;
	char w[128],buf[128],*p;
	int len,nclm,ret,i,j,iasta,sp0,nob,type;

	sqlca_fil.sqlcode = 0;
	sqlca_fil.sqlerrd[2] = 0;
	selp = cp->select;
	bndp = cp->bind;
	selp->F = bndp->F = nclm = nob = iasta = 0;
	ssp.sp = 0;
	ssp.wd = w;
	len=axtgwsp(sql,&ssp);
	if (len==0) {
		fil_errmsg(ERROR_NO_SQL);
		return 0;
	}
	if (stricmp(w,"select")) {
		fil_errmsg(ERROR_NOT_SELECT);
		return 0;
	}
	cp->isflg = 0;
	cp->icflg = 0;
	cp->nobj  = 0;
	cp->obj   = obj;
	cp->nnest = 0;
/*	cp->inflg = 0;	*/
	cp->ixflg = 0;
	cp->tree  = tree;
	cp->nest  = nest;
	cp->nest_flg  = nest_flg;
	while (len=axtgwsp(sql,&ssp)) {
/*
printf("w=%s\n",w);
*/
		if (!stricmp(w,"from")) {
			len=axtgwsp(sql,&ssp);
			break;
		}
		else if (ssp.attr[0]==1 || ssp.attr[0]==5 || *w=='*') {
			if (iasta) {
				fil_errmsg(ERROR_SYNTAX);
				return 0;
			}
			if (nclm >= selp->N) {
				selp->F = -1;
				fil_errmsg(ERROR_TOO_MANY);
				return 0;
			}
			selp->T[nclm] = ssp.attr[0];
			selp->M[nclm] = 0;
			selp->C[nclm] = 0;
#if 1	/* add 2004.3.17 Koba */
			if (ssp.attr[0] == 5) {
				sspw.sp = 0;
				sspw.wd = buf;
				akxtgwns(w,len,&sspw,"", 0x07);
				p = buf;
			}
			else p = w;
			strmemcpy(selp->S[nclm],p,selp->Y[nclm]);
#else
			strmemcpy(selp->S[nclm],p,selp->Y[nclm]);
#endif
			selp->L[nclm] = strlen(selp->S[nclm]);
			if (*w == '*') iasta = 1;
			else if (!stricmp(w,"max") || !stricmp(w,"min") ||
			         !stricmp(w,"sum") || !stricmp(w,"count")) {
				if (!stricmp(w,"max")) j = 1;
				else if (!stricmp(w,"min")) j = 2;
				else if (!stricmp(w,"sum")) j = 3;
				else {
					j = 4;
					cp->icflg++;
				}
				selp->C[nclm] = j;
				cp->isflg++;
				len=axtgwsp(sql,&ssp);
				if (*w != '(') {
					fil_errmsg(ERROR_SYNTAX);
					return 0;
				}
				len=axtgwsp(sql,&ssp);
				if (*w == '*') {
					if (j != 4) {
						fil_errmsg(ERROR_SYNTAX);
						return 0;
					}
				}
				else if (ssp.attr[0]!=1) {
					fil_errmsg(ERROR_SYNTAX);
					return 0;
				}
				strmemcpy(selp->S[nclm],w,selp->Y[nclm]);
/*
printf("fil_prepare:selp->S=[%s]\n",selp->S[nclm]);
*/
			/***
				selp->L[nclm] = strlen(selp->S[nclm]);
			***/
				while (len=axtgwsp(sql,&ssp)) {
					if (*w == ')') break;
				}
				if (!len) {
					fil_errmsg(ERROR_SYNTAX);
					return 0;
				}
			}
			nclm++;
		}
		else if (*w != ',') {
			fil_errmsg(ERROR_SYNTAX);
			return 0;
		}
	}
	if (!len) {
		fil_errmsg(ERROR_SYNTAX);
		return 0;
	}
	if (cp->isflg>0 && cp->isflg!=nclm) {
		fil_errmsg(ERROR_SYNTAX);
		return 0;
	}
	selp->F = nclm;
	if (ret=fil_bind(w,cp)) {
		fil_errmsg(ret);
		return 0;	/* add 1998.8.13 Koba */
	}
	else {
		bndp = cp->bind;
		if (selp->F>0) {
			for (i=0;i<selp->F;i++) {
#if 1	/* add 2004.3.17 Koba */
				type = selp->T[i];
				if (type!=1 && type!=('*'|0x80)) continue;
#endif
				for (j=0;j<bndp->F;j++) {
					if (!(stricmp(selp->S[i],bndp->S[j]))) {
						if (selp->C[i]==3 && bndp->T[j]!=TYPE_FIL_INTEGER) {
							fil_errmsg(ERROR_SYNTAX);
							return 0;
						}
						selp->T[i] = bndp->T[j];
						selp->L[i] = bndp->L[j];
						selp->M[i] = j + 1;
/*
printf("fil_prepare:i=%d,name=[%s],type=%d,len=%d,m=%d,c=%d\n",
i,selp->S[i],selp->T[i],selp->L[i],selp->M[i],selp->C[i]);
*/
						break;
					}
				}
				if (j>=bndp->F) {
					if (*(selp->S[i]) == '*') {
						if (!cp->isflg) {
							for (j=1;j<bndp->F;j++) {
								if (i >= selp->N) {
									selp->F = -1;
									fil_errmsg(ERROR_TOO_MANY);
									return 0;
								}
								selp->T[i] = bndp->T[j];
								selp->L[i] = bndp->L[j];
								selp->M[i] = j + 1;
								strmemcpy(selp->S[i],bndp->S[j],selp->Y[i]);
/*
printf("fil_prepare:i=%d,name=[%s],type=%d,len=%d,m=%d\n",
i,selp->S[i],selp->T[i],selp->L[i],selp->M[i]);
*/
								i++;
							}
							selp->F = i;
							break;
						}
					}
					else if (selp->T[i]==1) { /* add 1999/8/30 Koba */
						fil_errmsg(ERROR_NOT_COLNAME);
						return 0;
					}
				}
				if (j=selp->C[i]) {
					p = selp->S[i];
					if (j == 1)
						sprintf(w,"max(%s)",p);
					else if (j == 2)
						sprintf(w,"min(%s)",p);
					else if (j == 3)
						sprintf(w,"sum(%s)",p);
					else {
						sprintf(w,"count(%s)",p);
						if (*p == '*') {	/* update 2000.11.27 Koba */
							selp->T[i] = TYPE_FIL_INTEGER;
							selp->L[i] = 16;
						}
					}
					strmemcpy(p,w,selp->Y[i]);
/*
printf("fil_prepare:selp=%08x i=%d selp->S=[%s] L=%d\n",
selp,i,selp->S[i],selp->L[i]);
*/
				}
			}
		}
		else {
			selp->F = bndp->F;
			for (i=0;i<bndp->F;i++) {
				selp->T[i] = bndp->T[i];
				selp->L[i] = bndp->L[i];
				selp->M[i] = i + 1;
				strmemcpy(selp->S[i],bndp->S[i],selp->Y[i]);
			}
		}
	}
	for (i=0;i<bndp->F;i++) bndp->Z[i] = 0;

	if (len=axtgwsp(sql,&ssp)) {
/*
printf("w=%s\n",w);
*/
		if (!stricmp(w,"where")) {
			nob=fil_compile(bndp,&sql[ssp.sp],FIL_MAX_OBJ,obj);
			if (nob<0) {
				fil_errmsg(nob);
				return nob;
			}
/*
printf("fil_prepare : nobj=%d\n",nob);
*/
			cp->nobj = nob;
/*
for (i=0;i<nob;i++) printf("i=%2d obj=%d\n",i,obj[i]);
*/
		}
		else {
			fil_errmsg(ERROR_SYNTAX);
			return 0;
		}
	}
	if (nob==0) obj[0]=99;

	sqlca_fil.sqlcode = fil_errmsg(fil_optimize(cp));

	return sqlca_fil.sqlcode;
}

int fil_optimize(cp)
CURSOR *cp;
{
	SQLDA_FIL *bndp,*selp;
	int   *obj,nob;
	WHERE_TREE *tree;
	short *nest,*nest_flg;
	int i,j,ret;

	selp = cp->select;
	bndp = cp->bind;
	nob  = cp->nobj;
	obj  = cp->obj;
	tree = cp->tree;
	nest = cp->nest;
	nest_flg = cp->nest_flg;
#ifdef NO_INDEX
	if (bndp->Z[0]) {
		cp->ixflg |= IXFLG_IX_WHERE;
		for (i=1;i<bndp->F;i++) {
/*
printf("fil_optimize:i=%d Z=%d\n",i,bndp->Z[i]);
*/
			if (bndp->Z[i]) {
				cp->ixflg &= ~IXFLG_IX_WHERE;
				break;
			}
		}
	}
	else cp->ixflg &= ~IXFLG_IX_WHERE;
#else
	cp->ixflg |= IXFLG_IX_WHERE;
	for (i=1;i<bndp->F;i++) {
		if (bndp->Z[i] && !bndp->M[i]) {
			cp->ixflg &= ~IXFLG_IX_WHERE;
			break;
		}
	}
#endif
	if ((cp->ixflg & IXFLG_IX_WHERE) == 0) {
		if (nob>0) {
			ret = fil_cr_tree(obj,nob,tree);
			if (!ret) {
				ret = fil_cr_nest0(bndp,tree,nest,nest_flg);
				if (ret < 0) return ret;
				cp->nnest = ret;
				for (i=0;i<cp->nnest;i++)
					if (!nest_flg[i]) break;
			/* updated 1999/12/15 Koba
				if (i<cp->nnest) cp->inflg = 1;	*/
				if (i<cp->nnest) cp->ixflg |= IXFLG_IX_NEST;
					/* rowid or INDEXJ܂ރlXg */
			}
			else if (ret != -99) return ret;
		}
	}
#ifndef NO_INDEX
	else {
	/* selectڂ̃JINDEX݂̂̂Ƃ́At@Cǂ܂Ȃ悤ɂ */
		cp->ixflg |= IXFLG_IX_SELECT;
		for (i=0;i<selp->F;i++) {
			if ((j=selp->M[i]-1) >= 1) {
				if (!bndp->M[j]) {
					cp->ixflg &= ~IXFLG_IX_SELECT;
					break;
				}
			}
		}
	}
#endif
	if ((nob==6 && obj[1]==201 && obj[3]==501 &&
	     obj[4]>=FIL_WDATTR_NE && obj[4]<=FIL_WDATTR_LT)
	 || (nob==12 && obj[1]==201 && obj[3]==501 &&
	     obj[4]>=FIL_WDATTR_NE && obj[4]<=FIL_WDATTR_LT &&
	     obj[6]==201 && obj[8]==502 &&
	     obj[9]>=FIL_WDATTR_NE && obj[9]<=FIL_WDATTR_LT &&
	     obj[10]==FIL_WDATTR_AND)
	   ) {
		cp->ixflg |= IXFLG_IX_ROWID;
	}
/*
printf("fil_optimize:ixflg=%04x, inflg=%04x\n",cp->ixflg,cp->inflg);
*/
	return 0;
}
