static char sccsid[]="%Z% %M% %I% %E% %U%";
/*****************************************************/
/*                                                   */
/*       Database Interface Program for FILE         */
/*                                                   */
/*           coded by A.Kobayashi  2010.05.28        */
/*                                                   */
/*****************************************************/
#include "somn.h"

#define PORA(x)

static char *nullstring=" ";
SQLCA_FIL sqlca_fil
         = {
         {'S', 'Q', 'L', 'C', 'A', ' ', ' ', ' '},
         sizeof(SQLCA_FIL),
         0,
         { 0, {0}},
         {'N', 'O', 'T', ' ', 'S', 'E', 'T', ' '},
         {0, 0, 0, 0, 0, 0},
         {0, 0, 0, 0, 0, 0, 0, 0},
         {0, 0, 0, 0, 0, 0, 0, 0}
         }
         ;
static SQLDA_FIL *bind_dp;
static SQLDA_FIL *select_dp;

static CURSOR C;

static int precision,scale;
static int null_ok;
static short *indicator;
/* static short indicate[MAX_COLUMN]; */
static char  errmsg[71];

static int di_sqlerrm_fil(pdipCT)
qDipCT *pdipCT;
{
	int ret=0;

	memcpy(errmsg,sqlca_fil.sqlerrm.sqlerrmc,sqlca_fil.sqlerrm.sqlerrml);
	errmsg[sqlca_fil.sqlerrm.sqlerrml] = '\0';
	pdipCT->sqlcode = sqlca_fil.sqlcode;
	if (sqlca_fil.sqlcode) ret = ERROR_ORACLE;
	return ret;
}

int di_connect_fil(pdipCT)
qDipCT *pdipCT;
{
	qParm *p;
	int ret=0;

	p = pdipCT->pparm;
	fil_connect(p->database);
	return di_sqlerrm_fil(pdipCT);
}

SQLDA_FIL *sqlald_fil(x,y,z)
int x,y,z;
{
	SQLDA_FIL *p;
	int i;

	p = (SQLDA_FIL *)Malloc(sizeof(SQLDA_FIL));
	p->N = x;
	p->T = (short *)Malloc(x*sizeof(short));
	p->I = (short **)Malloc(x*sizeof(short *));
	p->L = (long *)Malloc(x*sizeof(long));
	p->S = (char **)Malloc(x*sizeof(char *));
	p->V = (char **)Malloc(x*sizeof(char *));
	p->X = (char **)Malloc(x*sizeof(char *));
	p->M = (short *)Malloc(x*sizeof(short));
	p->C = (short *)Malloc(x*sizeof(short));
	p->Y = (short *)Malloc(x*sizeof(short));
	p->Z = (short *)Malloc(x*sizeof(short));
#ifdef OLD_CASH
	p->LS= x*(y+1);
	p->S[0]=Malloc(p->LS);
#else
	p->S[0]=Malloc(x*(y+1));
	p->I[0]=(short *)Malloc(x*sizeof(short));
#endif
	for (i=1;i<x;i++) {
		p->S[i]=p->S[i-1]+(y+1);
		p->I[i]=p->I[i-1]+sizeof(short);
	}
	for (i=0;i<x;i++) {
		p->V[i]=NULL;
		p->X[i]=NULL;
		p->Y[i]=y;
	}
	return p;
}

void sqlclu_fil(p)
SQLDA_FIL *p;
{
	int i;

	if (!p) return;
	if (p->V) {
		for (i=0;i<p->N;i++) {
			if (p->V[i]) Free(p->V[i]);
		}
		Free(p->V);
	}
	if (p->X) {
		for (i=0;i<p->N;i++) {
			if (p->X[i]) Free(p->X[i]);
		}
		Free(p->X);
	}
	if (p->S[0]) Free(p->S[0]);
	if (p->I[0]) Free(p->I[0]);
	if (p->T) Free(p->T);
	if (p->I) Free(p->I);
	if (p->L) Free(p->L);
	if (p->S) Free(p->S);
	if (p->M) Free(p->M);
	if (p->C) Free(p->C);
	if (p->Y) Free(p->Y);
	if (p->Z) Free(p->Z);
	Free(p);
}

int di_init_fil(pdipCT)
qDipCT  *pdipCT;
{
	qDist *iitmn;
	int i,iRc;

	if (!(bind_dp = sqlald_fil(MAX_COLUMN,30,30))) return(ERROR_MALLOC);
	bind_dp->N = MAX_COLUMN;
	if (!(select_dp = sqlald_fil(MAX_COLUMN,30,30))) return(ERROR_MALLOC);
	select_dp->N = MAX_COLUMN;

	C.bind   = bind_dp;
	C.select = select_dp;
	C.tblnam = NULL;
	C.fp     = NULL;
	C.rec    = NULL;
	C.tptc   = NULL;

	iitmn = pdipCT->piitmn;
	for (i=0;i<MAX_COLUMN;i++) {
		iitmn[i].attr.dtype = TYPE_FIL_CHAR;
		iitmn[i].cpdat = select_dp->S[i];
		iitmn[i].len = 30;
	/*
		if (!(select_dp->V[i] = Malloc(257))) return(ERROR_MALLOC);
	*/
	}

	pdipCT->errormsg = errmsg;

	iRc = fil_init();
	if (iRc) fil_errmsg(ERROR_MALLOC);

	return di_sqlerrm_fil(pdipCT);
}

int di_pre_fil(psql,pdipCT)
char *psql;
qDipCT *pdipCT;
{
	int i;
	char variable[32], *pdat;
	qDist *idist, *odist, *iitmn;
/*
	C.bind   = bind_dp;
	C.select = select_dp;
	bind_dp->N   = MAX_COLUMN;
*/
#ifndef OLD_CASH
	C.bind   = bind_dp;
	bind_dp->N   = MAX_COLUMN;
#endif
	select_dp->N = MAX_COLUMN;

	idist = pdipCT->pidist;
	iitmn = pdipCT->piitmn;
	odist = pdipCT->podist;
/*	pdat  = pdipCT->inbuf;  */

	PORA(printf("EXEC SQL PREPARE S FROM :statement\n");)
	PORA(printf ("selp=%08x bndp=%08x\n",select_dp,bind_dp);)
	PORA(printf ("C.selp=%08x C.bndp=%08x\n",C.select,C.bind);)
	fil_prepare(psql,&C);
	if (sqlca_fil.sqlcode) goto SqlErr;

	PORA(printf("EXEC SQL OPEN C USING DESCRIPTOR select_dp\n");)
	PORA(printf ("C.selp=%08x C.bndp=%08x\n",C.select,C.bind);)
	fil_cursor_open(&C);
	if (sqlca_fil.sqlcode) goto SqlErr;
/*
printf("di_pre_fil: sel F=%d, bnd F=%d\n",select_dp->F,bind_dp->F);
*/
	PORA(printf ("C.selp=%08x C.bndp=%08x\n",C.select,C.bind);)
	if (select_dp->F < 0) {
		PORA(printf("Too many select-list items for: %d\n",-(select_dp->F));)
		return(ERROR_TOO_MANY);
	}
/*
	select_dp->N = select_dp->F;
*/
	for (i=0;i<select_dp->F;i++) {
		idist[i].attr.pre   = 0;
		idist[i].attr.scale = 0;
		odist[i].attr.dtype = select_dp->T[i];
		iitmn[i].len = select_dp->Y[i];
		PORA(printf ("i=%d type=%d L=%d",i,select_dp->T[i],select_dp->L[i]);)
		switch (select_dp->T[i] & 0x0f) {
			case TYPE_FIL_CHAR:
				idist[i].len = select_dp->L[i];
				break;
			case TYPE_FIL_INTEGER:
				select_dp->T[i] = TYPE_FIL_CHAR;
				select_dp->L[i] = 12;
				idist[i].attr.pre   = precision;
				idist[i].attr.scale = scale;
				idist[i].len = select_dp->L[i];
				break;
			case TYPE_FIL_BULK:
				/*
				select_dp->L[i] = MAX_LONG_SIZE;
				select_dp->T[i] = TYPE_FIL_BULK;
				*/
				idist[i].len = select_dp->L[i];
				break;
			case TYPE_FIL_DATE:
				select_dp->T[i] = TYPE_FIL_CHAR;
				select_dp->L[i] = 19;
				idist[i].len = select_dp->L[i];
				break;
		}
		PORA(printf (" --> type=%d L=%d\n",select_dp->T[i],select_dp->L[i]);)
#if 0
		if (select_dp->V[i]) Free(select_dp->V[i]);
		if (!(select_dp->V[i] = Malloc(idist[i].len+1)))
			return ERROR_MALLOC;
#else
		if (!select_dp->V[i]) {
			if (!(select_dp->V[i]=Malloc(idist[i].len+1)))
				return ERROR_MALLOC;
		}
		else {
			if (!(select_dp->V[i]=Realloc(select_dp->V[i],idist[i].len+1)))
				return ERROR_MALLOC;
		}
#endif
	/*	select_dp->I[i] = &indicate[i];	*/
		idist[i].attr.dtype = select_dp->T[i];
		idist[i].cpdat = select_dp->V[i];
/*
printf("i=%d, attr.dtype=%d, attr.pre=%d, attr.scale=%d, attr.flag=%d, cpdat=%08x, len=%d\n",i,idist[i].attr.dtype,idist[i].attr.pre,idist[i].attr.scale,idist[i].attr.flag,idist[i].cpdat,idist[i].len);
*/
	}
	pdipCT->nidist = select_dp->F;

	return (0);
SqlErr:
	PORA(printf("di_pre_fil:sqlcode=%d\n",sqlca_fil.sqlcode);)
	di_sqlerrm_fil(pdipCT);
	return sqlca_fil.sqlcode;
}

int di_fetch_fil(pdipCT)
qDipCT *pdipCT;
{
	fil_fetch(&C);
	di_sqlerrm_fil(pdipCT);
	return (sqlca_fil.sqlcode);
}

int di_eof_fil(pdipCT)
qDipCT *pdipCT;
{
int i;

	PORA(printf("\nNumber of rows processed = %d\n",sqlca_fil.sqlerrd[2]);)
	fil_cursor_close(&C);
	pdipCT->sqlcode = sqlca_fil.sqlcode;
	PORA(printf("EXEC SQL CLOSE C\n");)
	di_sqlerrm_fil(pdipCT);
	return (sqlca_fil.sqlerrd[2]);
}

int di_end_fil()
{
	int i;
/*
	for (i=0;i<select_dp->N;i++) {
		if (select_dp->V[i]) {
			Free(select_dp->V[i]);
			select_dp->V[i] = NULL;
		}
	}
*/
	sqlclu_fil(bind_dp);
	sqlclu_fil(select_dp);
	return (0);
}

int di_disconnect_fil(pdipCT)
qDipCT *pdipCT;
{
	int ret = 0;

	PORA(printf("EXEC SQL DISCONNECT\n");)
	return (ret);
}

int di_exec_sql_fil(sql,pdipCT)
char *sql;
qDipCT *pdipCT;
{
	char temp[256];

	strncpy(temp,sql,sizeof(temp)-1);
	temp[sizeof(temp)-1]='\0';
	PORA(printf("EXEC SQL EXECUTE [%s]\n",temp);)

#ifndef OLD_CASH
	C.bind   = bind_dp;
	bind_dp->N   = MAX_COLUMN;
#endif
	fil_exec_sql(sql,&C);
	di_sqlerrm_fil(pdipCT);
	return (sqlca_fil.sqlcode);
}

int di_start_tr_fil()
{
	PORA(printf("EXEC SQL START TRANSACTION\n");)
	return 0;
}

int di_commit_fil()
{
	PORA(printf("EXEC SQL COMMIT WORK\n");)
	return 0;
}

int di_rollback_fil()
{
	PORA(printf("EXEC SQL ROLLBACK WORK\n");)
	return 0;
}

CURSOR *di_cursor_fil()
{
	return &C;
}
