static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*
 *	akxsRb.c
 *
 *		coded   by A.Kobayashi 95.3.28
 *
 *
 */
#include "akxcommon.h"

tdtRB_CTL *akxs_rb_new(lBS,lRM)
int lBS,lRM;
{
	tdtRB_CTL *pCt;
	tdtRB_CHAIN *p1,*p2;

	if (!(pCt = (tdtRB_CTL *)Malloc(sizeof(tdtRB_CTL)))) return NULL;
	memset(pCt,0,sizeof(tdtRB_CTL));
	pCt->rb_bfsz = lBS;
	pCt->rb_max = lRM;
/*
	pCt->rb_num = 0;
	pCt->rb_used = 0;
*/
	if (!(p1 = (tdtRB_CHAIN *)Malloc(sizeof(tdtRB_CHAIN)))) {
		Free(pCt);
		return NULL;
	}
	pCt->rb_cur = pCt->rb_waddr = pCt->rb_raddr = p1;
	p1->rbc_buf = NULL;
	if (!(p2 = (tdtRB_CHAIN *)Malloc(sizeof(tdtRB_CHAIN)))) {
		Free(pCt);
		Free(p1);
		return NULL;
	}
	pCt->rb_wpriv = p2;
	p2->rbc_buf = NULL;
	p1->rbc_next = p2;
	p2->rbc_next = p1;
	pCt->rb_num = 2;
	return pCt;
}

tdtRB_CTL *akxs_rb_init(lBS,lRM)
int lBS,lRM;
{
	return akxs_rb_new(lBS,lRM);
}

char *akxs_rb_get(pCt)
tdtRB_CTL *pCt;
{
	if (!pCt) return NULL;
	return pCt->rb_raddr->rbc_buf;
}

char *akxs_rb_get_n(pCt)
tdtRB_CTL *pCt;
{
	char *p;
	tdtRB_CHAIN *pr;

	if (!pCt) return NULL;
	
	pr = pCt->rb_raddr;
	if (p=pr->rbc_buf) {
		pr->rbc_buf = NULL;
		pCt->rb_raddr = pr->rbc_next;
		pCt->rb_used--;
	}
	pCt->rb_cur = pCt->rb_raddr;
	pCt->rb_pos = 0;
	return p;
}

char *akxs_rb_set_n(pCt, addr)
tdtRB_CTL *pCt;
char *addr;
{
	tdtRB_CHAIN *pw, *pn, *pp;

	if (!pCt || !addr) return NULL;
	
	pw = pCt->rb_waddr;
	if (pw->rbc_buf) {
		if (!(pn = (tdtRB_CHAIN *)Malloc(sizeof(tdtRB_CHAIN)))) return NULL;
		pp = pCt->rb_wpriv;
		pCt->rb_waddr = pp->rbc_next = pn;
		pn->rbc_next = pw;
		pw = pCt->rb_waddr;
		pCt->rb_num++;
	}
	pw->rbc_buf = addr;
	pCt->rb_waddr = pw->rbc_next;
	pCt->rb_wpriv = pw;
	pCt->rb_used++;
	return addr;
}

int akxs_rb_free(pCt)
tdtRB_CTL *pCt;
{
	tdtRB_CHAIN *pw, *pn, *pp;

	if (!pCt) return -1;
	if (pp = pCt->rb_wpriv) {
		pw = pp->rbc_next;
		pp->rbc_next = NULL;
		while (pw) {
			pn = pw->rbc_next;
			Free(pw);
			pw = pn;
		}
	}
	Free(pCt);
	return 0;
}

int akxs_rb_buf_free(pCt)
tdtRB_CTL *pCt;
{
	char *p;

	if (!pCt) return -1;

	while (p=akxs_rb_get_n(pCt)) Free(p);

	return 0;
}

int akxs_rb_all_free(pCt)
tdtRB_CTL *pCt;
{
	int  iRc;

	if (!(iRc = akxs_rb_buf_free(pCt))) iRc = akxs_rb_free(pCt);

	return iRc;
}

char *akxs_rb_set_t(pCt, addr)
tdtRB_CTL *pCt;
char *addr;
{
	tdtRB_CHAIN *pw, *pn, *pp;

	if (!pCt || !addr) return NULL;
	if (!akxs_rb_get(pCt)) return akxs_rb_set_n(pCt,addr);
	
	pw = pCt->rb_waddr;
	while ((pp=pw->rbc_next) != pCt->rb_raddr) {
		pw = pp;
	}

	if (pw->rbc_buf) {
		if (!(pn = (tdtRB_CHAIN *)Malloc(sizeof(tdtRB_CHAIN)))) return NULL;
		pw->rbc_next = pn;
		pn->rbc_next = pp;
		pw = pn;
		pCt->rb_num++;
	}
	pw->rbc_buf = addr;
	if (pCt->rb_raddr == pCt->rb_waddr) {
		pCt->rb_waddr = pw;
	}
	pCt->rb_raddr = pw;
	pCt->rb_used++;
	pCt->rb_cur = pCt->rb_raddr;
	pCt->rb_pos = 0;
	return addr;
}

char *akxs_rb_srch(pCt, addr, compar)
tdtRB_CTL *pCt;
char *addr;
int (*compar)();
{
	int f;
	tdtRB_CHAIN *pr;
	char *p;

	if (!pCt || !addr) return NULL;
	if (!compar) compar = strcmp;
	pr = pCt->rb_raddr;
	while (p=pr->rbc_buf) {
		if (!compar(addr,p)) return p;
		pr = pr->rbc_next;
		if (pr == pCt->rb_waddr) break;
	}
	return NULL;
}

char *akxs_rb_read(pCt, cmd)
tdtRB_CTL *pCt;
int     cmd;
{
	tdtRB_CHAIN *pr;
	char *p=NULL;

	if (pCt) {
		if (!cmd) {
			pr = pCt->rb_raddr;
			pCt->rb_pos = 0;
		}
		else {
			if (pCt->rb_pos >= pCt->rb_used) return NULL;
			if (pCt->rb_pos) {
				pr = pCt->rb_cur;
				pCt->rb_cur = pr->rbc_next;
			}
			else pCt->rb_cur = pCt->rb_raddr;
			pr = pCt->rb_cur;
			pCt->rb_pos++;
		}
		p = pr->rbc_buf;
	}
	return p;
}

int akxs_rb_exchg(pCt1, pCt2, opt)
tdtRB_CTL *pCt1,*pCt2;
int opt;
{
	tdtRB_CTL tCtW;

	if (!pCt1 || !pCt2) return -1;
	tCtW  = *pCt1;
	*pCt1 = *pCt2;
	*pCt2 = tCtW;
	return 0;
}

int akxs_rb_used(pCt)
tdtRB_CTL *pCt;
{
	if (!pCt) return -1;
	return pCt->rb_used;
}
