static	char	sccsid[]="%Z% %M% %I% %E% %U%";

#define	DOMAIN	AF_INET

/****************************************************************************/
/*																			*/
/*	֐@Fint main()													*/
/*																			*/
/*	@F[-k] [-d] [-p] [AKB Name]										*/
/*																			*/
/*	TvFvZXǗvZX̋N									*/
/*																			*/
/****************************************************************************/
/* Oϐ̐錾 */
#define VALUE_DEFINICATION

#include "prom.h"

#define PRINTF(x)
#define PR_FD_RESV	5

extern int _exec_check_timer();
extern int ak_pr_proc_start();
extern int ak_pr_hp_to_entry();
extern int ak_pr_query();
extern int ak_pr_kill_class();
extern int ak_pr_shut_class();
extern int ak_pr_host_cmd_class();
extern int ak_pr_packet_write();
extern int ak_pr_packet_read();
extern int ak_pr_close_sd_func();
extern int akb_cha_rb_timer();

/* ֐錾 */
static int (*ppCommandFunc[256])();
static int ak_pr_daemon_exec_timer();
static int ak_pr_make_socket_timer();
static void ak_pr_sig_term();

/****************************/
/*	SigChldInfo Struct		*/
/****************************/
static struct {
	int sig_no;
	int pid;
	int status;
} gtSigChld={0,0,0};

#define D_SIZE_SIGCHLDPID	10
static int giSigChldPid[D_SIZE_SIGCHLDPID];

static int iWaitTime;
void sig_chld(n)
int n;
{
	int int_flg;
	int pid, status, i;
	pPROCESS_TABLE pPrT;

	int_flg = SIGCHLD;
	pid = wait(&status);
	signal(SIGCHLD,sig_chld);

	if (status) {
		for (i=0;i<D_SIZE_SIGCHLDPID;i++) {
			if (!giSigChldPid[i]) {
				giSigChldPid[i] = pid;
				break;
			}
		}
	}
}

void _check_sigchldpid()
{
	int isig,i,pid;
	pPROCESS_TABLE pPrT;
	pAUTO_EXEC_TABLE pAET;

	for (isig=0;isig<D_SIZE_SIGCHLDPID;isig++) {
		if (pid=giSigChldPid[isig]) {
			pPrT = &gp_process_tbl[1];
			for (i=1;i<gi_auto_exec_size;i++,pPrT++) {
				if (pPrT->sys_pid == pid) {
					pAET = &gp_auto_exec_tbl[i];
					pAET->status = D_NREGIST;
					if (pPrT->stat & D_ONDEMAND)
						ak_pr_del_on_demand_wait(pAET->pr_id,0);
					aka_del_reply_wait(pAET->pr_id,AKB_CMD_START);
					if ((pAET->opt1 & D_OPT_ONDEMAND) &&
					    (pPrT->regist < D_REGISTED /* D_CONNECTED */)) {
						pAET->opt1 |= D_OPT_NOT_ONDEMAND;
ERROROUT1("*** _check_sigchldpid: set D_OPT_NOT_ONDEMAND to pid=%d",
pAET->pr_id);
					}
					break;
				}
			}
			giSigChldPid[isig] = 0;
		}
	}
}

int _is_sigchldpid()
{
	int i,pid;

	for (i=0;i<D_SIZE_SIGCHLDPID;i++) {
		if (pid=giSigChldPid[i]) return pid;
	}
	return 0;
}

int ak_pr_get_sig_chld_info(i)
int i;
{
	int x;

	if      (i == 1) x = gtSigChld.sig_no;
	else if (i == 2) x = gtSigChld.pid;
	else if (i == 3) x = gtSigChld.status;
	else x = 0;

	return x;
}

int ak_pr_set_sig_chld_info(n,p,s)
int n,p,s;
{
DEBUGOUTL3(AKBP_LOG_GROUP|255,
"ak_pr_set_sig_chld_info: sig_no=%d pid=%d status=%08x",n,p,s);
	gtSigChld.sig_no = n;
	gtSigChld.pid    = p;
	gtSigChld.status = s;
	return 0;
}

/*****************************************************************************/
/*  ֐                                                                   */
/*        int    ak_pr_process_init()                                        */
/*                                                                           */
/*                                                                     */
/*        0                  : I@                                    */
/*        D_ERR_MEM_ALLOC    : [AP[VEG[                */
/*        D_ERR_MAKE_SOCKET  : \Pbg쐬G[                            */
/*        D_ERR_MAKE_DAEMON  : f[쐬G[                            */
/*                                                                           */
/*                                                                           */
/*  Tv                                                                 */
/*        vZXǗf[̏                                       */
/*****************************************************************************/
static int _set_exec_option()
{
	int irc,i,v;
	char buf[D_RECORD_BUFSIZE],*argv[9],*p,c;
	/* Execute Options */
	static char *exopt_name[]={"NOTIFY  ","SOCKET  ","ONDEMAND","AUTOEXEC"
	                          ,"DO_ONDEM","NEED_REP","CHANL_RB","UNUSED  "};
	static char *exoption[]={"Default","Select","All","None"};

	/* NOTIFY select */
	irc = akb_gs_akbname(D_SECTION_AKB_SYSTEM,D_KEYNAME_NOTIFY,buf);
	if (irc > 0) {
		if (!stricmp(buf,"select")) {
			gt_proc_man_ctl.opt |= D_OPT_NOTIFY;
		/*	PRINTOUT("Notify mode:select");	*/
		}
	}
	/* EXEC_OPTION notify socket ondemand auto_ex channel_rb */
	memset(gt_proc_man_ctl.ex_opt,D_EXOPT_SELECT,sizeof(gt_proc_man_ctl.ex_opt));
	if (!(gt_proc_man_ctl.opt & D_OPT_NOTIFY))
		gt_proc_man_ctl.ex_opt[D_EXOPT_NOTIFY] = D_EXOPT_ALL;
	irc = akb_gs_akb_stpl(D_SECTION_AKB_SYSTEM,D_KEYNAME_EXEC_OPTION,argv,9);
	for (i=0;i<irc-1;i++) {
		p = argv[i+1];
		switch (c=toupper(*p)) {
			case '.':
			case '-':
			case '\0':
					continue;
			case 'D':	/* Default 0 */
					v = D_EXOPT_DEFAULT;
					break;
			case 'S':	/* Select 1 */
					v = D_EXOPT_SELECT;
					break;
			case 'A':	/* All 2 */
					v = D_EXOPT_ALL;
					break;
			case 'N':	/* None 3 */
					v = D_EXOPT_NONE;
					break;
			default:
					if (c>='0' && c<='9') {
						v = atoi(p);
					}
					else {
						ERROROUT2("EXEC_OPTION invalid value i=%d val=[%s]",i,p);
						return -1;
					}
		}
		if (v >= 0) {
			if (i == D_EXOPT_NOTIFY) {
				if (v == D_EXOPT_DEFAULT) v = D_EXOPT_ALL;
			}
			else {
				if (v == D_EXOPT_DEFAULT) v = D_EXOPT_SELECT;
			}
			gt_proc_man_ctl.ex_opt[i] = v;
		}
	}
	for (i=0;i<8;i++) {
		v = gt_proc_man_ctl.ex_opt[i];
		PRINTOUT2("EXOPT_%s = %s",exopt_name[i],exoption[v]);
	}
	return 0;
}

int   ak_pr_process_init(cAkbIni,szPrName)
char *cAkbIni,*szPrName;
{
	int irc = 0;
	int i, pid[2], iParm[4], v;
	char buf[D_RECORD_BUFSIZE],*argv[6],*p,c;
	tdtMSG_COM tRecvMsg;

	/* 荞݃nh[̓o^ */ 
	signal(SIGALRM, akb_sock_time_out);
	siginterrupt(SIGALRM, 1);
	signal(SIGPIPE, akb_broken_pipe);
	siginterrupt(SIGPIPE, 1);

	/* ُInh */
	signal(SIGTERM, ak_pr_sig_term);
/*	signal(SIGSEGV, ak_pr_sig_term);	*/
	/* ^CInh */
	signal(SIGINT, ak_pr_sig_term);

	signal(SIGCHLD,sig_chld);
	memset(giSigChldPid,0,10*sizeof(int));

	/* AKB_SYSTEMZNV̓ǂݍ  add 2000.8.23 Koba */
	/* NOTIFY select */
	/* EXEC_OPTION notify socket ondemand auto_ex */
	if (irc=_set_exec_option()) return irc;

	/* TIMER start1 start2 shut reply_wait make_socket (msec) */
	irc = akb_gs_akb_stpl(D_SECTION_AKB_SYSTEM,D_KEYNAME_TIMER,argv,6);
	for (i=0;i<irc-1;i++) {
		if ((v=atoi(argv[i+1])) > 0) {
			gi_timer[i] = v;
			PRINTOUT2("Timer[%d]=%d",i,v);
		}
	}

	akb_get_term_base(pid);
	gi_prid_term_base = pid[0];
	gi_prid_term_max  = pid[1];
	PRINTOUT2("GetTermBase:base=%d max=%d",gi_prid_term_base,gi_prid_term_max);
	gi_prid_auto = gi_prid_term_base;

	/* őec̃`FbN */
	gi_max_daemon = D_MAX_DAEMON;
	irc = akb_set_fd_setsize(gi_max_daemon + PR_FD_RESV);
	if (irc < 0) ERROROUT1("akb_set_fd_setsize:error = %d",irc);
	else gi_max_daemon = irc - PR_FD_RESV;
	gi_resv_daemon = gi_max_daemon - X_MIN(10,gi_max_daemon*5/100);
	PRINTOUT2("gi_max_daemon=%d gi_resv_daemon=%d",
	          gi_max_daemon,gi_resv_daemon);

	/* ^CAEgԐݒ */
	akb_set_sys_com_time_out(gt_proc_man_ctl.proc_name,1);
DEBUGOUTL1(AKBP_LOG_GROUP|250,
"Time Out = %dSecond/4KByte",akb_get_time_out());

	/* e[u쐬 */
	irc = ak_pr_ctrl_table_make(cAkbIni,szPrName);
	if ( irc ) return irc ;
	gi_auto_exec_size = gi_daemon_size;	/* add 2000.8.16 Koba */
	memset(gi_pr_uchain,0,sizeof(gi_pr_uchain));

	/* vL[Ǘe[u */
	gi_max_que_write = gi_max_daemon;
	akb_init_que(gi_max_que_write,gt_que_write);
	akb_set_rwque_pa(gp_que_write_pa,gi_max_que_write,gt_que_write);
 
	/* qL[Ǘe[u */
	gi_max_que_read = gi_max_daemon;
	akb_init_que(gi_max_que_read,gt_que_read);
	akb_set_rwque_pa(gp_que_read_pa,gi_max_que_read,gt_que_read);
 
	/* `lRing Buff */
	memset(gp_rb_wctl_pa,0,sizeof(tdtRB_CTL *)*gi_max_que_write);
	memset(gp_rb_pri_ctl_pa,0,sizeof(tdtRB_CTL *)*gi_max_que_write);

	/* New Ring Buff */
	gp_rb_rctl  = akxs_rb_init(0,0);
	gp_rb_wctl  = akxs_rb_init(0,0);
	gp_rb_wwctl = akxs_rb_init(0,0);  /* Write Wait */
	gp_rb_sd_ctl = akxs_rb_init(0,0);  /* Used SocketId */

	/* ̃vZX̐ڑvp\Pbg쐬 */
/* 2000.8.1 ^C}[ō쐬 */
/* ŁAQdN`FbN邽߂ɁA^C}[͎gȂ */
#ifndef ACCEPT_MAKESOCKET_TIMER
	irc = akba_make_socket(gt_proc_man_ctl.proc_name,"Akb_Port",0);
	akb_get_make_sock_parm(4,iParm);
	if (irc <= 0) {
		ERROROUT2("ڑvpSocket쐬G[BPort=%d ret=%d",iParm[1],irc);
		return -1;
	}
	PRINTOUT4("*** ڑpSocket쐬njBPort=%d Type=%d Linger=%d Socket=%d",
	iParm[1],iParm[2],iParm[3],irc);
	gp_process_tbl[0].sd = irc;
#ifdef LINGER
	gi_linger_time = iParm[3];
#endif
	PRINTOUT3("   [%2d] <-> %s [%2d]",gp_process_tbl[0].sd,
			gp_auto_exec_tbl[0].mdname, gp_auto_exec_tbl[0].sd);
#endif
	/* zXghc擾 */
	if (irc=akb_get_host_addr(NULL,&gi_my_host_id)) return irc;
	v = htonl(gi_my_host_id);
	akb_get_text_addr4(v,buf,sizeof(buf));
	PRINTOUT2("akPrInit:gi_my_host_id=%08x(%s)",gi_my_host_id,buf);

	gt_proc_man_ctl.mode = 1;
	gt_proc_man_ctl.stat = 0;

	/* bZ[W\ */
	memset(ppCommandFunc,0,sizeof(ppCommandFunc));
	ppCommandFunc[AKB_CMD_START] = ak_pr_proc_start;
	ppCommandFunc[AKB_CMD_QUERY] = ak_pr_query;
	ppCommandFunc[AKB_CMD_FSHUT] = ppCommandFunc[AKB_CMD_SHUT] = ak_pr_shut_class;
	ppCommandFunc[AKB_CMD_KILL] = ak_pr_kill_class;
/*	ppCommandFunc[AKB_CMD_BROADCAST] = ak_pr_broad_castClass;	*/
	ppCommandFunc[AKB_CMD_HOSTCMD] = ak_pr_host_cmd_class;
	aka_initialize(0,D_PRID_PROM,0,
	              gp_rb_rctl,gp_rb_wctl,gp_rb_wwctl,gp_rb_wctl_pa,gp_rb_pri_ctl_pa,
	              gp_que_read_pa,gp_que_write_pa,gi_max_que_read,&gt_data_que_used,
	              ppCommandFunc,ak_pr_hp_to_entry,gi_resv_daemon);

	/* RWQue^CAEg̐ݒ */
	gt_data_que_used.gd_dlen = sizeof(int);
	gt_data_que_used.gd_scale = 1;
	gt_data_que_used.gd_resv = 0;
	gt_data_que_used.gd_data = (char *)&gi_daemon_size;
	aka_sys_rwque_time_out_new(NULL,NULL/*ak_pr_close_sd_func*/,&gt_data_que_used);

	/* pX[hNX̐ݒ */
	memset(&tRecvMsg,0,sizeof(tdtMSG_COM));
	tRecvMsg.msg_disp = AKA_REGIST_CLASS + 1;
	tRecvMsg.msg_pmsg = buf;
	buf[0] = gt_proc_man_ctl.opt & D_OPT_PASSWORD;
	strcpy(buf+1,gt_proc_man_ctl.pname);
	aka_sys_password_class(AKA_CLASS_PASSWORD,NULL,&tRecvMsg);

#ifdef ACCEPT_MAKESOCKET_TIMER
	/* ̃vZX̐ڑvpSocket쐬̃^C}[o^ */
	irc = aka_register_timer("MakeSocket",ak_pr_make_socket_timer,-gi_timer[4],NULL);
	if (irc < 0) return irc;
#endif

	/* vZXN^C}[o^ */ /* add 2000.8.8 Koba */
	gt_proc_man_ctl.mode = AKB_CMD_START;
	ak_pr_daemon_exec(0);
	gi_pr_t[0] = 0;
	irc = aka_register_timer("DaemonExec",ak_pr_daemon_exec_timer,-gi_timer[0],gi_pr_t);
	if (irc < 0) {
		irc = ak_pr_daemon_exec(-1);
		gt_proc_man_ctl.mode = 0;
		if (irc) return D_ERR_MAKE_DAEMON ;
	}
	gi_pr_t[0] = irc;
	PRINTOUT("*** Begin of Start Program.");
	aka_register_timer("EXEC_TIMER",_exec_check_timer,
	                 D_EXCHK_TIMER_INTERVAL,&gi_exec_timer_counter);

	/* `lEobt@؂ւ^C}[o^ */
	if (EXOPT_IS_SET(gt_proc_man_ctl.ex_opt[D_EXOPT_CHANNELRB])) {
		irc = aka_register_timer("ChaRbTimer",akb_cha_rb_timer,
		                       AKB_CHA_RB_WAIT_TIME,NULL);
		if (irc > 0) {
			aka_cha_rb_regist_timer(irc);
			aka_stop_timer(1,&irc);
		}
	}

	/* `orhc擾 */
	gus_my_apsys_id = aka_get_my_apsys_id();
	if (!(gi_my_apsys_hid=gus_my_apsys_id)) gi_my_apsys_hid = gi_my_host_id;
	PRINTOUT2("akPrInit:gi_my_apsys_hid=%08x(%d)",gi_my_apsys_hid,gi_my_apsys_hid);

	/* OnDemand Start Configration */
	gi_ignore_ondemand_time = IGNORE_ONDEMAND_TIME;

	/* וUe[u쐬 */
	gi_bunsan_size = 0;
	irc = ak_pr_bunsan_table_make(cAkbIni);
	if (irc) return irc ;

#ifdef MSG_TIME_OUT
	ak_pr_register_class();
#endif

	return 0 ;
}

/****************************************************************************/
/*  ֐                                                                  */
/*        int    ak_pr_ctrl_table_make()                                    */
/*                                                                          */
/*                                                                    */
/*                                                                          */
/*                                                                          */
/*  ߂l                                                                  */
/*        0                  :                                          */
/*        -1                 : ُI                                     */
/*                                                                          */
/*  Tv                                                                */
/*        pPbgǗe[uCvZXǗe[u쐬                  */
/****************************************************************************/
#define AKPR_NAMEOPT_NUM	8
	static char opt_c[AKPR_NAMEOPT_NUM]={'?','*','!','@','+','<','%','$'};
	static int  opt_b[AKPR_NAMEOPT_NUM]=
			{D_OPT_NOTIFY,D_OPT_NO_SOCKET,D_OPT_ONDEMAND,D_OPT_NO_AUTOEX
			,D_OPT_DO_ONDEMAND,D_OPT_NEED_REPLY,D_OPT_CHANNEL_RB,0};
	static char opt_n[AKPR_NAMEOPT_NUM]={2,1,0,1,0,0,0,0};
			/* 0x01:not opt, 0x02:not disp */

static int _set_opt(ph,iOpt,mdname,proc_no)
char *ph;
int  *iOpt;
char *mdname;
ushort proc_no;
{
	char wrk[AKPR_NAMEOPT_NUM+1],*p,c,optnot,optdsp;
	int len,i,j,wl;
	int opt,opt_bb;

	memset(wrk,0,sizeof(wrk));
	wl = 0;
	len = strlen(ph) - 1;
	opt_bb = 0;
	for (i=AKPR_NAMEOPT_NUM;i>0 && len>=0;i--) {
		c = ph[len];
		for (j=0;j<AKPR_NAMEOPT_NUM;j++) {
			if (c == opt_c[j]) break;
		}
		if (j >= AKPR_NAMEOPT_NUM) break;
		ph[len--] = '\0';
		if (j == 4 && opt_bb != D_OPT_ONDEMAND) continue;
		opt_bb = opt_b[j];
		if (iOpt) *iOpt |= opt_bb;
		wrk[j] = c;
	}
	if (iOpt && mdname) {
		for (i=0;i<AKPR_NAMEOPT_NUM;i++) {
			if (i == 4) continue;
			else if (i < 8) opt = gt_proc_man_ctl.ex_opt[i];
			else opt = D_EXOPT_SELECT;
			optnot = opt_n[i] & 0x01;
			optdsp = !(opt_n[i] & 0x02);
			if ((opt==D_EXOPT_ALL && !optnot) ||
			    (opt==D_EXOPT_NONE && optnot)) {
				if ((i != 3) || (proc_no != AKB_PRID_TERM)) {
					*iOpt |= opt_b[i];
					if (optdsp) {
						wrk[i] = opt_c[i];
					}
				}
			}
			else if ((opt==D_EXOPT_NONE && !optnot) ||
			         (opt==D_EXOPT_ALL  &&  optnot)) {
				*iOpt &= ~opt_b[i];
				wrk[i]  = '\0';
			}
		}
	}
	return ++len;
}

char *ak_pr_add_opt_name(iOpt,name)
int iOpt;
char *name;
{
	static char mdname[65];
	int i,opt;
	char wrk[AKPR_NAMEOPT_NUM+1],*p,c,optnotdsp;

	if (name) {
		strnzcpy(mdname,name,sizeof(mdname)-(AKPR_NAMEOPT_NUM+1));
		if (iOpt) {
			memset(wrk,0,sizeof(wrk));
			p = mdname + strlen(mdname);
			for (i=0;i<AKPR_NAMEOPT_NUM;i++) {
				if (i == 4) continue;
				else if (i < 8) opt = gt_proc_man_ctl.ex_opt[i];
				else opt = D_EXOPT_SELECT;
				optnotdsp = opt_n[i] & 0x02;
				if (((opt==D_EXOPT_SELECT && optnotdsp) ||
				     !optnotdsp) && (iOpt & opt_b[i])) {
					wrk[i] = c = opt_c[i];
					if (c=='!' && (iOpt & opt_b[4])) *p++ = opt_c[4];
					*p++ = c;
				}
			}
			*p = '\0';
		}
	}
	else return NULL;

	return mdname;
}

int   ak_pr_ctrl_table_make(cAkbIni,szPrName)
char *cAkbIni,*szPrName;
{
	char   szTmp[D_RECORD_BUFSIZE], *p, *ph, *hkey[2];
	int    iStatus     = 0;
	FILE  *fp          = NULL;
	char *argv[AKB_MAX_EXEC_PARM+4],parm[D_RECORD_BUFSIZE],c;
	int i, number, len, nitem;
	uchar opt;

	/* pPbgǗe[u */
	gui_rc_size = 0 ;
	gui_sd_size = 0 ;

	/* vZXǗe[u */
	gp_process_tbl = (pPROCESS_TABLE)Malloc(sizeof(tdtPROCESS_TABLE)*gi_resv_daemon);
	if (!gp_process_tbl) return -1 ;
	gp_auto_exec_tbl = (pAUTO_EXEC_TABLE)Malloc(sizeof(tdtAUTO_EXEC_TABLE)*gi_resv_daemon);
	if (!gp_auto_exec_tbl) return -1 ;

	memset(gp_process_tbl,0,sizeof(tdtPROCESS_TABLE)*gi_resv_daemon);
	memset(gp_auto_exec_tbl,0,sizeof(tdtAUTO_EXEC_TABLE)*gi_resv_daemon);
	for (i=0;i<gi_resv_daemon;i++) {
		gp_process_tbl[i].sd = -1;
		gp_process_tbl[i].ver = ' ';
	}
	gp_auto_exec_tbl[0].status  = D_REGIST  ;
	gp_auto_exec_tbl[0].pr_id   = number = D_PRID_PROM;
	if (!(p=Malloc(strlen(gt_proc_man_ctl.proc_name)+1))) return -1;
	strcpy(p,gt_proc_man_ctl.proc_name);
	gp_auto_exec_tbl[0].mdname = p;
	if (!(p=Malloc(strlen(szPrName)+1))) return -1;
	strcpy(p,szPrName);
	gp_auto_exec_tbl[0].module = p;
	gp_process_tbl[0].sd       = -1;
	gp_process_tbl[0].pr_id    = number;
	gp_process_tbl[0].ver      = 'C';
	gp_process_tbl[0].host_id   = gi_my_host_id;

	ak_pr_entry_cache_init(gi_my_host_id,number,0,0);

	/* vZXET[`Ee[u */
	gp_ha_proc = akxs_hasl_new(sizeof(long),gi_resv_daemon,0);
	gp_ha_auto = akxs_hasl_new(sizeof(long),gi_resv_daemon,0);
	if (/*!gi_ix_proc || !gi_ix_auto ||*/ !gp_ha_proc || !gp_ha_auto) return -1;
	hkey[1] = NULL;
	gp_ha_auto->ha_key = (char *)hkey;
	if ((i=akxshasls(gp_ha_auto,number)) > 0) {
/*
printf("ak_pr_ctrl_table_make: akxshasls Auto: proc=%d ix=%d\n",number,i);
*/
	}
	gp_ha_proc->ha_key = (char *)hkey;
	if ((i=akxshasls(gp_ha_proc,number)) > 0) {
/*
printf("ak_pr_ctrl_table_make: akxshasls Proc: proc=%d ix=%d\n",number,i);
*/
	}

	gi_daemon_size = 1;
	opt = gt_proc_man_ctl.ex_opt[D_EXOPT_ONDEMAND];

	/* vt@CI[v */
	if (!(fp=fopen(cAkbIni,"r"))) {
		ERROROUT1("file [%s] open error!!",cAkbIni);
		return -1 ;
	}
	szTmp[0]='\0';
	while (akbreadline(szTmp,D_RECORD_BUFSIZE,fp) && memcmp(szTmp,"[PROCESS]",9))
		;
	if (memcmp(szTmp,"[PROCESS]",9)) {
		ERROROUT("no execute process.");
		fclose(fp);
		return 0;
	}
	while (akbreadline(szTmp,D_RECORD_BUFSIZE,fp) && memcmp(szTmp,"[",1)) {
		if ( szTmp[0] == '#' ) continue;
		nitem = akxtgetargv2(szTmp,argv,AKB_MAX_EXEC_PARM+4,parm,sizeof(parm),3);
		if (nitem <= 0) continue;
		else if (nitem < 4) {
			ERROROUT1("prommain:get proc.name error. [%s]",szTmp);
			continue;
		}
		/*** Process ID ***/
		if ((number = atoi( argv[1] ))<=0) {
			ERROROUT1("prommain:procid <= 0. [%s]",argv[1]);
			continue;
		}
		if (number == D_PRID_PROM) continue;

		if (gi_daemon_size >= gi_resv_daemon) {
			ERROROUT1("vZX(%d)zB",gi_resv_daemon);
			break;
		}

		gp_auto_exec_tbl[gi_daemon_size].pr_id = number;
		hkey[1] = (char *)gi_daemon_size;
		if ((i=akxshasls(gp_ha_auto,number)) > 0) {
/*
printf("ak_pr_ctrl_table_make: akxshasls Auto: proc=%d ix=%d\n",number,i);
*/
		}

		/*** Process Name ***/
		if (!(p=Malloc(strlen(argv[0])+1+AKPR_NAMEOPT_NUM))) return -1;
		strcpy(p, argv[0]);
		gp_auto_exec_tbl[gi_daemon_size].mdname = p;
		if ((c=*argv[1])<'0' || c>'9') {
			ERROROUT1("prommain:procid is no number. [%s]",argv[1]);
			continue;
		}
		if ((c=*argv[2])<'0' || c>'9') {
			ERROROUT1("prommain:shutorder is no number. [%s]",argv[2]);
			continue;
		}
		if ((number = atoi( argv[2] ))<0) {
			ERROROUT1("prommain:shutorder < 0. [%s]",argv[2]);
			continue;
		}
		gp_auto_exec_tbl[gi_daemon_size].shut_order = number ;
		if (*argv[3] == '/') {
			ph = argv[3];
		}
		else {
			if (!(ph=akb_akb_home_add(argv[3]))) return -1;
		}

		len = _set_opt(ph,&gp_auto_exec_tbl[gi_daemon_size].opt1,
		               gp_auto_exec_tbl[gi_daemon_size].mdname,
		               gp_auto_exec_tbl[gi_daemon_size].pr_id);
		if (!(p=Malloc(len+1))) return -1;
		strcpy(p, ph);
		gp_auto_exec_tbl[gi_daemon_size].module = p;
		gp_auto_exec_tbl[gi_daemon_size].iparm = nitem - 4;
		if (nitem > 4) {
			if (!(gp_auto_exec_tbl[gi_daemon_size].pparm =
			      (char **)Malloc(sizeof(char *)*(nitem-4)))) return -1;
			for (len=0,i=4;i<nitem;i++) len += strlen(argv[i])+1;
/*
printf("ak_pr_ctrl_table_make:nitem=%d len=%d\n",nitem,len);
*/
			if (!(p=Malloc(len))) return -1;
			gp_auto_exec_tbl[gi_daemon_size].parm = p;
			for (i=4;i<nitem;i++) {
				gp_auto_exec_tbl[gi_daemon_size].pparm[i-4] = p;
				strcpy(p, argv[i]);
/*
printf("ak_pr_ctrl_table_make:i=%d argv=%08x[%s]\n",i,p,p);
*/
				p += strlen(argv[i])+1;
			}
		}
		if (gp_auto_exec_tbl[gi_daemon_size].opt1 & D_OPT_ONDEMAND)
			gp_auto_exec_tbl[gi_daemon_size].rb_odctl = akxs_rb_new(0,0);
		gi_daemon_size++ ;
	}
	fclose(fp);

	/* get process id */
	gi_tbl_host = -1;
	gi_tbl_term = -1;
	gi_tbl_buns = -1;
#ifdef	DEBUG
for(i=0;i<gi_daemon_size;i++) {
	printf("module [%s] ID = %d Shut = %d\n",gp_auto_exec_tbl[i].module,
	gp_auto_exec_tbl[i].pr_id,
	gp_auto_exec_tbl[i].shut_order);
 }
#endif
	return 0 ;
}

/****************************************************************************/
/*  ֐                                                                  */
/*        int   ak_pr_socket_pair_make( )                                   */
/*                                                                          */
/*                                                                    */
/*        int    pSd[]    :  \Pbghci[GA                         */
/*                                                                          */
/*                                                                          */
/*  ߂l                                                                  */
/*        0                                                             */
/*       -1  ُ                                                           */
/*                                                                          */
/*  Tv                                                                */
/*        ̃f[Ƃ̒ʐMp\PbgyA쐬                          */
/****************************************************************************/
#if DOMAIN == AF_INET
int   ak_pr_socket_pair_make(pSd)
int   pSd[] ;                      /* \Pbgԍi[̈              */
{
	char   host_name[HOST_NAME_LEN+1];
	int    irc,fd1,fd2,fd3;
	ushort port_n;
	int    saddrlen;
	INT4   host_addr;
	struct  sockaddr_in	 saddr;
	struct  hostent     *hosts;

	/* \Pbg쐬 */
#ifdef OLD_SD
	fd1 = socket(DOMAIN, SOCK_STREAM, 0);
	if (fd1 < 0) return  -1 ;

	fd2 = socket(DOMAIN, SOCK_STREAM, 0);
	if (fd2 < 0) {
		close(fd1);
		return -1 ;
	}
#else
	for (;;) {
		fd1 = socket(DOMAIN, SOCK_STREAM, 0);
		if (fd1 < 0) goto Err;
PRINTF(printf("ak_pr_socket_pair_make:fd1=%d\n",fd1);)
		if (!ak_pr_check_sd(fd1)) break;
	}
	for (;;) {
		fd2 = socket(DOMAIN, SOCK_STREAM, 0);
		if (fd2 < 0) goto Err;
PRINTF(printf("ak_pr_socket_pair_make:fd2=%d\n",fd2);)
		if (!ak_pr_check_sd(fd2)) break;
	}
#endif

	/* ahmc */
	memset((char *)&saddr,0,sizeof(saddr));
	saddr.sin_family      = DOMAIN;
	saddr.sin_port        = 0;
	saddr.sin_addr.s_addr = INADDR_ANY;
	saddrlen = sizeof(saddr);
	irc = bind(fd1,(struct sockaddr *)&saddr,saddrlen);
	if (irc) {
#ifdef DEBUG
printf("errno=%d\n",errno);
#endif
		goto Err;
	}

	/* khrsdm */
	irc = listen(fd1,1);
	if (irc) {
		goto Err;
	}

	/* zXgԍf */
	gethostname(host_name,HOST_NAME_LEN);
	hosts = gethostbyname(host_name);
	if (hosts == NULL) {
		goto Err;
	}
	host_addr = (INT4)*(INT4 *)hosts->h_addr;

	/* |[gԍf */
	memset(&saddr,0,sizeof(saddr));
	saddrlen = sizeof(saddr);
	irc = getsockname(fd1,(struct sockaddr *)&saddr,&saddrlen);
	if (irc) {
		goto Err;
	}
	port_n = saddr.sin_port;

for (;;) {
		/* \Pbgڑ */
		memset((char *)&saddr,0,sizeof(saddr));
		saddr.sin_family      = DOMAIN;
		saddr.sin_port        = port_n;
		saddr.sin_addr.s_addr = host_addr;
		saddrlen = sizeof( saddr );
		irc = connect(fd2,(struct sockaddr *)&saddr,saddrlen);
		memset((char *)&saddr,0,sizeof(saddr));
		saddrlen = sizeof( saddr );
		fd3 = accept(fd1,(struct sockaddr *)&saddr,&saddrlen);
PRINTF(printf("ak_pr_socket_pair_make:fd3=%d\n",fd3);)
		if (!ak_pr_check_sd(fd3)) break;
		akxs_rb_set_n(gp_rb_sd_ctl,(char *)fd2);
		for (;;) {
			fd2 = socket(DOMAIN, SOCK_STREAM, 0);
			if (fd2 < 0) goto Err;
PRINTF(printf("ak_pr_socket_pair_make:2nd fd2=%d\n",fd2);)
			if (!ak_pr_check_sd(fd2)) break;
		}
	}
	ak_pr_check_sd(-1);
	pSd[0] = fd3;
	close( fd1 );
	pSd[1] = fd2;
#ifdef DEBUG
printf("ak_pr_socket_pair_make:fd1=%d fd2=%d pSd[0]=%d pSd[1]=%d\n",fd1,fd2,pSd[0],pSd[1]);
#endif
	return 0;
 Err:
	if (fd1>2) close(fd1);
	if (fd2>2) close(fd2);
	if (fd3>2) close(fd3);
	ak_pr_check_sd(-1);
	return -1;
}
#else	/* DOMAIN */
int   ak_pr_socket_pair_make(pSd)
int   pSd[] ;                      /* \Pbgԍi[̈              */
{
    char    host_name[HOST_NAME_LEN+1] ;
    int     irc       =  0 ;
    int     fd1       =  0 ,
            fd2       =  0 ,
            fd3       =  0 ,
            port_no   =  0 ;
	int		saddrlen;
    INT4    host_addr =  0 ;
    struct  sockaddr_un	 saddr   ;
    struct  hostent     *hosts ;

    /* \Pbg쐬 */
    fd1 = socketpair(DOMAIN, SOCK_STREAM, 0, pSd);
    if (fd1 < 0) return  -1 ;

	fd1 = pSd[0];
	fd2 = pSd[1];

    /* ahmc */
    memset( (char *)&saddr , 0 , sizeof(saddr) );
    saddr.sun_family = DOMAIN    ;
	strcpy(saddr.sun_path,D_UNIXSTR_PATH);
    saddrlen = strlen(saddr.sun_path) + sizeof(saddr.sun_family);
	irc = bind( fd1 , (struct sockaddr *)&saddr , saddrlen );
	if ( irc ) {
#ifdef DEBUG
printf("errno=%d\n",errno);
#endif
		goto Err;
	}

    /* khrsdm */
	irc = listen( fd1 , 1 );
	if ( irc ) {
		goto Err;
	}

    irc = connect( fd2 , (struct sockaddr *)&saddr , saddrlen );
    if ( irc ) {
        close( fd1 );
        close( fd2 );
        return  -1  ;
	}

    /* `bbdos*/
    saddrlen = sizeof( saddr );
    pSd[0] = accept( fd1 , (struct sockaddr *)&saddr , &saddrlen ) ;
	close( fd1 );
	pSd[1] = fd2;
#ifdef DEBUG
printf("ak_pr_socket_pair_make:fd1=%d fd2=%d pSd[0]=%d pSd[1]=%d\n",fd1,fd2,pSd[0],pSd[1]);
#endif
    return 0 ;
 Err:
	if (fd1>2) close( fd1 );
	if (fd2>2) close( fd2 );
	return -1;
}
#endif	/* DOMAIN */

/**********************************************/
/*                                            */
/**********************************************/
static void close_socket_more(x)
int x;
{
	int i ;

	for( i = x ;i<gi_daemon_size ; i++ ) {
		if(gp_process_tbl[i].sd>2) ak_pr_close(gp_process_tbl[i].sd);
		if(gp_auto_exec_tbl[i].sd>2) ak_pr_close(gp_auto_exec_tbl[i].sd);
	}
}

/**********************************************/
/*                                            */
/**********************************************/
static void ex_close_socket(iProcessNumber)
int iProcessNumber;
{
	int  i,s,max=gi_daemon_size;
	pAUTO_EXEC_TABLE pAET;
	pPROCESS_TABLE  pPrT;

	pAET = &gp_auto_exec_tbl[1];
	pPrT = &gp_process_tbl[1];

	for (i=1;i<max;i++,pAET++,pPrT++) {
		if (i != iProcessNumber) {
			if ((s=pPrT->sd)>2) close(s);
			if ((s=pAET->sd)>2) close(s);
		}
	}
}

/****************************************************************************/
/*  ֐                                                                  */
/*        int   ak_pr_daemon_exec( )                                           */
/*                                                                          */
/*                                                                    */
/*                                                                          */
/*  ߂l                                                                  */
/*        0                                                             */
/*       -1  ُ                                                           */
/*                                                                          */
/*  Tv                                                                */
/*        ̃f[쐬                                                */
/****************************************************************************/
int ak_pr_proc_exec(iProcessNumber)
int iProcessNumber;
{
	pAUTO_EXEC_TABLE pAET;
	pPROCESS_TABLE  pPrT;
	char  szSocketId[8], szPrId[12],*prg;
	int   iPrId, len, i, j;
	char *argv[AKB_MAX_EXEC_PARM+5];
	int   s;

	pAET = &gp_auto_exec_tbl[iProcessNumber];
	pPrT = &gp_process_tbl[iProcessNumber];
	prg = pAET->module;
	iPrId = fork();
	if ( iPrId == 0 ) {
		/* qvZX */
		ex_close_socket(iProcessNumber);
		/* shutdown()sƃvZXǗɃCxgʒm
		   read()G[ƂȂ邽߁Aclose()̂ݎsB
		   ŁAvZXǗُIƂAqvZXIłB
		*/
		if ((s=pPrT->sd)>2) close(s);
		gi_pr_t[1] = pAET->pr_id;
		sprintf(szSocketId,"%d",pAET->sd);
		sprintf(szPrId,"%d",pAET->pr_id);
PRINTOUT1("Start Program [%s]",prg);
		_set_opt(pAET->mdname,NULL,NULL,0);
		argv[0] = prg;
		argv[1] = szSocketId;
		argv[2] = szPrId;
		argv[3] = pAET->mdname;
		for (j=4,i=0;i<pAET->iparm;i++) argv[j++] = pAET->pparm[i];
		argv[j] = NULL;
		execv(prg,argv);
		ERROROUT1("vZXNG[[%s]",prg);
		exit(-1);
	}
	else if (iPrId < 0) {
		/* G[ */
		ERROROUT1("vZX fork G[[%s]",prg);
		if ((s=pAET->sd)>2) ak_pr_close(s);
		if ((s=pPrT->sd)>2) ak_pr_close(s);
		return -1 ;
	}
	else {
		/* evZX */
		pAET->status  = D_REGIST  ;
		pPrT->shut_order = pAET->shut_order;
		pPrT->opt1 = pAET->opt1;
		pPrT->ver = ' ';
		pPrT->sys_pid = iPrId;
		/*
		  ̃\PbgȂƁANvZXŃ\Pbg
		@ĂG[ɂȂȂB
		*/
		if ((s=pAET->sd)>2) close(s);
	}

	return 0;
}

int   ak_pr_daemon_exec(iopt)
int iopt;
{
	pAUTO_EXEC_TABLE pAET;
	int  i, len, iRc, lmo;
	int  iCount,iCountMax;
	static int iStart = 0;
	uchar opt_auto,opt_sock;

	if (iopt < 0) {
		iStart = 1;
		iCountMax = gi_auto_exec_size;
	}
	else if (iopt == 0) {
		iStart = 0;
		return 0;
	}
	else {
		iCountMax = iopt;
		++iStart;
		if (iStart >= gi_auto_exec_size) return -1;
	}
	opt_auto = gt_proc_man_ctl.ex_opt[D_EXOPT_AUTOEXEC];
	opt_sock = gt_proc_man_ctl.ex_opt[D_EXOPT_SOCKET];
	iRc = iCount = 0;
	for(i=iStart;i<gi_auto_exec_size;i++) {
		pAET = &gp_auto_exec_tbl[i];
/*
printf("ak_pr_daemon_exec: i=%d, pAET->szModule=[%s]\n",i,pAET->module);
*/
		if (!(pAET->opt1 & D_OPT_NO_AUTOEX)
		    && pAET->status==D_NREGIST) {
			if ((gp_process_tbl[0].sd <= 0)&&
			    (pAET->opt1 & D_OPT_NO_SOCKET)
			   ) {
				iStart--;
				return 1;
			}
			iRc = ak_pr_proc_starti(i);
/*
PRINTOUT3("   [%2d] <-> %s [%2d]",gp_process_tbl[iProcessNumber].sd,
pAET->mdname, pAET->sd);
*/
			if (iRc) break;
			gi_exec_timer_counter = D_EXCHK_TIMER_MAXCOUNT;/* add 2004.3.4 Koba */
			if (++iCount >= iCountMax) break;
		}
	}
	iStart = i;
	return iRc;
}


static void
ak_pr_sig_term(sig)
int	sig;
{
	int  i= 0 ;
	char	sigStr[D_RECORD_BUFSIZE];

	switch(sig)
	{
		case SIGTERM:
			strcpy(sigStr ,"SIGTERM");
			break;
		case SIGINT:
			strcpy(sigStr ,"SIGINT");
			break;
		case SIGSEGV:
			strcpy(sigStr ,"SIGSEGV");
			break;
		default:
			strcpy(sigStr ,"UNKNOWN");
			break;
	}
	ERROROUTS("Catch %s signal......exit\n",sigStr);

	/* \PbgՒf*/
	for(i=0;i<gi_daemon_size;i++) {
		if (gp_process_tbl[i].sd > 0) ak_pr_close(gp_process_tbl[i].sd);
	}

	/* vZX~ */
	exit(1);
}

int ak_pr_set_shut_next(iPN)
int iPN;
{
	int i,next,iOrder;

	iOrder = gp_process_tbl[iPN].shut_order;
	i = 0;
	next = gp_process_tbl[i].shut_next;
	while (next) {
		if (gp_process_tbl[next].shut_order > iOrder) break;
		i = next;
		next = gp_process_tbl[i].shut_next;
	}
	gp_process_tbl[i].shut_next = iPN;
	gp_process_tbl[iPN].shut_next = next;
	return i;
}

int ak_pr_del_shut_next(iPN)
int iPN;
{
	int i,next;

	i = 0;
	next = gp_process_tbl[i].shut_next;
	while (next) {
		if (next == iPN) break;
		i = next;
		next = gp_process_tbl[i].shut_next;
	}
#ifdef DEBUG
printf("del_shut_next: i=%d next=%d\n",i,next);
#endif
	if (!next) return -1;
	gp_process_tbl[i].shut_next = gp_process_tbl[next].shut_next;
	gp_process_tbl[next].shut_next = 0;
	return i;
}

int ak_pr_check_sd(iSd)
int iSd;
{
	int i,max=gi_auto_exec_size;
	pAUTO_EXEC_TABLE pAET;

	if (iSd >= 0) {
		pAET = &gp_auto_exec_tbl[0];
		for(i=0;i<max;i++,pAET++) {
			if (pAET->sd == iSd) {
PRINTF(printf("ak_pr_check_sd:found i=%d iSd=%d\n",i,iSd);)
				akxs_rb_set_n(gp_rb_sd_ctl,iSd);
				return 1;
			}
		}
	}
	else {
		while (i=(int)akxs_rb_get_n(gp_rb_sd_ctl)) {
PRINTF(printf("ak_pr_check_sd:close iSd=%d\n",i);)
			close(i);
		}
	}
	return 0;
}

int ak_pr_proc_start_set(usPrId)
ushort usPrId;
{
	pCOMM_PACK_HEAD   pHead;
	pSD_PACKET_TABLE    pNew;
	short sCmd;
	char *p;
	unsigned short usPrId_n;

	if (!(pNew=(pSD_PACKET_TABLE)Malloc(sizeof(tdtRCSD_PACKET_TABLE))))
		return D_ERR_MEM_ALLOC;
	if (!(pNew->sp_content=Malloc(sizeof(tdtCOMM_PACK_HEAD)+4)))
		return D_ERR_MEM_ALLOC;

	pHead = (pCOMM_PACK_HEAD)pNew->sp_content;
	pHead->cph_prt.prt_ver       = 'C';
	pHead->cph_prt.prt_send = 0;
	pHead->cph_prt.prt_cmnd   = htons(AKB_CMD_SEND);

	pHead->cph_dinf.ind_hoid    = htonl(gi_my_host_id);
	pHead->cph_dinf.ind_clid  = 0;
	pHead->cph_dinf.ind_prid = htons(D_PRID_PROM);
	pHead->cph_dinf.ind_thrd   = 0 ;
	pHead->cph_dinf.ind_disp   = 0 ;
	pHead->cph_dinf.ind_pano  = 0 ;

	pHead->cph_sinf.ind_hoid     = htonl(gi_my_host_id);
	pHead->cph_sinf.ind_clid   = 0 ;
	pHead->cph_sinf.ind_prid = htons(D_PRID_PROM);
	pHead->cph_sinf.ind_thrd    = 0 ;
	pHead->cph_sinf.ind_disp    = 0 ;
	pHead->cph_sinf.ind_pano   = htons(usPrId);

	pHead->cph_plen = htonl(4);

	p = (char *)pHead + sizeof(tdtCOMM_PACK_HEAD);
	sCmd = htons(AKB_CMD_START);
	usPrId_n = htons(usPrId);
	memcpy(p,(char *)&sCmd,2);
	memcpy(p+2,(char *)&usPrId_n,2);

	pNew->sp_len = sizeof(tdtCOMM_PACK_HEAD) + 4;
	pNew->sp_ch  = 0;
	pNew->sp_offset = 0;
	akxs_rb_set_n(gp_rb_rctl,pNew);

	return 0;
}

static int _socket_func(domain, type, protocol)
int domain, type, protocol;
{
	int iSd;

	for (;;) {
		iSd = socket(domain, type, protocol);
		if (iSd < 0) break;
/*
printf("_socket_func:iSd=%d\n",iSd);
*/
		if (!ak_pr_check_sd(iSd)) break;
	}
	ak_pr_check_sd(-1);
	return iSd;
}

static int ak_pr_make_socket_timer(iTimerId, cpTimerName, cpParm, tptime)
int iTimerId;
char *cpTimerName;
char *cpParm;
struct timeval *tptime;
{
	int irc;

	irc = akba_make_socket_func(gt_proc_man_ctl.proc_name,"Akb_Port",0,_socket_func);
	if (irc > 0) {
		PRINTOUT("*** ڑpSocket쐬nj");
		gp_process_tbl[0].sd = irc;
		PRINTOUT3("   [%2d] <-> %s [%2d]",gp_process_tbl[0].sd,
				gp_auto_exec_tbl[0].mdname, gp_auto_exec_tbl[0].sd);
		return -1;
	}
	return 0;
}

int _exec_check_timer(
int iTimerId,
char *cpTimerName,
char *cpParm,
struct timeval *tptime)
{
	int pid,i,*pCount;
	pAUTO_EXEC_TABLE pAET;
	pPROCESS_TABLE  pProcTbl;

DEBUGOUTL3(AKBP_LOG_GROUP|250,
"_exec_check_timer: called TimerId=%d Name=[%s] Parm=%08x",
iTimerId,cpTimerName, cpParm);
	_check_sigchldpid();
	if (_is_sigchldpid()) return 0;
	pCount = (int *)cpParm;
DEBUGOUTL1(AKBP_LOG_GROUP|250,"_exec_check_timer: Count=%d",*pCount);
	if (--(*pCount) > 0) return 0;
	return -1;
}

static int ak_pr_daemon_exec_timer(iTimerId, cpTimerName, cpParm, tptime)
int iTimerId;
char *cpTimerName;
char *cpParm;
struct timeval *tptime;
{
	int irc,*pi;

	pi = (int *)cpParm;
	irc = ak_pr_daemon_exec(1);
	if (irc > 0) irc = 10000;
	else if (irc < 0) {
		gt_proc_man_ctl.mode = 0;
		PRINTOUT("*** End of Start Program.");
		pi[0] = 0;
	}
	if (irc >= 0) {
		if (pi[1] == AKB_PRID_BUNS) aka_stop_timer(1,&iTimerId);
	}
	return irc;
}

/********************************************************/
/*  main                                                */
/********************************************************/
int  main(int  argc, char *argv[])
{
	FILE *fp;
	int irc,iExit,len,iChk;
	char buf[D_RECORD_BUFSIZE],*cAkbInf,*cpExecName,*p,c;

#ifdef MEMCTL
	Meminit("akPrMemory.ctl");
#endif
	memcpy(gt_proc_man_ctl.id,"PM",2);
	gt_proc_man_ctl.len = sizeof(tdtPROC_MNG_CTL);
	gt_proc_man_ctl.proc_name = akb_prom_name(0);
	gt_proc_man_ctl.pname[0] = '\0';
	gt_proc_man_ctl.opt = 0;
	cpExecName = argv[0];
	iChk = 0;
	while (argc-- > 1) {
		argv++;
		p = argv[0];
		if ((c=*p) == '-') {
			c = *(++p);
			if (c == 'd') gt_proc_man_ctl.opt |= D_OPT_DAEMON;
			else if (c == 'p') gt_proc_man_ctl.opt |= D_OPT_PASSWORD;
			else if (c == 'k') iChk = 1;
			else {
				fprintf(stderr,"Usage: %s [-k] [-d] [-p] [AKB Name]\n",
					akxt_get_last_name("\\/",cpExecName));
				exit(0);
			}
		}
		else {
			strnzcpy(gt_proc_man_ctl.pname,p,sizeof(gt_proc_man_ctl.pname)-1);
		}
	}
	if (!gt_proc_man_ctl.pname[0]) gt_proc_man_ctl.opt &= ~D_OPT_PASSWORD;

	akb_trace_flg(0,0);
	akb_trace_set_file_name(D_PRLOGFILE);
	akb_log_setup_name(gt_proc_man_ctl.proc_name);
/*	akb_log_setup_clear(D_LOG_NO_TRACE,0);	*/

	if (iChk) {
		/* Nς݂`FbN */
		if ((irc=akb_connect_prom(0,0)) > 0) {
			ERROROUT2("%s is exist, port no is %d.",
			          gt_proc_man_ctl.proc_name,akb_get_connect_port());
			ak_pr_close(irc);
			exit(1);
		}
	}

	cAkbInf = Strdup(akb_akb_home_add(akb_akb_inf(0)));
	/* ^Cg̎擾 */
	if (fp=fopen(cAkbInf,"r")) {
		buf[0]='\0';
		while (akbreadline(buf,D_RECORD_BUFSIZE,fp) && memcmp(buf,"[TITLE]",7)) ;
		if (!memcmp(buf,"[TITLE]",7)) {
			while ((len=akbreadline(buf,D_RECORD_BUFSIZE,fp)) &&
			        memcmp(buf,"[",1)) {
				if (len != 0 && buf[len-1] == '\n') buf[len-1] = '\0';
				PRINTOUT(buf);
			}
		}
		fclose(fp);
	}
	/* vZX̏ */
	irc = ak_pr_process_init(cAkbInf,cpExecName);
	if ( irc ) {
		ERROROUT1("*** vZX̏G[ ret=%d, Exit.",irc);
		exit(-1);
	}
	akb_log_setup_clear(D_LOG_NO_TRACE,0);
	PRINTOUT("***** Start *****");

	if (gt_proc_man_ctl.opt & D_OPT_DAEMON) {
		akb_detach(0);
	}
	
	gp_process_tbl[0].sys_pid = getpid();

	/* C */
	iExit = 0;
	for (;;) {
		iWaitTime = -1;
		irc = aka_get_msg(iWaitTime,ak_pr_packet_read,ak_pr_packet_write);
		if (irc > 0) {
			/* pPbg̉ */
			iExit = ak_pr_packet_analize();
		}
		else if (irc < 0) iExit = irc;
DEBUGOUTL3(AKBP_LOG_GROUP|255,
"main: gi_term_bit=%08x irc=%d iExit=%d",gi_term_bit,irc,iExit);
		if (gi_term_bit == D_TERM_ALL) iExit = 1;
		if (iExit) break;
	}
printf("akProMan: exit main loop\n");
	aka_put_msg(-1,ak_pr_packet_write);
printf("akProMan: end PutMsg\n");
#ifdef MEMCTL
	printf("akProMan: nofree no=%d\n",Nofree(0));
#endif
	/* I */
	irc = ak_pr_term();

printf("akProMan: exit(0)\n");
	exit( 0 );
}
