static char sccsid[]="%Z% %M% %I% %E% %U%";
/************************************************/
/*												*/
/*	akxsRb.c									*/
/*												*/
/*		coded by A.Kobayashi 2010.5.20			*/
/*												*/
/************************************************/
#include "akxcommon.h"

tdtRB_CTL *akxs_rb_new2(lBS,lRM,m_alloc,pConstCt)
int lBS,lRM;
char *(*m_alloc)();
tdtCONSTCT *pConstCt;
{
	tdtRB_CTL *pCt;
	tdtRB_CHAIN *p1,*p2;
	int ret;

	pCt = (tdtRB_CTL *)akxm_malloc_constct(m_alloc,pConstCt,sizeof(tdtRB_CTL));
	if (!pCt) return NULL;
	memset(pCt,0,sizeof(tdtRB_CTL));
	pCt->rb_bfsz = lBS;
	pCt->rb_max = lRM;
	ret = akxm_malloc_constct_pp(m_alloc,pConstCt,sizeof(tdtRB_CHAIN),(char *)&p1);
	if (!p1) {
		if (!ret) Free(pCt);
		return NULL;
	}
	pCt->rb_cur = pCt->rb_waddr = pCt->rb_raddr = p1;
	p1->rbc_buf = NULL;
	ret = akxm_malloc_constct_pp(m_alloc,pConstCt,sizeof(tdtRB_CHAIN),(char *)&p2);
	if (!p2) {
		if (!ret) {
			Free(pCt);
			Free(p1);
		}
		return NULL;
	}
	pCt->rb_wpriv = p2;
	p2->rbc_buf = NULL;
	p1->rbc_next = p2;
	p2->rbc_next = p1;
	pCt->rb_num = 2;
	pCt->rb_malloc = m_alloc;
	pCt->rb_constct = pConstCt;
	return pCt;
}

tdtRB_CTL *akxs_rb_new(lBS,lRM)
int lBS,lRM;
{
	return akxs_rb_new2(lBS,lRM,NULL,NULL);
}

tdtRB_CTL *akxs_rb_init(lBS,lRM)
int lBS,lRM;
{
	return akxs_rb_new2(lBS,lRM,NULL,NULL);
}

char *akxs_rb_get(pCt)
tdtRB_CTL *pCt;
{
	if (!pCt) return NULL;
	return pCt->rb_raddr->rbc_buf;
}

char *akxs_rb_get_n(pCt)
tdtRB_CTL *pCt;
{
	char *p;
	tdtRB_CHAIN *pr;

	if (!pCt) return NULL;

	if (!(pr = pCt->rb_raddr)) return NULL;
	if (p=pr->rbc_buf) {
		pr->rbc_buf = NULL;
		pCt->rb_raddr = pr->rbc_next;
		pCt->rb_used--;
	}
	pCt->rb_cur = pCt->rb_raddr;
	pCt->rb_pos = 0;
	return p;
}

char *akxs_rb_set_n(pCt, addr)
tdtRB_CTL *pCt;
char *addr;
{
	tdtRB_CHAIN *pw, *pn, *pp;
/*
printf("akxs_rb_set_n: pCt=%08x addr=%08x\n",pCt,addr);
*/
	if (!pCt || !addr) return NULL;

	if (!(pw = pCt->rb_waddr)) return NULL;
	if (pw->rbc_buf) {
		pn = (tdtRB_CHAIN *)akxm_malloc_constct(pCt->rb_malloc,pCt->rb_constct,sizeof(tdtRB_CHAIN));
		if (!pn) return NULL;
		pp = pCt->rb_wpriv;
		pCt->rb_waddr = pp->rbc_next = pn;
		pn->rbc_next = pw;
		pw = pCt->rb_waddr;
		pCt->rb_num++;
	}
	pw->rbc_buf = addr;
	pCt->rb_waddr = pw->rbc_next;
	pCt->rb_wpriv = pw;
	pCt->rb_used++;
	return addr;
}

int akxs_rb_free(pCt)
tdtRB_CTL *pCt;
{
	tdtRB_CHAIN *pw, *pn, *pp;
	char *(*m_alloc)();

	if (!pCt) return -1;
	m_alloc = pCt->rb_malloc;
	if (pp = pCt->rb_wpriv) {
		pw = pp->rbc_next;
		pp->rbc_next = NULL;
		while (pw) {
			pn = pw->rbc_next;
			if (!m_alloc) Free(pw);
			pw = pn;
		}
	}
	if (!m_alloc) Free(pCt);
	return 0;
}

int akxs_rb_buf_free(pCt)
tdtRB_CTL *pCt;
{
	char *p;
	char *(*m_alloc)();

	if (!pCt) return -1;

	m_alloc = pCt->rb_malloc;
	while (p=akxs_rb_get_n(pCt)) {
		if (!m_alloc) Free(p);
	}
	return 0;
}

int akxs_rb_all_free(pCt)
tdtRB_CTL *pCt;
{
	int  iRc;

	if (!(iRc = akxs_rb_buf_free(pCt))) iRc = akxs_rb_free(pCt);

	return iRc;
}

char *akxs_rb_set_t(pCt, addr)
tdtRB_CTL *pCt;
char *addr;
{
	tdtRB_CHAIN *pw, *pn, *pp;

	if (!pCt || !addr) return NULL;
	if (!akxs_rb_get(pCt)) return akxs_rb_set_n(pCt,addr);
	
	pw = pCt->rb_waddr;
	while ((pp=pw->rbc_next) != pCt->rb_raddr) {
		pw = pp;
	}

	if (pw->rbc_buf) {
		pn = (tdtRB_CHAIN *)akxm_malloc_constct(pCt->rb_malloc,pCt->rb_constct,sizeof(tdtRB_CHAIN));
		if (!pn) return NULL;
		pw->rbc_next = pn;
		pn->rbc_next = pp;
		pw = pn;
		pCt->rb_num++;
	}
	pw->rbc_buf = addr;
	if (pCt->rb_raddr == pCt->rb_waddr) {
		pCt->rb_waddr = pw;
	}
	pCt->rb_raddr = pw;
	pCt->rb_used++;
	pCt->rb_cur = pCt->rb_raddr;
	pCt->rb_pos = 0;
	return addr;
}

char *akxs_rb_read(pCt, cmd)
tdtRB_CTL *pCt;
int     cmd;
{
	tdtRB_CHAIN *pr;
	char *p=NULL;

	if (pCt) {
		if (!cmd) {
			pr = pCt->rb_raddr;
			pCt->rb_pos = 0;
		}
		else {
			if (pCt->rb_pos >= pCt->rb_used) return NULL;
			if (pCt->rb_pos) {
				pr = pCt->rb_cur;
				pCt->rb_cur = pr->rbc_next;
			}
			else pCt->rb_cur = pCt->rb_raddr;
			pr = pCt->rb_cur;
			pCt->rb_pos++;
		}
		p = pr->rbc_buf;
	}
	return p;
}

int akxs_rb_exchg(pCt1, pCt2, opt)
tdtRB_CTL *pCt1,*pCt2;
int opt;
{
	tdtRB_CTL tCtW;

	if (!pCt1 || !pCt2) return -1;
	tCtW  = *pCt1;
	*pCt1 = *pCt2;
	*pCt2 = tCtW;
	return 0;
}

int akxs_rb_used(pCt)
tdtRB_CTL *pCt;
{
	if (!pCt) return -1;
	return pCt->rb_used;
}

char *akxs_rb_srch(pCt, addr, compar)
tdtRB_CTL *pCt;
char *addr;
int (*compar)();
{
	int f;
	tdtRB_CHAIN *pr;
	char *p;

	if (!pCt || !addr) return NULL;
	if (!compar) compar = strcmp;
	pr = pCt->rb_raddr;
	while (p=pr->rbc_buf) {
		if (!compar(addr,p)) return p;
		pr = pr->rbc_next;
		if (pr == pCt->rb_waddr) break;
	}
	return NULL;
}

/************************************************/
/*												*/
/*		List									*/
/*												*/
/************************************************/
tdtRB_CTL *akxs_list_new2(lBS,lRM,m_alloc,pConstCt)
int lBS,lRM;
char *(*m_alloc)();
tdtCONSTCT *pConstCt;
{
	tdtRB_CTL *pCt;

	pCt = (tdtRB_CTL *)akxm_malloc_constct(m_alloc,pConstCt,sizeof(tdtRB_CTL));
	if (!pCt) return NULL;
	memset(pCt,0,sizeof(tdtRB_CTL));
	pCt->rb_bfsz = lBS;
	pCt->rb_max = lRM;
	pCt->rb_malloc = m_alloc;
	return pCt;
}

tdtRB_CTL *akxs_list_new(lBS,lRM)
int lBS,lRM;
{
	return akxs_list_new2(lBS,lRM,NULL,NULL);
}

int akxs_list_free(pCt,free_func)
tdtRB_CTL *pCt;
int (*free_func)();
{
	tdtRB_CHAIN *pw, *pn, *pp;
	char *p;
	char *(*m_alloc)();

	if (!pCt) return -1;
	m_alloc = pCt->rb_malloc;
	while (akxs_list_get(pCt,&p) > 0) {
		if (p) {
			if (free_func) free_func(p);
			else if (!m_alloc) Free(p);
		}
	}
	if (!m_alloc) Free(pCt);
	return 0;
}

int akxs_list_get(pCt,pp)
tdtRB_CTL *pCt;
char **pp;
{
	tdtRB_CHAIN *pr;

	if (!pCt) return -1;
	
	if (pr = pCt->rb_raddr) {
		*pp = pr->rbc_buf;
		pCt->rb_raddr = pr->rbc_next;
		pCt->rb_used--;
		if (pr == pCt->rb_waddr) pCt->rb_waddr = NULL;
		Free(pr);
		return 1;
	}
	else return 0;
}

int akxs_list_set(pCt, addr)
tdtRB_CTL *pCt;
char *addr;
{
	tdtRB_CHAIN *pw, *pn;

	if (!pCt) return -1;

	pn = (tdtRB_CHAIN *)akxm_malloc_constct(pCt->rb_malloc,pCt->rb_constct,sizeof(tdtRB_CHAIN));
	if (!pn) return 0;
	pn->rbc_buf = addr;
	pn->rbc_next = NULL;
	if (pw = pCt->rb_waddr) pw->rbc_next = pn;
	else pCt->rb_raddr = pn;
	pCt->rb_waddr = pn;
	pCt->rb_used++;
	return 1;
}

int akxs_list_srch(pCt, addr, compar, opt)
tdtRB_CTL *pCt;
char *addr;
int (*compar)();
int opt;
{
	int f;
	tdtRB_CHAIN *pr,*pre;
	char *p;

	if (!pCt) return -1;
	pre = NULL;
	pr = pCt->rb_raddr;
	while (pr) {
		if (compar) f = !compar(addr,pr->rbc_buf);
		else f = (addr == pr->rbc_buf);
		if (f) {
			if (opt) {
				if (pre) pre->rbc_next = pr->rbc_next;
				else pCt->rb_raddr = pr->rbc_next;
				if (!pr->rbc_next) pCt->rb_waddr = pre;
				pCt->rb_used--;
			}
			pCt->rb_cur = pr;
			return 1;
		}
		pre = pr;
		pr = pr->rbc_next;
	}
	return 0;
}

int akxs_list_read(pCt, cmd, pp)
tdtRB_CTL *pCt;
int     cmd;
char   **pp;
{
	tdtRB_CHAIN *pr;

	if (!pCt) return -1;

	if (!cmd) {
		pCt->rb_cur = NULL;
	}
	else {
		if (cmd > 0) {
			if (pr = pCt->rb_cur) pr = pr->rbc_next;
			else pr = pCt->rb_raddr;
		}
		else {
			if (!(pr = pCt->rb_cur)) pr = pCt->rb_raddr;
		}
		if (pr) {
			pCt->rb_cur = pr;
			*pp = pr->rbc_buf;
			return 1;
		}
	}
	return 0;
}

/************************************************/
/*												*/
/*		Stack									*/
/*												*/
/************************************************/
/********1*********2*********3*********4*********5*********6*********/
/*	@\ : X^bN\̂									*/
/*	 : IN : stack		: X^bN\̂ւ̎Q				*/
/*				max_stack	: X^bN							*/
/*		   OUT: stack		: X^bN\̂̃o				*/
/*								stack->wdmax = max_stack			*/
/*								stack->sp = 0						*/
/*								((char **)stack->wd)[] = NULL		*/
/*	ԋp : = 0 													*/
/*		   =-2 max_stack <= 0										*/
/*	쐬 : 2014/12/01 Akito Kobayashi								*/
/*	XV :															*/
/********************************************************************/
int akxs_stack_init(SSPL_S *stack,int max_stack)
{
	int ret;

	ret = 0;
	if (max_stack <= 0) ret -= 2;
	if (ret == 0) {
		stack->wdmax = max_stack;
		stack->sp = 0;
		mem_set_addr((char **)stack->wd,NULL,max_stack);
	}
	return ret;
}

/********1*********2*********3*********4*********5*********6*********/
/*	@\ : X^bN\̂쐬A							*/
/*	 : IN : max_stack	: X^bN							*/
/*		   OUT: stack		: X^bN\̂̃o				*/
/*								stack->wdmax = max_stack			*/
/*								stack->sp = 0						*/
/*								((char **)stack->wd)[] = NULL		*/
/*	ԋp : != NULL 												*/
/*		   =  NULL G[											*/
/*	쐬 : 2020/01/27 Akito Kobayashi								*/
/*	XV :															*/
/********************************************************************/
SSPL_S *akxs_stack_new(int max_stack)
{
	SSPL_S *stack;
	int ret;

	stack = NULL;
	if (max_stack > 0) {
		if (stack = (SSPL_S *)Malloc(sizeof(SSPL_S))) {
			if (stack->wd = Malloc(sizeof(char *)*max_stack)) {
				akxs_stack_init(stack,max_stack);
			}
			else {
				Free(stack);
				stack = NULL;
			}
		}
	}
	return stack;
}

/********1*********2*********3*********4*********5*********6*********/
/*	@\ : X^bN\̂J									*/
/*	 : IN : stack		: X^bN\̂ւ̎Q				*/
/*	ԋp : = 0 													*/
/*		   =-1 stack = NULL											*/
/*	쐬 : 2020/01/27 Akito Kobayashi								*/
/*	XV :															*/
/********************************************************************/
int akxs_stack_free(SSPL_S *stack)
{
	int ret;

	ret = 0;
	if (stack) {
		Free(stack->wd);
		Free(stack);
	}
	else ret = -1;
	return ret;
}

/********1*********2*********3*********4*********5*********6*********/
/*	@\ X^bNɐς												*/
/*	 : IN : stack		: X^bN\̂ւ̎Q				*/
/*				val			: X^bNɐςޒl						*/
/*		   OUT: stack		: X^bN\̂̃o				*/
/*							  ((char **)stack->wd)[stack->sp] = val */
/*							  stack->sp++							*/
/*	ԋp :	= 0 : 												*/
/*			=-1 : stack = NULL										*/
/*			=-4 : X^bNI[o									*/
/*	쐬 :2014/12/01 AkitoKobayashi									*/
/*	XV :															*/
/********************************************************************/
int akxs_stack_push(SSPL_S *stack,char *val)
{
	int ret;
	char **p;

	ret = 0;
	if (stack) {
		if (stack->sp >= stack->wdmax)
			ret = -4;
		else {
			p = (char **)(stack->wd);
			p[stack->sp] = val;
			stack->sp++;
		}
	}
	else ret = -1;
	return ret;
}

/********1*********2*********3*********4*********5*********6*********/
/*	@\ : X^bN̂A܂́AX^bNo			*/
/*	 : IN : stack		: X^bN\̂ւ̎Q				*/
/*				val			: X^bN̒lւ̎Q					*/
/*				isPeek		: PeektO							*/
/*								= 0 : X^bNo			*/
/*								!=0 : X^bN̂				*/
/*		   OUT: stack		: X^bN\̂̃o				*/
/*							  X^bNoƤ				*/
/*								stack->sp--							*/
/*	ԋp :	= 0 : 												*/
/*			=-1 : stack = NULL										*/
/*			=-8 : X^bN͋										*/
/*	쐬 : 2014/12/01 Akito Kobayashi								*/
/*	XV :															*/
/********************************************************************/
static int _PopPeekStack(SSPL_S *stack,char **val,int isPeek)
{
	int ret;
	char **p;

	ret = 0;
	if (stack && val) {
		if (stack->sp <= 0)
			ret = -8;
		else {
			p = (char **)(stack->wd);
			*val = p[stack->sp - 1];
			if (isPeek == 0) stack->sp--;
		}
	}
	else ret = -1;
	return ret;
}

/********1*********2*********3*********4*********5*********6*********/
/*	@\ : X^bNo										*/
/*	 : IN : stack		: X^bN\̂ւ̎Q				*/
/*				val			: X^bN̒lւ̎Q					*/
/*		   OUT: val			: ol							*/
/*				stack		: X^bN\̂̃o				*/
/*								stack->sp--							*/
/*	ԋp :	= 0 : 												*/
/*			=-1 : stack = NULL										*/
/*			=-8 : X^bN͋										*/
/*	쐬 : 2014/12/01 Akito Kobayashi								*/
/*	XV :															*/
/********************************************************************/
int akxs_stack_pop(SSPL_S *stack,char **val)
{

	return _PopPeekStack(stack, val, 0);

}

/********1*********2*********3*********4*********5*********6*********/
/*	@\ : X^bN̂											*/
/*	 : IN : stack		: X^bN\̂ւ̎Q				*/
/*				val			: X^bN̒lւ̎Q					*/
/*		   OUT: val			: ̂l							*/
/*	ԋp :	= 0 : 												*/
/*			=-1 : stack = NULL										*/
/*			=-8 : X^bN͋										*/
/*	쐬 : 2014/12/01 Akito Kobayashi								*/
/*	XV :															*/
/********************************************************************/
int akxs_stack_peek(SSPL_S *stack,char **val)
{

	return _PopPeekStack(stack, val, 1);

}

/********1*********2*********3*********4*********5*********6*********/
/*	@\ :X^bNT[`AȂΓo^						*/
/*	 : IN : stack		: X^bN\̂ւ̎Q				*/
/*				val			: X^bNɓo^l					*/
/*				Optional 	: opt 0x01=1 : o^					*/
/*		   OUT: stack		: X^bN\̂̃o				*/
/*							  o^Ƃ́A						*/
/*							  ((char **)stack->wd)[stack->sp] = val */
/*							  stack->sp++							*/
/*	ԋp :	> 0 : o^ʒu + 1										*/
/*			=-4 : X^bNI[o									*/
/*			=-8 : X^bN͋										*/
/*	쐬 : 2018/03/15 Aki to Kobayashi								*/
/*	XV :															*/
/********************************************************************/
int akxs_statck_srch(SSPL_S *stack,char *val,int opt)
{
	int ret,i;
	char **p;

	ret = 0;
	if (stack && val) {
		p = (char **)(stack->wd);
		for (i = 0; i< stack->sp - 1; i++) {
			if (p[i] == val) {
				ret = i + 1;
				break;
			}
		}
		if (opt & 0x01) ret = akxs_stack_push(stack, val);
	}
	else ret = -1;
	return ret;
}
