static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*****************************************************/
/*                                                   */
/*     akxcgcvn ( s, n, pnum )                       */
/*                                                   */
/*****************************************************/
#include "akxcommon.h"
#include <math.h>

#if defined(_LP64)
#define D_CHK_X_OVER	0xf000000000000000
#define D_CHK_O_OVER	0xa000000000000000
#define D_CHK_B_OVER	0x8000000000000000
#else
#define D_CHK_X_OVER	0xf0000000
#define D_CHK_O_OVER	0xa0000000
#define D_CHK_B_OVER	0x80000000
#endif

static char *sep=" \t\n\r";

int akxcgcvl(wd0,len0,pnum)
char *wd0;
int  len0;
long *pnum;
{
	int n31w=0,rc,i,len,len1,len2,s,skip,iLONG;
	char ch,*wd,*wd1,*wd2;
	long lnum;

	rc = s = 0;
	iLONG = 1;
	wd  = wd0;
	len = len0;
	skip = akxnskipin(wd,len," \t");
	wd += skip;
	len = akxnrskipin(wd,len-skip,sep);
	if (len<=0) rc = -1;
	else if (len >= 3) {
		wd1  = wd;
		len1 = len;
		if ((ch = *wd1)=='+' || ch=='-') {
			if (ch == '-') s = -1;
			len1--;
			wd1++;
		}
		if (*wd1 == '0') {
			iLONG = 0;
			wd2  = wd1  + 2;
			len2 = len1 - 2;
			skip += 2;
			switch (wd1[1]) {
				case 'D':
				case 'd':
					rc = akxccvl(10,wd,len,&lnum);
					break;
				case 'X':
				case 'x':
					rc = akxccvlx(wd2,len2,&lnum);
					break;
				case 'B':
				case 'b':
					rc = akxccvlb(wd2,len2,&lnum);
					break;
				case 'O':
				case 'o':
					rc = akxccvlo(wd2,len2,&lnum);
					break;
				default:
					skip -= 2;
					s = 0;
					iLONG = 1;
			}
#if 1	/* 2020.5.24 */
			if (rc == -3) {
				if (s) lnum = LONG_MIN;
				else lnum = LONG_MAX;
			}
			else if (s) lnum = -lnum;
#else
			if (rc == -3) {
				if (s) n31w = INT_MIN;
				else n31w = INT_MAX;
			}
			else if (s) n31w = -n31w;
			lnum = n31w;
#endif
		}
	}
	if (iLONG) {
		rc = akxccvl(10,wd,len,&lnum);
	}
#if 1	/* 2020.5.24 */
	if (pnum) *pnum = lnum;
#else
	if (pnum) memcpy(pnum,&lnum,sizeof(long));
#endif
	if (rc > 0) rc += skip;
	return rc;
}

int akxcgcvn(wd0,len0,pnum)
char *wd0;
int len0;
int *pnum;
{
#if defined(_LP64)
	int rc,ret,num;
	long lnum;

	ret = akxcgcvl(wd0,len0,&lnum);
#if 1	/* 2020.5.24 */
	if (rc = _chk_int_over(lnum,pnum)) ret = rc;
#else
	if (lnum > INT_MAX) {
		num = INT_MAX;
		ret = -3;
	}
	else if (lnum <INT_MIN) {
		num = INT_MIN;
		ret = -3;
	}
	else num = lnum;
	if (pnum) *pnum = num;
#endif
	return ret;
#else
	return akxcgcvl(wd0,len0,pnum);
#endif
}

int akxccvx(wd0,len0,pnum)
char *wd0;
int len0;
uint *pnum;
{
	int ret;
	long lnum;

	ret = akxccvx(wd0,len0,&lnum);
	if (pnum) *pnum = lnum;
	return ret;
}

int akxccvlx(wd0,len0,pnum)
char *wd0;
int len0;
ulong *pnum;
{
	int rc,i,len;
	ulong uVal, n;
	char c,*wd;

	wd  = wd0;
	len = len0;
	uVal = rc = 0;
	if (len <= 0) return -1;
	for (i=0;i<len;i++,wd++) {
		if (uVal & D_CHK_X_OVER) {
			rc = -3;
			break;
		}
		if ((c = *wd)>='0' && c<='9') n = c - '0';
		else if (c>='a' && c<='f') n = c - 'a' + 10;
		else if (c>='A' && c<='F') n = c - 'A' + 10;
		else {
			rc = i + 1;
			break;
		}
		uVal <<= 4;
		uVal |= n;
	}
	*pnum = uVal;

	return rc;
}

int akxccvo(wd0,len0,pnum)
char *wd0;
int len0;
uint *pnum;
{
	int ret;
	long lnum;

	ret = akxccvx(wd0,len0,&lnum);
	if (pnum) *pnum = lnum;
	return ret;
}

int akxccvlo(wd0,len0,pnum)
char *wd0;
int len0;
ulong *pnum;
{
	int rc,i,len;
	ulong uVal,n;
	char *wd;

	wd  = wd0;
	len = len0;
	uVal = rc = 0;
	if (len <= 0) return -1;
	for (i=0;i<len;i++,wd++) {
		if (uVal & D_CHK_O_OVER) {
			rc = -3;
			break;
		}
		n = *wd - '0';
		if (n>=0 && n<=7) {
			uVal <<= 3;
			uVal |= n;
		}
		else {
			rc = i + 1;
			break;
		}
	}
	*pnum = uVal;

	return rc;
}

int akxccvb(wd0,len0,pnum)
char *wd0;
int len0;
uint *pnum;
{
	int ret;
	long lnum;

	ret = akxccvx(wd0,len0,&lnum);
	if (pnum) *pnum = lnum;
	return ret;
}

int akxccvlb(wd0,len0,pnum)
char *wd0;
int len0;
ulong *pnum;
{
	int rc,i,len;
	ulong uVal,n;
	char *wd;

	wd  = wd0;
	len = len0;
	uVal = rc = 0;
	if (len <= 0) return -1;
	for (i=0;i<len;i++,wd++) {
		if (uVal & D_CHK_B_OVER) {
			rc = -3;
			break;
		}
		n = *wd - '0';
		if (!n) {
			uVal <<= 1;
		}
		else if (n == 1) {
			uVal <<= 1;
			uVal |= 1;
		}
		else {
			rc = i + 1;
			break;
		}
	}
	*pnum = uVal;

	return rc;
}
