static char sccsid[]="%Z% %M% %I% %D% %T%";
#include	"akbcommon.h"

#define SELECT

#define SK_RW_BLK	8192
#define READ_SIZE	8192
#define WRITE_SIZE	8192

#define TIMEOUT_BASE	5
#define TIMEOUT_RW_BLK	SK_RW_BLK

#ifdef SELECT
/************************************/
/*                                  */
/************************************/
int akb_sk_read( fd, buff, size )
int	 fd, size;
char *buff;
{
	fd_set	readfds;
	int	    rc, len, time_out;
	int 	count, ret_len;
	char    *p;
	struct  timeval tm, *ptm;

	if (fd<0 || fd>=FD_SETSIZE) return -1;
	p     = buff;
	count = size;
	ret_len = 0;
	time_out = akb_get_time_outi(D_TIMEOUT_SET_READ);
	while( count>0 ) {
		FD_ZERO( &readfds  );
		FD_SET( fd, &readfds );
		if (time_out >= 0) {
			tm.tv_sec  = time_out;
			tm.tv_usec = 0;
			ptm = &tm;
		}
		else ptm = NULL;
		rc = select( fd + 1, &readfds, NULL, NULL, ptm );
		if( rc < 0 ) {
			ERROROUTL2(250,"akb_sk_read:select errno=%d [%s]",errno,strerror(errno));
			if (errno == EINTR) continue;
			return -1;
		}
		else if(!rc) {
			return -2;
		}
		len = sk_nolp_read(fd, p, count);
		if (len <= 0) return -1;
		count -= len;
		p     += len;
		ret_len += len;
	}
	return ret_len;
}
#else	/* SELECT */
/************************************/
/*                                  */
/************************************/
int akb_sk_read( fd, buff, size )
int	 fd, size;
char *buff;
{
	int	    rc, len, time_out, time_cnt;
	int 	count, r_len, ret_len;
	char    *p;

	if (fd<0 || fd>=FD_SETSIZE) return -1;

	akb_set_signal_msg("occured fd = %d in %s !!",fd,"sk_read",0,0,0);

    p     = buff;
	count = size;
	ret_len = 0;
	time_out = akb_get_time_outi(D_TIMEOUT_SET_READ);
/*
	time_cnt = count/TIMEOUT_RW_BLK+TIMEOUT_BASE;
*/
	time_cnt = 2;

#ifdef SET_SIGNAL_ON_SKRW
	signal(SIGALRM, akb_sock_time_out);
	siginterrupt(SIGALRM, 1);
	signal(SIGPIPE, akb_broken_pipe);
	siginterrupt(SIGPIPE, 1);
#endif
	while( count>0 && time_cnt) {
		r_len = count > SK_RW_BLK ? SK_RW_BLK : count;
		if (time_out > 0) alarm(time_out);
		else if (!time_out) alarm(1);
#ifdef SOCKET_ONLY
		len = recv( fd, p, r_len, 0 );
#else
		len = read( fd, p, r_len );
#endif
/*
printf("sk_read:set r_len=%d, return len=%d\n",r_len,len);
*/
		alarm(0);
		if( len < 0 && count == size && errno == EWOULDBLOCK ) {
			return 0;
		}
		if( len < 0 ) {
			ERROROUTL2(250,"akb_sk_read: errno=%d [%s]",errno,strerror(errno));
			if (errno == EINTR) return -2;
			return -1;
		}
		if( len == 0 && time_cnt>0 ) {
			sleep( 1 );
			--time_cnt;
			continue;
		}
		count -= len;
		p     += len;
		ret_len += len;
	}
	if (!time_cnt) return -1;
	return ret_len;
}
#endif	/* SELECT */

#ifdef SELECT
/************************************/
/*                                  */
/************************************/
int akb_sk_write(fd, buff, size)
int	 fd, size;
char *buff;
{
	fd_set	writefds;
	int  rc, len, time_out;
	int  count, ret_len;
    char *p;
	struct  timeval tm, *ptm;

	if (fd<0 || fd>=FD_SETSIZE) return -1;
    p     = buff;
    count = size;
	ret_len = 0;
	time_out = akb_get_time_outi(D_TIMEOUT_SET_WRITE);
	while(count > 0) {
		FD_ZERO( &writefds  );
		FD_SET( fd, &writefds );
		if (time_out >= 0) {
			tm.tv_sec  = time_out;
			tm.tv_usec = 0;
			ptm = &tm;
		}
		else ptm = NULL;
		rc = select( fd + 1, NULL, &writefds, NULL, ptm );
		if( rc < 0 ) {
			ERROROUTL2(250,"akb_sk_write:select errno=%d [%s]",errno,strerror(errno));
			if (errno == EINTR) continue;
			return -1;
		}
		else if(!rc) {
			return -2;
		}
		len = sk_nolp_write(fd, p, count);
		if (len <= 0) return -1;
		count -= len;
		p     += len;
		ret_len += len;
	}
	return ret_len;
}
#else	/* SELECT */
/************************************/
/*                                  */
/************************************/
int akb_sk_write(fd, buff, size)
int	 fd, size;
char *buff;
{
	int  rc, len, time_out, time_cnt;
	int  count, w_len, ret_len;
    char *p;

	if (fd<0 || fd>=FD_SETSIZE) return -1;

	akb_set_signal_msg("occured fd = %d in %s !!",fd,"sk_write",0,0,0);

    p     = buff;
    count = size;
	ret_len = 0;
	time_out = akb_get_time_outi(D_TIMEOUT_SET_WRITE);
/*
	time_cnt = count/TIMEOUT_RW_BLK+TIMEOUT_BASE;
*/
	time_cnt = 2;

#ifdef SET_SIGNAL_ON_SKRW
	signal(SIGALRM, akb_sock_time_out);
	siginterrupt(SIGALRM, 1);
	signal(SIGPIPE, akb_broken_pipe);
	siginterrupt(SIGPIPE, 1);
#endif
	while( count>0 && time_cnt) {
		w_len = count > SK_RW_BLK ? SK_RW_BLK : count;
		if (time_out > 0) alarm(time_out);
		else if (!time_out) alarm(1);
#ifdef SOCKET_ONLY
		len = send( fd , p ,w_len ,0);
#else
		len = write( fd , p ,w_len );
#endif
/*
printf("sk_write:set w_len=%d, return len=%d\n",w_len,len);
*/
		alarm(0);
		if ( len < 0 ) {
			ERROROUTL2(250,"akb_sk_write: errno=%d [%s]",errno,strerror(errno));
			if (errno == EINTR) return -2;
			return -1;
		}
		else if( len == 0 && time_cnt>0 ) {
			sleep( 1 );
			--time_cnt;
			continue;
		}
		count -= len;
		p     += len;
		ret_len += len;
	}
	if (!time_cnt) return -1;
	return ret_len;
}
#endif	/* SELECT */

/************************************/
/*   ǂݎ̂ėp                     */
/************************************/
#define DMY_BUFF_SIZE	4096

int akb_sk_dmy_read(fd ,size)
int		fd;
int		size;
{
	int	 len, count, ret_len, r_len;
	char buff[DMY_BUFF_SIZE];

	if (fd<0 || fd>=FD_SETSIZE) return -1;

	akb_set_signal_msg("occured fd = %d in %s !!",fd,"sk_dmy_read",0,0,0);

	count   = size;
	ret_len = 0;
	while (count > 0) {
		r_len = count > DMY_BUFF_SIZE ? DMY_BUFF_SIZE : count;
		len = akb_sk_read(fd, buff, r_len);
		if (len < 0) return len;
		count   -= len;
		ret_len += len;
	}
	return ret_len;
}

/************************************/
/*                                  */
/************************************/
int sk_nolp_read( fd, buff, size )
int	 fd, size;
char *buff;
{
	int	    len, r_len;
/*
	printf("sk_nolp_read start:fd=%d size=%d\n",fd,size);
*/
/* 2000.8.25 Koba
	alarm(akb_get_time_outi(D_TIMEOUT_SET_READ));
*/
	r_len = size > READ_SIZE ? READ_SIZE : size;
#ifdef SOCKET_ONLY
	len = recv( fd, buff, r_len, 0 );
#else
	len = read( fd, buff, r_len );
#endif
/* 2000.8.25 Koba
	alarm(0);
*/
/*
	printf("sk_nolp_read:len = %d, r_len = %d\n",len,r_len);
*/
	if( len < 0 ) {
		ERROROUTL2(250,"sk_nolp_read:errno=%d [%s]",errno,strerror(errno));
		return -1;
	}
	return len;
}

/************************************/
/*                                  */
/************************************/
int sk_nolp_write( fd, buff, size )
int	 fd, size;
char *buff;
{
	int	    len, w_len;
/*
	printf("sk_nolp_write start:fd=%d size=%d\n",fd,size);
*/
/* 2000.8.25 Koba
	alarm(akb_get_time_outi(D_TIMEOUT_SET_WRITE));
*/
	w_len = size > WRITE_SIZE ? WRITE_SIZE : size;
#ifdef SOCKET_ONLY
	len = send( fd, buff, w_len, 0 );
#else
	len = write( fd, buff, w_len );
#endif
/* 2000.8.25 Koba
	alarm(0);
*/
/*
	printf("sk_nolp_write:len = %d, w_len = %d\n",len,w_len);
*/
	if( len < 0 ) {
		ERROROUTL2(250,"sk_nolp_write:errno=%d [%s]",errno,strerror(errno));
		return -1;
	}
	return len;
}

/************************************/
/*                                  */
/************************************/
int akb_sk_recv_from(fd, buf, size, sa_in, from_len)
int	 fd, size;
char *buf;
struct sockaddr_in *sa_in;
int *from_len;
{
	int	len, time_out;

	if (fd<0 || fd>=FD_SETSIZE) return -1;

	akb_set_signal_msg("occured fd = %d in %s !!",fd,"sk_recv_from",0,0,0);

	time_out = akb_get_time_outi(D_TIMEOUT_SET_READ);

#ifdef SET_SIGNAL_ON_SKRW
	signal(SIGALRM, akb_sock_time_out);
	siginterrupt(SIGALRM, 1);
	signal(SIGPIPE, akb_broken_pipe);
	siginterrupt(SIGPIPE, 1);
#endif
	if (time_out > 0) alarm(time_out);
	else if (!time_out) alarm(1);
	*from_len = sizeof(struct sockaddr);
	len = recvfrom(fd,buf,size,0,(struct sockaddr *)sa_in,(uint *)from_len);
	alarm(0);
/*
printf("sk_recv_from:set size=%d, return len=%d\n",size,len);
*/
	if (len < 0) {
		if (errno == EWOULDBLOCK) len = 0;
		else if (errno == EINTR) len = -2;
		else {
			ERROROUTL2(250,"sk_recv_from:errno=%d [%s]",errno,strerror(errno));
		}
	}
	return len;
}

/************************************/
/*                                  */
/************************************/
int akb_sk_send_to(fd, buf, size, sa_in, to_len)
int	 fd, size;
char *buf;
struct sockaddr_in *sa_in;
int  to_len;	/* yobi */
{
	int	    rc, len, time_out, time_cnt;
	int 	count, r_len, ret_len;
	char    *p;

	if (fd<0 || fd>=FD_SETSIZE) return -1;

	akb_set_signal_msg("occured fd = %d in %s !!",fd,"sk_send_to",0,0,0);
	time_out = akb_get_time_outi(D_TIMEOUT_SET_WRITE);

#ifdef SET_SIGNAL_ON_SKRW
	signal(SIGALRM, akb_sock_time_out);
	siginterrupt(SIGALRM, 1);
	signal(SIGPIPE, akb_broken_pipe);
	siginterrupt(SIGPIPE, 1);
#endif
	if (time_out > 0) alarm(time_out);
	else if (!time_out) alarm(1);
	len = sendto(fd,buf,size,0,
	             (struct sockaddr *)sa_in,sizeof(struct sockaddr));
	alarm(0);
/*
printf("sk_send_to:set size=%d, return len=%d\n",size,len);
*/
	if (len < 0) {
		if (errno == EWOULDBLOCK) len = 0;
		else if (errno == EINTR) len = -2;
		else {
			ERROROUTL2(250,"sk_send_to:errno=%d [%s]",errno,strerror(errno));
		}
	}
	return len;
}

/************************************/
/*                                  */
/************************************/
int sk_nolp_recv_from(fd, buf, size, sa_in, from_len)
int	 fd, size;
char *buf;
struct sockaddr_in *sa_in;
int *from_len;
{
	int	len;

	*from_len = sizeof(struct sockaddr);
	len = recvfrom(fd,buf,size,0,(struct sockaddr *)sa_in,(uint *)from_len);
/*
printf("sk_nolp_recv_from:set size=%d, return len=%d host=%08x port=%d\n",
size,len, ntohl(sa_in->sin_addr.s_addr), ntohs(sa_in->sin_port));
*/
	if (len < 0) {
		if (errno == EWOULDBLOCK) len = 0;
		else if (errno == EINTR) len = -2;
		else {
			ERROROUTL2(250,"sk_nolp_recv_from:errno=%d [%s]",errno,strerror(errno));
		}
	}
	return len;
}
