/*************************************************
 *
 *  akaclass.c (include file)
 *
 *        coded by A.Kobayashi 2000.8.15
 *
 *************************************************/
/*---------------------------
#include "akacommon.h"

extern tdtMSG_CTL          tMsgCtl;
extern tdtCLASS_CTLHead    tClassHead;
extern tdtSTATISTICS      tStatistics,tStat2;
----------------------------*/

static int  _statistics_load(/* buf, iopt, &mcat */);

/********************************************************/
/*                                                      */
/********************************************************/
static int sys_watch_class(lInstanceHandle,cpInstanceData,tpRecvMsg)
long lInstanceHandle;
char *cpInstanceData;
AKAMSGCOM *tpRecvMsg;
{
	AKAMSGCOM    tReplyMsg;

	if (tpRecvMsg->msg_disp == AKA_REGIST_CLASS ||
	    tpRecvMsg->msg_disp > 0 ||
	    tpRecvMsg->msg_pret < 0) {
		return 0;
	}
	aka_reply_msg(lInstanceHandle,tpRecvMsg);

	return 0;
}

static char *_usage_getfile="getfile {e/p/d/{-/+}file} [[-]line] [all|proc name]";
static char *_usage_srcfile="srcfile logno [[+/-]file [line1 [line2]]]";
static char *_usage_setno="srcfile logno [[+/-]setno [file [line1 [line2]]]]";
static char *_usage_getinfo="getinfo logno";
/********************************************************/
/*                                                      */
/********************************************************/
static int _logsrcfile(mcat,buf,maxsize,argc,argv)
MCAT *mcat;
char *buf,*argv[];
int maxsize,argc;
{
	static tdtRB_CTL *pCtChg=NULL;
	char cope;
	int  iRc,ope,size,count,len,pa[7];
	tdtLOG_FILE_LINE *tlFL;

	iRc = akxa_log_set_src_parm(argc,argv,pa);
	if (iRc < 0) {
		if (buf && maxsize>strlen(_usage_srcfile)+strlen(_usage_setno)+8)
			sprintf(buf,"usage:%s\n      %s\n",_usage_srcfile,_usage_setno);
		return iRc;
	}

	if ((ope=pa[2]) > 0) cope = '+';
	else if (ope < 0) cope = '-';
	else cope = ' ';

	if (!pCtChg) {
		if (!(pCtChg=akxs_rb_new(0,0))) {
			if (buf && maxsize>20) strcpy(buf,"akxs_rb_new() error\n");
			return -3;
		}
	}

	count = akb_log_set_src_file(pCtChg,pa[1],pa[2],pa[3],pa[4],pa[5],pa[6]);
	if (count < 0) {
		if (buf && maxsize>20) sprintf(buf,"error=%d\n",count);
		size = count;
	}
	else if (count > 0) {
		size = 0;
		while (tlFL=(tdtLOG_FILE_LINE *)akxs_rb_get_n(pCtChg)) {
			if (buf && size+strlen(tlFL->lfl_file_name)+29 < maxsize) {
				sprintf(buf,"%c%3d %s %d %d\n",
				    cope,tlFL->lfl_no,tlFL->lfl_file_name,tlFL->lfl_line[0],tlFL->lfl_line[1]);
/*
printf("_logsrcfile:buf=[%s]\n",buf);
*/
				len = strlen(buf);
				size += len;
				buf  += len;
			}
			if (ope < 0) Free(tlFL);
		}
	}
	else {
		if (buf && maxsize>10) strcpy(buf,"no data\n");
		size = -1;
	}
	return size;
}

#define AKXS_LOG_PROCNAME_POS	20
/********************************************************/
/*                                                      */
/********************************************************/
static int _getpos(fname,pRbCtl,line_max,proc)
char *fname;
tdtRB_CTL *pRbCtl;
int  line_max;
char *proc;
{
	int proclen;
	int  c,ret,pos0,pos,len,kai;
	FILE *fp;
	char parm[256],*procname;

	if (fname) {
		fp = fopen(fname,"r");
		if (!fp) {
			ERROROUT1("_getpos: file[%s] open error!!",fname);
			return -1;
		}
	}
	proclen = strlen(proc);
	kai = pos0 = pos = len = 0;
	procname = parm + AKXS_LOG_PROCNAME_POS;
	*procname = '\0';
	while ((c=getc(fp)) != EOF) {
		if (len < sizeof(parm)) parm[len] = c;
		len++;
		pos++;
		if (c == '\r') {
			c = getc(fp);
			if (c == '\n') {
				pos++;
			}
			else {
				ungetc(c,fp);
			}
			kai = 1;
		}
		else if (c == '\n') kai = 1;
		if (kai) {
			if (!*proc || !memcmp(procname,proc,proclen)) {
				if (pRbCtl->rb_used >= line_max) {
					akxs_rb_get_n(pRbCtl);
				}
DEBUGOUTL2(AKA_LOG_GROUP|255,"pos0=%d pos=%d",pos0,pos);
				if (!akxs_rb_set_n(pRbCtl, (char *)(pos0+1))) {
				/*	strcpy(buf,"akxs_rb_set_n() error\n");	*/
					break;
				}
			}
			len = kai = 0;
			*procname = '\0';
			pos0 = pos;
		}
	}
	fclose(fp);
	if (pos != pos0) {
		if (!*proc || !memcmp(procname,proc,proclen)) {
			if (pRbCtl->rb_used >= line_max) {
				akxs_rb_get_n(pRbCtl);
			}
DEBUGOUTL2(AKA_LOG_GROUP|250,"pos0=%d pos=%d",pos0,pos);
			if (!akxs_rb_set_n(pRbCtl, (char *)(pos0+1))) {
			/*	strcpy(buf,"akxs_rb_set_n() error\n");	*/
				return -4;
			}
		}
	}
	return pos;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _getlogfile(mcat,buf,maxsize,iRc,argv,cpFv)
MCAT *mcat;
char *buf,*argv[],*cpFv[];
int maxsize,iRc;
{
	char parm[256],*fn,c,*cpPath,*p,*proc,*pp;
	int  i,j,maxline,line,len,size,proclen,len2,pos,ret;
	static char *cpPath2=NULL,*cpPath3=NULL;
	FILE *fp=NULL;
	tdtRB_CTL *pRbCtl=NULL;
	struct stat tStat;

	cpFv[0] = NULL;
	proc = NULL;
	j = -1;
	/* p[^̉ */
	if (iRc >= 2)  {
		if ((c=toupper(*argv[1]))=='E') j = 1;
		else if (c == 'P') j = 2;
		else if (c == 'D') j = 3;
		else if (c == '-') j = 0;
		else if (c == '+') {
			cpFv[0] = argv[1] + 1;
			if (stat(akb_akb_home_add(cpFv[0]),&tStat)) {
				sprintf(buf,"file[%s] errno=%d[%s]\n",cpFv[0],errno,strerror(errno));
				cpFv[0] = NULL;
				ret = -5;
				goto Err;
			}
			sprintf(buf,"<%s>\n",cpFv[0]);
			akxtmcats(mcat,buf);
			return mcat->mc_ipos;
		}
		maxline = 20;
		if (iRc >= 3) maxline = atoi(argv[2]);
		if ((line=maxline) < 0) {
			line = -line;
		}
		if (j>0 && iRc >= 4)  {
			proc = argv[3];
			if (!strcmp(proc,"all")) *proc = '\0';
		}
	}

	/* t@C̐ݒƒovZX̐ݒ */
	if (j < 0) {
		sprintf(buf,"usage:%s\n",_usage_getfile);
		return -2;
	}
	else if (j > 0) {
		if (!(fn=akb_log_set_file_name(--j,NULL))) {
			switch (j) {
				case 0:	fn=ERROR_LOG_FILE;	break;
				case 1:	fn=PRINT_LOG_FILE;	break;
				case 2:	fn=DEBUG_LOG_FILE;	break;
			}
		}
		cpPath = akxt_add_dir2(akb_akb_home(0),
			akxt_add_dir2(akb_log_set_dir(NULL),fn,&cpPath2),&cpPath3);

		if (!proc) {
			if (!(proc = akb_log_get_proc_name())) {
				strcpy(buf,"proc name not set\n");
				return -1;
			}
		}
	}
	else {
		cpPath = akb_akb_home_add(argv[1]+1);
		proc = "";
	}

	if (cpPath) {
		if (maxline > 0) {
			if (!(pRbCtl = akxs_rb_init(0,0))) {
				strcpy(buf,"akxs_rb_init() error\n");
				return -4;;
			}
			ret = _getpos(cpPath,pRbCtl,line,proc);
			if (ret < 0) {
				sprintf(buf,"_getpos() error rc=%d\n",ret);
				goto Err;
			}
		}
	}
	else {
		strcpy(buf,"log file path create error\n");
		return -4;
	}

	/* t@C̃I[v */
	if (!(fp = fopen(cpPath, "r"))) {
		sprintf(buf,"log file[%s] open error %d\n",cpPath,errno);
		ret = -3;
		goto Err;
	}
	sprintf(buf,"<%s>\n",cpPath);
	akxtmcats(mcat,buf);
	if (pRbCtl) {
		while (pos=(int)akxs_rb_get_n(pRbCtl)) {
			fseek(fp,pos-1,0);
			len=akxa_read_line(buf,maxsize,fp);
			if (akxtmcat(mcat,buf,len) < 0) break;
		}
		fclose(fp);
		akxs_rb_all_free(pRbCtl);
	}
	else {
		proclen = strlen(proc);
		i = 0;
		while ((len=akxa_read_line(buf,maxsize,fp))>0 && i<line) {
			if (*proc && memcmp(buf+AKXS_LOG_PROCNAME_POS,proc,proclen))
				continue;
/*
printf("_getlogfile:ReadLi:len=%d i=%d\n",len,i);
*/
			if (akxtmcat(mcat,buf,len) < 0) break;
			i++;
		}
	}
	fclose(fp);
	akxtmcat(mcat,"",1);
/*
printf("_getlogfile:return: size=%d\n",mcat->mc_ipos);
*/
	return mcat->mc_ipos;
 Err:
	if (fp) fclose(fp);
	if (pRbCtl) akxs_rb_all_free(pRbCtl);
	return ret;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _getloginfo(mcat,buf,maxsize,argc,argv)
MCAT *mcat;
char *buf,*argv[];
int maxsize,argc;
{
	tdtLOG_CTL *tlc;
	int usage,ret,logno,i,max,group_mask,group,level,prigroup,priority;
	XHASHB *xhan;
	long key[2];
	tdtLOG_INFO *pInfo;
	char *p1,*p2;

	usage = 0;
	if (argc > 1) {
		if (ret=akxcgcvn(argv[1],strlen(argv[1]),&logno)) usage = 1;
	}
	else usage = 1;
	if (usage) {
		sprintf(buf,"usage:%s\n",_usage_getinfo);
		return -2;
	}
	if (!(tlc = akb_log_get_ctl(logno))) {
		sprintf(buf,"error on get tlc for logno=%d\n",logno);
		return -2;
	}
	group_mask = akb_log_grp_mask(logno,0);
	xhan = tlc->log_info;
	sprintf(buf,"logno = %d\nfile        (line) group(level) pri format\n",
	        logno);
	if ((ret=akxtmcats(mcat,buf)) < 0) return ret;
	while (xhan) {
		max = xhan->xha_maxreg;
		for (i=1;i<=max;i++) {
			xhan->xha_xhix = i;
			ret = akxs_xhash2(xhan,'K',key,&pInfo);
			if (ret > 0) {
				if (!(p1=pInfo->lgi_file)) p1 = AKX_NULL_PRINT;
				if (!(p2=pInfo->lgi_format)) p2 = AKX_NULL_PRINT;
				group = pInfo->lgi_level & group_mask;
				level = pInfo->lgi_level & ~group_mask;
				prigroup = pInfo->lgi_pri & group_mask;
				priority = pInfo->lgi_pri & ~group_mask;
				sprintf(buf,"%-12.12s(%4d) %08x(%3d) %08x(%3d) %s\n"
					,p1
					,pInfo->lgi_line
					,group,level
					,prigroup,priority
					,p2
				/*	,pInfo->a1
					,pInfo->lgi_a2
					,pInfo->lgi_a3
					,pInfo->lgi_a4
					,pInfo->lgi_a5
				*/
					);
				if (akxtmcats(mcat,buf) < 0) break;
			}
		}
		xhan = xhan->xha_xhnext;
	}
	return mcat->mc_ipos;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int sys_log_class(lInstanceHandle,cpInstanceData,tpRecvMsg)
long lInstanceHandle;
char *cpInstanceData;
tdtMSG_COM *tpRecvMsg;
{
	char buf[4096],*argv[9],parm[256],*p,*pi,*fn,*cpFv[2];
	int  len,iRc,i,no,f,j,iset,size,level,iParm[10],l,iusage;
	tdtMSG_COM tReplyMsg;
	tdtGENERAL_DATA Parm, Parmd;
	static MCAT mcat={'M','C',4096,0,0,0,NULL,0};

	if (tpRecvMsg->msg_disp == AKA_REGIST_CLASS ||
	    tpRecvMsg->msg_disp > 0 ||
	    tpRecvMsg->msg_pret < 0) {
		return 0;
	}
	cpFv[0] = NULL;
	memset(&tReplyMsg,0,sizeof(tdtMSG_COM));
	memset(&Parm,0,sizeof(tdtGENERAL_DATA));
	Parm.gd_data = buf;
	iset = 1;
	no = level = f = size = -1;
	iusage = 0;
	mcat.mc_ipos = 0;
	if (tpRecvMsg->msg_mlen > 0) {
/*
printf("sys_log_class:msg=[%s]\n",tpRecvMsg->msg_pmsg);
*/
		iRc = akxtgetargv(tpRecvMsg->msg_pmsg,argv,9,parm,sizeof(parm));
		if (iRc >= 1) {
			pi = argv[0];
			if (*pi>='0' && *pi<='9') {	/* LOGNO */
				akb_log_set_parm2(iRc,argv,10,iParm);
				no = iParm[0];
			}
			else if (*pi == '-') ;
			else if (!stricmp(pi,"getfile")) {
				iset = 0;
				size = _getlogfile(&mcat,buf,sizeof(buf),iRc,argv,cpFv);
				if (size >= 0) Parm.gd_data = mcat.mc_bufp;
			}
			else if (!stricmp(pi,"srcfile")) {
				iset = 0;
				size = _logsrcfile(&mcat,buf,sizeof(buf),iRc,argv);
			}
			else if (!stricmp(pi,"getinfo")) {
				iset = 0;
				size = _getloginfo(&mcat,buf,sizeof(buf),iRc,argv);
				if (size >= 0) Parm.gd_data = mcat.mc_bufp;
			}
			else
				iusage = 1;
		}
		else iusage = 1;
	}
	else iusage = 1;
	if (iusage) {
		iset = 0;
		sprintf(buf,"usage:\n-1\nlogno flag [level [size_max [file_max [option [filename [priority]]]]]]\n%s\n%s\n%s\n%s\n",_usage_getfile,_usage_srcfile,_usage_setno,_usage_getinfo);
	}
	if (iset) {
		if (!(p=akb_log_get_proc_name())) p = AKX_NULL_PRINT;
		sprintf(buf,"ProcName : %s\nNo  flg grplevel size_max file_max option filename  no check grppriority\n",p);
		size = akxtmcats(&mcat,buf);
		for (j=0;j<D_LOG_NO_MAX;j++) {
			if (no<0 || j==no) {
				iParm[0] = j;
				akb_log_set_parm2(1,NULL,10,iParm);
/*
printf("sys_log_class:iParm[6]=%d\n",iParm[6]);
*/
				if ((iParm[6]==-1) || !(fn=(char *)iParm[6])) fn = "(null)";
				sprintf(parm,"%2d %04x %08x %8d %8d %06x %-9s %2d %5d %08x\n",j,iParm[1],iParm[2],iParm[3],iParm[4],iParm[5],fn,iParm[7],iParm[8],iParm[9]);
				size = akxtmcats(&mcat,parm);
			}
		}
		Parm.gd_data = mcat.mc_bufp;
	}
	if ((len=size) < 0) len = strlen(buf);
	Parm.gd_dlen = len + 1;
	Parm.gd_code = akxt_get_code_type();
	Parmd.gd_code = Parm.gd_code;
	Parmd.gd_data    = NULL;	/* Parm.gd_data; */
#if 1	/* NCAgʐMf[C܂ł̎b */
{int pid[2];
	akb_get_term_base(pid);
	if (/* tpRecvMsg->msg_hoid != aka_get_my_host_id() && */
	    tpRecvMsg->msg_prid > pid[0] &&
	    tpRecvMsg->msg_prid <=pid[1])
		Parmd.gd_code = CD_TYPE_SJIS;
}
#endif
	if ((len=akxt_code_trans(&Parm,&Parmd))<0) {
		strcpy(buf,"code transfer error!!");
		len = strlen(buf) + 1;
	}
	if (Parmd.gd_data) tReplyMsg.msg_pmsg = Parmd.gd_data;
	else tReplyMsg.msg_pmsg = Parm.gd_data;
	tReplyMsg.msg_mlen = len;
	if (cpFv[0]) {
		tReplyMsg.msg_form = AKA_PFM_INDIRECT;
		tReplyMsg.msg_filc = 1;
		tReplyMsg.msg_filv = cpFv;
	}
	iRc = aka_reply_msg(lInstanceHandle,&tReplyMsg);
DEBUGOUTL1(AKA_LOG_GROUP|100,"SysLogClas: aka_reply_msg() ret=%d",iRc);
	if (Parmd.gd_data) Free(Parmd.gd_data);

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_statistics_count(i,iLen)
int i,iLen;
{
	tdtSTAT_UNIT *pSu;

	if (i>=0 && i<=3) {
		pSu = &tStatistics.u[i];
		if (tStatistics.timer_id) {
			pSu->msg_count++;
			pSu->msg_len += iLen;
			pSu->msg_count_s++;
			pSu->msg_len_s += iLen;
		}
		pSu->msg_total++;
		pSu->msg_len_total += iLen;
	}

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int sys_statistics_class(lInstanceHandle,cpInstanceData,tpRecvMsg)
long lInstanceHandle;
char *cpInstanceData;
AKAMSGCOM *tpRecvMsg;
{
	AKAMSGCOM    tReplyMsg;
	char buf[4096],*argv[6],parm[128];
	int  len, iRc, n, mode=0, iopt[5], i, pid[2], log_clear=0,t;
/*	struct timeval ttime;	*/
	tdtGENERAL_DATA    Parm, Parmd;	/* p[^\ */
	static MCAT mcat={'M','C',4096,0,0,0,NULL,0};
	tdtSTAT_UNIT *pSu;
	int  log_start,intval_set,intval;

	switch (tpRecvMsg->msg_disp) {
	case AKA_REGIST_CLASS:
		break;
	case 0:
	    if (tpRecvMsg->msg_pret) break;
		memset(&Parmd,0,sizeof(tdtGENERAL_DATA));
		memset(&tReplyMsg,0,sizeof(AKAMSGCOM));
		tReplyMsg.msg_pmsg = buf;
		*buf = '\0';
		tReplyMsg.msg_mlen = 1;
		if (tpRecvMsg->msg_mlen > 0) {
			iRc = akxtgetargv(tpRecvMsg->msg_pmsg,argv,6,parm,sizeof(parm));
			if (iRc >= 1) {
				aka_set_inst_comment(lInstanceHandle,argv[0]);
				if (!stricmp(argv[0],"get")) {
					for (i=1;i<=5;i++) {
						if (i< iRc) iopt[i-1] = atoi(argv[i]);
						else iopt[i-1] = 0;
					}
					mcat.mc_ipos = 0;
					iRc = _statistics(buf, iopt, &mcat);
					memset(&Parm,0,sizeof(tdtGENERAL_DATA));
					Parm.gd_data   = mcat.mc_bufp;
					Parm.gd_dlen = mcat.mc_ipos + 1;
					Parm.gd_code = akxt_get_code_type();
#if 0	/* 2000.12.1 Koba */
					Parmd.gd_code = AKBGETCDTYPE(tpRecvMsg->msg_form);
#else
					Parmd.gd_code = akxt_get_code_type();
#endif
#if 1	/* NCAgʐMf[C܂ł̎b */
					{int pid[2];
					akb_get_term_base(pid);
					if (tpRecvMsg->msg_hoid != aka_get_my_host_id() &&
					    tpRecvMsg->msg_prid > pid[0] &&
					    tpRecvMsg->msg_prid <=pid[1])
						Parmd.gd_code = CD_TYPE_SJIS;
					}
#endif
					if ((len=akxt_code_trans(&Parm,&Parmd))<0) {
						strcpy(buf,"code transfer error!!");
						tReplyMsg.msg_mlen = strlen(buf) + 1;
					}
					else {
						tReplyMsg.msg_pmsg = Parm.gd_data;
						tReplyMsg.msg_mlen = len;
					}
				}
				else if (!stricmp(argv[0],"start")) {
					if (iRc==1 && tStatistics.timer_id) {
						strcpy(buf,"NG!! already started.\n");
						iRc = -1;
					}
					else {
						*buf = '\0';
						log_clear = log_start = intval_set = 0;
						for (i=1;i<iRc;i++) {
							if (!akxcgcvn(argv[i],strlen(argv[i]),&n)) {
								intval = n;
								intval_set = 1;
							}
							else if (!stricmp(argv[i],"LOG"))
								log_start = 1;
							else if (!stricmp(argv[i],"CLEAR"))
								log_clear = 1;
							else {
								sprintf(buf,"NG!! invalid parameter[%s]",argv[i]);
								iRc = -1;
								break;
							}
						}
					}
					if (iRc < 0) {
						tReplyMsg.msg_mlen = strlen(buf) + 1;
						aka_reply_msg(lInstanceHandle,&tReplyMsg);
						return 0;
					}
					if (intval_set) {
						if (tStatistics.timer_id)
							strcpy(buf,"NG!! already started. ignore time.\n");
						else tStatistics.interval = intval;
					}
					else if (!tStatistics.timer_id) tStatistics.interval = 60;

					if (log_start) {
						if (tStatistics.opt[0] && !log_clear)
							strcpy(buf+strlen(buf),
							"NG!! already logging. ignore LOG.\n");
						else {
							tStatistics.opt[0] = 1;
							LOGFLG(D_LOG_NO_STATI,
						       D_LOG_FLG_FILE | D_LOG_FLG_NO_SRC |
						       D_LOG_FLG_NO_PROC);
							if (!akb_log_set_file_name(D_LOG_NO_STATI, NULL)) {
								sprintf(parm,"statistics%d_log",
								        aka_get_regist_pid());
								akb_log_set_file_name(D_LOG_NO_STATI, parm);
							}
							if (log_clear) {
								akb_log_clear(D_LOG_NO_STATI,0);
								strcpy(buf+strlen(buf),"OK now clear log.\n");
							}
							akb_log_out_main(D_LOG_NO_STATI,0,0,",%s%s%s%s%s",
"Thread,RbR,RbW,Que,",
"GMTot,GMAvt,GMCnt,GMRat,GMAvg,GMMax,GMMxt,GMLTot,GMLAvt,GML,GMLRat,GMLAvg,GMLMax,GMLMxt,",
"PMTot,PMAvt,PMCnt,PMRat,PMAvg,PMMax,PMMxt,PMLTot,PMLAvt,PML,PMLRat,PMLAvg,PMLMax,PMLMxt,",
"WMTot,WMAvt,WMCnt,WMRat,WMAvg,WMMax,WMMxt,WMLTot,WMLAvt,WML,WMLRat,WMLAvg,WMLMax,WMLMxt,",
"ExTot,ExAvt,ExCnt,ExRat,ExAvg,ExMax,ExMxt");
							strcpy(buf+strlen(buf),"OK start logging.\n");
						}
					}
					else if (log_clear)
							strcpy(buf+strlen(buf),
							"NG!! not logging.ignore CLEAR.\n");
					if (!tStatistics.timer_id) {
						pSu = &tStatistics.u[0];
						for (i=0;i<4;i++,pSu++) {
							pSu->msg_count  = 0;
							pSu->msg_len    = 0;
							pSu->msg_count_s = 0;
							pSu->msg_len_s   = 0;
							pSu->msg_max     = 0;
							pSu->msg_len_max = 0;
						}
						tStatistics.start_time =
						tStatistics.check_time = aka_get_msec(NULL);
#ifdef AKA_INCLUDE
						iRc = aka_set_sleep(lInstanceHandle,1,
						                  tStatistics.interval*1000);
						if (iRc) {
							sprintf(buf+strlen(buf),
							"NG!! timer not started. SetSleep ret=%d",iRc);
						}
						else {
							tStatistics.timer_id = 1;
							mode = 1;
#else
						iRc = aka_register_timer("Statistics",_statistics_timer,
						               tStatistics.interval*1000,NULL);
						if (iRc <= 0) {
							sprintf(buf+strlen(buf),
							"NG!! timer not started. RegisterTimer ret=%d",iRc);
						}
						else {
							tStatistics.timer_id = iRc;
#endif
							strcpy(buf+strlen(buf),"OK timer started.");
						}
					}
					tReplyMsg.msg_mlen = strlen(buf) + 1;
				}
				else if (!stricmp(argv[0],"end")) {
					if (tStatistics.timer_id) {
						if (iRc >= 2) {
							if (!stricmp(argv[1],"LOG")) {
								tStatistics.opt[0] = 0;
								strcpy(buf,"OK stop LOG");
							}
							else {
								strcpy(buf,"NG!! invalid parameter");
							}
						}
						else {
#ifdef AKA_INCLUDE
							aka_wake_up_msg(lInstanceHandle & 0xffff,D_ERR_SHUT_WAKEUP);
#else
							aka_cancel_timer(tStatistics.timer_id);
							tStatistics.check_time = aka_get_msec(NULL);
							tStatistics.timer_id = 0;
#endif
							tStatistics.interval = 0;
							tStatistics.opt[0] = 0;
							strcpy(buf,"OK stop");
						}
					}
					else strcpy(buf,"OK not started.");
					tReplyMsg.msg_mlen = strlen(buf) + 1;
				}
				else if (!stricmp(argv[0],"load")) {
					iRc = _statistics_load(buf, iopt, &mcat);
				/*
					tReplyMsg.msg_pmsg   = mcat.mc_bufp;
					tReplyMsg.msg_mlen = mcat.mc_ipos + 1;
				*/
					tReplyMsg.msg_mlen = strlen(buf) + 1;
				}
				else {
					strcpy(buf,"NG!! invalid command");
					strcat(buf,"\nusage: get [class_opt] [channel_opt] [timer_opt] [timeout_opt]");
					strcat(buf,"\n           class_opt  : 0x01=instance. 0x02=no_display class");
					strcat(buf,"\n           channel_opt: !0=channel. 0x02=RWbuf");
					strcat(buf,"\n           timer_opt  : 0x01=timer.");
					strcat(buf,"\n           timeout_opt: 0x01=timeout");
					strcat(buf,"\n       start [<check interval(sec)>] [LOG] [CLEAR]");
					strcat(buf,"\n       end [LOG]");
					strcat(buf,"\n       load");
					tReplyMsg.msg_mlen = strlen(buf) + 1;
				}
			}
		}
		aka_reply_msg(lInstanceHandle,&tReplyMsg);
		if (Parmd.gd_data) Free(Parmd.gd_data);
#ifdef AKA_INCLUDE
		if (mode) {
			sprintf(parm,"Interval=%d logout=%d",
					tStatistics.interval,tStatistics.opt[0]);
			aka_set_inst_comment(lInstanceHandle,parm);
			return mode;
		}
		break;
	case 1:
		t = aka_get_msec();
		if (tpRecvMsg->msg_pret || aka_shut_control(AKA_SHUT_GET,NULL)) {
			tStatistics.check_time = t;
			tStatistics.timer_id = 0;
			break;
		}
		_statistics_fileout(t,tClassHead.used_thread_total,
				tMsgCtl.rb_rctl->rb_used,tMsgCtl.rb_wctl->rb_used,
				tMsgCtl.que_rwctl->qct_used);
		iRc = aka_set_sleep(lInstanceHandle,1,tStatistics.interval*1000);
		if (!iRc) return 1;
		ERROROUT("stop statistics!!");
		tStatistics.timer_id = 0;
#endif
	}
	aka_set_inst_comment(lInstanceHandle,NULL);
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _statistics(buf,iopt,mcat)
char *buf;
int  iopt[];
MCAT *mcat;
{
	int  ret;
	char *p;
	struct timeval tval;
	struct tm t;
	struct rusage rus;

	if (!(p=akb_log_get_proc_name())) p = nullname;
	aka_get_msec(&tval);
	akxe_edit_elapse_time(tval.tv_sec,&t);
#if 0
#if 0
	getrusage(RUSAGE_SELF,&rus);
	sprintf(buf,"ProcName : %s(%d)    ElapseTime : %d(day) %02d:%02d:%02d\nMemory shm=%d data=%d stack=%d\n\nTimerId  WaitTime(msec)  Status  Name\n",p,t.tm_mday,t.tm_hour,t.tm_min,t.tm_sec,rus.ru_ixrss,rus.ru_idrss,rus.ru_isrss);
#else
	sprintf(buf,"ProcName : %s(%d)    ElapseTime : %d(day) %02d:%02d:%02d\n",
	        p,tMsgCtl.proc,t.tm_mday,t.tm_hour,t.tm_min,t.tm_sec);
#endif
#else
	sprintf(buf,"ProcName : %s(%d)    ElapseTime : %d(day) %02d:%02d:%02d\n\nMaxThreadTotal : %d   UsedThreadTotal : %d\n\nClassId    Option  DataSize  MaxThread  UsedCount  Name\n",
	        p,tMsgCtl.proc,t.tm_mday,t.tm_hour,t.tm_min,t.tm_sec,
	        tClassHead.max_thread_total,tClassHead.used_thread_total);
#endif
	if ((ret = akxtmcats(mcat,buf))<0) return ret;

	if ((ret = _statistics_class(buf,iopt,mcat)) < 0) return ret;

	if ((ret = _statistics_que(buf,mcat)) < 0) return ret;

	if ((ret = _statistics_edit(tval.tv_sec,buf,mcat)) < 0) return ret;

	if (iopt[1]) {
		if ((ret = _statistics_channel(buf,mcat)) < 0) return ret;

		if (iopt[1] & 0x02) {
			if ((ret = _statistics_rwbuf(buf,mcat)) < 0) return ret;
		}
		if (iopt[1] & 0x04) {
			if ((ret = _statistics_cha_rb(buf,mcat)) < 0) return ret;
		}
	}

	if (iopt[2]) {
		if ((ret = _statistics_Timer(buf,mcat)) < 0) return ret;
	}

	if (iopt[3]) {
		if ((ret = _statistics_time_out(buf,mcat)) < 0) return ret;
	}

	if ((ret = _statistics_memory(buf,mcat)) < 0) return ret;

	return ret;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _statistics_fileout(
	tv_sec,iUsedThreadTotal,lRbRUsed,lRbWUsed,lQueUsed)
int tv_sec,iUsedThreadTotal,lRbRUsed,lRbWUsed,lQueUsed;
{
	static char *format= " %d, %.2f, %d, %.2f, %.2f, %.2f, %.2f, %.0f, %.0f%c, %d, %d, %d, %d, %d,";
	char buf1[50],buf[1024],*p,*bufv[4];
	double dlavg;
	tdtSTAT_UNIT *pSu;
	int  n;
	char c,ca;
	int ret,t,lavg,i;
	uint T,S,U,D;

	n = tv_sec - tStatistics.check_time;
	if (n <= 0) return 0;

	pSu = &tStatistics.u[0];
	for (i=0;i<4;i++,pSu++) {
		pSu->msg_avg = (double)pSu->msg_count/n;
		if (pSu->msg_avg > pSu->msg_max)
			pSu->msg_max = pSu->msg_avg;
		pSu->msg_len_avg = pSu->msg_len/n;
		if (pSu->msg_len_avg > pSu->msg_len_max)
			pSu->msg_len_max = pSu->msg_len_avg;

		if (pSu->msg_max > pSu->msg_max0)
			pSu->msg_max0 = pSu->msg_max;
		if (pSu->msg_len_max > pSu->msg_len_max0)
			pSu->msg_len_max0 = pSu->msg_len_max;
	}

	if (tStatistics.opt[0]) {
		if ((t=tv_sec-tStatistics.start_time) <= 0) t = 1;

		sprintf(buf1," %d, %d, %d, %d,"
		,iUsedThreadTotal
		,lRbRUsed
		,lRbWUsed
		,lQueUsed);

		p = buf;
		pSu = &tStatistics.u[0];
		for (i=0;i<4;i++,pSu++,p+=256) {
			T = pSu->msg_total;
			S = pSu->msg_count_s;
			if (i == 2) {
				sprintf(p," %d, %.2f, %d, %.2f, %.2f, %.2f, %.2f"
				,T,(double)T/tv_sec,pSu->msg_count,pSu->msg_avg
				,(double)S/t,pSu->msg_max,pSu->msg_max0);
			}
			else {
				ca = ' ';
				if ((dlavg = pSu->msg_len_total/tv_sec) > 1.0E06) {
					dlavg /= 1.0E06;
					ca = 'M';
				}
				sprintf(p,format
				,T,(double)T/tv_sec,pSu->msg_count,pSu->msg_avg
				,(double)S/t,pSu->msg_max,pSu->msg_max0
				,pSu->msg_len_total,dlavg,ca,pSu->msg_len
				,pSu->msg_len_avg,pSu->msg_len_s/t
				,pSu->msg_len_max,pSu->msg_len_max0);
			}
			bufv[i] = p;
		}
		akb_log_out_main(D_LOG_NO_STATI,NULL,0,",%s%s%s%s%s",
		              buf1,bufv[0],bufv[1],bufv[3],bufv[2]);
	}

	tStat2 = tStatistics;

	tStatistics.check_time = tv_sec;
	pSu = &tStatistics.u[0];
	for (i=0;i<4;i++,pSu++) {
		pSu->msg_count = 0;
		pSu->msg_len = 0;
	}

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _statistics_edit(tv_sec,buf,mcat)
int  tv_sec;
char *buf;
MCAT *mcat;
{
	static char *name[]={" GetMsg"," PutMsg","   Exec","WaitMsg"};
	char c,ca,form[64],*pfm1,*pfm2;
	int ret,t,lavg,la,i,j,tm;
	uint T,S,U,D;
	double dlavg,dT;
	tdtSTAT_UNIT *pSu;

	if (tStatistics.timer_id) tm = tv_sec;
	else tm = tStatistics.check_time;
	if ((tm -= tStatistics.start_time) < 0) tm = 0;
	if ((t=tm) <= 0) t = 1;
	sprintf(buf,"\nStatistics : Interval=%d logout=%d measurement time=%d(sec)\n",
			tStatistics.interval,tStatistics.opt[0],tm);
	if ((ret = akxtmcats(mcat,buf))<0) return ret;

	if (tv_sec <= 0) tv_sec = 1;

	if ((ret = akxtmcats(mcat,"\n  MsgKind     Total  AvgTru(/s)    Count  Rate(/s)  Avg(/s)  Max(/s) MaxTru(/s)\n"))<0) return ret;
	for (j=0;j<4;j++) {
		if ((i=j) == 2) i = 3;
		else if (j == 3) i = 2;
		pSu = &tStatistics.u[i];
		T = pSu->msg_total;
		S = pSu->msg_count_s;
		sprintf(buf,"  %s%10d%11.2f%10d%10.2f%9.2f%9.2f%9.2f\n",name[i],
		        T,(double)T/tv_sec,tStat2.u[i].msg_count,
		        pSu->msg_avg,(double)S/t,
		        pSu->msg_max,pSu->msg_max0);
		if ((ret = akxtmcats(mcat,buf))<0) return ret;

		if (j == 3) continue;

		dT = pSu->msg_len_total;
		if (dT < 1.0E11) {
			pfm1 = "%10.0f ";
		}
		else if (dT < 1.0E13) {
			pfm1 = "%10.6fM";
			dT /= 1.0E10;
		}
		else {
			pfm1 = "%10.6fG";
			dT /= 1.0E12;
		}

		dlavg = dT/tv_sec;
		if (dlavg < 1.0E08) {
			pfm2 = "%7.0f ";
		}
		else if (dlavg < 1.0E13) {
			pfm2 = "%7.3fM";
			dlavg /= 1.0E07;
		}
		else {
			pfm2 = "%7.3fG";
			dlavg /= 1.0E12;
		}

/*		sprintf(buf,"Len(byte)%10.0f%c%7.0f%c%13d%6d%9d%9d%9d\n",	*/
		sprintf(form,"Len(byte)%s%s%%12d%%7d%%9d%%9d%%9d\n",pfm1,pfm2);
		sprintf(buf,form,
		        dT,dlavg,tStat2.u[i].msg_len,pSu->msg_len_avg,
		        pSu->msg_len_s/t,pSu->msg_len_max,pSu->msg_len_max0);
		if ((ret = akxtmcats(mcat,buf))<0) return ret;
	}

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _statistics_que(buf,mcat)
char *buf;
MCAT *mcat;
{
	int ret,w1;

	if (tMsgCtl.que_rwctl) w1 = tMsgCtl.que_rwctl->qct_used;
	else w1 = -1;
	sprintf(buf,"\nQUE : RbR=%d/%d RbW=%d/%d RbWW=%d/%d RWait=%d\n",
	        tMsgCtl.rb_rctl->rb_used,tMsgCtl.rb_rctl->rb_num,
	        tMsgCtl.rb_wctl->rb_used,tMsgCtl.rb_wctl->rb_num,
	        tMsgCtl.rb_wwctl->rb_used,tMsgCtl.rb_wwctl->rb_num,
	        w1);
	if ((ret = akxtmcats(mcat,buf))<0) return ret;

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _statistics_cha_rb(buf,mcat)
char *buf;
MCAT *mcat;
{
	int ret,w1,w2,w3,w4;
	tdtGENERAL_DATA *pD;
	int i,iMax,iSta;
	tdtRW_QUE *pQ;
	tdtRB_CTL  *pRbW;
	tdtRB_CTL  *pRbP;

	if ((pD=tMsgCtl.que_used_data) &&
	    tMsgCtl.write_que_pa && tMsgCtl.rb_pri_ctl_pa) {
		iSta = pD->gd_scale;
		iMax = akx_get_gen_int_data(pD) + pD->gd_resv;
/*
printf("_statistics_cha_rb: iSta=%d lResv=%d iMax=%d\n",iSta,pD->gd_resv,iMax);
*/
		strcpy(buf,"\nCHANNEL WRITE QUE:\n    i  Normal  Priority\n");
		if ((ret = akxtmcats(mcat,buf))<0) return ret;
		for (i=iSta;i<iMax;i++) {
			if ((pQ=tMsgCtl.write_que_pa[i]) && (pQ->rwq_sd>0)) {
				if (pRbW = tMsgCtl.rb_wctl_pa[i]) {
					w1 = pRbW->rb_used;
					w2 = pRbW->rb_num;
				}
				else {
					w1 = w2 = -1;
				}
				if (pRbP = tMsgCtl.rb_pri_ctl_pa[i]) {
					w3 = pRbP->rb_used;
					w4 = pRbP->rb_num;
				}
				else {
					w3 = w4 = -1;
				}
				sprintf(buf,"%5d %3d/%3d %3d/%3d\n",i,w1,w2,w3,w4);
				if ((ret = akxtmcats(mcat,buf))<0) return ret;
			}
		}
	}

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _statistics_rwbuf(buf,mcat)
char *buf;
MCAT *mcat;
{
	int ret,i,j;
	tdtRW_QUE *pQ,**ppQ;

	ppQ = tMsgCtl.read_que_pa;
	strcpy(buf,"\nReadBuf ");
	for (j=0;j<2;j++) {
		strcat(buf," No  Sock  Mode ToLen   Len  Wait    OutTime\n");
		if ((ret = akxtmcats(mcat,buf))<0) return ret;
		for (i=0;i<tMsgCtl.channel_used;i++,ppQ++) {
			if ((pQ = *ppQ) && (pQ->rwq_sd > 0)) {
				sprintf(buf,"%11d%6d     %c%6d%6d%6d%11d\n",i,pQ->rwq_sd,
				pQ->rwq_mode,pQ->rwq_torwlen,pQ->rwq_rwlen,pQ->rwq_wtime,pQ->rwq_otime);
				if ((ret = akxtmcats(mcat,buf))<0) return ret;
			}
		}
		ppQ = tMsgCtl.write_que_pa;
		strcpy(buf,"WriteBuf");
	}

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _statistics_Timer(buf,mcat)
char *buf;
MCAT *mcat;
{
	static char *stat[]={"start","stop "};
	int ret;
	char          *p;
	tdtTIMER_CTL   *next;

	if ((ret = akxtmcats(mcat,"\nTimerId  WaitTime(msec)  Status  Name\n"))<0)
		return ret;
	next = tMsgCtl.timer_ctl->th_ptimer;
	while (next) {
		if (next->tc_pfunc) {
			if (next->tc_status == AKX_TIMER_START) p = stat[0];
			else p = stat[1];
			sprintf(buf,"%7d  %8d         %s  %s\n",
			        next->tc_tmrid,
			        next->tc_watime, p,
			        next->tc_tmrname);
			if ((ret = akxtmcats(mcat,buf))<0) return ret;
		}
		next = next->tc_tmrnext;
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _statistics_time_out(buf,mcat)
char *buf;
MCAT *mcat;
{
	int ret,t[10],w1,w2;

	akb_get_time_out_set(t,6);
	w1 = w2 = -1;
	if (tMsgCtl.rwqtime_out) {
		w1 = tMsgCtl.rwqtime_out->rwt_rqto.qto_wait;
		w2 = tMsgCtl.rwqtime_out->rwt_wqto.qto_wait;
	}
	sprintf(buf,"\nComTimeOut(sec) : read=%d write=%d connect=%d accept=%d RQue=%d WQue=%d\nMsgTimeOut(msec): Send=%d\nRWQTimeOut(sec) : Read=%d Write=%d\n",
		t[0],t[1],t[2],t[3],t[4],t[5],
		tMsgCtl.send_msg_time_out,
		w1,w2);
	if ((ret = akxtmcats(mcat,buf))<0) return ret;

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _statistics_memory(buf,mcat)
char *buf;
MCAT *mcat;
{
	int  ret,n;
	long parm[12];

	akxm_stat_memory(12,parm);
	if ((n = Nofree(0)) < 0) n = parm[0] - parm[1] + parm[2];
	sprintf(buf,"\nMemory : malloc = %d(%d byte), free = %d, realloc = %d, remain = %d\n    ctl=[%s], maxreg=%d, af=[%s], nf=[%s]\n    Memcontl=%d, AFDUMP=%d, NFDUMP=%d, AFHASH=%d\n",
	parm[0],parm[3],parm[1],parm[2],n,
	parm[4],parm[5],parm[6],parm[7],
	parm[8],parm[9],parm[10],parm[11]);
	if (mcat) {
		if ((ret = akxtmcats(mcat,buf))<0) return ret;
	}

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
#define AKB_PASSWORD_EXPIRE	180000	/* msec */
#define AKB_PASSWORD_REGSIZE	5

static struct {
	uchar ucOpt;
	char  cPasswd[32];
} tPasswdCtl={0,0};

static int iPasswdRegMaxSize=0;
static struct {
	ushort usProcId;
	ushort usRsv;
	int    lEndTime;
	int    iTimerId;
} tPasswdReg[AKB_PASSWORD_REGSIZE];

static int _password_timer(iTimerId, cpTimerName, cpParm, tptime)
int iTimerId;
char *cpTimerName;
char *cpParm;
struct timeval *tptime;
{
	int i;

	for (i=0;i<iPasswdRegMaxSize;i++) {
		if (tPasswdReg[i].iTimerId == iTimerId) tPasswdReg[i].iTimerId = -1;
	}
	return -1;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_sys_password_class(lInstanceHandle,cpInstanceData,tpRecvMsg)
long lInstanceHandle;
char *cpInstanceData;
tdtMSG_COM *tpRecvMsg;
{
	char buf[128],msg[256];
	int  len,iRc,i,aki;
	tdtMSG_COM tReplyMsg;
	tdtGENERAL_DATA Parm, Parmd;

	if (tpRecvMsg->msg_disp == AKA_REGIST_CLASS) {
		iPasswdRegMaxSize = 0;
	/*
		memset(tPasswdReg,0,sizeof(tPasswdReg));
	*/
		return 0;
	}
	else if (tpRecvMsg->msg_disp == AKA_REGIST_CLASS+1) {
		memcpy(&tPasswdCtl,tpRecvMsg->msg_pmsg,sizeof(tPasswdCtl));
/*
printf("aka_sys_password_class:opt=%x passwd=[%s]\n",tPasswdCtl.ucOpt,tPasswdCtl.cPasswd);
*/
		return 0;
	}
	if (tpRecvMsg->msg_disp > 0 || tpRecvMsg->msg_pret < 0) {
		return 0;
	}
	if (tPasswdCtl.ucOpt) {
		strcpy(buf,"Error. Password is unmatch!!");
		if (tpRecvMsg->msg_mlen > 0) {
			memset(&Parm,0,sizeof(tdtGENERAL_DATA));
			Parm.gd_data   = tpRecvMsg->msg_pmsg;
			Parm.gd_dlen = tpRecvMsg->msg_mlen + 1;
			Parm.gd_code = akxt_get_code_type();
			Parmd.gd_code = Parm.gd_code;
			Parmd.gd_data    = NULL;
#if 1	/* NCAgʐMf[C܂ł̎b */
			{int pid[2];
				akb_get_term_base(pid);
				if (tpRecvMsg->msg_hoid != aka_get_my_host_id() &&
				    tpRecvMsg->msg_prid > pid[0] &&
				    tpRecvMsg->msg_prid <=pid[1])
					Parmd.gd_code = CD_TYPE_SJIS;
			}
#endif
			if ((len=akxt_code_trans(&Parm,&Parmd))<0) {
				sprintf(buf,"Error. Code transfer error(%d)!!",len);
			}
			else {
				if (Parmd.gd_data) Parm.gd_data = Parmd.gd_data;
			/*
				if (strcmp(Parm.gd_data,tPasswdCtl.cPasswd)) {
					strcpy(buf,"Error. Password is unmatch!!");
				}
				else {
			*/
				if (!strcmp(Parm.gd_data,tPasswdCtl.cPasswd)) {
					aki = -1;
					for (i=0;i<iPasswdRegMaxSize;i++) {
						if (tPasswdReg[i].iTimerId <= 0) aki = i;
						else if (tPasswdReg[i].usProcId==tpRecvMsg->msg_prid) {
							aki = i;
							break;
						}
					}
					if (i<AKB_PASSWORD_REGSIZE &&
					    i>=iPasswdRegMaxSize && aki<0) {
						aki = i++;
						iPasswdRegMaxSize++;
					}
/*
printf("aka_sys_password_class:aki=%d iPasswdRegMaxSize=%d\n",aki,iPasswdRegMaxSize);
*/
					if (aki < 0) {
						strcpy(buf,"Error. No entry!!");
					}
					else {
						if (tPasswdReg[aki].iTimerId > 0)
							aka_cancel_timer(tPasswdReg[aki].iTimerId);
						sprintf(buf,"proc%d",tpRecvMsg->msg_prid);
						iRc = aka_register_timer(buf,_password_timer,
												AKB_PASSWORD_EXPIRE,NULL);
						tPasswdReg[aki].iTimerId = iRc;
						if (iRc > 0) {
							tPasswdReg[aki].usProcId = tpRecvMsg->msg_prid;
						/*
							tPasswdReg[aki].lEndTime = aka_get_msec(NULL);
						*/
							sprintf(buf,"Ok. Password expire time = %d sec.",
								AKB_PASSWORD_EXPIRE/1000);
						}
						else {
							sprintf(buf,"Error. RegisterTimer (%d)!!",iRc);
						}
					}
				}
				if (Parmd.gd_data) Free(Parmd.gd_data);
			}
		}
	}
	else {
		strcpy(buf,"Ok. Password is not necessary.");
	}
	memset(&tReplyMsg,0,sizeof(tdtMSG_COM));
	if ((lInstanceHandle & 0xffff) == 2) {
		strcpy(msg,"R 0\n");
		len = strlen(msg);
	}
	else len = 0;
	sprintf(msg+len,"%s: %s",akb_log_get_proc_name(),buf);
	tReplyMsg.msg_pmsg = msg;
	tReplyMsg.msg_mlen = strlen(msg) + 1;
	aka_reply_msg(lInstanceHandle,&tReplyMsg);

	return 0;
}

int aka_sys_password_check(usProcId)
ushort usProcId;
{
	int i;

	if (!tPasswdCtl.ucOpt) return 0;
	for (i=0;i<iPasswdRegMaxSize;i++) {
		if (tPasswdReg[i].iTimerId>0 && tPasswdReg[i].usProcId==usProcId) {
/*
printf("aka_sys_password_check:OK usProcId=%d\n",usProcId);
*/
			return 0;
		}
	}
	return -1;
}

static char *_mem_usage[]=
{"Usage:"
,"get"
,"----------"
,"stop  [AFDUMP NFDUMP AFHASH]"
,"----------"
,"start [AFDUMP NFDUMP AFHASH]"
,"----------"
,"start -f xxxxx.ctl"
,"----------"
,"start -c {affile|.} {nffile|.} maxreg"
,"----------"
,"start -"
,"afhash:maxreg"
,"afdump:file name"
,"nfdump:file name"
,"----------"
,"dump addr len opt"
,NULL
};
/********************************************************/
/*                                                      */
/********************************************************/
static int sys_memory_class(lInstanceHandle,cpInstanceData,tpRecvMsg)
long lInstanceHandle;
char *cpInstanceData;
tdtMSG_COM *tpRecvMsg;
{
	char *msg,buf[512],*argv[8],work[256],*pi,c,*p;
	int  msglen,len,iRc,i,iusage,m,n,num,ret;
	long parm[8];
	tdtMSG_COM tReplyMsg;
	SSP_S ssp;

	if (tpRecvMsg->msg_disp == AKA_REGIST_CLASS ||
	    tpRecvMsg->msg_disp > 0 ||
	    tpRecvMsg->msg_pret < 0) {
		return 0;
	}
	iusage = 0;
	memset(&tReplyMsg,0,sizeof(tdtMSG_COM));

	if ((msglen=tpRecvMsg->msg_mlen) > 0) {
		msg = tpRecvMsg->msg_pmsg;
		ssp.sp = 0;
		n = akxtgetargv2(msg,argv,5,work,sizeof(work),5);
		if (n > 0) {
			pi = argv[0];
			if (!stricmp(pi,"get")) {
				_statistics_memory(buf,NULL);
			}
			else if (!stricmp(pi,"stop")) {
				parm[0] = 2;
				ret = 0;
				if (n >= 2) {
					parm[1] = 1;
					for (i=1;i<n;i++) {
						ret = akxcgcvn(argv[i],strlen(argv[i]),&num);
						if (ret) break;
						else parm[i+1] = num;
					}
				}
				else parm[1] = 0;
				if (ret) iRc = -4;
				else iRc = akxm_mem_cntl(n+1,parm);
				if (!iRc) strcpy(buf,"OK.");
				else if (iRc == 2) strcpy(buf,"already stopped!!");
				else sprintf(buf,"error!! ret=%d",iRc);
			}
			else if (!stricmp(pi,"start")) {
				parm[0] = 1;
				parm[1] = 0;
				if (n >= 2) {
					pi = argv[1];
					if (*pi == '-') {
						pi++;
						if (*pi == 'c') {
							parm[1] = 2;
							if (n >= 3) {
								if (*(p=argv[2]) && strcmp(p,"."))
									parm[2] = (long)p;
								else parm[2] = 0;
							}
							if (n >= 4) {
								if (*(p=argv[3]) && strcmp(p,"."))
									parm[3] = (long)p;
								else parm[3] = 0;
							}
							if (n >= 5) parm[4] = atoi(argv[4]);
							iRc = akxm_mem_cntl(n,parm);
						}
						else if (*pi == 'f') {
							iRc = akxm_mem_init(argv[2]);
						}
						else  if (*pi == '\0'){
							iRc = akxm_mem_init_msg(msg,msglen);
						}
						else iusage = 1;
					}
					else {
						parm[1] = 1;
						ret = 0;
						for (i=1;i<n;i++) {
							ret = akxcgcvn(argv[i],strlen(argv[i]),&num);
							if (ret) break;
							else parm[i+1] = num;
						}
						if (ret) iRc = -4;
						else iRc = akxm_mem_cntl(n+1,parm);
					}
				}
				else {
					iRc = akxm_mem_cntl(1,parm);
				}
				if (!iRc) strcpy(buf,"OK.");
				else if (iRc == 1) strcpy(buf,"already started!!");
				else if (iRc == 10) strcpy(buf,"not started!!");
				else if (iRc == 11) strcpy(buf,"can't restart to hash!!");
				else if (iRc == 12) strcpy(buf,"can't start to hash on the way!!");
				else sprintf(buf,"error!! ret=%d",iRc);
			}
			else if (!stricmp(pi,"dump")) {
				if (n >= 3) {
					parm[2] = 0;
					for (i=1;i<n;i++) {
						ret = akxcgcvn(argv[i],strlen(argv[i]),&num);
						if (ret) break;
						else parm[i-1] = num;
					}
					if (ret) sprintf(buf,"gcvn: error!! ret=%d",ret);
					else {
						if (parm[1] > 0) {
							ret = akxm_mem_check(parm[0],parm[1],parm[2]);
							if (ret > 0) {
								sprintf(work,"%s_mem.dump",akb_log_get_proc_name());
								akxafixdmp(work,akb_log_time(),parm[0],ret);
								strcat(work," dump len=%d");
								sprintf(buf,work,ret);
							}
							else if (ret < 0) sprintf(buf,"no allocated!! ret=%d",ret);
							else strcpy(buf,"allocated len=0 !!");
						}
						else strcpy(buf,"parmeter len<=0 !!");
					}
				}
				else iusage = 1;
			}
			else iusage = 1;
		}
		else iusage = 1;
	}
	else iusage = 1;
	if (iusage) {
		char **ph;
		ph = _mem_usage;
		p = buf;
		while (msg = *ph++) {
			len = strlen(msg);
			memcpy(p,msg,len);
			p += len;
			*p++ = '\n';
		}
		*p = '\0';
	}
	tReplyMsg.msg_pmsg = buf;
	tReplyMsg.msg_mlen = strlen(buf)+1;
	aka_reply_msg(lInstanceHandle,&tReplyMsg);

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _statistics_load(buf,iopt,mcat)
char *buf;
int  iopt[];
MCAT *mcat;
{
	static uint ulGetMsgTotal1=0,ulGetMsgAvg=0;
	static struct timeval tval1={0,0};
	struct timeval tval2;
	int   t;
	uint T;

	aka_get_msec(&tval2);
	t = akxe_timer_sub(NULL,&tval2,&tval1)/1000;
	/* O񂩂̌oߎԂPTb̂Ƃ́AO񑪒lԂB
	   Aŏ̂PTbԂ́A擾ɗƂ̑lԂB */
#ifndef OLD_STAT_TBL
	if (t < 15) {
		if (!akxe_timer_set(NULL,&tval1))
			ulGetMsgAvg = tStatistics.u[0].msg_total / t;
	}
	else {
		ulGetMsgAvg = (tStatistics.u[0].msg_total - ulGetMsgTotal1) / t;
		ulGetMsgTotal1 = tStatistics.u[0].msg_total;
		memcpy(&tval1,&tval2,sizeof(struct timeval));
	}
#else
	if (t < 15) {
		if (!akxe_timer_set(NULL,&tval1))
			ulGetMsgAvg = tStatistics.ulGetMsgTotal / t;
	}
	else {
		ulGetMsgAvg = (tStatistics.ulGetMsgTotal - ulGetMsgTotal1) / t;
		ulGetMsgTotal1 = tStatistics.ulGetMsgTotal;
		memcpy(&tval1,&tval2,sizeof(struct timeval));
	}
#endif
	sprintf(buf,"GetMsg: %d\n",ulGetMsgAvg);
/*
	if ((ret = akxtmcats(mcat,buf))<0) return ret;
*/
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int sys_help_class(lInstanceHandle,cpInstanceData,tpRecvMsg)
long lInstanceHandle;
char *cpInstanceData;
AKAMSGCOM *tpRecvMsg;
{
	static char *cpPath=NULL;
	static MCAT mcat={'M','C',4096,0,0,0,NULL,0};
	AKAMSGCOM    tReplyMsg;
	char *p,*argv[2],parm[128],buf[128];
	int n,iUsage=1,pret[2];
	FILE *fp;

	if (tpRecvMsg->msg_disp == AKA_REGIST_CLASS ||
	    tpRecvMsg->msg_disp > 0 ||
	    tpRecvMsg->msg_pret < 0) {
		return 0;
	}
	memset(&tReplyMsg,0,sizeof(tdtMSG_COM));
	tReplyMsg.msg_pmsg = buf;
	if (tpRecvMsg->msg_mlen > 0) {
		mcat.mc_ipos = 0;
		n = akxtgetargv(tpRecvMsg->msg_pmsg,argv,2,parm,sizeof(parm));
		if (n >= 2) {
			iUsage = 0;
			strnzcpy(buf,argv[0],sizeof(buf)-5);
			if (!strchr(buf,'.')) strcat(buf,".hlp");
/*
printf("sys_help_class: file=[%s]\n",buf);
*/
			p = akxt_add_dir2(akb_akb_help_dir(0),buf,&cpPath);
			if (!p) p = buf;
/*
printf("sys_help_class: path=[%s]\n",p);
*/
			fp = akxa_gs_fopen(p,argv[1],NULL,0,NULL,0,
			                 AKX_GSFOPEN_NO_CACHE | 1,pret);
			if (!fp) {
				if (pret[0] < 0) {
					if (pret[0] == -1)
						strcpy(buf,"system error!!");
					else if (pret[0] == -2)
						sprintf(buf,"file [%s] open error!!",p);
					else
						strcat(buf,"syntax error!!");
				}
				else sprintf(buf,"item [%s] not found!!",argv[1]);
			}
			else {
				while (akxa_read_line_opt(buf,sizeof(buf),fp,1)>=0 &&
				       *buf!='[') {
					if (*buf == '#') continue;
					akxtmcats(&mcat,buf);
				}
				fclose(fp);
				tReplyMsg.msg_pmsg = mcat.mc_bufp;
			}
		}
	}
	if (iUsage) {
		strcpy(buf,"HelpFileName HelpItemName");
	}
	tReplyMsg.msg_mlen = strlen(tReplyMsg.msg_pmsg) + 1;
	aka_reply_msg(lInstanceHandle,&tReplyMsg);

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int sys_property_class(lInstanceHandle,cpInstanceData,tpRecvMsg)
long lInstanceHandle;
char *cpInstanceData;
AKAMSGCOM *tpRecvMsg;
{
	AKAMSGCOM tReplyMsg;
	char buf[128];
	int iRc;

	if (tpRecvMsg->msg_disp == AKA_REGIST_CLASS) {
		return akb_set_property_all(0);
	}

	if (tpRecvMsg->msg_pret < 0) {
		return 0;
	}

	strcpy(buf,tpRecvMsg->msg_pmsg);
	memset(&tReplyMsg,0,sizeof(tdtMSG_COM));
	if (tpRecvMsg->msg_mlen > 0) {
		iRc = akb_get_inf_max_indirf(buf,sizeof(buf));
		if (iRc < 0) sprintf(buf,"ret=%d",iRc);
	}
	else {
		strcpy(buf,"GET\nSET indirf_size indirf_count spool delete/save");
	}
	tReplyMsg.msg_pmsg = buf;
	tReplyMsg.msg_mlen = strlen(tReplyMsg.msg_pmsg) + 1;
	aka_reply_msg(lInstanceHandle,&tReplyMsg);

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _statistics_class(buf, iopt, mcat)
char *buf;
int  iopt[];
MCAT *mcat;
{
	int ret,i,n,opt0_1,opt0_2;
	tdtCLASS_CTL   *tpClass;
	tdtINSTANCE   *tpIns;
	tdtWAIT_PACKET *tpNext;
	char          *p,*p2;
	tdtMETHOD *pMethod;

	opt0_1 = iopt[0] & 0x01;	/* display instance */
	opt0_2 = iopt[0] & 0x02;	/* display no_display class */
	tpClass = tClassHead.class;
	while (tpClass) {
		if (((tpClass->class_id >= AKA_CLASS_FSHUT) ||
		     ((tpClass->class_id < AKA_CLASS_FSHUT) &&
		      (tpClass->option & AKA_RCO_NODISPLAY))) && !opt0_2) {
			tpClass = tpClass->class_next;
			continue;
		}
		sprintf(buf,"%7d  %08x  %8d  %9d  %9d  %s",
		        tpClass->class_id,tpClass->option,
		        tpClass->instance_data_size,
		        tpClass->max_thread,tpClass->used_count,tpClass->class_name);
		if ((ret = akxtmcats(mcat,buf))<0) return ret;
		if (tpClass->func_name2) {
			if (!(p=tpClass->class_name2)) p = nullname;
			sprintf(buf,"(%s[%d])\n",p,tpClass->instance_data_size2);
		}
		else strcpy(buf,"\n");
		if ((ret = akxtmcats(mcat,buf))<0) return ret;
		/* print Method */
		if (pMethod=tpClass->method) {
			for (i=0;i<tpClass->max_method;i++,pMethod++) {
				if (!(p=pMethod->method_name)) p = nullname;
				if (!(p2=pMethod->explain)) p2 = nullname;
				sprintf(buf,"               method maxparm=%3d option=%08x [%s %s]\n",pMethod->max_parm,pMethod->option,p,p2);
				if ((ret = akxtmcats(mcat,buf))<0) return ret;
			}
		}
		/* print Instance */
		if (opt0_1 && tpClass->used_count > 0) {
			tpIns = &tpClass->instance[0];
			for (i=0;i<tpClass->max_thread;i++,tpIns++) {
				if (tpIns->used) {
					n = 0;
					tpNext = tpIns->wait_next;
					while (tpNext) {
						n++;
						tpNext = tpNext->wait_next;
					}
					sprintf(buf,"                   thread no=%3d wait packet =%3d",i+1,n);
					if ((ret = akxtmcats(mcat,buf))<0) return ret;
					if (tpIns->comment) {
						if ((ret = akxtmcats(mcat," <"))<0) return ret;
						if ((ret = akxtmcats(mcat,tpIns->comment))<0) return ret;
						if ((ret = akxtmcats(mcat,">"))<0) return ret;
					}
					if ((ret = akxtmcats(mcat,"\n"))<0) return ret;
				}
			}
		}
		tpClass = tpClass->class_next;
	}

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _statistics_channel(buf, mcat)
char *buf;
MCAT *mcat;
{
	int ret,i,n,iLen;
	tdtCHANNEL    *pCh,**ppCh;
	tdtREP_HEAD    *pRH;
	tdtCHANNEL_USER_IO *pCuio;
	pCOMM_PACK_HEAD pHd;
	char wrk[AKA_CHANNEL_SEQMAX*2+1];

	if ((ret = akxtmcats(mcat,"\nChannelNo Status Socket Select HeadLen Heads Opt   SysOpt\n"))<0) return ret;
/*	i = tMsgCtl.sChannelAkbUsed;	*/
	i = 0;
	ppCh = &tMsgCtl.channel_pa[i];
	for (;i<tMsgCtl.channel_used;i++,ppCh++) {
		if ((pCh = *ppCh) && pCh->status) {
			sprintf(buf,"%9d     %02x %6d %6d %7d %5d  %02x %08x\n",
			        pCh->index, pCh->status, pCh->sd,
			        pCh->select, pCh->head_len, pCh->resv4,
			        pCh->opt, pCh->sys_opt);
			if ((ret = akxtmcats(mcat,buf))<0) return ret;
#ifndef NO_CHANNEL_QUE
			akxs_que_move(pCh->wpack_que,QUE_TOP_PREV);
			while ((n=akxs_que_peek(pCh->wpack_que,QUE_NEXT,&pRH)) > 0) {
				if (pRH) {
					pHd = (pCOMM_PACK_HEAD )pRH;
					iLen = ntohl(pHd->cph_plen);
					wrk[akxcxtoc(pRH->sequence,iLen,wrk)] = '\0';
					sprintf(buf,"    Seq InstHandl=%08x len=%2d No=%s [%s]\n",
						pRH->instance_handle,iLen,wrk,pRH->sequence);
					if ((ret = akxtmcats(mcat,buf))<0) return ret;
				}
			}
#endif
			if (pCuio=pCh->cuio) {
				sprintf(buf,"\n    SelectInterval=%d Parm=%08x\n    Open    =%08x Connect =%08x Select  =%08x\n    Read    =%08x Write   =%08x WriteEnd=%08x\n    Shutdown=%08x Close   =%08x Accept  =%08x\n",
					pCuio->select_interval, pCuio->parm,
					pCuio->open, pCuio->connect, pCuio->select,
					pCuio->read, pCuio->write, pCuio->write_end,
					pCuio->shutdown, pCuio->close, pCuio->accept);
				if ((ret = akxtmcats(mcat,buf))<0) return ret;
			}
		}
	}

	return 0;
}
