/*
 *	nofree.c
 *
 *		coded   by A.Kobayashi 93/11/01
 *
 */
#include "akxcommon.h"
#define LINE_EXT	1000

typedef struct {
	int  line;
	char *text;
} tdtLineText;

char *addr_srch();

int main(argc,argv)
int argc;
char **argv;
{
	int i, linemax, ih, *indx, len, nkai,iEOF, num;
	char w[9], buf[128], *p, *s;
	FILE *nop, *mmp;
	XHASHB *pXh;
	tdtLineText tLT,*pLT;

	if (argc < 3) {
		printf("usage: %s mem.dump nofree.dump\n",argv[0]);
		exit(0);
	}
	if (!(nop=fopen(argv[2],"r"))) {
		printf("%s open error\n",argv[1]);
		exit(1);
	}
	linemax = LINE_EXT;
	pXh = akxs_xhash_new2(8,linemax,0,sizeof(tdtLineText));
	if (!(mmp=fopen(argv[1],"r"))) {
		printf("%s open error\n",argv[1]);
		exit(2);
	}
	i = 0;
	iEOF = 0;
	nkai = 0;
	indx = NULL;
while (!iEOF) {
	printf("***** Nofree(%3d) *****\n",++nkai);
	while (akxa_read_line(buf,128,mmp)) {
		i++;
		if (*buf=='*' && atoi(buf+13)==(nkai+1)) break;
		if (*buf=='a' || *buf=='r') {
			if (p=addr_srch(buf)) {
				ih = akxs_xhash2(pXh,'R',p+5,&pLT);
				if (ih > 0) {
					if (pLT->text) Free(pLT->text);
				}
				tLT.line = i;
				tLT.text = Strdup(buf);
				ih = akxs_xhash2(pXh,'S',p+5,&tLT);
/*
printf("line = %10d ih = %10d %s\n",i,ih,buf);
*/
				if (ih <= 0) {
					printf("Xhash2 error ret=%d at line=%d %s\n",ih,i,buf);
					exit(3);
				}
			}
			else {
				printf("not found 'addr' line=%d in %s\n",i,argv[1]);
			}
		}
	}
/*	fclose(mmp);	*/

	linemax = i;
	indx = (int *)MRealloc(indx,linemax*4);
	memset(indx,0,linemax*4);
	while (s=fgets(buf,128,nop)) {
		if (*buf != '*') {
			if (p=addr_srch(buf)) {
				ih = akxs_xhash2(pXh,'R',p+5,&pLT);
				if (ih > 0)
					indx[pLT->line-1] = ih;
			}
			else {
				printf("not found 'addr' in %s\n",argv[2]);
			}
		}
		else if (atoi(buf+13)==(nkai+1)) break;
	}
	if (!s) iEOF = 1;
/*	fclose(nop);	*/

	num = 0;
	for (i=0;i<linemax;i++) {
		if (ih=indx[i]) {
			pXh->xha_xhix = ih;
			ih = akxs_xhash2(pXh,'K',p+5,&pLT);
			printf("%10d %s",pLT->line,pLT->text);
			num++;
		}
	}
	printf("***** End   (%3d)(%d) *****\n",nkai,num);
}
	fclose(mmp);
	fclose(nop);
	exit(0);
}

char *addr_srch(p)
char *p;
{
	while (*p) {
		if (!memcmp(p,"addr",4)) return (p);
		p++;
	}
	return (0);
}
