/*******************************************/
/*						*/
/*	fctr	 			*/
/*		file code trans				*/
/*		by A.Kobayashi 2005.1.15	*/
/*						*/
/*******************************************/
#include	"akxcommon.h"

#define MAX_CTR	100
#define MAX_LEN	4096

typedef struct {
	int   col;
	int   nmj;
	short type[2];
	uchar ignr;
	uchar exch;
	char  dummy[2];
} tdtCtr;

static tdtCtr *tpCtr=NULL,*gpCtr;
static int  lrecl=0,nctr=0,sta_rec=1,num_rec=0,trec=0,max_ctr=0,rec_mode=0;
static int  iIGNR=0,iUWM=0,iCUT=0,iONLY=0;
static int  buf_len=MAX_LEN,dat_len;
static char *rec=NULL;
static FILE *fp=NULL;
static char *fname=NULL,*tfile=NULL;
static uchar grepc='\0';

static void _usage(pn)
char *pn;
{
	static char *h[]=
	{"usage: %s [-h|-?|-v] [--{e|p|d|l}[LOG_PARM]]"
	,"            [-l[ ]R[h] [-n[ ][Jns][,[s][,only]]][-c]"
	,"            [-t[ ]ϊݒt@C][-i[u]][-r[u|w|m]]"
	,"            [̓t@C|-]"
	,"  where"
	,"    LOG_PARM := FLAG,LEVEL,SIZE_MAX,FILE_MAX,OPTION,FILE,PRIORITY"
	""
	,NULL
	};
	char **ph,*p;

	ph = h;
	XERROROUTL5(0,*ph++,pn,0,0,0,0);
	while (p = *ph++) XERROROUTL5(0,"%s",p,0,0,0,0);
}

void _Exit(stat)
int stat;
{
	if (fp) fclose (fp);
	if (tpCtr) Free(tpCtr);
	if (rec) Free(rec);
	exit(stat);
}

static int _setctr(tfile)
char *tfile;
{
	tdtCtr *pCtr;
	FILE *fpc;
	char parm[128],*argv[5],buf[128],c,*p;
	int  i,n,m,ret,len,ignr;

	if (!tfile) return -1;
	if (!tpCtr) {
		if (!max_ctr) max_ctr = MAX_CTR;
		if (!(tpCtr=(tdtCtr *)Malloc(max_ctr*sizeof(tdtCtr)))) {
			XERROROUTL5(0,"setctr: Ctr table malloc error!!",0,0,0,0,0);
			return -2;
		}
		memset(tpCtr,0,max_ctr*sizeof(tdtCtr));
		pCtr = tpCtr;
	}
	else pCtr = gpCtr;

	XPRINTOUTL5(0,"setctr: tfile=[%s] max_ctr=%d nctr=%d",
	            tfile,max_ctr,nctr,0,0);
	if (!(fpc=fopen(tfile,"r"))) {
		XERROROUTL5(200,"setctr: %s open error",tfile,0,0,0,0);
		return -3;
    }

	ret = 0;
	while ((len = akxa_read_line(buf,sizeof(buf),fpc)) > 0) {
		n = akxtgetargv2(buf,argv,5,parm,sizeof(parm),1);
XDEBUGOUTL5(0,"setctr: buf=[%s] n=%d",buf,n,0,0,0);
		if (n >= 5) {
			if (nctr > max_ctr) {
				XERROROUTL5(0,"control table over(max=%d)!!",max_ctr,0,0,0,0);
				ret = -6;
				break;
			}
			if ((i=atoi(argv[1]))<=0 || (lrecl>0 && i>lrecl)) {
				XERROROUTL5(0,"column(%d) invalid!!",i,0,0,0,0);
				ret = -5;
				break;
			}
			pCtr->col = i - 1;
			m = atoi(argv[2]);
			if (lrecl>0 && i+m-1>lrecl) {
				XERROROUTL5(0,"len(%d) invalid!!",m,0,0,0,0);
				ret = -5;
				break;
			}
			pCtr->nmj = m;
			for (i=0;i<2;i++) {
				c = *argv[i+3];
				m = akxt_get_code_type();
				if (c=='K' || c=='H') m = CD_TYPE_EBCDIK;
				else if (c == 'S') m = CD_TYPE_SJIS;
				pCtr->type[i] = m;
			}
			if (n >= 6) {
				if (!strncmp(p = argv[5],"-i",2)) {
					p += 2;
					ignr = 1;
					m = strlen(++p);
					c = *p;
					if (m>1 && c>='0' && c<='9') {
						ignr = 2;
						if (ret = akxcgcvn(p,m,&i)) {
							XERROROUTL5(0,"rep code(%d) invalid ret=%d!!",
							p,ret,0,0,0);
							break;
						}
						pCtr->exch = (uchar)(i & 0xff);
					}
					pCtr->ignr = ignr;
				}
			}
			nctr++;
			XPRINTOUTL5(0,"setctr: nctr=%d col=%d nmj=%d type=%d to %d",
				nctr,pCtr->col+1,pCtr->nmj,pCtr->type[0],pCtr->type[1]);
			pCtr++;
		}
	}
	fclose(fpc);
	gpCtr = pCtr;
	return ret;
}

static int _getopt(argc, argv)
int  argc;
char *argv[];
{
	char parm[128],*argv2[3];
	uchar c1,c2,*p,c;
	char *p1,*p2,*pr;
	int n,ret,i;

	fp = NULL;
	fname = NULL;
	ret = 1;
	while (argc > 0) {
		p = (uchar *)*argv;
		c1 = *p;
		if (c1 == '-') {
			p++;
			c2 = *p;
			if (c2=='l' || c2=='n' || c2=='t') {
				if (*(p+1)) p++;
				else if (--argc > 0) {
					argv++;
					p = argv[0];
					if (*p == '-') {
						ret = 1;
						break;
					}
				}
				else {
					ret = 1;
					break;
				}
				if (c2=='l') {
					lrecl = atoi(p);
					if (lrecl <= 0) {
						XERROROUTL5(0,"lrecl(%d) <= 0",lrecl,0,0,0,0);
						_Exit(10);
					}
					if (rec) rec=Realloc(rec,lrecl+1);
					else rec=Malloc(lrecl+1);
					if (!rec) {
						XERROROUTL5(0,"rec buff malloc error!!",0,0,0,0,0);
						_Exit(3);
					}
					rec_mode = 1;
					dat_len = lrecl;
					if (!max_ctr) {
						if ((max_ctr = lrecl/10)<MAX_CTR) max_ctr = MAX_CTR;
					}
				}
				else if (c2 == 'n') {
					n = akxtgetargv2(p,argv2,3,parm,sizeof(parm),5);
					if (n >= 1) sta_rec = atoi(argv2[0]);
					if (n >= 2) num_rec = atoi(argv2[1]);
					if (n >= 3) {
						if (!stricmp(argv2[2],"ONLY")) iONLY = 1;
					}
				}
				else if (c2 == 't') {
					if (ret = _setctr(p)) return ret;
				}
			}
			else if (c2 == 'i') {
				iIGNR = 1;
				n = strlen(++p);
				c = *p;
				if (n>1 && c>='0' && c<='9') {
					iIGNR = 2;
					if (ret = akxcgcvn(p,n,&i)) {
						XERROROUTL5(0,"rep code(%d) invalid ret=%d!!",
						p,ret,0,0,0);
						return ret;
					}
					grepc = (uchar)(i & 0xff);
				}
			}
			else if (c2 == 'c') {
				iCUT = 1;
			}
			else if (c2 == 'r') {
				iUWM = 1;
				if (c = *(++p)) {
					if (c == 'u') iUWM = 1;
					else if (c == 'w') iUWM = 2;
					else if (c == 'm') iUWM = 3;
					else return -4;
				}
			}
			else if (c2 == '-') {
				p++;
				if (akx_log_set_command_parm(*p,p+1) < 0) return -4;
			}
			else if (!c2) {
				fname = "stdin";
				fp = stdin;
				ret = 0;
			}
			else return -3;
		}
		else {
			fname = (char *)p;
			ret = 0;
		}
		argc--;
		argv++;
	}
	return ret;
}

static int _k_to_s(buf,len,opt,repc)
uchar *buf,repc;
int  len,opt;
{
	static uchar k_to_s[]=
		{' ','','','','','','','','','','[','.','<','(','+','!'
		,'&','','','','','','', 0 ,'','a',']','$','*',')',';','^'
		,'-','/','b','c','d','e','f','g','h','i','|',',','%','_','>','?'
		,'j','k','l','m','n','o','p','q','r','`',':','#','@','\'','=','"'
		,'s','','','','','','','','','','','t','','','',''
		,'','','','','','','','','','','','u','v','','',''
		,'w','~','','','','','','','','','','x','','','',''
		,'y','z', 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,'','','','','',''
		,'{','A','B','C','D','E','F','G','H','I', 0 , 0 , 0 , 0 , 0 , 0
		,'}','J','K','L','M','N','O','P','Q','R', 0 , 0 , 0 , 0 , 0 , 0
		,'\\','0','S','T','U','V','W','X','Y','Z', 0 , 0 , 0 , 0 , 0 , 0
		,'0','1','2','3','4','5','6','7','8','9', 0 , 0 , 0 , 0 , 0 , 0
		};
	int i,iuf;
	uchar *p,uf,ut;

	p = buf;
	for (i=0;i<len;i++) {
		uf = *p;
		if ((iuf=uf) < 0x40) {
			if (opt) {
				ut = uf;
				if (opt == 2) ut = repc;
			}
			else return i+1;
		}
		else {
			iuf -= 0x40;
			if (!(ut = k_to_s[iuf])) {
				if (opt) {
					ut = uf;
					if (opt == 2) ut = repc;
				}
				else return i+1;
			}
		}
		*p++ = ut;
	}
	return 0;
}

static int _ctr()
{
	int i,j,nm,pos,len,ret,t1,t2,ignr;
	char *p,*pr,repc;
	tdtCtr *pCtr;

	for (;;) {
		if (rec_mode) {
			if (!fread(rec,1,lrecl,fp)) break;
		}
		else {
			if ((len=akxa_get_line(rec,buf_len,fp,0x01)) < 0) break;
			XDEBUGOUTL5(0,"1st  len=%d",len,0,0,0,0);
			pos = 0;
			lrecl = len;
			while (rec[lrecl-1] != '\n') {
				pos += len;
				buf_len += MAX_LEN;
				if (!(rec=Realloc(rec,buf_len))) {
					XERROROUTL5(0,"rec buff malloc error!!",0,0,0,0,0);
					_Exit(3);
				}
				if ((len=akxa_get_line(rec+pos ,MAX_LEN , fp, 0x01)) < 0) break;
				XDEBUGOUTL5(0,"next len=%d",len,0,0,0,0);
				lrecl += len;
			}
			dat_len = lrecl - 1;
		}
		if (++trec < sta_rec) {
			if (iONLY) fwrite(rec,1,lrecl,stdout);
		}
		else if (num_rec>0 && trec>=num_rec) {
			if (iONLY) fwrite(rec,1,lrecl,stdout);
			else break;
		}
		else {
			pCtr = tpCtr;
			for (i=0;i<nctr;i++,pCtr++) {
				pos = pCtr->col;
				p = rec+pos;
				if ((nm = pCtr->nmj) < 0) nm = lrecl - pos;
				else nm = X_MIN(nm,lrecl-pos);
				if (pCtr->ignr) {
					ignr = pCtr->ignr;
					repc = pCtr->exch;
				}
				else {
					ignr = iIGNR;
					repc = grepc;
				}
				t1 =pCtr->type[0];
				t2 =pCtr->type[1];
				if (t1 != t2) {
					if (t1==CD_TYPE_EBCDIK && t2==CD_TYPE_SJIS) {
						if (ret = _k_to_s(p,nm,ignr,repc)) {
							XERROROUTL5(0,"rec=%d pos=%d code invalid(%02x)!!",
								trec,pos+ret,*(p+ret-1),0,0);
							return -1;
						}
					}
				}
				if (iCUT) fwrite(p,1,nm,stdout);
			}
			if (!iCUT) fwrite(rec,1,lrecl,stdout);
			if (rec_mode && iUWM) {
				if (iUWM >= 2) putc('\r',stdout);
				if (iUWM <= 2) putc('\n',stdout);
			}
		/*	if (!iONLY && num_rec>0 && trec>=num_rec) break;	*/
		}
	}
	return 0;
}

int main(argc,argv)
int  argc;
char *argv[];
{
	char *p;

	p = akxt_get_last_name("\\/",argv[0]);
	akx_log_set_up_name(p);
	XLOGFLG(X_LOG_NO_ERROR,D_LOG_FLG_STDERR);
	XLOGFLG(X_LOG_NO_PRINT,D_LOG_FLG_STDERR);

	XPRINTOUTL5(0,"V1.0 (c) Copyright CSK 2005",p,0,0,0,0);
	if (--argc <= 0) {
		_usage(p);
		exit(0);
	}
	argv++;
	if (_getopt(argc, argv)) {
		_usage(p);
		_Exit(1);
	}

	if (!fp) {
		if (fname) {
			fp = fopen(fname,"rb");
			if (!fp) {
				XERROROUTL5(0,"file[%s] open error!!",fname,0,0,0,0);
				_Exit(2);
			}
		}
		else {
			fname = "stdin";
			fp = stdin;
		}
	}

	if (lrecl <= 0) {
		if (!(rec=Malloc(buf_len))) {
			XERROROUTL5(0,"rec buff malloc error!!",0,0,0,0,0);
			_Exit(3);
		}
	}

	XPRINTOUTL5(0,"start: file=[%s] sta_rec=%d num_rec=%d iONLY=%d",
		fname,sta_rec,num_rec,iONLY,0);
	XPRINTOUTL5(0,"       rec_mode=%d lrecl=%d iUWM=%d iCUT=%d",
		rec_mode,lrecl,iUWM,iCUT,0);
	XPRINTOUTL5(0,"       nctr=%d iIGNR=%d repc=[%c](0x%02x) dat_len=%d",
		nctr,iIGNR,akxctoank(grepc),grepc,dat_len);

	_ctr();

	XPRINTOUTL5(0,"end  : trec=%d",trec,0,0,0,0);

	_Exit(0);
}
