static char sccsid[]="%Z% %M% %I% %D% %T%";
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*      coded by A.Kobayashi ()    1996/2/1                               */
/*                                                                           */
/*****************************************************************************/
#include "somn.h"                 /* ʃwb_   */

#define PARMPRINT(x,y)  printf("%s = [%s]\n",x,y);
#define PRINTF(x) 

char *Puserid="/";

qDipCT  qdipCT;
qDist   qidist[MAX_COLUMN];
qDist   qiitmn[MAX_COLUMN];
qDist   qodist[MAX_COLUMN];
qParm   qarg;

HASHB  *gp_hx_sel_term=NULL;
tdtRB_CTL *gp_rb_log_file=NULL;
int     gi_log_file[SO_LOG_TERM_MAX];
int     gi_log_send_status=1;
int     gi_log_send_proc=0;
int     gi_log_send_type=0;
long    gl_log_send_host=0;
tdtRB_CTL *gp_rb_log_msg_ctl=NULL;
tdtRB_CTL *gp_rb_sql_ctl=NULL;
int     gi_sql_timer_id=0;
int     gi_sqlinterval=0;
int     gi_sql_exec_max=1;
int     gi_sql_rb=0;
int     gi_msg_count_max=0;
int     gi_sql_exec_rate=80;
char   *gcp_log_get_id_port=NULL;

extern int so_log_class();
extern int so_log_class2();
extern int so_log_notify();
extern int so_log_shut();

/*******************************************/
/*   Exit                                  */
/*******************************************/
void so_log_exit(rc)
int rc;
{
    so_log_sqlend(&qdipCT,rc);
#ifdef MEMCTL
    PRINTOUT1("nofree no=%d",Nofree(0));
#endif
    exit(rc);
}

/*******************************************/
/*                                         */
/*******************************************/
static int _exec_sql(iTimerId, cpTimerName, cpParm, tptime)
int iTimerId;
char *cpTimerName;
char *cpParm;
struct timeval *tptime;
{
	qCmdInf   *pCmdInf;
	int i,iRc;
	char *p;
/*
printf("_exec_sql: now=%d.%06d gi_sql_rb=%d\n",tptime->tv_sec,tptime->tv_usec,gi_sql_rb);
*/
	for (i=0;i<gi_sql_exec_max;i++) {
		if (p=akxs_rb_get_n(gp_rb_sql_ctl)) {
			so_log_rotate(p+sizeof(qCmdInf));
			pCmdInf = (qCmdInf *)p;
			iRc = so_log_sql(pCmdInf,NULL,&qdipCT);
			Free(pCmdInf->szSQL);
			Free(pCmdInf);
		}
		else {
		/*	if (!gi_sql_rb) */
				aka_stop_timer(1,&iTimerId);
/*
printf("_exec_sql: Stop Timer\n");
*/
			break;
		}
	}
/*
	if ((i=gi_msg_count_max*gi_sql_exec_rate/100) <= 0) i = 1;
	gi_sqlinterval = 1000*gi_sql_exec_max/i;
printf("_exec_sql: gi_sqlinterval = %d (msec)\n",gi_sqlinterval);
*/
	return gi_sqlinterval;
}

/*******************************************/
/*                                         */
/*******************************************/
static int _get_id_exception(iCh,iEvent)
int iCh;
int iEvent;
{
	ERROROUT2("GetId: Channel Exception: channel=%d  event=%d",iCh,iEvent);
	return 0;
}

/*******************************************/
/*                                         */
/*******************************************/
static int _get_id_connect(pCh,iSd)
tdtCHANNEL *pCh;
int iSd;
{
    tdtCHANNEL_OPEN tChannel;
    int iCh;

    memset(&tChannel,0,sizeof(tdtCHANNEL_OPEN));
    tChannel.sd   = iSd;
    tChannel.opt = AKA_CHSO_USE_AKB_HEAD;
    tChannel.exception = _get_id_exception;
    iCh = aka_channel_open(&tChannel);
PRINTOUT1("GetIdConnect: iCh=%d",iCh);
	return 0;
}

/*******************************************/
/*                                         */
/*******************************************/
static int _init()
{
	int i,iCh;
	tdtCHANNEL_OPEN tChannel;

	if (gi_msg_count_max> 0) {
		if (gp_rb_sql_ctl = akxs_rb_new(0,0)) {
/*
			if ((i=gi_msg_count_max*gi_sql_exec_rate/100) <= 0) i = 1;
			gi_sqlinterval = 1000*gi_sql_exec_max/i;
printf("init: gi_sqlinterval = %d (msec)\n",gi_sqlinterval);
*/
			gi_sqlinterval = 3000;
			if ((gi_sql_timer_id=aka_register_timer("SQL TIMER",_exec_sql,
			                                   gi_sqlinterval,NULL)) > 0) {
				PRINTOUT1("SQL TimerId = %d",gi_sql_timer_id);
				aka_stop_timer(1,&gi_sql_timer_id);
			}
			else {
				ERROROUT1("SQL RegisterTimer error = %d",gi_sql_timer_id);
				akxs_rb_free(gp_rb_sql_ctl);
				gp_rb_sql_ctl = NULL;
				gi_sqlinterval = 0;
			}
		}
		else gi_sqlinterval = 0;
	}

	if (gcp_log_get_id_port) {
		memset(&tChannel,0,sizeof(tdtCHANNEL_OPEN));
		tChannel.host_name = "*";
		tChannel.service = gcp_log_get_id_port;
		tChannel.head_check = _get_id_connect;
		tChannel.exception = _get_id_exception;
		iCh = aka_channel_open(&tChannel);
		PRINTOUT2("GetIdPort: service=[%s] iCh=%d",tChannel.service,iCh);
	}
	return 0;
}

/*****************************************************************************
*                                                                            *
*      ړI@@F  C                                                *
*                                                                            *
*      ֐@@@F@void main(argc, argv)                                 *
*                                                                            *
*            F@(I)int    argc                                        *
*                      (I)char * argv[]                                      *
*                                                                            *
*      ߂l@@@F@                                    @            *
*                                                                            *
*      Tv@@F@                                              *
*                                                                            *
*****************************************************************************/
int main( argc, argv )
int   argc;
char *argv[];
{
	int iRc;
	int ret,iSd,iProcId,iCmdNo;
	char *cpProcName,service[256];

	/****************************************************/
	/* vZXǗNꂽƂ́Aȉn */
	/*   argv[1]:ڑς݂̃\Pbgԍ (Sd)            */
	/*   argv[2]:vZXԍ           (ProcId)        */
	/*   argv[3]:vZX             (ProcName)      */
	/*   argv[4]:p[^             (Parm)          */
	/****************************************************/
	cpProcName = akxt_get_last_name("\\/",argv[0]);
	if (argc < 3) {
		fprintf(stderr,"Usage: %s {SocketId|0} ProcId [ProcName]\n",cpProcName);
		exit( 1 );
	}
#ifdef TIME
	akb_ptime('I',"pwlogtime.log");
	akb_ptime('S',"NULL");
	akb_ptime('E',"NULL");
#endif
#ifdef MEMCTL
	Meminit("pwMemory.ctl");
#endif

	iSd     = atoi(argv[1]);
	iProcId = atoi(argv[2]);
	if (argc >= 4) cpProcName = argv[3];
	akb_log_set_log_name(D_LOG_NO_SOLOG,"SOLOG_LOG");
	akb_log_set_up_name(cpProcName);

	if (iSd == 0) {
		iSd = akb_connect_prom(0,0);
		PRINTOUT1("akb_connect_prom ret=%d",iSd);
		if (iSd <= 0) exit(1);
	}
	else if (iSd < 0) iSd = 0;	/* exit(2); */

DEBUGOUT2("Socket=%d, ProcId=%d",iSd,iProcId);
	/*
	 * 
	 */
	/* \̂\̃e[uɃZbg */
	qdipCT.nidist = 0;
	qdipCT.nodist = 0;
	qdipCT.nclist = 0;
	qdipCT.pparm  = &qarg;
	qdipCT.pidist = qidist;
	qdipCT.piitmn = qiitmn;
	qdipCT.podist = qodist;
	if (so_getenvf(qdipCT.pparm)) exit(1);
	if (iRc=so_log_sqlinit(&qdipCT)) {
		ERROROUTRC("init error =",iRc);
		exit(99);
	}
	/* SQL command  log file 폜
	unlink(SQL_LOG_FILE);
	*/
	/* ʃt@C폜p */
#ifdef TERM_HASX
	gp_hx_sel_term = akxs_hasx_new(2,SO_LOG_TERM_MAX,0);
#else
	gp_hx_sel_term = akxs_hasl_new(4,SO_LOG_TERM_MAX,0);
#endif
	gp_rb_log_file = akxs_rb_new(0,0);
	memset((char *)gi_log_file,0,sizeof(gi_log_file));
	gp_rb_log_msg_ctl = akxs_rb_new(0,0);

	/* N̒ʒmpPbg */
	ret = aka_regist(iSd,iProcId);
	if (ret) ERROROUTRC("aka_regist ret=",ret);
	else {
		ret = aka_initialize(iSd,iProcId,0);
		if (ret) ERROROUTRC("aka_initialize ret=",ret);
		else {
			so_log_request();
			so_log_send_watch();
			ret = aka_register_class2(so_log_class,1,0,1,0,"LOG_GET/PUT/SAVE");
			if (ret) ERROROUTRC("aka_register_class ret=",ret);
			else if (ret = aka_register_class2(so_log_class2,2,0,1,0, "LOG_WATCH"))
				ERROROUT1("aka_register_class(SendWatch) ret=%d",ret);
			else if (ret = aka_register_class2(so_log_notify,AKA_CLASS_NOTIFY,0,1,0,
			                   "LOG_NOTIFY"))
				ERROROUT1("aka_register_class(Notify) ret=%d",ret);
			else if (ret = aka_register_class2(so_log_shut,
			            AKA_CLASS_SHUT|AKA_CLASS_ADDFUNC2,16,2,0,"LOG_SHUT"))
				ERROROUT1("aka_register_class(Shut) ret=%d",ret);
			else if (ret = aka_register_class2(so_log_shut,
			            AKA_CLASS_FSHUT|AKA_CLASS_ADDFUNC2,0,0,-1,"LOG_FSHUT"))
				ERROROUT1("aka_register_class(FShut) ret=%d",ret);
			else {
				PRINTOUT("**** Start ****");
				_init();
				/* Iv܂Ń[v */
				while ((ret = aka_get_msg(-1))>=0) {
					if (ret = aka_dispatch_msg()) break;
				}
				PRINTOUT1("aka_get_msg/Dispatch ret=%d",ret);
			/*	if (ret == D_ERR_READ_SOCKET) iSd = -1;	*/
			}
			aka_terminate();
		}
		aka_cancel(iSd,iProcId);
	}
	if (iSd > 0) aka_shut_down(iSd);

	/* OǗI */
#ifdef TIME
	akb_ptime('T',NULL);
#endif
	so_log_exit(0);
}

/*******************************************/
/*                                         */
/*******************************************/
#define SETARG(x,y)  \
    if (!strcmp(argv[0],x)) {\
        if (!(y)) {\
            if (!(y = malloc(strlen(argv[1])+1)))\
                return (ERROR_MALLOC);\
            strcpy(y,argv[1]);\
        }\
	}
/*
printf("%s=[%s]\n",x,y);\
    }
*/
 
/*******************************************/
/*                                         */
/*******************************************/
#define BUFF_SIZE 256
#define MAXARGC     3
 
int di_getenvf(p)
qParm *p;
{
    char buf[BUFF_SIZE],*argv[MAXARGC],parm[BUFF_SIZE];
    int i,f;
    FILE   *fp = NULL ;
 
    if (!(p->envfile)) {
        if (!(p->envfile=malloc(strlen(ENVFILE)+1))) return (ERROR_MALLOC);
        strcpy(p->envfile,ENVFILE);
    }
    if ((fp=fopen(p->envfile,"r"))) {
        while (fgets(buf,BUFF_SIZE,fp)) {
            if (*buf == '#') continue;
            if ((i=getargv(buf,argv,MAXARGC,parm,BUFF_SIZE))<2)
                continue;
            SETARG(ID_LOGIN,p->logname)
            SETARG(ID_PASSWD,p->password)
            SETARG(ID_DBNAME,p->database)
            SETARG(ID_NETNAME,p->netname)
            SETARG(ID_USERID,p->userid)
            if (!strcmp(argv[0],ID_BUFSIZE)) {
                if (p->buf_size == 0)
                    p->buf_size = atoi(argv[1]);
            }
        }
        fclose(fp);
    }
    return(0);
}

/*******************************************/
/*                                         */
/*******************************************/
int so_getenvf(p)
qParm *p;
{
	char buf[BUFF_SIZE], *cpDir,*argv[4];
	int iRc;

	/* OpfBNg̎擾 */
	iRc = akb_gs_akbname(ID_ETC,ID_LOGDIR,buf);
	if (iRc<=0) {
	/*
		ERROROUT("so_getenvf:OpfBNg̎w肪Ȃ");
	*/
		ERROROUT("so_getenvf:undefined LOGDIR.");
		return -14010001;
	}
	cpDir = akb_akb_home_add(buf);
	if (!(p->database = Malloc(strlen(cpDir)+1))) return ERROR_MALLOC;
	strcpy(p->database,cpDir);
	PRINTOUT2("so_getenvf:%s=[%s]",ID_LOGDIR,cpDir);

	/* OspoolfBNg̎擾 */
	iRc = akb_gs_akbname(ID_ETC,ID_LOGSPOOLDIR,buf);
	if (iRc<=0) {
	/*
		ERROROUT("so_getenvf:LOGSPOOLDIR `AJggpB");
	*/
		ERROROUT("so_getenvf:undefined LOGSPOOLDIR,use current directory.");
		*buf = '\0';
	}
/*	̃fBNgԐڃt@CɎgp邽߂ł͕tȂB
	ʂt@Cɏo͂ƂɕtB
	cpDir = akb_akb_home_add(buf);
*/
	cpDir = buf;
	if (!(p->msgfile = Malloc(strlen(cpDir)+1))) return ERROR_MALLOC;
	strcpy(p->msgfile,cpDir);
	PRINTOUT2("so_getenvf:%s=[%s]",ID_LOGSPOOLDIR,cpDir);

	/* O]vZX̎擾 */
	iRc = akb_gs_akb_stpl(ID_ETC,ID_LOGSENDPROC,argv,4);
	if (iRc >= 2) {
		if ((gi_log_send_proc=atoi(argv[1])) <= 0) {
			strnzcpy(buf,argv[1],sizeof(buf)-1);
			gi_log_send_proc = akb_get_proc_id(buf);
		}
	}
	if (iRc >= 3) {
		iRc = akb_get_host_addr(argv[2],&gl_log_send_host);
	}
	PRINTOUT2("so_getenvf:gi_log_send_proc=%d gl_log_send_host=%08x",
		gi_log_send_proc,gl_log_send_host);

	/* Oxݏ̎擾 */
	iRc = akb_gs_akb_stpl(ID_ETC,"LOG_PUT_TIMER",argv,4);
	if (iRc >= 2) {
		if ((gi_msg_count_max=atoi(argv[1])) < 0) gi_msg_count_max = 0;
	}
	if (iRc >= 3) {
		if ((gi_sql_exec_rate=atoi(argv[2])) < 1) gi_sql_exec_rate = 100;
	}
	if (iRc >= 4) {
		if ((gi_sql_exec_max=atoi(argv[3])) < 1) gi_sql_exec_max = 1;
	}
	PRINTOUT3("so_getenvf:gi_msg_count_max=%d gi_sql_exec_rate=%d(%%) gi_sql_exec_max=%d",
		gi_msg_count_max,gi_sql_exec_rate,gi_sql_exec_max);

	/* Ohc擾ڑ̎擾 */
	iRc = akb_gs_akb_stpl(ID_ETC,"LOG_GETID_PORT",argv,2);
	if (iRc >= 2) {
		if (gcp_log_get_id_port=Strdup(argv[1]))
			PRINTOUT1("so_getenvf:gcp_log_get_id_port=[%s]",gcp_log_get_id_port);
	}
	return 0;
}

/*******************************************/
/*                                         */
/*******************************************/
int	so_log_request()
{
	AKAMSGCOM tSendMsg;
	int iRc;
	ushort usw[2],sW;

	sW = AKB_CMD_REQUEST;
	usw[0] = htons(sW);
	sW = AKB_CMD_NOTIFY<<8 | 2;
	usw[1] = htons(sW);
	memset(&tSendMsg,0,sizeof(AKAMSGCOM));
	tSendMsg.msg_prid = 3;
	tSendMsg.msg_clid = 1;
	tSendMsg.msg_pmsg     = (char *)usw;
	tSendMsg.msg_mlen   = 4;
	iRc = aka_post_msg(0,&tSendMsg);
	return iRc;
}

/*******************************************/
/*                                         */
/*******************************************/
int so_log_send_watch()
{
	AKAMSGCOM tSendMsg;
	int iRc;

	memset(&tSendMsg,0,sizeof(AKAMSGCOM));
	tSendMsg.msg_clid = 2;
/*
	tSendMsg.msg_pmsg     = (char *)&iProc;
	tSendMsg.msg_mlen   = 4;
*/
	iRc = aka_post_msg(0,&tSendMsg);
	return iRc;
}
