static    char    sccsid[]="%Z% %M% %I% %D% %T%";
/*************************************************
 *
 *  akxetimer.c
 *
 *        coded by A.Kobayashi 2000/2/23
 *
 *************************************************/
#include "akunix.h"
#include "akx.h"

/********************************************************/
/*                                                      */
/********************************************************/
int akxe_timer_set(ptvalo,ptvali)
struct timeval *ptvalo,*ptvali;
{
	int t_sec,t_usec;

	if (ptvali) {
		t_sec  = ptvali->tv_sec;
		t_usec = ptvali->tv_usec;
	}
	else {
		t_sec  = t_usec = 0;
	}
	if (ptvalo) {
		ptvalo->tv_sec  = t_sec;
		ptvalo->tv_usec = t_usec;
	}

	return t_sec*1000 + t_usec/1000;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akxe_timer_add(ptvalo,ptvali,ptval2)
struct timeval *ptvalo,*ptvali,*ptval2;
{
	int t_sec,t_usec;

	if (ptvali) {
		t_sec  = ptvali->tv_sec;
		t_usec = ptvali->tv_usec;
	}
	else {
		t_sec  = t_usec = 0;
	}
	if (ptval2) {
		t_sec  += ptval2->tv_sec;
		t_usec += ptval2->tv_usec;
	}
	if (t_usec >= 1000000) {
		t_sec++;
		t_usec -= 1000000;
	}
	else if (t_usec < 0) {
		t_sec--;
		t_usec += 1000000;
	}
	if (ptvalo) {
		ptvalo->tv_sec  = t_sec;
		ptvalo->tv_usec = t_usec;
	}

	return t_sec*1000 + t_usec/1000;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akxe_timer_set_msec(ptval,msec)
struct timeval *ptval;
int msec;
{
	if (msec) {
		ptval->tv_sec  = msec / 1000;
		ptval->tv_usec = (msec % 1000)*1000;
	}
	else {
		ptval->tv_sec  = 0;
		ptval->tv_usec = 0;
	}

	return msec;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akxe_timer_add_msec(ptvalo,ptvali,msec)
struct timeval *ptvalo,*ptvali;
int msec;
{
	struct timeval tval;

	akxe_timer_set_msec(&tval,msec);

	return akxe_timer_add(ptvalo,ptvali,&tval);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akxe_timer_sub(ptvalo,ptvali,ptval2)
struct timeval *ptvalo,*ptvali,*ptval2;
{
	struct timeval tval;

	if (ptval2) {
		tval.tv_sec  = -ptval2->tv_sec;
		tval.tv_usec = -ptval2->tv_usec;
	}
	else {
		tval.tv_sec = tval.tv_usec = 0;
	}

	return akxe_timer_add(ptvalo,ptvali,&tval);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akxe_timer_cmp(ptval1,ptval2)
struct timeval *ptval1,*ptval2;
{
	int t1_sec,t1_usec;
	int t2_sec,t2_usec;
	int f=0;

	if (ptval1) {
		t1_sec  = ptval1->tv_sec;
		t1_usec = ptval1->tv_usec;
	}
	else {
		t1_sec  = t1_usec = 0;
	}
	if (ptval2) {
		t2_sec  = ptval2->tv_sec;
		t2_usec = ptval2->tv_usec;
	}
	else {
		t2_sec  = t2_usec = 0;
	}
	if (!(f = t1_sec - t2_sec)) f = t1_usec - t2_usec;

	return f;
}

/********************************************************/
/*                                                      */
/********************************************************/
tdtTIMER_CTL_HEAD *akxe_timer_new()
{
	tdtTIMER_CTL_HEAD *pTC;
	struct timeval tval;

	if (pTC = (tdtTIMER_CTL_HEAD *)Malloc(sizeof(tdtTIMER_CTL_HEAD))) {
		memset(pTC,0,sizeof(tdtTIMER_CTL_HEAD));
		pTC->th_mwtext = pTC->th_minwait = -1;
		if (akxe_get_msec(pTC,&tval) < 0) {
			Free(pTC);
			pTC = NULL;
		}
	}
	return pTC;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akxe_timer_free(pTC)
tdtTIMER_CTL_HEAD *pTC;
{
	if (pTC) Free(pTC);
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akxe_get_msec(pTC,ptval)
tdtTIMER_CTL_HEAD *pTC;
struct timeval *ptval;
{
	struct timeval tval;
	int t, t_sec,t_usec;

	t = gettimeofday(&tval,NULL);
	if (!t) {
		if (pTC) {
			if (!pTC->th_tmbase.tv_sec) {
				pTC->th_tmbase.tv_sec  = tval.tv_sec;
				pTC->th_tmbase.tv_usec = tval.tv_usec;
			}
			t_sec  = tval.tv_sec  - pTC->th_tmbase.tv_sec;
			t_usec = tval.tv_usec - pTC->th_tmbase.tv_usec;
			if (t_usec < 0) {
				t_sec--;
				t_usec += 1000000;
			}
			pTC->th_latest.tv_sec  = t_sec;
			pTC->th_latest.tv_usec = t_usec;
		}
		else {
			t_sec  = tval.tv_sec;
			t_usec = tval.tv_usec;
		}
		if (ptval) {
			ptval->tv_sec  = t_sec;
			ptval->tv_usec = t_usec;
		}
	/* 1/1000 secł̓vZXNA24.86Ń}CiXɂȂ
		t = t_sec*1000 + t_usec/1000;
	*/
		t = t_sec;
	}
	return t;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akxe_edit_elapse_time(el_sec,t)
int el_sec;
struct tm *t;
{
	int tm_sec,tm_min,tm_hour,tm_day;

	tm_sec  = el_sec;
	tm_min  = tm_sec/60;
	tm_hour = tm_min/60;
	t->tm_mday = tm_hour/24;
	t->tm_sec  = tm_sec  % 60;
	t->tm_min  = tm_min  % 60;
	t->tm_hour = tm_hour % 24;

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akxe_register_timer(pTC,cpTimerName,pFuncName,iWaitTime,cpParm)
tdtTIMER_CTL_HEAD *pTC;
char *cpTimerName ; /* ^C}[ */
int (*pFuncName)(); /* ^CAEgĂяo֐ւ̃|C^ */
int  iWaitTime    ; /* ^CAEg(msec) */
char *cpParm      ; /* ֐Ăяõp[^ */
{
	tdtTIMER_CTL *curr,*next,*empty;
	int i,ret,iTimerId,iWT;
	struct timeval ttime;

	if (!pTC) {
	/*	ERROROUT("^C}[Ǘ\ւ̃|C^mtkk");	*/
		return -1;
	}
	if (!cpTimerName) {
		return -2;
	}
	if (!*cpTimerName) {
		return -3;
	}
	if (!pFuncName) {
	/*	ERROROUT("֐mtkk");	*/
		return -4;
	}
	if (iWaitTime < 0) {
		iWT = 0;
		iWaitTime = -iWaitTime;
	}
	else if (iWaitTime > 0) {
		iWT = iWaitTime;
	}
	else {
	/*	ERROROUT1("^CAEg(%d)O",iWaitTime);	*/
		return -5;
	}
	iTimerId = 0;
	empty = curr = NULL;
	next = pTC->th_ptimer;
	while (next) {
		curr = next;
		if (curr->tc_tmrname) {
			if (!strcmp(curr->tc_tmrname,cpTimerName)) return -6;
		}
		else empty = curr;
		next = curr->tc_tmrnext;
		iTimerId++;
	}
	if (empty) next = empty;
	else if (!next) {
		if (!(next=(tdtTIMER_CTL *)Malloc(sizeof(tdtTIMER_CTL)))) {
			return -7;
		}
		memset(next,0,sizeof(tdtTIMER_CTL));
		if (!pTC->th_ptimer) pTC->th_ptimer = next;
		else curr->tc_tmrnext = next;
		next->tc_tmrid = iTimerId + 1;
	}
	if (!(next->tc_tmrname=Malloc(strlen(cpTimerName)+1))) return -8;
	strcpy(next->tc_tmrname,cpTimerName);
	next->tc_pfunc = pFuncName;
	next->tc_watime = iWaitTime;
	next->tc_parm    = cpParm;
	next->tc_status  = AKX_TIMER_START;
	if (akxe_get_msec(pTC,&ttime) < 0) return -9;
	akxe_timer_add_msec(&next->tc_timeout,&ttime,iWT);

	if (pTC->th_minwait < 0 || iWaitTime < pTC->th_minwait)
		pTC->th_minwait = iWaitTime;

	return next->tc_tmrid;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akxe_cancel_timer(pTC,iTimerId)
tdtTIMER_CTL_HEAD *pTC;
int  iTimerId;	/* ^C}[ʔԍ */
{
	tdtTIMER_CTL *next;

	if (!pTC) {
	/*	ERROROUT("^C}[Ǘ\ւ̃|C^mtkk");	*/
		return -1;
	}
	next = pTC->th_ptimer;
	while (next) {
		if (next->tc_tmrid == iTimerId) {
			if (next->tc_tmrname) Free(next->tc_tmrname);
			next->tc_tmrname = NULL;
			next->tc_pfunc = NULL;
			next->tc_watime = 0;
			next->tc_status  = AKX_TIMER_UNUSED;
			return 0;
		}
		next = next->tc_tmrnext;
	}
	return -2;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akxe_proc_timer(pTC)
tdtTIMER_CTL_HEAD *pTC;
{
	tdtTIMER_CTL *next;
	struct timeval ttime;
	int rc, iMinWait, iWaitTime;
	char c;

	if (!pTC) return -1;

	if (pTC->th_minwait < 0) return 0;

	/* ݎ̎肾 */
	if (akxe_get_msec(pTC,&ttime) < 0) return -2;

	iMinWait = -1;
	next = pTC->th_ptimer;
	while (next) {
		if (next->tc_tmrname && (next->tc_status==AKX_TIMER_START)) {
/*
printf("akxe_proc_timer:name=[%s] now=%d.%06d timeout=%d.%06d\n",
next->tc_tmrname,ttime.tv_sec,ttime.tv_usec,next->tc_timeout.tv_sec,next->tc_timeout.tv_usec);
*/
			if (akxe_timer_cmp(&ttime,&next->tc_timeout) >= 0) {
				pTC->th_mwtext = -1;
				if ((c=*next->tc_tmrname) == '&') rc = next->tc_pfunc(next);
				else if (c == '?')
					rc = next->tc_pfunc(next->tc_tmrid, next->tc_tmrname,
				                  next->tc_parm, &ttime, next->tc_event);
				else rc = next->tc_pfunc(next->tc_tmrid, next->tc_tmrname,
				                          next->tc_parm, &ttime);
				next->tc_event = 0;
				if (rc < 0) {
					if (next->tc_tmrname) Free(next->tc_tmrname);
					next->tc_tmrname = NULL;
					next->tc_pfunc = NULL;
					next->tc_watime = 0;
					next->tc_status  = AKX_TIMER_UNUSED;
				}
				else if (next->tc_status == AKX_TIMER_START) {
			/*	else {	2004.3.4 Koba */
				/* 2000.8.18 Koba
					if (rc > 0) next->tc_watime = rc;
					iWaitTime = next->tc_watime;
				*/
					if (rc > 0) iWaitTime = rc;
					else iWaitTime = next->tc_watime;
					akxe_timer_add_msec(&next->tc_timeout,&ttime,iWaitTime);
					if (iMinWait<0 || iWaitTime<iMinWait) iMinWait = iWaitTime;
				}
				if ((iWaitTime=pTC->th_mwtext) >= 0) {
					if (iMinWait<0 || iWaitTime<iMinWait) iMinWait = iWaitTime;
				}
			}
			else {
				iWaitTime = akxe_timer_sub(NULL,&next->tc_timeout,&ttime);
				if (iMinWait<0 || iWaitTime<iMinWait) iMinWait = iWaitTime;
			}
		}
		next = next->tc_tmrnext;
	}
	pTC->th_minwait = iMinWait;
	pTC->th_mwtext = -1;
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _is_timer_obj(next,opt,obj)
tdtTIMER_CTL *next;
int  opt;	/* =0:all,=1:TimerId,=2:TimerName */
char *obj;
{
	int f;

	if (!next || (!opt && !obj)) return 0;
	f = 0;
	if (!opt) f = 1;
	else if (opt==1) {
		if (next->tc_tmrid == *(int *)obj) f = 1;
	}
	else {
		if (!strcmp(next->tc_tmrname,obj)) f = 1;
	}
	return f;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akxe_wake_up_timer(pTC,opt,obj,event)
tdtTIMER_CTL_HEAD *pTC;
int  opt;	/* =0:all,=1:TimerId,=2:TimerName */
char *obj;
int  event;
{
	int  iTimerId     ; /* ^C}[ʔԍ */
	struct timeval ttime;
	tdtTIMER_CTL *next;
	int  f;

	if (!pTC) return -1;
	if (!opt && !obj) return -2;

	/* ݎ̎肾 */
	if (akxe_get_msec(pTC,&ttime) < 0) return -3;

	next = pTC->th_ptimer;
	while (next) {
		if (next->tc_tmrname && (next->tc_status==AKX_TIMER_START)) {
			if (_is_timer_obj(next,opt,obj)) {
				akxe_timer_set(&next->tc_timeout,&ttime);
				next->tc_event = event;
				pTC->th_mwtext = pTC->th_minwait = 0;
				if (opt) return next->tc_tmrid;
			}
		}
		next = next->tc_tmrnext;
	}
	if (opt) return -4;
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _set_status_timer(pTC,opt,obj,status)
tdtTIMER_CTL_HEAD *pTC;
int  opt;	/* =0:all,=1:TimerId,=2:TimerName */
char *obj;
int  status;
{
	tdtTIMER_CTL *next;
	struct timeval tt;
	int iGet=1;
/*
printf("_set_status_timer:opt=%d status=%d\n",opt,status);
*/
	if (!pTC) return -1;
	if (!opt && !obj) return -2;

	next = pTC->th_ptimer;
	while (next) {
		if (next->tc_tmrname) {
			if (_is_timer_obj(next,opt,obj)) {
				if ((status==AKX_TIMER_START) &&
				    (next->tc_status != status)) {
#if 1
#if 1
					if (akxe_get_msec_l(pTC,&tt) < 0) akxe_timer_set_msec(&tt,0);
#else
					if (iGet) {
						if (akxe_get_msec(pTC,&tt) < 0) akxe_timer_set_msec(&tt,0);
						iGet = 0;
					}
#endif
					akxe_timer_add_msec(&next->tc_timeout,&tt,next->tc_watime);
#else
					akxe_timer_set_msec(&next->tc_timeout,0);
#endif
				}
				next->tc_status = status;
				if (opt) return next->tc_tmrid;
			}
		}
		next = next->tc_tmrnext;
	}
	if (opt) return -4;
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akxe_start_timer(pTC,opt,obj)
tdtTIMER_CTL_HEAD *pTC;
int  opt;	/* =0:all,=1:TimerId,=2:TimerName */
char *obj;
{
	if (!pTC) return -1;
	pTC->th_minwait = 0;	/* PacketRead̒ŌĂ΂ꂽƂɃ^C}[Ăяo
							s悤ɂ*/
	return _set_status_timer(pTC,opt,obj,AKX_TIMER_START);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akxe_stop_timer(pTC,opt,obj)
tdtTIMER_CTL_HEAD *pTC;
int  opt;	/* =0:all,=1:TimerId,=2:TimerName */
char *obj;
{
	return _set_status_timer(pTC,opt,obj,AKX_TIMER_STOP);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akxe_min_wait_timer(pTC)
tdtTIMER_CTL_HEAD *pTC;
{
	tdtTIMER_CTL *next;
	struct timeval ttime;
	int rc, iMinWait, iWaitTime;

	if (!pTC) return -1;
	if (akxe_get_msec(pTC,&ttime) < 0) return -3;
	iMinWait = -1;
	next = pTC->th_ptimer;
	while (next) {
		if (next->tc_tmrname && (next->tc_status==AKX_TIMER_START)) {
			iWaitTime = akxe_timer_sub(NULL,&next->tc_timeout,&ttime);
			if (iWaitTime < 0) iWaitTime = 0;
			if (iMinWait<0 || iWaitTime<iMinWait) iMinWait = iWaitTime;
		}
		next = next->tc_tmrnext;
	}
	pTC->th_minwait = iMinWait;
	return iMinWait;
}
/********************************************************/
/*                                                      */
/********************************************************/
int akxe_get_msec_l(pTC,ptval)
tdtTIMER_CTL_HEAD *pTC;
struct timeval *ptval;
{
	int t,t_sec,t_usec;

	if (pTC) {
		t_sec  = pTC->th_latest.tv_sec;
		t_usec = pTC->th_latest.tv_usec;
		if (ptval) {
			ptval->tv_sec  = t_sec;
			ptval->tv_usec = t_usec;
		}
	/* 1/1000 secł̓vZXNA24.86Ń}CiXɂȂ
		t = t_sec*1000 + t_usec/1000;
	*/
		t = t_sec;
	}
	else {
#if 1
		t = akxe_get_msec(NULL,ptval);
#else
		t = -1;
#endif
	}

	return t;
}
