static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*************************************************
 *
 *  akalib1.c
 *
 *        coded by A.Kobayashi 96/1/29
 *
 *************************************************/
#include "akacommon.h"

#define AKA_CONNECT_RETRY	3
#define AKA_CONNECT_SLEEP	2


static int mk_pkhead();
static int akb_command();

INT4 aka_get_pr_host_id();

static INT4 lPrHostId=0;
static INT4 lMyHostId=0;
static int  iRegistPid=0;
static int  iConnectSd=-1;
static int  iConnectPort=0;
static tdtCOMM_PACK_HEAD  tShutHead, *tpShutHead=NULL;
static char gcAkbVer='C';
static int  giInitStatus = 0;	/* 1/2/4 = connected/registed/initialized */
static int  iRegistDestPid=0;
static int  giRegistOption=0;

/********************************************************/
/*                                                      */
/********************************************************/
int aka_connect(cpHost,cpService)
char *cpHost     ;	/* ڑzXg */
char *cpService  ;	/* ڑT[rX܂̓|[gԍ */
{
	int iRc;

	iRc = akb_connect(cpHost,cpService,AKA_CONNECT_RETRY,AKA_CONNECT_SLEEP);
	if (iRc > 0) {
		iConnectPort = akb_get_connect_port();
		aka_set_connect_sd(iRc);
	}
	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_shut_down(iSd)
int   iSd        ;	/* ڑ\Pbg̔ԍ */
{
	int iRc;

	if (iSd<0) return -18500301;
	if (iRc=shutdown(iSd,2)) {
		ERROROUT2("aka_shut_down: iSd=%d shutdown: %s",iSd,strerror(errno));
		return -18500302;
	}
	close(iSd);
	if (iSd == aka_get_connect_sd()) {
		iConnectPort = 0;
		aka_set_connect_sd(-1);
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_shut_down2()
{
	return aka_shut_down(aka_get_connect_sd());
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_regist_host(iSd,iProcNumber,cpMsg,lMsgLen,lMyHid,iOption)
int  iSd        ;	/* ڑ\Pbg̔ԍ */
int  iProcNumber ;	/* vZXԍ */
char *cpMsg;
INT4 lMsgLen,lMyHid;
int  iOption;
{
	int iRc,l,len;
	tdtCOMM_PACK_HEAD head,*ph;
	char *p=NULL;
/*
printf("aka_regist_host(iSd=%d,iProcNumber=%d,cpMsg=[%s],lMsgLen=%d,lMyHid=%d,iOption=%d\n",iSd,iProcNumber,cpMsg,lMsgLen,lMyHid,iOption);
*/
	if (iSd<0) return -18500401;
	else if (!iSd) return 0;
	iConnectSd = iSd;
	ph  = &head;
	len = sizeof(head);
	if (cpMsg && lMsgLen>0) {
		l = sizeof(head) + lMsgLen + 1;
		if (p = Malloc(l)) {
			ph = (tdtCOMM_PACK_HEAD *)p;
			memcpy(p+sizeof(head),cpMsg,lMsgLen);
			*(p+sizeof(head)+lMsgLen) = '\0';
			len = l;
		}
	}
	mk_pkhead(ph,AKB_CMD_REGIST,iProcNumber,lMyHid,iOption);
	ph->cph_plen = htonl(len - sizeof(head));
	iRc = akb_command(1,iSd,ph,len);
/*
printf("aka_regist_host: iRc = %d\n",iRc);
*/
	if (!iRc) {
		lPrHostId  = ntohl(ph->cph_sinf.ind_hoid);
/*
printf("aka_regist_host: lPrHostId = %08x\n",lPrHostId);
*/
		aka_set_regist_pid(ntohs(ph->cph_dinf.ind_prid));
		aka_set_regist_dest_pid(ntohs(ph->cph_sinf.ind_prid));
		aka_set_regist_option(ntohs(ph->cph_dinf.ind_clid));
	}
	if (p) Free(p);
	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_regist2(iSd,iProcNumber,cpMsg,lMsgLen)
int  iSd        ;	/* ڑ\Pbg̔ԍ */
int  iProcNumber ;	/* vZXԍ */
char *cpMsg;
int  lMsgLen;
{
	return aka_regist_host(iSd,iProcNumber,cpMsg,lMsgLen,0,0);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_regist(iSd,iProcNumber)
int  iSd        ;	/* ڑ\Pbg̔ԍ */
int  iProcNumber ;	/* vZXԍ */
{
	return aka_regist_host(iSd,iProcNumber,NULL,0,0,0);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_connect_regist(iSd,iProcId,cpMsg,lMsgLen)
int  iSd    ;	/* ڑ\Pbg̔ԍ */
int  iProcId;	/* vZXԍ */
char *cpMsg;
int  lMsgLen;
{
	int iRc;

	if (iSd == 0) {
		iSd = akb_connect_prom(0,0);
		PRINTOUT1("aka_connect_regist: akb_connect_prom ret=%d",iSd);
		if (iSd <= 0) return -18500402;
		aka_set_connect_sd(iSd);
	}
DEBUGOUT2("aka_connect_regist:Socket=%d, ProcId=%d",iSd,iProcId);
	if ((iRc=aka_regist2(iSd,iProcId,cpMsg,lMsgLen)) < 0) iSd = iRc;
	return iSd;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_cancel_msg(iSd,iProcNumber,cpMsg,lMsgLen)
int  iSd        ;	/* ڑ\Pbg̔ԍ */
int  iProcNumber ;	/* vZXԍ */
char *cpMsg;
int  lMsgLen;
{
	tdtCOMM_PACK_HEAD head, *tpHead;
	int iRead, iRc;
	int l,len;
	tdtCOMM_PACK_HEAD *ph;
	char *p=NULL;

	if (iSd<0) return -18500501;
	else if (!iSd) return 0;
	len = sizeof(head);
	ph = &head;
	if (tpShutHead) {
		memcpy(ph,tpShutHead,sizeof(head));
		iRead = 0;
	}
	else {
		if (cpMsg && lMsgLen>0) {
			l = sizeof(head) + lMsgLen + 1;
			if (p = Malloc(l)) {
				ph = (tdtCOMM_PACK_HEAD *)p;
				memcpy(p+sizeof(head),cpMsg,lMsgLen);
				*(p+sizeof(head)+lMsgLen) = '\0';
				len = l;
			}
		}
		mk_pkhead(ph,AKB_CMD_DELETE,iProcNumber,lMyHostId,0);
		iRead = 1;
		ph->cph_plen = htonl(len - sizeof(head));
	}
	iRc = akb_command(iRead,iSd,ph,len);
	if (!iRc) {
		lPrHostId  = 0;
		aka_set_regist_pid(0);
	}
	if (p) Free(p);
	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_cancel2(cpMsg,lMsgLen)
char *cpMsg;
int  lMsgLen;
{
	return aka_cancel_msg(iConnectSd,iRegistPid,cpMsg,lMsgLen);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_cancel_ret(iRet)
int  iRet;
{
	char buf[40];

	sprintf(buf,"RetCode:%d\n",iRet);
	return aka_cancel2(buf,strlen(buf));
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_cancel(iSd,iProcNumber)
int  iSd        ;	/* ڑ\Pbg̔ԍ */
int  iProcNumber ;	/* vZXԍ */
{
	return aka_cancel_msg(iSd,iProcNumber,NULL,0);
}

/********************************************************/
/*                                                      */
/********************************************************/
static int mk_pkhead(head,iCommand,iProc,lMyHid,iOption)
tdtCOMM_PACK_HEAD   *head ;
int iCommand,iProc;
INT4 lMyHid;
int  iOption;
{
	int irc;
	short sWrk;

	if (lMyHid) lMyHostId = lMyHid;
	else if (irc=akb_get_host_addr(NULL,&lMyHostId)) return irc;

	head->cph_prt.prt_ver       = gcAkbVer;/* vgRo[W */
	head->cph_prt.prt_send = 0;		/* ]iځj */
	sWrk = iCommand;
	head->cph_prt.prt_cmnd   = htons(sWrk);/* R}h             */

	head->cph_dinf.ind_hoid     = 0;		/* ]zXghc     */

	head->cph_dinf.ind_clid   = 0;		/* ]NXhc     */
	head->cph_dinf.ind_prid = 0;		/* ]vZXhc   */

	head->cph_dinf.ind_thrd    = 0;		/* ]Xbhm   */
	head->cph_dinf.ind_disp    = 0;		/* boeIvV     */
	head->cph_dinf.ind_pano   = 0;		/* boeG[R[h   */

	head->cph_sinf.ind_hoid     = htonl(lMyHostId);	/* ]zXghc */

	sWrk = iOption;
	head->cph_sinf.ind_clid   = htons(sWrk);	/* ]NXhc */
	sWrk = iProc;
	head->cph_sinf.ind_prid = htons(sWrk);	/* ]vZXhc   */

	head->cph_sinf.ind_thrd    = 1;		/* ]Xbhm   */
	head->cph_sinf.ind_disp    = 1;		/* hc             */
	head->cph_sinf.ind_pano   = htons(1);	/* pPbgʔ         */

	head->cph_plen = 0 ;         		/* pPbg           */

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int akb_command(iR,iSd,tpHead,len)
int iR, iSd, len;
pCOMM_PACK_HEAD   tpHead;
{
	int iRc, rLen, rlen;
	short sCommand;
	char cver;
	pCOMM_PACK_HEADB pHeadB;

	if ((iRc=akb_sk_write(iSd,tpHead,len))!=len) {
		ERROROUT3("Command write error cmd=%d, from proc=%d to proc=%d",
		            ntohs(tpHead->cph_prt.prt_cmnd),
		            ntohs(tpHead->cph_sinf.ind_prid),
		            ntohs(tpHead->cph_dinf.ind_prid));
		return -18500901;
	}
	if (!iR) return 0;

	sCommand = tpHead->cph_prt.prt_cmnd;
#if 0	/* 1998.5.8 Koba */
	if ((iRc=akb_sk_read(iSd,tpHead,len))!=len) {
		ERROROUT("Read error for Command write reply");
		return -18500902;
	}

	if (tpHead->cph_prt.prt_cmnd == sCommand) {
		if (tpHead->cph_sinf.ind_thrd) {
			ERROROUT("MpPbĝ܂ܕԋpꂽ");
			iRc = -18500903;
		}
		else iRc = (short)ntohs(tpHead->cph_sinf.ind_pano);	/* boeG[R[h  */
	}
	else iRc = 0;
#else
	iRc = 0;
	for (;;) {
		rLen = sizeof(tdtCOMM_PACK_HEAD);
		if ((rlen=akb_sk_read(iSd,tpHead,rLen))!=rLen) {
			ERROROUT1("Read error for Command write reply ret=%d",rlen);
			return -18500902;
		}
		cver = tpHead->cph_prt.prt_ver;
		pHeadB = (pCOMM_PACK_HEADB)tpHead;
		if ((cver=='C' && tpHead->cph_sinf.ind_thrd) ||
		    (cver=='B' && pHeadB->phb_dind.inb_pkid == 0)) { /* MpPbg */
			if (tpHead->cph_prt.prt_cmnd == sCommand) {
				ERROROUT("MpPbĝ܂ܕԋpꂽ");
				iRc = -18500903;
			}
			ERROROUTRC("MpPbgM.Cmd=",htons(tpHead->cph_prt.prt_cmnd));
			rLen = ntohl(tpHead->cph_plen);
			if (akb_sk_dmy_read(iSd,rLen) != rLen) {
				iRc = -18500904;
			}
		}
		else {	/* ԐMpPbg */
			if (tpHead->cph_prt.prt_cmnd == sCommand) {
				iRc = (short)ntohs(tpHead->cph_sinf.ind_pano);/* AKBG[R[h */
			}
			else {
				ERROROUT2("Cmd=%dȊO(%d)ԋpꂽ.",sCommand,htons(tpHead->cph_prt.prt_cmnd));
				iRc = -18500905;
			}
			rLen = ntohl(tpHead->cph_plen);
/*
printf("rLen=%d\n",rLen);
*/
			if (akb_sk_dmy_read(iSd,rLen) != rLen) {
				iRc = -18500906;
			}
			break;
		}
	}
#endif

	return iRc;
}

INT4 aka_get_pr_host_id()
{
	return lPrHostId;
}

INT4 aka_get_my_host_id()
{
	int irc;

	if (!lMyHostId) {
		if (irc=akb_get_host_addr(NULL,&lMyHostId)) return (INT4)irc;
	}
	return lMyHostId;
}

void aka_set_shut_packet(tpHead)
tdtCOMM_PACK_HEAD *tpHead;
{
	if (tpHead) {
		tpShutHead = &tShutHead;
		memcpy(tpShutHead,tpHead,sizeof(tdtCOMM_PACK_HEAD));
	}
	else tpShutHead = NULL;
}

int aka_get_regist_pid()
{
	return iRegistPid;
}

int aka_get_connect_port()
{
	return iConnectPort;
}

int aka_set_regist_pid(iPid)
int iPid;
{
	int i,set;

	i = iRegistPid;
	if ((iRegistPid = iPid) > 0) set = 1;
	else set = -1;
	aka_init_status(AKA_IST_REGISTED,set);
	return i;
}

char aka_set_regist_ver(cVer)
char cVer;
{
	char c;

	c = gcAkbVer;
	if (cVer=='B' || cVer=='C') gcAkbVer = cVer;
	return c;
}

char aka_get_regist_ver()
{
	return gcAkbVer;
}

int aka_set_connect_sd(iSd)
int iSd;
{
	int i,set;

	i = iConnectSd;
	if ((iConnectSd = iSd) < 0) set = -1;
	else set = 1;
	aka_init_status(AKA_IST_CONNECTED,set);
	return i;
}

int aka_get_connect_sd()
{
	return iConnectSd;
}

int aka_init_status(iStatus,iSet)
int iStatus,iSet;
{
	return akxt_set_bits(&giInitStatus,iStatus,iSet);
}

int aka_get_regist_dest_pid()
{
	return iRegistDestPid;
}

int aka_set_regist_dest_pid(iPid)
int iPid;
{
	int i;

	i = iRegistDestPid;
	iRegistDestPid = iPid;
	return i;
}

int aka_usage(cpProc)
char *cpProc;
{
	if (!cpProc) cpProc = "program";
	fprintf(stderr,"Usage: %s {SocketId|0} ProcId [ProcName]\n",cpProc);
	return 0;
}

int aka_set_regist_option(iOption)
int iOption;
{
	int i;

	i = giRegistOption;
	giRegistOption = iOption;
	return i;
}

int aka_get_regist_option()
{
	return giRegistOption;
}
