static char sccsid[]="%Z% %M% %I% %D% %T%";
/*************************************************
 *
 *  akbfdset.c
 *
 *        coded by A.Kobayashi 2000.10.13
 *
 *************************************************/
#include "akbcommon.h"

static int iFdSetSize=-1;
static int giFD_SETSIZE=FD_SETSIZE;

void akb_fd_zero(pfdset)
fd_set *pfdset;
{
	iFdSetSize = 0;
	FD_ZERO(pfdset);
/*
printf("akb_fd_zero:IFdSetSize=%d\n",iFdSetSize);
*/
}

void akb_fd_set(iSd, pfdset)
int iSd;
fd_set *pfdset;
{
	FD_SET(iSd, pfdset);
	if (++iSd > iFdSetSize) iFdSetSize = iSd;
/*
printf("akb_fd_set:iSd+1=%d IFdSetSize=%d\n",iSd,iFdSetSize);
*/
}

void akb_fd_clr(iSd, pfdset)
int iSd;
fd_set *pfdset;
{
	FD_CLR(iSd, pfdset);
	if (++iSd == iFdSetSize) iFdSetSize--;
}

int  akb_fd_isset(iSd, pfdset)
int iSd;
fd_set *pfdset;
{
	return FD_ISSET(iSd,pfdset);
}

int  akb_fd_setsize()
{
	int n;

	if ((n=iFdSetSize) < 0) n = giFD_SETSIZE;
/*
printf("akb_fd_setsize:IFdSetSize=%d\n",n);
*/
	return n;
}

int  akb_set_fd_setsize(size)
int size;
{
	int ret,n,cur;
	struct rlimit rl;

	n = size;
	ret = getrlimit(RLIMIT_NOFILE, &rl);
	if (ret) {
		if (!n) ret = FD_SETSIZE;
		return ret;
	}
/*
printf("get rlim_cur=%d rlim_max=%d\n",rl.rlim_cur,rl.rlim_max);
*/
	rl.rlim_cur;
	cur = rl.rlim_cur;
	rl.rlim_max;
	if (n <= 0) {
		n = rl.rlim_cur;
		if (n > FD_SETSIZE) n = FD_SETSIZE;
	}
	else {
		if (n > FD_SETSIZE) n = FD_SETSIZE;
		if (n > rl.rlim_cur) {
			if (n > rl.rlim_max) n = rl.rlim_max;
		}
		rl.rlim_cur = n;
/*
printf("set rlim_cur=%d rlim_max=%d\n",rl.rlim_cur,rl.rlim_max);
*/
		ret = setrlimit(RLIMIT_NOFILE, &rl);
/*
printf("set rlimit rc=%d\n",ret);
*/
		if (ret) {
			if (n > cur) n = cur;
		}
	}
	giFD_SETSIZE = n;
/*
printf("n=%d\n",n);
*/
	return n;
}
