/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.io.IOException;
import java.net.URL;
import javafx.application.Platform;
import javafx.scene.media.AudioClip;
import javafx.scene.media.Media;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import rdj.Audio;
import rdj.UI;

public class Voice
extends Audio {
    public static AudioClip audioClipSounds;
    public static AudioClip audioClipVoice;
    private static AudioInputStream audioInputStreamSounds;
    private static AudioInputStream audioInputStreamVoice;
    private static Clip clipSounds;
    private static Clip clipVoice;

    public static synchronized void play(UI ui, String audio, int audio_codec) {
        Media media;
        switch (audio_codec) {
            case 0: {
                media = new Media(ui.getClass().getResource(audio + ".wav").toExternalForm());
                break;
            }
            case 1: {
                media = new Media(ui.getClass().getResource(audio + ".ogg").toExternalForm());
                break;
            }
            case 2: {
                media = new Media(ui.getClass().getResource(audio + ".aiff").toExternalForm());
                break;
            }
            case 3: {
                media = new Media(ui.getClass().getResource(audio + ".mp3").toExternalForm());
                break;
            }
            default: {
                media = new Media(ui.getClass().getResource(audio + ".wav").toExternalForm());
            }
        }
        Voice.playJavaFX(ui, media, audio_codec);
    }

    public static synchronized void playJavaX(UI ui, Media media, int audio_codec) {
        if (media != null) {
            if (media.getSource().contains("sounds")) {
                if (sound_Is_Enabled) {
                    try {
                        audioInputStreamSounds = AudioSystem.getAudioInputStream(new URL(media.getSource()));
                    }
                    catch (UnsupportedAudioFileException ex) {
                        ui.log("Error: UnsupportedAudioFileException " + Voice.class.getSimpleName() + ".play(..) AudioSystem.getAudioInputStream(" + media.getSource() + " " + ex.getMessage() + " \r\n", true, true, true, true, false);
                    }
                    catch (IOException ex) {
                        ui.log("Error: IOException " + Voice.class.getSimpleName() + ".play(..) AudioSystem.getAudioInputStream(" + media.getSource() + " " + ex.getMessage() + " \r\n", true, true, true, true, false);
                    }
                    clipSounds = null;
                    try {
                        clipSounds = AudioSystem.getClip();
                    }
                    catch (LineUnavailableException ex) {
                        ui.log("Error: LineUnavailableException " + Voice.class.getSimpleName() + ".play(..).AudioSystem.getClip() " + ex.getMessage() + " \r\n", true, true, true, true, false);
                    }
                    try {
                        clipSounds.open(audioInputStreamSounds);
                    }
                    catch (LineUnavailableException ex) {
                        clipSounds.close();
                        clipSounds = null;
                        ui.log("Error: LineUnavailableException " + Voice.class.getSimpleName() + ".play(..).clipSounds.open(" + media.getSource() + ") " + ex.getMessage() + " \r\n", true, true, true, false, false);
                    }
                    catch (IOException ex) {
                        clipSounds.close();
                        clipSounds = null;
                        ui.log("Error: IOException " + Voice.class.getSimpleName() + ".play(..).clipSounds.open(" + media.getSource() + ") " + ex.getMessage() + " \r\n", true, true, true, false, false);
                    }
                    if (clipSounds != null) {
                        clipSounds.start();
                        try {
                            audioInputStreamSounds.close();
                        }
                        catch (IOException ex) {
                            ui.log("Error: IOException " + Voice.class.getSimpleName() + ".play(..).audioInputStreamSounds.close() " + ex.getMessage() + " \r\n", true, true, true, false, false);
                        }
                    } else {
                        try {
                            audioInputStreamSounds.close();
                        }
                        catch (IOException ex) {
                            ui.log("Error: IOException " + Voice.class.getSimpleName() + ".play(..).audioInputStreamSounds.close() " + ex.getMessage() + " \r\n", true, true, true, false, false);
                        }
                    }
                }
            } else if (media.getSource().contains("voice")) {
                if (voice_Is_Enabled) {
                    if (clipVoice != null && clipVoice.isOpen()) {
                        clipVoice.stop();
                        try {
                            audioInputStreamVoice.close();
                        }
                        catch (IOException ex) {
                            ui.log("Error: IOException audioIn.close() " + ex.getMessage() + " \r\n", true, true, true, true, false);
                        }
                    }
                    try {
                        audioInputStreamVoice = AudioSystem.getAudioInputStream(new URL(media.getSource()));
                    }
                    catch (UnsupportedAudioFileException ex) {
                        ui.log("Error: UnsupportedAudioFileException play(..) AudioSystem.getAudioInputStream(" + media.getSource() + " " + ex.getMessage() + " \r\n", true, true, true, true, false);
                    }
                    catch (IOException ex) {
                        ui.log("Error: IOException " + Voice.class.getSimpleName() + ".play(..) AudioSystem.getAudioInputStream(" + media.getSource() + " " + ex.getMessage() + " \r\n", true, true, true, true, false);
                    }
                    clipVoice = null;
                    try {
                        clipVoice = AudioSystem.getClip();
                    }
                    catch (LineUnavailableException ex) {
                        ui.log("Error: LineUnavailableException " + Voice.class.getSimpleName() + ".play(..).AudioSystem.getClip() " + ex.getMessage() + " \r\n", true, true, true, true, false);
                    }
                    try {
                        clipVoice.open(audioInputStreamVoice);
                    }
                    catch (LineUnavailableException ex) {
                        clipVoice.close();
                        clipVoice = null;
                        ui.log("Error: LineUnavailableException " + Voice.class.getSimpleName() + ".play(..).clipVoice.open(" + media.getSource() + ") " + ex.getMessage() + " \r\n", true, true, true, false, false);
                    }
                    catch (IOException ex) {
                        clipVoice.close();
                        clipVoice = null;
                        ui.log("Error: IOException " + Voice.class.getSimpleName() + ".play(..).clipVoice.open(" + media.getSource() + ") " + ex.getMessage() + " \r\n", true, true, true, false, false);
                    }
                    if (clipVoice != null) {
                        clipVoice.start();
                        try {
                            audioInputStreamVoice.close();
                        }
                        catch (IOException ex) {
                            ui.log("Error: IOException " + Voice.class.getSimpleName() + ".play(..).audioInputStreamVoice.close() " + ex.getMessage() + " \r\n", true, true, true, false, false);
                        }
                    } else {
                        try {
                            audioInputStreamVoice.close();
                        }
                        catch (IOException ex) {
                            ui.log("Error: IOException " + Voice.class.getSimpleName() + ".play(..).audioInputStreamVoice.close() " + ex.getMessage() + " \r\n", true, true, true, false, false);
                        }
                    }
                }
            } else {
                ui.log("Alert: " + Voice.class.getSimpleName() + ".play(" + media.getSource() + ") not recognized!\r\n", true, true, true, true, false);
            }
        }
    }

    public static synchronized void playJavaFX(final UI ui, final Media media, int audio_codec) {
        if (media != null) {
            if (media.getSource().contains("sounds")) {
                if (sound_Is_Enabled) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (media != null) {
                                if (media.getSource().contains("sounds")) {
                                    Thread playSoundThread = new Thread(() -> {
                                        if (Audio.sound_Is_Enabled) {
                                            audioClipSounds = new AudioClip(media.getSource());
                                            audioClipSounds.play();
                                        }
                                    });
                                    playSoundThread.setName("playSoundThread");
                                    playSoundThread.setDaemon(true);
                                    playSoundThread.start();
                                } else if (media.getSource().contains("voice")) {
                                    if (Audio.voice_Is_Enabled) {
                                        if (audioClipVoice != null && audioClipVoice.isPlaying()) {
                                            audioClipVoice.stop();
                                        }
                                        audioClipVoice = new AudioClip(media.getSource());
                                        audioClipVoice.play();
                                    }
                                } else {
                                    ui.log("Alert: play(" + media.getSource() + ") not recognized!\r\n", true, true, true, true, false);
                                }
                            }
                        }
                    });
                }
            } else if (media.getSource().contains("voice")) {
                if (voice_Is_Enabled) {
                    if (audioClipSounds != null && audioClipSounds.isPlaying()) {
                        audioClipSounds.stop();
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (media != null) {
                                if (media.getSource().contains("sounds")) {
                                    Thread playVoiceThread = new Thread(() -> {
                                        if (Audio.sound_Is_Enabled) {
                                            audioClipSounds = new AudioClip(media.getSource());
                                            audioClipSounds.play();
                                        }
                                    });
                                    playVoiceThread.setName("playVoiceThread");
                                    playVoiceThread.setDaemon(true);
                                    playVoiceThread.start();
                                } else if (media.getSource().contains("voice")) {
                                    if (Audio.voice_Is_Enabled) {
                                        if (audioClipVoice != null && audioClipVoice.isPlaying()) {
                                            audioClipVoice.stop();
                                        }
                                        audioClipVoice = new AudioClip(media.getSource());
                                        audioClipVoice.play();
                                    }
                                } else {
                                    ui.log("Alert: play(" + media.getSource() + ") not recognized!\r\n", true, true, true, true, false);
                                }
                            }
                        }
                    });
                }
            } else {
                ui.log("Alert: " + Voice.class.getSimpleName() + ".play(" + media.getSource() + ") not recognized!\r\n", true, true, true, true, false);
            }
        }
    }
}

