/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import com.sun.management.OperatingSystemMXBean;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import javax.net.ssl.HttpsURLConnection;
import rdj.Configuration;
import rdj.UI;
import rdj.Validate;

public class Version {
    private static boolean checkOnlineFailed;
    private static URI mailtoURI;
    private UI ui;
    private static final String COMPANYNAME = "Private Person";
    public static final String PRODUCTNAME = "FinalCrypt";
    private static final String COMMANDLINE;
    private static String fcInterface;
    public static final String AUTHOR_FIRSTNAME = "Ron";
    public static final String AUTHOR_LASTNAME = "de Jong";
    public static final String AUTHOR = "Ron de Jong";
    public static final String AUTHOREMAIL = "ron@finalcrypt.org";
    public static final String EMAIL = "info@finalcrypt.org";
    public static final String SUPPORTEMAIL = "support@finalcrypt.org";
    public static final String LICENSE = "Creative Commons License: (CC BY-NC-ND 4.0)";
    public static final String LICENSE_DESCRIPTION;
    private static final String OS_NAME;
    private static final String OS_VERSION;
    private static final String OS_ARCH;
    private static final String FILE_ENCODING;
    private static final int PROCESSORS;
    private static final long TOT_MEM;
    private static final long MAX_MEM;
    private static final long FREE_MEM;
    private static final long USED_MEM;
    private static final String JAVA_VENDOR;
    private static final String JAVA_VERSION;
    private static final String CLASS_VERSION;
    private static final String JAVA_HOME;
    private static final String JAVA_VM_VERSION;
    private static final String JAVA_VM_NAME;
    private static final String JAVA_RUNTIME_VERSION;
    private static final String USER_COUNTRY;
    private static final String USER_LANGUAGE;
    private static final String USER_NAME;
    private static final String USER_HOME;
    private static final String USER_DIR;
    private static final int HTTP_CONNECT_TIMEOUT = 3000;
    private static String localOverallVersionString;
    private static String localOverallVersionPrefString;
    private static String latestOverallVersionString;
    private static int localVersionTotal;
    private static int latestVersionTotal;
    private static InputStream istream;
    private static final String LOCALVERSIONFILEURLSTRING = "VERSION2";
    private static String localContent;
    public static final String[] HOMEPAGEURLSTRINGARRAY;
    public static final String[] DOWNLOADPAGEURLSTRINGARRAY;
    public static final String[] VIDEOPAGEURLSTRINGARRAY;
    public static final String[] SUPPORTPAGEURLSTRINGARRAY;
    private static final String[] REMOTEVERSIONFILEURLSTRINGARRAY;
    private static String remoteContent;
    public static final String WEBSITEURISTRING = "http://www.finalcrypt.org/";
    public static final String REMOTEPACKAGEDOWNLOADURISTRING = "http://www.finalcrypt.org/project-6.php";
    private static URL remoteURL;
    private static ReadableByteChannel localVersionByteChannel;
    private static ReadableByteChannel latestVersionByteChannel;
    private static ByteBuffer byteBufferLocal;
    private static ByteBuffer byteBufferRemote;
    private static boolean localVersionIsKnown;
    private static boolean latestVersionIsKnown;
    private static boolean updateAvailable;
    private static String[] localFields;
    private static String[] localValues;
    private static String[] remoteFields;
    private static String[] remoteValues;
    private static String localReleaseString;
    private static String latestReleaseString;
    private static String latestAlertSubjectString;
    private static String latestAlertString;
    private static String localAlertSubjectString;
    private static String localAlertString;
    public static int localVersion;
    public static int latestRemoteVersion;
    private int localUpgrade;
    private int localUpdate;
    private String localUpdateNotes = "";
    private String localVersionNotes = "";
    private String localUpgradeNotes = "";
    private String latestUpdateNotes = "";
    private String latestVersionNotes = "";
    private String latestUpgradeNotes = "";

    public Version(UI ui) {
        this.ui = ui;
        localReleaseString = "";
        latestReleaseString = "";
        latestAlertSubjectString = "";
        latestAlertString = "";
        localAlertSubjectString = "";
        localAlertString = "";
    }

    public static String getSysEnv(String classname, Version version, Configuration configuration) {
        fcInterface = classname;
        String content = "";
        content = content + Version.getSysEnvWelcome(classname, version, configuration);
        content = content + "\r\n";
        content = content + Version.getSysEnvHeader(classname, version, configuration);
        content = content + "\r\n";
        content = content + Version.getSysEnvOS(classname, version, configuration);
        content = content + "\r\n";
        content = content + Version.getSysEnvSystem(classname, version, configuration);
        content = content + "\r\n";
        content = content + Version.getSysEnvJava(classname, version, configuration);
        content = content + "\r\n";
        content = content + Version.getSysEnvUser(classname, version, configuration);
        content = content + "\r\n";
        content = content + Version.getSysEnvCaption(classname, version, configuration);
        content = content + "\r\n";
        content = content + "\r\n";
        return content;
    }

    public static String getSysEnvEmail(String classname, Version version, Configuration configuration) {
        fcInterface = classname;
        String content = "";
        content = content + Version.getSysEnvHeader(classname, version, configuration);
        content = content + "\r\n";
        content = content + Version.getSysEnvOS(classname, version, configuration);
        content = content + "\r\n";
        content = content + Version.getSysEnvSystem(classname, version, configuration);
        content = content + "\r\n";
        content = content + Version.getSysEnvJava(classname, version, configuration);
        content = content + "\r\n";
        content = content + Version.getSysEnvUser(classname, version, configuration);
        content = content + "\r\n";
        return content;
    }

    public static String getSysEnvWelcome(String classname, Version version, Configuration configuration) {
        fcInterface = classname;
        String content = "";
        content = content + "Welcome to:              FinalCrypt " + version.getLocalOverallVersionString() + "\r\n";
        return content;
    }

    public static String getSysEnvHeader(String classname, Version version, Configuration configuration) {
        fcInterface = classname;
        String content = "";
        content = content + "Interface:               " + fcInterface + "\r\n";
        content = content + "Author:                  Ron de Jong\r\n";
        content = content + "Email:                   ron@finalcrypt.org\r\n";
        content = content + "Logfiles:                " + configuration.getLogDirPath().toString() + "\r\n";
        content = content + "Command line:            " + COMMANDLINE + " --help\r\n";
        content = content + "License:                 Creative Commons License: (CC BY-NC-ND 4.0)\r\n";
        return content;
    }

    public static String getLogDirPath(String classname, Version version, Configuration configuration) {
        fcInterface = classname;
        String content = "";
        content = content + configuration.getLogDirPath().toString();
        return content;
    }

    public static String getSysEnvOS(String classname, Version version, Configuration configuration) {
        fcInterface = classname;
        String content = "";
        content = content + "OS Name:                 " + OS_NAME + "\r\n";
        content = content + "OS Architecture:         " + OS_ARCH + "\r\n";
        content = content + "OS Version:              " + OS_VERSION + "\r\n";
        content = content + "OS Time:                 " + configuration.getTime() + "\r\n";
        content = content + "File Encoding:           " + FILE_ENCODING + "\r\n";
        return content;
    }

    public static String getSysEnvSystem(String classname, Version version, Configuration configuration) {
        fcInterface = classname;
        String content = "";
        content = content + "Processors:              " + PROCESSORS + "\r\n";
        content = content + "Total   Memory:          " + Validate.getHumanSize(TOT_MEM, 1, "Bytes") + "\r\n";
        content = content + "Maximum Memory:          " + Validate.getHumanSize(MAX_MEM, 1, "Bytes") + "\r\n";
        content = content + "Free    Memory:          " + Validate.getHumanSize(FREE_MEM, 1, "Bytes") + "\r\n";
        content = content + "Used    Memory:          " + Validate.getHumanSize(USED_MEM, 1, "Bytes") + "\r\n";
        return content;
    }

    public static String getSysEnvJava(String classname, Version version, Configuration configuration) {
        fcInterface = classname;
        String content = "";
        content = content + "Java Version:            " + JAVA_VERSION + "\r\n";
        content = content + "Java Vendor:             " + JAVA_VENDOR + "\r\n";
        content = content + "Java Home:               " + JAVA_HOME + "\r\n";
        content = content + "Java_VM_Name:            " + JAVA_VM_NAME + "\r\n";
        content = content + "Java_VM_Version:         " + JAVA_VM_VERSION + "\r\n";
        content = content + "Java_Runtime_Version:    " + JAVA_RUNTIME_VERSION + "\r\n";
        content = content + "Class Version:           " + CLASS_VERSION + "\r\n";
        return content;
    }

    public static String getSysEnvUser(String classname, Version version, Configuration configuration) {
        fcInterface = classname;
        String content = "";
        content = content + "User Country:            " + USER_COUNTRY + "\r\n";
        content = content + "User Language:           " + USER_LANGUAGE + "\r\n";
        content = content + "User Name:               " + USER_NAME + "\r\n";
        content = content + "User Home:               " + USER_HOME + "\r\n";
        content = content + "User Dir:                " + USER_DIR + "\r\n";
        content = content + "User Agent:              " + Version.getUserAgent("") + "\r\n";
        return content;
    }

    public static String getSysEnvCaption(String classname, Version version, Configuration configuration) {
        fcInterface = classname;
        String content = "";
        content = content + "Action Symbols           ";
        content = content + "+ = Create | ";
        content = content + "R = Read | ";
        content = content + "W = Write | ";
        content = content + "E = Encrypt | ";
        content = content + "D = Decrypt | ";
        content = content + "X = XOR | ";
        content = content + "S = Shred | ";
        content = content + "C = Clone | ";
        content = content + "- = Delete | ";
        content = content + "PS = Pause | ";
        content = content + "UP = UnPause | ";
        content = content + "ST = Stop ";
        content = content + "\r\n";
        content = content + "Data   Symbols           ";
        content = content + "O = Old Target | ";
        content = content + "N = New Target | ";
        content = content + "M = Message Authentication Code (MAC) | ";
        content = content + "K = Key | ";
        content = content + "A = File Attributes ";
        content = content + "\r\n";
        content = content + "Status Symbols           ";
        content = content + "S = Succeeded | ";
        content = content + "? = Success Unknown | ";
        content = content + "U = Unsucceeded | ";
        content = content + "UE = Unencryptable | ";
        content = content + "UD = Undecryptable ";
        content = content + "\r\n";
        content = content + "\r\n";
        return content;
    }

    public synchronized String checkLocalVersion(UI ui) {
        istream = this.getClass().getResourceAsStream(LOCALVERSIONFILEURLSTRING);
        localOverallVersionString = "Unknown";
        localVersionByteChannel = Channels.newChannel(istream);
        byteBufferLocal = ByteBuffer.allocate(100000);
        byteBufferLocal.clear();
        localContent = "";
        try {
            while (localVersionByteChannel.read(byteBufferLocal) > 0) {
                byteBufferLocal.flip();
                while (byteBufferLocal.hasRemaining()) {
                    localContent = localContent + (char)byteBufferLocal.get();
                }
            }
        }
        catch (IOException ex) {
            ui.log("Error: Version.checkLocalInstalledVersion IOException: Channel.read(..): " + ex.getMessage() + "\r\n", true, true, true, true, false);
        }
        try {
            localVersionByteChannel.close();
        }
        catch (IOException ex) {
            ui.log("Error: Version.checkLocallyInstalledVersion IOException: Channel.close(..) " + ex.getMessage() + "\r\n", true, true, true, true, false);
        }
        String[] lines = localContent.split("\n");
        localFields = new String[lines.length];
        localValues = new String[lines.length];
        int c = 0;
        for (String line : lines) {
            String localValue;
            if (line == null || line.isEmpty() || !line.contains("[") || !line.contains("]") || !line.contains("{") || !line.contains("}")) continue;
            boolean validLine = false;
            String localField = line.substring(line.indexOf("[") + 1, line.indexOf("]"));
            if (!localField.isEmpty()) {
                Version.localFields[c] = localField;
                validLine = true;
            }
            if (!(localValue = line.substring(line.indexOf("{") + 1, line.lastIndexOf("}"))).isEmpty()) {
                Version.localValues[c] = localValue;
                validLine = true;
            }
            if (!validLine) continue;
            ++c;
        }
        if (localFields.length > 0) {
            for (int x = 0; x < localFields.length; ++x) {
                if (localFields[x] == null) continue;
                if (localValues[x] == null) {
                    Version.localValues[x] = "";
                }
                if (localFields[x].toLowerCase().equals("Version".toLowerCase())) {
                    localOverallVersionString = localValues[x];
                    String localVersionString = localOverallVersionString.substring(0, localOverallVersionString.indexOf(".")).replaceAll("[^\\d]", "");
                    String localUpgradeString = localOverallVersionString.substring(localOverallVersionString.indexOf("."), localOverallVersionString.lastIndexOf(".")).replaceAll("[^\\d]", "");
                    String localUpdateString = localOverallVersionString.substring(localOverallVersionString.lastIndexOf("."), localOverallVersionString.length()).replaceAll("[^\\d]", "");
                    localVersion = Integer.parseInt(localVersionString);
                    this.localUpgrade = Integer.parseInt(localUpgradeString);
                    this.localUpdate = Integer.parseInt(localUpdateString);
                    localVersionTotal = localVersion * 100 + this.localUpgrade * 10 + this.localUpdate * 1;
                    localOverallVersionString = localVersionString + "." + localUpgradeString + "." + localUpdateString;
                    localOverallVersionPrefString = "-" + localVersionString + "-" + localUpgradeString;
                    localVersionIsKnown = true;
                }
                if (localFields[x].toLowerCase().equals("Version Notes".toLowerCase())) {
                    this.localVersionNotes = this.localVersionNotes + localValues[x] + "\r\n";
                }
                if (localFields[x].toLowerCase().equals("Upgrade Notes".toLowerCase())) {
                    this.localUpgradeNotes = this.localUpgradeNotes + localValues[x] + "\r\n";
                }
                if (localFields[x].toLowerCase().equals("Update Notes".toLowerCase())) {
                    this.localUpdateNotes = this.localUpdateNotes + localValues[x] + "\r\n";
                }
                if (localFields[x].toLowerCase().equals("Alert Subject".toLowerCase())) {
                    localAlertSubjectString = localValues[x];
                }
                if (!localFields[x].toLowerCase().equals("Alert Notes".toLowerCase())) continue;
                localAlertString = localAlertString + localValues[x] + "\r\n";
            }
            if (this.localVersionNotes.length() > 0 && this.localUpgradeNotes.length() > 0 && this.localVersionNotes.length() > 0 && localVersionIsKnown) {
                localReleaseString = localReleaseString + this.localUpdateNotes;
                localReleaseString = localReleaseString + "\r\n";
                localReleaseString = localReleaseString + this.localUpgradeNotes;
                localReleaseString = localReleaseString + "\r\n";
                localReleaseString = localReleaseString + this.localVersionNotes;
                return localOverallVersionString;
            }
        }
        return "Could not check your current version (VERSION2 file missing?)";
    }

    public static String encode2URL(UI ui, String value) {
        String returnValue = "";
        try {
            returnValue = URLEncoder.encode(value, StandardCharsets.UTF_8.toString()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException ex) {
            ui.log("Error: Version.encodeValue URLEncoder.encode(" + value + ") (URL Encoding?)\r\n", false, true, true, true, false);
        }
        return returnValue;
    }

    private static String getUserAgent(String connType) {
        String userAgent = "";
        userAgent = userAgent + Version.getProductName() + "/" + Version.getLocalOverallVersionString() + " " + fcInterface + " " + connType;
        userAgent = userAgent + " (" + OS_NAME + " " + OS_VERSION + "; " + OS_ARCH + "; ";
        userAgent = userAgent + JAVA_VENDOR + " " + JAVA_VERSION + " " + CLASS_VERSION;
        userAgent = userAgent + ")";
        return userAgent;
    }

    public static String httpGetRequest(UI ui, String urlString, String requestMethod) {
        String userAgent = Version.getUserAgent("(HTTP)");
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException ex) {
            checkOnlineFailed = true;
            ui.log("Error: httpGetRequest MalformedURLException: new URL(" + urlString + ") (URL Typo?)\r\n", false, true, true, true, false);
            return null;
        }
        if (url == null) {
            checkOnlineFailed = true;
            ui.log("Error: httpGetRequest InvalidURL: url = new URL(" + urlString + "); (URL Typo?)\r\n", false, true, true, true, false);
            return null;
        }
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)url.openConnection();
        }
        catch (IOException ex) {
            checkOnlineFailed = true;
            ui.log("Error: httpGetRequest IOException: url.openConnection(): " + ex.getMessage() + "\r\n", false, true, true, true, false);
            return null;
        }
        httpURLConnection.setConnectTimeout(3000);
        httpURLConnection.setReadTimeout(3000);
        httpURLConnection.setRequestProperty("User-Agent", userAgent);
        try {
            httpURLConnection.setRequestMethod(requestMethod);
        }
        catch (ProtocolException ex) {
            checkOnlineFailed = true;
            ui.log("Error: httpGetRequest ProtocolException: httpConnection.setRequestMethod(\"GET\"): " + ex.getMessage() + "\r\n", false, true, true, true, false);
            return null;
        }
        int responseCode = 0;
        try {
            responseCode = httpURLConnection.getResponseCode();
        }
        catch (IOException ex) {
            checkOnlineFailed = true;
            ui.log("Error: httpGetRequest IOException: httpConnection.getResponseCode(): " + ex.getMessage() + "\r\n", false, true, true, true, false);
            return null;
        }
        if (responseCode >= 200 && responseCode < 400) {
            BufferedReader responseReader = null;
            try {
                responseReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            }
            catch (IOException ex) {
                checkOnlineFailed = true;
                ui.log("Error: httpGetRequest IOException: new InputStreamReader(httpConnection.getInputStream()): " + ex.getMessage() + "\r\n", false, true, true, true, false);
                return null;
            }
            StringBuffer response = new StringBuffer();
            try {
                String responseLine;
                while ((responseLine = responseReader.readLine()) != null) {
                    response.append(responseLine + "\n");
                }
            }
            catch (IOException ex) {
                checkOnlineFailed = true;
                ui.log("Error: httpGetRequest IOException: responseReader.readLine(): " + ex.getMessage() + "\r\n", false, true, true, true, false);
            }
            try {
                responseReader.close();
            }
            catch (IOException ex) {
                checkOnlineFailed = true;
                ui.log("Error: httpGetRequest IOException: responseReader.close(): " + ex.getMessage() + "\r\n", false, true, true, true, false);
            }
            httpURLConnection.disconnect();
            return response.toString();
        }
        checkOnlineFailed = true;
        ui.log("Error: httpGetRequest HTTP Response Code: " + responseCode + "\r\n", false, true, true, true, false);
        return null;
    }

    public static String httpsGetRequest(UI ui, String urlString, String requestMethod) {
        String userAgent = Version.getUserAgent("(HTTPS)");
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException ex) {
            checkOnlineFailed = true;
            ui.log("Error: MalformedURLException: new URL(" + urlString + ") (URL Typo?)\r\n", false, true, true, true, false);
        }
        if (url == null) {
            checkOnlineFailed = true;
            ui.log("Error: InvalidURL: url = new URL(" + urlString + "); (URL Typo?)\r\n", false, true, true, true, false);
            return null;
        }
        HttpsURLConnection httpsURLConnection = null;
        try {
            httpsURLConnection = (HttpsURLConnection)url.openConnection();
        }
        catch (IOException ex) {
            checkOnlineFailed = true;
            ui.log("Error: IOException: url.openConnection(): " + ex.getMessage() + "\r\n", false, true, true, true, false);
        }
        httpsURLConnection.setConnectTimeout(3000);
        httpsURLConnection.setReadTimeout(3000);
        try {
            httpsURLConnection.setRequestMethod(requestMethod);
        }
        catch (ProtocolException ex) {
            checkOnlineFailed = true;
            ui.log("Error: ProtocolException: httpsURLConnection.setRequestMethod(\"GET\"): " + ex.getMessage() + "\r\n", false, true, true, true, false);
        }
        httpsURLConnection.setRequestProperty("User-Agent", userAgent);
        httpsURLConnection.setRequestProperty("Referer", WEBSITEURISTRING);
        int responseCode = 0;
        try {
            responseCode = httpsURLConnection.getResponseCode();
        }
        catch (IOException ex) {
            checkOnlineFailed = true;
            ui.log("Error: IOException: httpsURLConnection.getResponseCode(): " + ex.getMessage() + "\r\n", false, true, true, true, false);
        }
        if (responseCode >= 200 && responseCode < 400) {
            BufferedReader responseReader = null;
            try {
                responseReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
            }
            catch (IOException ex) {
                checkOnlineFailed = true;
                ui.log("Error: IOException: new InputStreamReader(httpsURLConnection.getInputStream()): " + ex.getMessage() + "\r\n", false, true, true, true, false);
            }
            StringBuffer response = new StringBuffer();
            try {
                String responseLine;
                while ((responseLine = responseReader.readLine()) != null) {
                    response.append(responseLine + "\n");
                }
            }
            catch (IOException ex) {
                checkOnlineFailed = true;
                ui.log("Error: IOException: responseReader.readLine() " + ex.getCause() + "\r\n", false, true, true, true, false);
            }
            try {
                responseReader.close();
            }
            catch (IOException ex) {
                checkOnlineFailed = true;
                ui.log("Error: IOException: responseReader.close(): " + ex.getMessage() + "\r\n", false, true, true, true, false);
            }
            httpsURLConnection.disconnect();
            return response.toString();
        }
        checkOnlineFailed = true;
        ui.log("Error: HTTP Response Code: " + responseCode + "\r\n", false, true, true, true, false);
        return null;
    }

    public synchronized String checkLatestVersion(UI ui) {
        latestVersionIsKnown = false;
        latestOverallVersionString = "Unknown";
        for (String remoteVERSION2FileURLString : REMOTEVERSIONFILEURLSTRINGARRAY) {
            checkOnlineFailed = false;
            Thread logThread = new Thread(() -> ui.log("Fetch: " + remoteVERSION2FileURLString + "\r\n", false, true, true, false, false));
            logThread.setName("logThread");
            logThread.setDaemon(true);
            logThread.start();
            remoteContent = remoteVERSION2FileURLString.startsWith("https://") ? Version.httpsGetRequest(ui, remoteVERSION2FileURLString, "GET") : Version.httpGetRequest(ui, remoteVERSION2FileURLString, "GET");
            if (remoteContent == null || checkOnlineFailed) continue;
            String[] lines = remoteContent.split("\n");
            remoteFields = new String[lines.length];
            remoteValues = new String[lines.length];
            if (lines.length <= 0) continue;
            int c = 0;
            for (String line : lines) {
                String remoteValue;
                if (line == null || line.isEmpty() || !line.contains("[") || !line.contains("]") || !line.contains("{") || !line.contains("}")) continue;
                boolean validLine = false;
                String remoteField = line.substring(line.indexOf("[") + 1, line.indexOf("]"));
                if (!remoteField.isEmpty()) {
                    Version.remoteFields[c] = remoteField;
                    validLine = true;
                }
                if (!(remoteValue = line.substring(line.indexOf("{") + 1, line.lastIndexOf("}"))).isEmpty()) {
                    Version.remoteValues[c] = remoteValue;
                    validLine = true;
                }
                if (!validLine) continue;
                ++c;
            }
            if (remoteFields.length <= 0) continue;
            for (int x = 0; x < remoteFields.length; ++x) {
                if (remoteFields[x] == null) continue;
                if (remoteValues[x] == null) {
                    Version.remoteValues[x] = "";
                }
                if (remoteFields[x].toLowerCase().equals("Version".toLowerCase())) {
                    latestOverallVersionString = remoteValues[x];
                    String latestVersionString = latestOverallVersionString.substring(0, latestOverallVersionString.indexOf(".")).replaceAll("[^\\d]", "");
                    String latestUpgradeString = latestOverallVersionString.substring(latestOverallVersionString.indexOf("."), latestOverallVersionString.lastIndexOf(".")).replaceAll("[^\\d]", "");
                    String latestUpdateString = latestOverallVersionString.substring(latestOverallVersionString.lastIndexOf("."), latestOverallVersionString.length()).replaceAll("[^\\d]", "");
                    latestRemoteVersion = Integer.parseInt(latestVersionString);
                    int latestUpgrade = Integer.parseInt(latestUpgradeString);
                    int latestUpdate = Integer.parseInt(latestUpdateString);
                    latestVersionTotal = latestRemoteVersion * 100 + latestUpgrade * 10 + latestUpdate * 1;
                    latestOverallVersionString = latestVersionString + "." + latestUpgradeString + "." + latestUpdateString;
                    latestVersionIsKnown = true;
                }
                if (remoteFields[x].toLowerCase().equals("Version Notes".toLowerCase())) {
                    this.latestVersionNotes = this.latestVersionNotes + remoteValues[x] + "\r\n";
                }
                if (remoteFields[x].toLowerCase().equals("Upgrade Notes".toLowerCase())) {
                    this.latestUpgradeNotes = this.latestUpgradeNotes + remoteValues[x] + "\r\n";
                }
                if (remoteFields[x].toLowerCase().equals("Update Notes".toLowerCase())) {
                    this.latestUpdateNotes = this.latestUpdateNotes + remoteValues[x] + "\r\n";
                }
                if (remoteFields[x].toLowerCase().equals("Alert Subject".toLowerCase())) {
                    latestAlertSubjectString = remoteValues[x];
                }
                if (!remoteFields[x].toLowerCase().equals("Alert Notes".toLowerCase())) continue;
                latestAlertString = latestAlertString + remoteValues[x] + "\r\n";
            }
            if (this.latestVersionNotes.length() <= 0 || this.latestUpgradeNotes.length() <= 0 || this.latestUpdateNotes.length() <= 0 || !latestVersionIsKnown) continue;
            latestReleaseString = latestReleaseString + this.latestUpdateNotes;
            latestReleaseString = latestReleaseString + "\r\n";
            latestReleaseString = latestReleaseString + this.latestUpgradeNotes;
            latestReleaseString = latestReleaseString + "\r\n";
            latestReleaseString = latestReleaseString + this.latestVersionNotes;
            return latestOverallVersionString;
        }
        if (latestVersionIsKnown) {
            return latestOverallVersionString;
        }
        return "Could not check for new updates (Internet?)";
    }

    public static String getLatestOnlineOverallVersionString() {
        return latestOverallVersionString;
    }

    public static String getLocalOverallVersionString() {
        return localOverallVersionString;
    }

    public static String getLocalOverallVersionPrefString() {
        return localOverallVersionPrefString;
    }

    public static String getLocalReleaseString() {
        return localReleaseString;
    }

    public static String getLatestReleaseString() {
        return latestReleaseString;
    }

    public static String getLatestAlertSubjectString() {
        return latestAlertSubjectString;
    }

    public static String getLatestAlertString() {
        return latestAlertString;
    }

    public static String getLocalAlertSubjectString() {
        return localAlertSubjectString;
    }

    public static String getLocalAlertString() {
        return localAlertString;
    }

    public String getUpdateStatus() {
        String returnString = "";
        if (localVersionIsKnown && latestVersionIsKnown) {
            if (localVersionTotal < latestVersionTotal) {
                returnString = returnString + Version.getProductName() + " " + localOverallVersionString + " can be updated to version: " + latestOverallVersionString + " at: " + REMOTEPACKAGEDOWNLOADURISTRING + "\r\n";
                if (!Version.getLatestReleaseString().isEmpty()) {
                    returnString = returnString + Version.getLatestReleaseString() + "\r\n";
                }
            } else {
                returnString = localVersionTotal > latestVersionTotal ? returnString + Version.getProductName() + " " + localOverallVersionString + " is a development version!\r\n" : returnString + Version.getProductName() + " " + localOverallVersionString + " is up to date\r\n";
            }
        } else {
            if (!localVersionIsKnown) {
                returnString = "Could not retrieve the locally installed " + Version.getProductName() + " Version\r\n";
            }
            if (!latestVersionIsKnown) {
                returnString = "Could not retrieve the latest online " + Version.getProductName() + " Version\r\n";
            }
        }
        return returnString;
    }

    public static synchronized void openWebSite(UI ui, String[] SITEURLSTRINGARRAY, String requestMethod) {
        String identifierExpected = PRODUCTNAME;
        Configuration configuration = new Configuration(ui);
        for (String SITEURLSTRING : SITEURLSTRINGARRAY) {
            checkOnlineFailed = false;
            if (!SITEURLSTRING.isEmpty()) {
                remoteContent = "";
                ui.log("Website: " + SITEURLSTRING + "\r\n", false, true, true, false, false);
                remoteContent = SITEURLSTRING.startsWith("https://") ? Version.httpsGetRequest(ui, SITEURLSTRING, requestMethod) : Version.httpGetRequest(ui, SITEURLSTRING, requestMethod);
                if (!checkOnlineFailed) {
                    if (remoteContent != null) {
                        if (remoteContent.toLowerCase().contains(identifierExpected.toLowerCase()) || SITEURLSTRING.endsWith(".mp4")) {
                            ui.log("Opening Browser\r\n", false, true, true, false, false);
                            Thread openWebSiteThread = new Thread(() -> {
                                try {
                                    Desktop.getDesktop().browse(new URI(SITEURLSTRING));
                                }
                                catch (URISyntaxException ex) {
                                    ui.log("Version.openWebSite() Desktop.getDesktop().browse URISyntaxException: " + ex.getMessage() + "\r\n", true, true, true, true, false);
                                }
                                catch (IOException ex) {
                                    ui.log("Version.openWebSite() Desktop.getDesktop().browse IOException: " + ex.getMessage() + "\r\n", true, true, true, true, false);
                                }
                                catch (UnsupportedOperationException ex) {
                                    ui.log("Version.openWebSite() Desktop.getDesktop().browse UnsupportedOperationException: " + ex.getMessage() + " " + SITEURLSTRING + "\r\n", true, true, true, true, false);
                                }
                            });
                            openWebSiteThread.setName("openWebSiteThread");
                            openWebSiteThread.setDaemon(true);
                            openWebSiteThread.start();
                            break;
                        }
                        ui.log("Invalid webpage content\r\n", false, true, true, true, false);
                        continue;
                    }
                    ui.log("Empty webpage\r\n", false, true, true, true, false);
                    continue;
                }
                ui.log("Opening Browser Failed!\r\n", false, true, true, true, false);
                continue;
            }
            ui.log("Error: openWebSite Empty website url: " + SITEURLSTRING + "\r\n", false, true, true, true, false);
        }
        ui.log("\r\n", false, true, true, true, false);
    }

    public static synchronized void openLogDir(UI ui) {
        Configuration configuration = new Configuration(ui);
        Thread openLogDirThread = new Thread(() -> {
            try {
                Desktop.getDesktop().open(configuration.getLogDirPath().toFile());
            }
            catch (IOException ex) {
                ui.log("Version.openEmail() Desktop.getDesktop().open(() IOException: " + ex.getMessage() + "\r\n", true, true, true, true, false);
            }
        });
        openLogDirThread.setName("openLogDirThread");
        openLogDirThread.setDaemon(true);
        openLogDirThread.start();
    }

    public static synchronized void openEmail(UI ui, String mailto, String cc, String subject, String body) {
        Configuration configuration = new Configuration(ui);
        String mailTo = SUPPORTEMAIL;
        String mailURIStr = String.format("mailto:%s?subject=%s&cc=%s&body=%s", mailTo, subject, cc, body);
        try {
            mailtoURI = new URI(mailURIStr);
        }
        catch (URISyntaxException ex) {
            ui.log(ex.getMessage(), true, true, true, true, false);
        }
        Thread openEmailThread = new Thread(() -> {
            try {
                Desktop.getDesktop().mail(mailtoURI);
            }
            catch (IOException ex) {
                ui.log("Version.openEmail() Desktop.getDesktop().mail(() IOException: " + ex.getMessage() + "\r\n", true, true, true, true, false);
            }
        });
        openEmailThread.setName("openEmailThread");
        openEmailThread.setDaemon(true);
        openEmailThread.start();
    }

    public boolean latestVersionIsKnown() {
        return latestVersionIsKnown;
    }

    public boolean versionIsDifferent() {
        return latestVersionIsKnown && localVersionTotal != latestVersionTotal;
    }

    public boolean versionCanBeUpdated() {
        return latestVersionIsKnown && localVersionTotal < latestVersionTotal;
    }

    public boolean versionIsDevelopment() {
        return latestVersionIsKnown && localVersionTotal > latestVersionTotal;
    }

    public static String getLicenseDescription() {
        return LICENSE_DESCRIPTION;
    }

    public static String getLicense() {
        return LICENSE;
    }

    public static String getAuthor() {
        return AUTHOR;
    }

    public static String getAuthorEmail() {
        return AUTHOREMAIL;
    }

    public static String getEmail() {
        return EMAIL;
    }

    public static String getProductName() {
        return PRODUCTNAME;
    }

    public static String getCommandLine() {
        return COMMANDLINE;
    }

    public static String getCompany() {
        return COMPANYNAME;
    }

    static {
        COMMANDLINE = "java -cp " + PRODUCTNAME.toLowerCase() + ".jar rdj.CLUI";
        fcInterface = "";
        LICENSE_DESCRIPTION = "License 2017-" + Calendar.getInstance().get(1);
        OS_NAME = System.getProperty("os.name");
        OS_VERSION = System.getProperty("os.version");
        OS_ARCH = System.getProperty("os.arch");
        FILE_ENCODING = System.getProperty("file.encoding");
        PROCESSORS = Runtime.getRuntime().availableProcessors();
        TOT_MEM = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize();
        MAX_MEM = Runtime.getRuntime().maxMemory();
        FREE_MEM = Runtime.getRuntime().freeMemory();
        USED_MEM = Runtime.getRuntime().totalMemory();
        JAVA_VENDOR = System.getProperty("java.vendor");
        JAVA_VERSION = System.getProperty("java.version");
        CLASS_VERSION = System.getProperty("java.class.version");
        JAVA_HOME = System.getProperty("java.home");
        JAVA_VM_VERSION = System.getProperty("java.vm.version");
        JAVA_VM_NAME = System.getProperty("java.vm.name");
        JAVA_RUNTIME_VERSION = System.getProperty("java.runtime.version");
        USER_COUNTRY = System.getProperty("user.country");
        USER_LANGUAGE = System.getProperty("user.language");
        USER_NAME = System.getProperty("user.name");
        USER_HOME = System.getProperty("user.home");
        USER_DIR = System.getProperty("user.dir");
        localOverallVersionString = "";
        localOverallVersionPrefString = "";
        latestOverallVersionString = "";
        localVersionTotal = 0;
        latestVersionTotal = 0;
        istream = null;
        localContent = "";
        HOMEPAGEURLSTRINGARRAY = new String[]{WEBSITEURISTRING, "https://www.finalcrypt.org/", "http://www.finalcrypt.com/", "https://www.finalcrypt.com/", "https://sourceforge.net/projects/finalcrypt/files/", "https://github.com/ron-from-nl/FinalCrypt/releases/", "https://osdn.net/users/finalcrypt/pf/FinalCrypt/files/", "http://www.majorgeeks.com/files/details/finalcrypt.html", "http://sites.google.com/site/ronuitholland/home/finalcrypt/", "http://duckduckgo.com/?q=finalcrypt+homepage&t=h_&ia=web", "http://www.google.com/search?q=finalcrypt+homepage&oq=finalcrypt+homepage"};
        DOWNLOADPAGEURLSTRINGARRAY = new String[]{REMOTEPACKAGEDOWNLOADURISTRING, "https://www.finalcrypt.org/project-6.php", "http://www.finalcrypt.com/project-6.php", "https://www.finalcrypt.com/project-6.php", "https://sourceforge.net/projects/finalcrypt/files/", "https://github.com/ron-from-nl/FinalCrypt/releases/", "https://osdn.net/users/finalcrypt/pf/FinalCrypt/files/", "http://www.majorgeeks.com/files/details/finalcrypt.html", "http://sites.google.com/site/ronuitholland/home/finalcrypt/", "http://duckduckgo.com/?q=finalcrypt+homepage&t=h_&ia=web", "http://www.google.com/search?q=finalcrypt+homepage&oq=finalcrypt+homepage"};
        VIDEOPAGEURLSTRINGARRAY = new String[]{"http://www.finalcrypt.org/video/how_does_finalcrypt_work.mp4", "https://www.finalcrypt.org/video/how_does_finalcrypt_work.mp4", "http://www.finalcrypt.com/video/how_does_finalcrypt_work.mp4", "https://www.finalcrypt.com/video/how_does_finalcrypt_work.mp4", "https://youtu.be/MRKREuF_ovI"};
        SUPPORTPAGEURLSTRINGARRAY = new String[]{"http://www.finalcrypt.org/project-7.php", "https://www.finalcrypt.org/project-7.php", "http://www.finalcrypt.com/project-7.php", "https://www.finalcrypt.com/project-7.php", "https://sourceforge.net/projects/finalcrypt/support", "https://github.com/ron-from-nl/FinalCrypt/issues", "https://osdn.net/users/finalcrypt/pf/FinalCrypt/ticket/", "http://www.majorgeeks.com/files/details/finalcrypt.html", "http://sites.google.com/site/ronuitholland/home/finalcrypt/", "http://duckduckgo.com/?q=finalcrypt+homepage&t=h_&ia=web", "http://www.google.com/search?q=finalcrypt+homepage&oq=finalcrypt+homepage"};
        REMOTEVERSIONFILEURLSTRINGARRAY = new String[]{"https://www.finalcrypt.org/VERSION2", "http://www.finalcrypt.org/VERSION2", "https://www.finalcrypt.com/VERSION2", "http://www.finalcrypt.com/VERSION2", "https://sourceforge.net/p/finalcrypt/code/ci/master/tree/src/rdj/VERSION2?format=raw", "https://raw.githubusercontent.com/ron-from-nl/FinalCrypt/master/src/rdj/VERSION2", "https://osdn.net/users/finalcrypt/pf/FinalCrypt/scm/blobs/master/src/rdj/VERSION2?export=raw", "https://gitlab.com/finalcrypt/finalcrypt/raw/master/src/rdj/VERSION2"};
        remoteContent = "";
        remoteURL = null;
        localVersionByteChannel = null;
        latestVersionByteChannel = null;
        localVersionIsKnown = false;
        latestVersionIsKnown = false;
        updateAvailable = false;
    }
}

