/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import rdj.AudioPlayer;
import rdj.Configuration;
import rdj.GUIFX;
import rdj.Version;

public class Support
extends Application
implements Initializable {
    private Parent root;
    private Stage stage;
    private Scene scene;
    private FXMLLoader loader;
    private GUIFX guifx;
    private boolean exitAppOnClose = false;
    public Support controller;
    @FXML
    private Label headerLabel;
    @FXML
    private Label line1Label;
    @FXML
    private Label line2Label;
    @FXML
    private Label statusLabel;
    @FXML
    private ImageView facebookImageView;
    @FXML
    private ImageView twitterImageView;
    @FXML
    private ImageView linkedInImageView;
    @FXML
    private ImageView pinterestImageView;
    @FXML
    private ImageView homeImageView;
    @FXML
    private ImageView supportImageView;
    @FXML
    private ImageView emailImageView;
    @FXML
    private ImageView videoImageView;
    private Preferences prefs;
    private ResourceBundle bundle;
    private Version version;

    public void switchLanguage(Locale locale) {
        if (locale != null) {
            this.bundle = ResourceBundle.getBundle("rdj.language.translation", locale);
            this.headerLabel.setText(this.bundle.getString("142"));
            this.line1Label.setText(this.bundle.getString("143"));
            this.line2Label.setText(this.bundle.getString("144"));
            this.statusLabel.setText(this.bundle.getString("145"));
        }
    }

    public void setExitAppOnClose(boolean exitAppOnClose) {
        this.exitAppOnClose = exitAppOnClose;
        Stage stage = (Stage)this.facebookImageView.getScene().getWindow();
        stage.setOnCloseRequest(e -> Platform.runLater(() -> {
            if (exitAppOnClose) {
                System.exit(0);
            }
        }));
    }

    public void start(Stage primaryStage) throws Exception {
        this.loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("Support.fxml"));
        this.root = (Parent)this.loader.load();
        this.controller = (Support)((Object)this.loader.getController());
        this.scene = new Scene((Parent)this.loader.getRoot());
        this.stage = primaryStage;
        this.stage.setScene(this.scene);
        this.stage.setTitle(Version.getProductName() + " Support");
        this.stage.setResizable(false);
        this.stage.setOnCloseRequest(e -> Platform.runLater(() -> {
            if (this.exitAppOnClose) {
                System.exit(0);
            }
        }));
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.facebookImageView.setImage(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/rdj/images/facebook.png")));
        this.twitterImageView.setImage(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/rdj/images/twitter.png")));
        this.linkedInImageView.setImage(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/rdj/images/linkedin.png")));
        this.pinterestImageView.setImage(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/rdj/images/pinterest.png")));
        this.homeImageView.setImage(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/rdj/images/finalcrypt.png")));
        this.supportImageView.setImage(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/rdj/images/support.png")));
        this.emailImageView.setImage(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/rdj/images/email.png")));
        this.videoImageView.setImage(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/rdj/images/video.png")));
    }

    public void setGUI(GUIFX ui) {
        this.guifx = ui;
        this.version = new Version(this.guifx);
        this.version.checkLocalVersion(this.guifx);
        Support support = this;
        this.prefs = Preferences.userRoot().node(Version.getProductName() + support.version.getLocalOverallVersionPrefString());
    }

    public void setSupportState() {
        String val = this.prefs.get("Shared", "Unknown");
        if (val.equals("Unknown")) {
            this.setSupportButtonsDisabledState(true);
        } else if (val.equals("No")) {
            this.setSupportButtonsDisabledState(true);
        } else if (val.equals("Yes")) {
            this.setSupportButtonsDisabledState(false);
        } else {
            this.setSupportButtonsDisabledState(true);
        }
    }

    private void closeWindow() {
        Platform.runLater(() -> {
            Stage stage = (Stage)this.facebookImageView.getScene().getWindow();
            stage.close();
            if (this.exitAppOnClose) {
                System.exit(0);
            }
        });
    }

    public static void main(String[] args) {
        Support.launch((String[])args);
    }

    private void flushPrefs(Preferences prefsParam) {
        try {
            prefsParam.flush();
        }
        catch (BackingStoreException ex) {
            this.guifx.log("Error: flushPrefs(..) " + ex.getMessage() + "\r\n", true, true, true, true, false);
        }
    }

    @FXML
    private void facebookImageViewOnMouseClicked(MouseEvent event) {
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/button", 2);
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/open", 2);
        Thread shareThread = new Thread(() -> {
            String urlTarget = "https://www.facebook.com/share.php";
            String param1 = "?u=" + Version.encode2URL(this.guifx, "http://www.finalcrypt.org/");
            String url = urlTarget + param1;
            this.setSupportButtonsDisabledState(false);
            try {
                Desktop.getDesktop().browse(new URI(url));
                this.prefs.put("Shared", "Yes");
                this.flushPrefs(this.prefs);
            }
            catch (URISyntaxException ex) {
                this.guifx.log("Error: URISyntaxException: " + ex.getMessage() + "\r\n", true, true, true, true, false);
            }
            catch (IOException ex) {
                this.guifx.log("Error: IOException: " + ex.getMessage() + "\r\n", true, true, true, true, false);
            }
            catch (UnsupportedOperationException ex) {
                this.guifx.log(ex.getMessage() + " " + url + "\r\n", true, true, true, true, false);
            }
            this.closeWindow();
        });
        shareThread.setName("shareThread");
        shareThread.setDaemon(true);
        shareThread.start();
    }

    @FXML
    private void twitterImageViewOnMouseClicked(MouseEvent event) {
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/button", 2);
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/open", 2);
        Thread shareThread = new Thread(() -> {
            String urlTarget = "https://twitter.com/intent/tweet";
            String param1 = "?text=" + Version.encode2URL(this.guifx, "FinalCrypt - Unbreakable OTP Encryption independent from Governments & Industries");
            String param2 = "&url=" + Version.encode2URL(this.guifx, "http://www.finalcrypt.org/");
            String param3 = "&hashtags=FinalCrypt%2CEncryption";
            String url = urlTarget + param1 + param2 + param3;
            this.setSupportButtonsDisabledState(false);
            try {
                Desktop.getDesktop().browse(new URI(url));
                this.prefs.put("Shared", "Yes");
                this.flushPrefs(this.prefs);
            }
            catch (URISyntaxException ex) {
                this.guifx.log("Error: URISyntaxException: " + ex.getMessage() + "\r\n", true, true, true, true, false);
            }
            catch (IOException ex) {
                this.guifx.log("Error: IOException: " + ex.getMessage() + "\r\n", true, true, true, true, false);
            }
            catch (UnsupportedOperationException ex) {
                this.guifx.log(ex.getMessage() + " " + url + "\r\n", true, true, true, true, false);
            }
            this.closeWindow();
        });
        shareThread.setName("shareThread");
        shareThread.setDaemon(true);
        shareThread.start();
    }

    @FXML
    private void linkedInImageViewOnMouseClicked(MouseEvent event) {
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/button", 2);
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/open", 2);
        Thread shareThread = new Thread(() -> {
            String urlTarget = "https://www.linkedin.com/sharing/share-offsite/";
            String param1 = "?url=" + Version.encode2URL(this.guifx, "http://www.finalcrypt.org/");
            String url = urlTarget + param1;
            this.setSupportButtonsDisabledState(false);
            try {
                Desktop.getDesktop().browse(new URI(url));
                this.prefs.put("Shared", "Yes");
                this.flushPrefs(this.prefs);
            }
            catch (URISyntaxException ex) {
                this.guifx.log("Error: URISyntaxException: " + ex.getMessage() + "\r\n", true, true, true, true, false);
            }
            catch (IOException ex) {
                this.guifx.log("Error: IOException: " + ex.getMessage() + "\r\n", true, true, true, true, false);
            }
            catch (UnsupportedOperationException ex) {
                this.guifx.log(ex.getMessage() + " " + url + "\r\n", true, true, true, true, false);
            }
            this.closeWindow();
        });
        shareThread.setName("shareThread");
        shareThread.setDaemon(true);
        shareThread.start();
    }

    @FXML
    private void pinterestImageViewOnMouseClicked(MouseEvent event) {
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/button", 2);
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/open", 2);
        Thread shareThread = new Thread(() -> {
            String urlTarget;
            String url = urlTarget = "https://pin.it/72kLWc2";
            this.setSupportButtonsDisabledState(false);
            try {
                Desktop.getDesktop().browse(new URI(url));
                this.prefs.put("Shared", "Yes");
                this.flushPrefs(this.prefs);
            }
            catch (URISyntaxException ex) {
                this.guifx.log("Error: URISyntaxException: " + ex.getMessage() + "\r\n", true, true, true, true, false);
            }
            catch (IOException ex) {
                this.guifx.log("Error: IOException: " + ex.getMessage() + "\r\n", true, true, true, true, false);
            }
            catch (UnsupportedOperationException ex) {
                this.guifx.log(ex.getMessage() + " " + url + "\r\n", true, true, true, true, false);
            }
            this.closeWindow();
        });
        shareThread.setName("shareThread");
        shareThread.setDaemon(true);
        shareThread.start();
    }

    public boolean getSupportButtonsDisabledState() {
        boolean bool = this.homeImageView.isDisabled();
        return bool;
    }

    public void setSupportButtonsDisabledState(boolean bool) {
        if (!bool && this.getSupportButtonsDisabledState()) {
            Thread getSupportThread = new Thread(() -> {
                this.homeImageView.setDisable(bool);
                this.homeImageView.setOpacity(1.0);
                this.videoImageView.setDisable(bool);
                this.videoImageView.setOpacity(1.0);
                this.supportImageView.setDisable(bool);
                this.supportImageView.setOpacity(1.0);
                this.emailImageView.setDisable(bool);
                this.emailImageView.setOpacity(1.0);
            });
            getSupportThread.setName("getSupportThread");
            getSupportThread.setDaemon(true);
            getSupportThread.start();
        } else if (bool && !this.getSupportButtonsDisabledState()) {
            Thread setSupportThread = new Thread(() -> {
                this.homeImageView.setDisable(bool);
                this.homeImageView.setOpacity(0.2);
                this.videoImageView.setDisable(bool);
                this.videoImageView.setOpacity(0.2);
                this.supportImageView.setDisable(bool);
                this.supportImageView.setOpacity(0.2);
                this.emailImageView.setDisable(bool);
                this.emailImageView.setOpacity(0.2);
            });
            setSupportThread.setName("setSupportThread");
            setSupportThread.setDaemon(true);
            setSupportThread.start();
        }
    }

    @FXML
    private void homeImageViewOnMouseClicked(MouseEvent event) {
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/button", 2);
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/open", 2);
        Thread homeOpenThread = new Thread(() -> {
            Version.openWebSite(this.guifx, Version.HOMEPAGEURLSTRINGARRAY, "GET");
            this.closeWindow();
        });
        homeOpenThread.setName("homeOpenThread");
        homeOpenThread.setDaemon(true);
        homeOpenThread.start();
    }

    @FXML
    private void videoImageViewOnMouseClicked(MouseEvent event) {
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/button", 2);
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/open", 2);
        Thread videoOpenThread = new Thread(() -> {
            Version.openWebSite(this.guifx, Version.VIDEOPAGEURLSTRINGARRAY, "HEAD");
            this.closeWindow();
        });
        videoOpenThread.setName("videoOpenThread");
        videoOpenThread.setDaemon(true);
        videoOpenThread.start();
    }

    @FXML
    private void supportImageViewOnMouseClicked(MouseEvent event) {
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/button", 2);
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/open", 2);
        Thread supportOpenThread = new Thread(() -> {
            Version.openWebSite(this.guifx, Version.SUPPORTPAGEURLSTRINGARRAY, "GET");
            this.closeWindow();
        });
        supportOpenThread.setName("supportOpenThread");
        supportOpenThread.setDaemon(true);
        supportOpenThread.start();
    }

    @FXML
    private void emailImageViewOnMouseClicked(MouseEvent event) {
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/button", 2);
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/open", 2);
        String to = "support@finalcrypt.org";
        String cc = "";
        String subject = Version.encode2URL(this.guifx, Version.getProductName() + " User Support");
        String bodyText = "";
        String attachLine1 = "You might want to attach logfiles from: \"" + Version.getLogDirPath(((Object)((Object)this)).getClass().getSimpleName(), this.version, new Configuration(this.guifx)) + "\".";
        String attachLine2 = "Logfiles help to see what happened and eases and speed up support.";
        bodyText = bodyText + "Hi Ron,\r\n\r\nYour message...\r\n\r\n" + attachLine1 + "\r\n" + attachLine2 + "\r\n\r\n--\r\nRegards,\r\n\r\nYour name please\r\n\r\n";
        bodyText = bodyText + "================================================================================\r\n";
        bodyText = bodyText + "======================== FinalCrypt System Support Info ========================\r\n";
        bodyText = bodyText + "================================================================================\r\n\r\n";
        bodyText = bodyText + Version.getSysEnvEmail(((Object)((Object)this)).getClass().getSimpleName(), this.version, new Configuration(this.guifx));
        bodyText = bodyText + "================================================================================\r\n";
        String body = Version.encode2URL(this.guifx, bodyText);
        Thread emailOpenThread = new Thread(() -> {
            Version.openEmail(this.guifx, to, "", subject, body);
            this.closeWindow();
        });
        emailOpenThread.setName("emailOpenThread");
        emailOpenThread.setDaemon(true);
        emailOpenThread.start();
    }
}

