/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import rdj.DeviceController;
import rdj.FCPath;
import rdj.GPT_Entries;
import rdj.GPT_Header;
import rdj.GPT_PMBR;
import rdj.UI;

public class GPT {
    UI ui;
    public GPT_PMBR gpt_PMBR;
    public GPT_Header gpt_Header1;
    public GPT_Entries gpt_Entries1;
    public GPT_Header gpt_Header2;
    public GPT_Entries gpt_Entries2;
    private int printAddressByteCounter;

    public GPT(UI ui) {
        this.ui = ui;
        this.gpt_PMBR = new GPT_PMBR(this.ui);
        this.gpt_Header1 = new GPT_Header(this.ui, this, 1L);
        this.gpt_Entries1 = new GPT_Entries(this.ui, this, 2L, 128);
        this.gpt_Header2 = new GPT_Header(this.ui, this, -1L);
        this.gpt_Entries2 = new GPT_Entries(this.ui, this, -33L, 128);
    }

    public synchronized void clear() {
        this.gpt_PMBR.clear();
        this.gpt_Header1.clear();
        this.gpt_Entries1.clear();
        this.gpt_Header2.clear();
        this.gpt_Entries2.clear();
    }

    public synchronized void read(FCPath keyDevice) {
        this.gpt_PMBR.read(keyDevice);
        this.gpt_Header1.read(keyDevice);
        this.gpt_Entries1 = new GPT_Entries(this.ui, this, 2L, this.gpt_Header1.numberOfPartitionEntries);
        this.gpt_Entries1.read(keyDevice);
        this.gpt_Header2.read(keyDevice);
        this.gpt_Entries2 = new GPT_Entries(this.ui, this, -33L, this.gpt_Header2.numberOfPartitionEntries);
        this.gpt_Entries2.read(keyDevice);
    }

    public synchronized void create(long partitionSize, FCPath targetFCPath) {
        this.gpt_PMBR.create(targetFCPath);
        this.gpt_Header1.create(targetFCPath);
        this.gpt_Entries1.create(partitionSize);
        this.gpt_Header1.setCRC32Partitions();
        this.gpt_Header1.setHeaderCRC32Bytes();
        this.gpt_Header2.create(targetFCPath);
        this.gpt_Entries2.create(partitionSize);
        this.gpt_Header2.setCRC32Partitions();
        this.gpt_Header2.setHeaderCRC32Bytes();
    }

    public synchronized void write(FCPath targetFCPath) {
        this.gpt_PMBR.write(targetFCPath);
        this.gpt_Header1.write(targetFCPath);
        this.gpt_Entries1.write(targetFCPath);
        this.gpt_Entries2.write(targetFCPath);
        this.gpt_Header2.write(targetFCPath);
    }

    public synchronized void createManualKeyPartitions(FCPath keyFCPath, FCPath targetFCPath) {
        this.gpt_Entries1.createManualKeyPartitions(keyFCPath, targetFCPath);
    }

    public synchronized void cloneManualKeypartitions(FCPath keyFCPath, FCPath targetFCPath) {
        this.gpt_Entries1.cloneManualKeyPartitions(keyFCPath, targetFCPath);
    }

    public GPT_PMBR get_GPT_PMBR() {
        return this.gpt_PMBR;
    }

    public GPT_Header get_GPT_Header1() {
        return this.gpt_Header1;
    }

    public GPT_Entries get_GPT_Entries1() {
        return this.gpt_Entries1;
    }

    public GPT_Header get_GPT_Header2() {
        return this.gpt_Header2;
    }

    public GPT_Entries get_GPT_Entries2() {
        return this.gpt_Entries2;
    }

    public static byte[] byteListToByteArray(List<Byte> list) {
        byte[] result = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static byte[] getUUID() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    public static synchronized byte[] getReverseBytes(byte[] bytes) {
        byte[] reversedBytes = new byte[bytes.length];
        for (int byteArrayCounter = bytes.length - 1; byteArrayCounter >= 0; --byteArrayCounter) {
            reversedBytes[bytes.length - 1 - byteArrayCounter] = bytes[byteArrayCounter];
        }
        return reversedBytes;
    }

    public static synchronized byte[] getZeroBytes(int length) {
        boolean zeroByte = false;
        byte[] byteArray = new byte[length];
        for (int forCounter = 0; forCounter < length; ++forCounter) {
            byteArray[forCounter] = 0;
        }
        return byteArray;
    }

    public static byte hex2Byte(String string) {
        string = string.replaceAll("[^A-Za-z0-9]", "");
        byte myByte = (byte)(Character.digit(string.charAt(0), 16) << 4 & 255 + Character.digit(string.charAt(1), 16) & 0xFF);
        return myByte;
    }

    public static int hex2Integer(String string) {
        int myInt = 0;
        if ((string = string.replaceAll("[^A-Za-z0-9]", "")).length() == 2) {
            myInt = Integer.parseUnsignedInt(string, 16);
            return myInt;
        }
        return myInt;
    }

    public static byte[] hex2Bytes(String string) {
        string = string.replaceAll("[^A-Za-z0-9]", "");
        byte[] data = new byte[string.length() / 2];
        for (int stringpos = 0; stringpos < string.length(); stringpos += 2) {
            data[stringpos / 2] = (byte)((Character.digit(string.charAt(stringpos), 16) << 4) + Character.digit(string.charAt(stringpos + 1), 16));
        }
        return data;
    }

    public static synchronized void logBytes(byte[] bytes) {
        for (byte mybyte : bytes) {
            GPT.logByte(mybyte);
        }
    }

    public static synchronized void logByte(byte dataByte) {
        String datbin = GPT.getBinaryString(dataByte);
        String dathex = GPT.getHexString(dataByte, 2);
        String datdec = GPT.getDecString(dataByte);
        String datchr = GPT.getChar(dataByte);
        System.out.print("| " + datbin + " " + dathex + " " + datdec + " " + datchr + " |\r\n");
    }

    public static synchronized byte[] getBytesPart(byte[] inBytes, int offset, int length) {
        byte[] outBytes = new byte[length];
        for (int position = offset; position < offset + length; ++position) {
            outBytes[position - offset] = inBytes[position];
        }
        return outBytes;
    }

    public static synchronized int bytesToInteger(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.put(bytes);
        bb.flip();
        return bb.getInt();
    }

    public static synchronized long bytesToLong(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.put(bytes);
        bb.flip();
        return bb.getLong();
    }

    public static synchronized String getBinaryString(Byte value) {
        return String.format("%8s", Integer.toBinaryString(value & 0xFF)).replace(' ', '0');
    }

    public static synchronized String getDecString(Byte value) {
        return String.format("%3d", value & 0xFF).replace(" ", "0").replaceAll("[^A-Za-z0-9]", "");
    }

    public static synchronized String getHexString(byte[] bytes, int digits) {
        String returnString = "";
        for (byte mybyte : bytes) {
            returnString = returnString + GPT.getHexString(mybyte, digits);
        }
        return returnString;
    }

    public static synchronized String getHexString(byte value, int digits) {
        return String.format("%0" + Integer.toString(digits) + "X", value & 0xFF).replaceAll("[^A-Za-z0-9]", "");
    }

    public static synchronized String getHexString(int value, int digits) {
        return String.format("%0" + Integer.toString(digits) + "X", value & 0xFF).replaceAll("[^A-Za-z0-9]", "");
    }

    public static synchronized String getHexString(long value, int digits) {
        return String.format("%0" + Integer.toString(digits) + "X", value).replaceAll("[^A-Za-z0-9]", "");
    }

    public static synchronized String getHexStringLittleEndian(long value, int bytes) {
        String returnString = "";
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        buffer.flip();
        for (int x = 0; x < bytes; ++x) {
            returnString = returnString + String.format("%02X", buffer.get(7 - x) & 0xFF);
        }
        buffer.clear();
        return returnString.replaceAll("[^A-Za-z0-9]", "");
    }

    public static String getHexAndDecimal(byte[] bytes, boolean decimal) {
        long allbytes = 0L;
        String returnString = "";
        String hexPrefix = "";
        String hexString = "";
        for (byte mybyte : bytes) {
            allbytes += (long)mybyte;
        }
        if (allbytes == 0L) {
            returnString = "0 [" + bytes.length + "]";
        } else {
            for (byte mybyte : bytes) {
                hexString = hexString + GPT.getHexString(mybyte, 2);
            }
            returnString = returnString + hexPrefix + String.format("%-32s", hexString);
            if (decimal) {
                if (bytes.length == 4) {
                    returnString = returnString + " " + Integer.reverseBytes(GPT.bytesToInteger(bytes));
                }
                if (bytes.length == 8) {
                    returnString = returnString + " " + Long.reverseBytes(GPT.bytesToLong(bytes));
                }
            }
            hexString = "";
            returnString = returnString + "";
        }
        return returnString;
    }

    public static synchronized String getChar(Byte myByte) {
        return String.format("%1s", Character.valueOf((char)(myByte & 0xFF))).replaceAll("\\p{C}", "?");
    }

    public static synchronized String getHumanSize(double value, int decimals, String unit) {
        long factor;
        int x = 0;
        double newValue = value;
        String returnString = new String("");
        ArrayList<String> magnitude = new ArrayList<String>();
        magnitude.addAll(Arrays.asList("Zi" + unit.charAt(0), "Ei" + unit.charAt(0), "Pi" + unit.charAt(0), "Ti" + unit.charAt(0), "Gi" + unit.charAt(0), "Mi" + unit.charAt(0), "Ki" + unit.charAt(0), unit));
        for (factor = 70L; factor > 0L; factor -= 10L) {
            if (value / Math.pow(2.0, factor) >= 1.0) {
                newValue = value / Math.pow(2.0, factor);
                returnString = String.format("%.1f", newValue) + " " + (String)magnitude.get(x);
                break;
            }
            ++x;
        }
        if (factor == 0L) {
            newValue = value / Math.pow(2.0, factor);
            returnString = String.format("%." + decimals + "f", newValue) + " " + (String)magnitude.get(x);
        }
        return returnString;
    }

    public static synchronized String getLBAHumanSize(byte[] value, int decimals) {
        if (value.length == 4) {
            return GPT.getHumanSize((long)Integer.reverseBytes(GPT.bytesToInteger(value)) * DeviceController.bytesPerSector, decimals, "Bytes");
        }
        return GPT.getHumanSize(Long.reverseBytes(GPT.bytesToLong(value)) * DeviceController.bytesPerSector, decimals, "Bytes");
    }

    public synchronized boolean validateIntegerString(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void print() {
        this.ui.log(this.toString(), false, true, true, false, false);
    }

    public String toString() {
        String returnString = "";
        returnString = returnString + this.gpt_PMBR.toString();
        returnString = returnString + this.gpt_Header1.toString();
        returnString = returnString + this.gpt_Entries1.toString();
        returnString = returnString + this.gpt_Entries2.toString();
        returnString = returnString + this.gpt_Header2.toString();
        return returnString;
    }

    public synchronized void fileStoreInfo() {
        FileSystem fs = FileSystems.getDefault();
        Iterable<FileStore> stores = fs.getFileStores();
        this.ui.log("\r\n", true, true, true, false, false);
        this.ui.log(String.format("%-70s", "Name"), true, true, true, false, false);
        this.ui.log(String.format("%-20s", "Type"), true, true, true, false, false);
        this.ui.log(String.format("%-20s", "Tot"), true, true, true, false, false);
        this.ui.log(String.format("%-20s", "Used"), true, true, true, false, false);
        this.ui.log(String.format("%-20s", "Avail"), true, true, true, false, false);
        this.ui.log(String.format("%-20s", "rd-Only"), true, true, true, false, false);
        this.ui.log("\r\n", true, true, true, false, false);
        for (FileStore store : stores) {
            try {
                long total_space = store.getTotalSpace();
                long used_space = store.getTotalSpace() - store.getUnallocatedSpace();
                long available_space = store.getUsableSpace();
                boolean is_read_only = store.isReadOnly();
                if (total_space <= 0L) continue;
                this.ui.log(String.format("%-70s", store.name()), true, true, true, false, false);
                this.ui.log(String.format("%-20s", store.type()), true, true, true, false, false);
                this.ui.log(String.format("%-20s", GPT.getHumanSize(total_space, 1, "Bytes")), true, true, true, false, false);
                this.ui.log(String.format("%-20s", GPT.getHumanSize(used_space, 1, "Bytes")), true, true, true, false, false);
                this.ui.log(String.format("%-20s", GPT.getHumanSize(available_space, 1, "Bytes")), true, true, true, false, false);
                this.ui.log(String.format("%-20s", is_read_only), true, true, true, false, false);
                this.ui.log("\r\n", true, true, true, false, false);
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }
}

