/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Duration;
import rdj.AudioPlayer;
import rdj.FinalCrypt;
import rdj.GUIFX;
import rdj.Message;
import rdj.RNG;
import rdj.Validate;

public class CreateOTPKey
extends Application
implements Initializable {
    private Parent root;
    private Stage stage;
    private Scene scene;
    private FXMLLoader loader;
    private GUIFX guifx;
    public Path currentDirPath;
    private Path keyPath;
    private Timeline repeaterTimeline;
    public static final String FIP140_2_URL_STRING = "https://en.wikipedia.org/wiki/FIPS_140";
    public static final String ONE_TIME_PAD_URL_STRING = "https://en.wikipedia.org/wiki/One-time_pad";
    private final long UPDATE_PROGRESS_TIMERTASK_PERIOD = 100L;
    @FXML
    private ImageView bgImageView;
    @FXML
    private TextField filenameTextField;
    @FXML
    private TextField filesizeTextField;
    @FXML
    private ChoiceBox<String> unitChoiceBox;
    @FXML
    private Button increaseButton;
    @FXML
    private Button decreaseButton;
    @FXML
    private Button cancelButton;
    @FXML
    private Button createButton;
    @FXML
    private Label filenameLabel;
    @FXML
    private Label filesizeLabel;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private Label untiLabel;
    @FXML
    private Label statusLabel1;
    @FXML
    private Label statusLabel2;
    @FXML
    private Label otpRulesLabel;
    @FXML
    private Label otpRulesLabel2;
    @FXML
    private Label complianceLabel;
    public CreateOTPKey controller;
    private Long filesizeNumber;
    private Long factor;
    private Long filesizeInBytes;
    private int bufferSize = 0x100000;
    private TimerTask updateProgressTask;
    private Timer updateProgressTaskTimer;
    private long totalTranfered;
    private long throughputClock;
    private long lastThroughputClock;
    private long realtimeBytesProcessed;
    private double realtimeMiBPS;
    private String windowTitle = "Create OTP Key";
    private String currentDirectory = "Current Directory";
    private String file = "File";
    private String fileExists = "File already exists";
    private String creatingOTPKeyFile = "Creating OTP Key File";
    private String createdOTPKeyFile = "Created OTP Key File";
    private ResourceBundle bundle;
    @FXML
    private Label headerLabel;
    private Message ugMessage;

    public void switchLanguage(Locale locale, Boolean firstTime) {
        this.bundle = ResourceBundle.getBundle("rdj.language.translation", locale);
        this.headerLabel.setText(this.bundle.getString("012"));
        this.filenameLabel.setText(this.bundle.getString("008"));
        this.filenameTextField.setPromptText(this.bundle.getString("009"));
        this.filesizeLabel.setText(this.bundle.getString("010"));
        this.untiLabel.setText(this.bundle.getString("015"));
        this.cancelButton.setText(this.bundle.getString("001"));
        this.createButton.setText(this.bundle.getString("003"));
        this.otpRulesLabel.setText(this.bundle.getString("014"));
        this.otpRulesLabel2.setText(this.bundle.getString("013"));
        this.complianceLabel.setText(this.bundle.getString("002"));
        this.currentDirectory = this.bundle.getString("006");
        this.file = this.bundle.getString("011");
        this.fileExists = this.bundle.getString("007");
        this.creatingOTPKeyFile = this.bundle.getString("005");
        this.createdOTPKeyFile = this.bundle.getString("004");
    }

    public void start(Stage primaryStage) throws Exception {
        this.loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("CreateOTPKey.fxml"));
        this.root = (Parent)this.loader.load();
        this.controller = (CreateOTPKey)((Object)this.loader.getController());
        this.scene = new Scene((Parent)this.loader.getRoot());
        this.stage = primaryStage;
        this.stage.setScene(this.scene);
        this.stage.setTitle(this.windowTitle);
        this.stage.setResizable(false);
        this.stage.show();
        this.filesizeInBytes = 0L;
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.bgImageView.setImage(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/rdj/images/Gardenchurch.jpg")));
        this.bgImageView.autosize();
        this.unitChoiceBox.getItems().add((Object)"Bytes");
        this.unitChoiceBox.getItems().add((Object)"KiB");
        this.unitChoiceBox.getItems().add((Object)"MiB");
        this.unitChoiceBox.getItems().add((Object)"GiB");
        this.unitChoiceBox.getItems().add((Object)"TiB");
        this.unitChoiceBox.getItems().add((Object)"PiB");
        this.unitChoiceBox.getItems().add((Object)"EiB");
        this.unitChoiceBox.getSelectionModel().select(2);
        this.filenameTextField.textProperty().addListener((obs, oldText, newText) -> {
            String regex = "[^a-zA-Z0-9\\\\-\\\\_\\\\.\\\\ ]";
            if (this.filenameTextField.getText().matches(regex)) {
                this.filenameTextField.setText(this.filenameTextField.getText().replaceAll(regex, ""));
            } else {
                new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/key_press", 2);
                this.filenameTextField.setText(this.filenameTextField.getText().replaceAll(regex, ""));
            }
            if (this.filenameTextField.getText().length() > 0) {
                if (Files.exists(Paths.get(this.currentDirPath.toAbsolutePath().toString(), this.filenameTextField.getText()), LinkOption.NOFOLLOW_LINKS)) {
                    this.filesizeLabel.setDisable(true);
                    this.filesizeTextField.setDisable(true);
                    this.increaseButton.setDisable(true);
                    this.decreaseButton.setDisable(true);
                    this.untiLabel.setDisable(true);
                    this.unitChoiceBox.setDisable(true);
                    this.createButton.setDisable(true);
                    this.keyPath = Paths.get(this.currentDirPath.toAbsolutePath().toString(), this.filenameTextField.getText());
                    this.statusLabel1.setText(this.fileExists);
                    this.statusLabel2.setText(this.keyPath.toAbsolutePath().toString());
                } else {
                    this.filesizeLabel.setDisable(false);
                    this.filesizeTextField.setDisable(false);
                    this.increaseButton.setDisable(false);
                    this.decreaseButton.setDisable(false);
                    this.untiLabel.setDisable(false);
                    this.unitChoiceBox.setDisable(false);
                    this.createButton.setDisable(false);
                    this.createButton.setDefaultButton(true);
                    this.keyPath = Paths.get(this.currentDirPath.toAbsolutePath().toString(), this.filenameTextField.getText());
                    this.calculateOTPKeyFileSize();
                }
            } else {
                this.filesizeLabel.setDisable(true);
                this.filesizeTextField.setDisable(true);
                this.increaseButton.setDisable(true);
                this.decreaseButton.setDisable(true);
                this.untiLabel.setDisable(true);
                this.unitChoiceBox.setDisable(true);
                this.createButton.setDisable(true);
                this.keyPath = null;
                this.statusLabel1.setText(this.currentDirectory);
                this.statusLabel2.setText(this.currentDirPath.toAbsolutePath().toString());
            }
        });
        this.filesizeTextField.textProperty().addListener((obs, oldText, newText) -> {
            this.filesizeTextField.setText(this.filesizeTextField.getText().replaceAll("[^0-9]", "").replaceAll("^0", ""));
            if (this.filesizeTextField.getText().equals("0") || this.filesizeTextField.getText().length() == 0) {
                this.filesizeTextField.setText("1");
            }
            try {
                Long.valueOf(this.filesizeTextField.getText());
            }
            catch (NumberFormatException e) {
                this.filesizeTextField.setText(oldText);
            }
            this.calculateOTPKeyFileSize();
        });
        this.unitChoiceBox.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number num1, Number num2) {
                CreateOTPKey.this.calculateOTPKeyFileSize();
            }
        });
    }

    public void setCurrentDir(Path curDirPath, GUIFX guifx) {
        this.guifx = guifx;
        this.currentDirPath = curDirPath;
        this.statusLabel1.setText(this.currentDirectory);
        this.statusLabel2.setText(this.currentDirPath.toAbsolutePath().toString());
        this.ugMessage = new Message(guifx.create_key, 64, false, false, false, false, "/rdj/audio/voice/create_key", 0);
        guifx.userGuidanceMessage(this.ugMessage);
    }

    @FXML
    private void increaseButtonOnAction(ActionEvent event) {
        this.changeSize(1L);
    }

    @FXML
    private void decreaseButtonOnAction(ActionEvent event) {
        this.changeSize(-1L);
    }

    @FXML
    private void increaseButtonOnMousePressed(MouseEvent event) {
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/button", 2);
        this.changeSizeRepeaterOn(1L);
    }

    @FXML
    private void decreaseButtonOnMousePressed(MouseEvent event) {
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/button", 2);
        this.changeSizeRepeaterOn(-1L);
    }

    @FXML
    private void increaseButtonOnMouseReleased(MouseEvent event) {
        this.changeSizeRepeaterOff();
    }

    @FXML
    private void decreaseButtonOnMouseReleased(MouseEvent event) {
        this.changeSizeRepeaterOff();
    }

    private void changeSizeRepeaterOn(long step) {
        if (this.repeaterTimeline != null) {
            this.repeaterTimeline.stop();
        }
        this.repeaterTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)20.0), ae -> this.changeSize(step), new KeyValue[0])});
        this.repeaterTimeline.setCycleCount(-1);
        this.repeaterTimeline.setDelay(Duration.millis((double)250.0));
        this.repeaterTimeline.play();
    }

    private void changeSizeRepeaterOff() {
        if (this.repeaterTimeline != null) {
            this.repeaterTimeline.stop();
        }
    }

    private void changeSize(long l) {
        Long num = Long.valueOf(this.filesizeTextField.getText());
        num = num + l;
        boolean valid = true;
        try {
            Long.valueOf(this.filesizeTextField.getText());
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        if (num > 0L) {
            this.filesizeTextField.setText(num.toString());
        }
    }

    private void calculateOTPKeyFileSize() {
        this.filesizeNumber = Long.valueOf(this.filesizeTextField.getText());
        Integer selectedIndexAsPower = this.unitChoiceBox.getSelectionModel().getSelectedIndex();
        double interimFactor = Math.pow(1024.0, selectedIndexAsPower.intValue());
        this.factor = new Double(interimFactor).longValue();
        this.filesizeInBytes = this.filesizeNumber * this.factor;
        if (this.filesizeInBytes > 0L && this.filesizeInBytes <= Long.MAX_VALUE) {
            this.createButton.setDisable(false);
        } else {
            this.createButton.setDisable(true);
        }
        if (this.filenameTextField.getText().length() > 0) {
            this.keyPath = Paths.get(this.currentDirPath.toAbsolutePath().toString(), this.filenameTextField.getText());
            String status1String = this.file;
            String status2String = this.keyPath.getParent().toAbsolutePath().toString() + File.separator + this.keyPath.getFileName().toString();
            if (this.filesizeInBytes > 0L && this.filesizeInBytes <= Long.MAX_VALUE) {
                status1String = status1String + " (" + Validate.getHumanSize(this.filesizeInBytes.longValue(), 1, "Bytes") + ")";
            }
            this.statusLabel1.setText(status1String);
            this.statusLabel2.setText(status2String);
        } else if (this.currentDirPath != null) {
            this.statusLabel1.setText(this.currentDirectory);
            this.statusLabel2.setText(this.currentDirPath.toAbsolutePath().toString());
        }
    }

    @FXML
    private void createButtonAction(ActionEvent event) {
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/button", 2);
        this.filenameTextField.setDisable(true);
        this.filesizeLabel.setDisable(true);
        this.filesizeTextField.setDisable(true);
        this.increaseButton.setDisable(true);
        this.decreaseButton.setDisable(true);
        this.untiLabel.setDisable(true);
        this.unitChoiceBox.setDisable(true);
        this.createButton.setDisable(true);
        this.keyPath = Paths.get(this.currentDirPath.toAbsolutePath().toString(), this.filenameTextField.getText());
        this.statusLabel1.setText(this.creatingOTPKeyFile + " (" + Validate.getHumanSize(this.filesizeInBytes.longValue(), 1, "Bytes") + ")");
        this.statusLabel2.setText(this.keyPath.toAbsolutePath().toString());
        this.repeaterTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)250.0), ae -> this.blinkStatusLabel1(), new KeyValue[0])});
        this.repeaterTimeline.setCycleCount(-1);
        this.repeaterTimeline.setDelay(Duration.millis((double)250.0));
        this.repeaterTimeline.play();
        this.progressBar.setDisable(false);
        Thread createManualKeyThread = new Thread(() -> {
            if (this.filesizeInBytes < (long)this.bufferSize) {
                this.bufferSize = this.filesizeInBytes.intValue();
            }
            boolean inputEnded = false;
            long writeKeyFileChannelPosition = 0L;
            long writeKeyFileChannelTransfered = 0L;
            this.totalTranfered = 0L;
            Long remainder = 0L;
            ByteBuffer randomBuffer = ByteBuffer.allocate(this.bufferSize);
            randomBuffer.clear();
            this.throughputClock = 0L;
            this.lastThroughputClock = 0L;
            this.realtimeBytesProcessed = 0L;
            this.realtimeMiBPS = 0.0;
            this.updateProgressTask = new TimerTask(){

                @Override
                public void run() {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CreateOTPKey.this.throughputClock = System.nanoTime();
                            CreateOTPKey.this.realtimeMiBPS = (double)CreateOTPKey.this.realtimeBytesProcessed * (1.0E9 / (double)(CreateOTPKey.this.throughputClock - CreateOTPKey.this.lastThroughputClock)) / 1048576.0;
                            if (CreateOTPKey.this.realtimeMiBPS > FinalCrypt.io_Throughput_Ceiling) {
                                FinalCrypt.io_Throughput_Ceiling = CreateOTPKey.this.realtimeMiBPS;
                            }
                            CreateOTPKey.this.lastThroughputClock = CreateOTPKey.this.throughputClock;
                            CreateOTPKey.this.realtimeBytesProcessed = 0L;
                            CreateOTPKey.this.progressBar.setProgress((double)CreateOTPKey.this.totalTranfered / (double)CreateOTPKey.this.filesizeInBytes.longValue());
                            CreateOTPKey.this.guifx.processProgress(0, 0, 0L, 0L, CreateOTPKey.this.realtimeMiBPS);
                        }
                    });
                }
            };
            this.updateProgressTaskTimer = new Timer();
            this.updateProgressTaskTimer.schedule(this.updateProgressTask, 0L, 200L);
            new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/encrypt_files", 2);
            while (this.totalTranfered < this.filesizeInBytes && !inputEnded) {
                remainder = this.filesizeInBytes - this.totalTranfered;
                if (remainder >= (long)this.bufferSize) {
                    randomBuffer = ByteBuffer.allocate(this.bufferSize);
                    randomBuffer.clear();
                } else if (remainder > 0L && remainder < (long)this.bufferSize) {
                    randomBuffer = ByteBuffer.allocate(remainder.intValue());
                    randomBuffer.clear();
                } else {
                    inputEnded = true;
                }
                randomBuffer = RNG.getFCRandomBuffer(this.guifx, randomBuffer.capacity(), true, true, FinalCrypt.print_vertical);
                try (SeekableByteChannel writeKeyFileChannel = Files.newByteChannel(this.keyPath, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE)), new FileAttribute[0]);){
                    writeKeyFileChannel.position(writeKeyFileChannelPosition);
                    writeKeyFileChannelTransfered = writeKeyFileChannel.write(randomBuffer);
                    randomBuffer.rewind();
                    this.realtimeBytesProcessed += writeKeyFileChannelTransfered;
                    this.totalTranfered += writeKeyFileChannelTransfered;
                    writeKeyFileChannelPosition += writeKeyFileChannelTransfered;
                    writeKeyFileChannel.close();
                }
                catch (IOException ex) {
                    this.statusLabel1.setText("Error: " + ex.getMessage());
                    inputEnded = true;
                    break;
                }
                randomBuffer.clear();
            }
            writeKeyFileChannelPosition = 0L;
            writeKeyFileChannelTransfered = 0L;
            inputEnded = false;
            this.updateProgressTaskTimer.cancel();
            this.updateProgressTaskTimer.purge();
            this.realtimeMiBPS = 0.0;
            this.realtimeBytesProcessed = 0L;
            this.guifx.processProgress(0, 0, 0L, 0L, this.realtimeMiBPS);
            this.progressBar.setProgress((double)this.totalTranfered / (double)this.filesizeInBytes.longValue());
            if (this.repeaterTimeline != null) {
                this.repeaterTimeline.stop();
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    CreateOTPKey.this.statusLabel1.setText(CreateOTPKey.this.createdOTPKeyFile + " (" + Validate.getHumanSize(CreateOTPKey.this.filesizeInBytes.longValue(), 1, "Bytes") + ")");
                    CreateOTPKey.this.ugMessage = new Message(((CreateOTPKey)CreateOTPKey.this).guifx.select_key_dir, 64, false, false, true, false, "/rdj/audio/voice/select_key_directory", 0);
                    CreateOTPKey.this.guifx.userGuidanceMessage(CreateOTPKey.this.ugMessage);
                }
            });
            this.repeaterTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), ae -> this.closeWindow(), new KeyValue[0])});
            this.repeaterTimeline.setCycleCount(1);
            this.repeaterTimeline.setDelay(Duration.millis((double)1000.0));
            this.repeaterTimeline.play();
        });
        createManualKeyThread.setName("createManualKeyThread");
        createManualKeyThread.setDaemon(true);
        createManualKeyThread.start();
    }

    @FXML
    private void cancelButtonAction(ActionEvent event) {
        new AudioPlayer().play(this.guifx, "/rdj/audio/sounds/button", 2);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (CreateOTPKey.this.repeaterTimeline != null) {
                    CreateOTPKey.this.repeaterTimeline.stop();
                    CreateOTPKey.this.statusLabel1.setText("Canceled");
                } else {
                    CreateOTPKey.this.statusLabel1.setText("Closing");
                }
                CreateOTPKey.this.statusLabel1.setVisible(true);
                new AudioPlayer().play(CreateOTPKey.this.guifx, "/rdj/audio/sounds/input_fail", 2);
                CreateOTPKey.this.repeaterTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), ae -> CreateOTPKey.this.closeWindow(), new KeyValue[0])});
                CreateOTPKey.this.repeaterTimeline.setCycleCount(1);
                CreateOTPKey.this.repeaterTimeline.setDelay(Duration.millis((double)1000.0));
                CreateOTPKey.this.repeaterTimeline.play();
            }
        });
    }

    private void closeWindow() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                new AudioPlayer().play(CreateOTPKey.this.guifx, "/rdj/audio/sounds/shutdown", 2);
                CreateOTPKey.this.guifx.updateFileChoosers(true, false, true, true, false, true);
                Stage stage = (Stage)CreateOTPKey.this.cancelButton.getScene().getWindow();
                stage.close();
            }
        });
    }

    private void blinkStatusLabel1() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                CreateOTPKey.this.statusLabel1.setVisible(!CreateOTPKey.this.statusLabel1.isVisible());
            }
        });
    }

    public static void main(String[] args) {
        CreateOTPKey.launch((String[])args);
    }

    @FXML
    private void complianceLabelOnMouseClicked(MouseEvent event) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                new AudioPlayer().play(CreateOTPKey.this.guifx, "/rdj/audio/sounds/button", 2);
                new AudioPlayer().play(CreateOTPKey.this.guifx, "/rdj/audio/sounds/open", 2);
                Thread complianceURLThread = new Thread(() -> {
                    try {
                        Desktop.getDesktop().browse(new URI(CreateOTPKey.FIP140_2_URL_STRING));
                    }
                    catch (URISyntaxException ex) {
                        CreateOTPKey.this.statusLabel1.setText(ex.getMessage());
                    }
                    catch (IOException ex) {
                        CreateOTPKey.this.statusLabel1.setText(ex.getMessage());
                    }
                    catch (UnsupportedOperationException ex) {
                        CreateOTPKey.this.statusLabel1.setText(ex.getMessage() + " " + CreateOTPKey.FIP140_2_URL_STRING);
                    }
                });
                complianceURLThread.setName("complianceURLThread");
                complianceURLThread.setDaemon(true);
                complianceURLThread.start();
            }
        });
    }

    @FXML
    private void otpRulesOnMouseClicked(MouseEvent event) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                new AudioPlayer().play(CreateOTPKey.this.guifx, "/rdj/audio/sounds/button", 2);
                new AudioPlayer().play(CreateOTPKey.this.guifx, "/rdj/audio/sounds/open", 2);
                Thread otpRulesURLThread = new Thread(() -> {
                    try {
                        Desktop.getDesktop().browse(new URI(CreateOTPKey.ONE_TIME_PAD_URL_STRING));
                    }
                    catch (URISyntaxException ex) {
                        CreateOTPKey.this.statusLabel1.setText(ex.getMessage());
                    }
                    catch (IOException ex) {
                        CreateOTPKey.this.statusLabel1.setText(ex.getMessage());
                    }
                    catch (UnsupportedOperationException ex) {
                        CreateOTPKey.this.statusLabel1.setText(ex.getMessage() + " " + CreateOTPKey.ONE_TIME_PAD_URL_STRING);
                    }
                });
                otpRulesURLThread.setName("otpRulesURLThread");
                otpRulesURLThread.setDaemon(true);
                otpRulesURLThread.start();
            }
        });
    }
}

