﻿
# Mozc UT Dictionary

20210421

## Overview

Mozc UT Dictionary is an additional dictionary for Mozc. It will add over 1,000,000 entries to Mozc.
I used them for this dictionary.

File | License | Note
-- | -- | --
alt-cannadic | [GPL-2.0](https://ja.osdn.net/projects/alt-cannadic/wiki/FrontPage) | Disabled.
edict | [CC-BY-SA 3.0](http://www.edrdg.org/jmdict/edict.html) | Disabled.
jawiki-articles | [CC-BY-SA 3.0](https://ja.wikipedia.org/wiki/Wikipedia:ウィキペディアを二次利用する) | A dictionary generated from Japanese Wikipedia.
jinmei-ut | [Apache-2.0](http://linuxplayers.g1.xrea.com/mozc-ut.html) | Japanese names.
neologd | [Apache-2.0](https://github.com/neologd/mecab-ipadic-neologd) | 
nicoime | [unknown](http://tkido.com/blog/1019.html) | Disabled.
skk | [GPL-2.0-or-later](http://openlab.ring.gr.jp/skk/wiki/wiki.cgi?page=SKK%BC%AD%BD%F1) | Disabled.
sudachidict | [Apache-2.0](https://github.com/WorksApplications/SudachiDict) | Disabled.
zipcode | [public domain](http://www.post.japanpost.jp/zipcode/dl/readme.html) | 
jawiki-all-titles | [CC-BY-SA 3.0](https://ja.wikipedia.org/wiki/Wikipedia:ウィキペディアを二次利用する) | For cost adjustments.
mozc | [BSD-3-Clause](https://github.com/google/mozc) | For checking duplicates.
*.rb, *.sh | [Apache-2.0](http://linuxplayers.g1.xrea.com/mozc-ut.html) | Codes to generate dictionaries.

## Download

https://osdn.net/users/utuhiro/pf/utuhiro/files/

## Install

Download original Mozc.

```
wget -nc https://osdn.net/users/utuhiro/pf/utuhiro/dl/mozc-2.26.4346.102.tar.bz2
tar xf mozc-2.26.4346.102.tar.bz2
```

Add Mozc UT Dictionary to Mozc.

```
cat mozcdic-ut-20210421.1/mozcdic-ut-20210421.1.txt >> mozc-2.26.4346.102/src/data/dictionary_oss/dictionary00.txt
```

Build Mozc as usual.

## Install (Arch Linux)

Get "fcitx5-mozc-ut.PKGBUILD" from [OSDN](https://osdn.net/users/utuhiro/pf/utuhiro/files/) and run it.

```
makepkg -i -p fcitx5-mozc-ut-20210421.1.PKGBUILD
```

## Option: Rebuild Mozc UT Dictionary

Mozc UT Dictionary is so big. You can disable some dictionaries to reduce the size and simplify the license.

```
tar xf mozcdic-ut-20210421.1.tar.bz2
mv mozcdic-ut-20210421.1 mozcdic-ut-dev
cd mozcdic-ut-dev/src/
mousepad make-dictionaries.sh 
```

Comment out unnecessary dictionaries.
If you want to use only neologd and zipcode dictionaries, edit the lines like this.

```
#altcannadic="true"
#edict="true"
#ekimei="true"
#jawikiarticles="true"
#jinmeiut="true"
neologd="true"
#nicoime="true"
#skk="true"
#sudachidict="true"
```

Run `make-dictionaries.sh`. It generates new "mozcdic-ut-20210421.1.txt".
NOTE: If you enable "jawikiarticles", `make-dictionaries.sh` downloads "jawiki-latest-pages-articles.xml.bz2" (over 3.0GB).

```
cd ../src/
gem install bzip2-ffi parallel
sh make-dictionaries.sh
ls ../../mozcdic-ut-20210421.1.txt
```

## 更新の概要

2010-11-03: Mozc UT辞書をリリース。

2016-01-14: Mozc NEologd UT辞書をリリース。コストは mecab-ipadic-NEologd のものをベースにした。

2016-10-13: Mozc UT2辞書をリリース。Mozc UT辞書を入れたパーティションを壊してしまったので作り直した。

2016-10-20: Mozc UT2辞書のコスト計算を変更。表記をウィキペディア全記事から完全一致検索して、そのヒット数からコストを計算した。例えば「生物学」を検索して、ヒット数が1ならコストを6000、ヒット数が2ならコストを6000-(100*2)、ヒット数が0ならコストを8000、のようにする（計算式はダミー）。ウィキペディア全記事から表記を検索するのは長い時間と高い負荷がかかった。

2020-01-15: NEologd辞書を公式Mozcにマージした形で配布するのをやめた。公式Mozcにはパッチがいくつか必要になっているので、辞書も追加ファイルの1つにするほうが扱いやすいと判断した。

2020-02-06: NEologd辞書のコストを独自に計算することにした。元のコストだと「三浦大知」より「三浦大地」が優先される。表記をウィキペディア全見出しから前方一致検索して、そのヒット数からコストを計算した。これはウィキペディア全記事の完全一致検索より遥かに処理が軽い。

2020-06-11: 2代目Mozc UT辞書をリリース。UT2辞書とNEologd辞書をまとめた形だが、辞書作成用のコードはほとんど書き直した。UT2辞書に相当する部分はコストの計算方法をNEologd辞書と同じものにした（全記事からの完全一致検索をやめて、全見出しからの前方一致検索にした）。辞書の組み合わせを変えて配布するときは、「mozcdic-utからの派生」という意味でファイル名を「mozcdic-ut-*」とした。

2020-06-22: jawiki-articles辞書を追加。ウィキペディア全見出しを表記とし、対応する記事から読みを得て、辞書を作成した。コストの算出方法はNEologd辞書と同じ。jawiki-articles辞書はユーザー自身でアップデートでき、新しい人名や用語への対応が容易。1人の努力に頼り切らない仕組みが必要だと考えた。

2021-02-15: SudachiDict を追加。

[HOME](http://linuxplayers.g1.xrea.com/index.html)
