static char sccsid[]="%Z% %M% %I% %E% %U%";
/************************************************/
/*												*/
/*	akxsRb.c									*/
/*												*/
/*		coded by A.Kobayashi 2010.5.20			*/
/*												*/
/************************************************/
#include "akxcommon.h"

tdtRbCtl *akxs_rb_new2(lBS,lRM,m_alloc)
int lBS,lRM;
char *(*m_alloc)();
{
	tdtRbCtl *pCt;
	tdtRbChain *p1,*p2;

	if (m_alloc) {
		if (!(pCt = (tdtRbCtl *)m_alloc(sizeof(tdtRbCtl)))) return NULL;
	}
	else {
		if (!(pCt = (tdtRbCtl *)Malloc(sizeof(tdtRbCtl)))) return NULL;
	}
	memset(pCt,0,sizeof(tdtRbCtl));
	pCt->rb_bfsz = lBS;
	pCt->rb_max = lRM;
	if (m_alloc) {
		if (!(p1 = (tdtRbChain *)m_alloc(sizeof(tdtRbChain)))) return NULL;
	}
	else {
		if (!(p1 = (tdtRbChain *)Malloc(sizeof(tdtRbChain)))) {
			Free(pCt);
			return NULL;
		}
	}
	pCt->rb_cur = pCt->rb_waddr = pCt->rb_raddr = p1;
	p1->rbc_buf = NULL;
	if (m_alloc) {
		if (!(p2 = (tdtRbChain *)m_alloc(sizeof(tdtRbChain)))) return NULL;
	}
	else  {
		if (!(p2 = (tdtRbChain *)Malloc(sizeof(tdtRbChain)))) {
			Free(pCt);
			Free(p1);
			return NULL;
		}
	}
	pCt->rb_wpriv = p2;
	p2->rbc_buf = NULL;
	p1->rbc_next = p2;
	p2->rbc_next = p1;
	pCt->rb_num = 2;
	pCt->rb_malloc = m_alloc;
	return pCt;
}

tdtRbCtl *akxs_rb_new(lBS,lRM)
int lBS,lRM;
{
	return akxs_rb_new2(lBS,lRM,NULL);
}

char *akxs_rb_get(pCt)
tdtRbCtl *pCt;
{
	if (!pCt) return NULL;
	return pCt->rb_raddr->rbc_buf;
}

char *akxs_rb_get_n(pCt)
tdtRbCtl *pCt;
{
	char *p;
	tdtRbChain *pr;

	if (!pCt) return NULL;
	
	pr = pCt->rb_raddr;
	if (p=pr->rbc_buf) {
		pr->rbc_buf = NULL;
		pCt->rb_raddr = pr->rbc_next;
		pCt->rb_used--;
	}
	pCt->rb_cur = pCt->rb_raddr;
	pCt->rb_pos = 0;
	return p;
}

char *akxs_rb_set_n(pCt, addr)
tdtRbCtl *pCt;
char *addr;
{
	tdtRbChain *pw, *pn, *pp;
	char *(*m_alloc)();
/*
printf("akxs_rb_set_n: pCt=%08x addr=%08x\n",pCt,addr);
*/
	if (!pCt || !addr) return NULL;
	
	pw = pCt->rb_waddr;
	if (pw->rbc_buf) {
		if (m_alloc=pCt->rb_malloc) {
			if (!(pn = (tdtRbChain *)m_alloc(sizeof(tdtRbChain)))) return NULL;
		}
		else {
			if (!(pn = (tdtRbChain *)Malloc(sizeof(tdtRbChain)))) return NULL;
		}
		pp = pCt->rb_wpriv;
		pCt->rb_waddr = pp->rbc_next = pn;
		pn->rbc_next = pw;
		pw = pCt->rb_waddr;
		pCt->rb_num++;
	}
	pw->rbc_buf = addr;
	pCt->rb_waddr = pw->rbc_next;
	pCt->rb_wpriv = pw;
	pCt->rb_used++;
	return addr;
}

int akxs_rb_free(pCt)
tdtRbCtl *pCt;
{
	tdtRbChain *pw, *pn, *pp;
	char *(*m_alloc)();

	if (!pCt) return -1;
	m_alloc = pCt->rb_malloc;
	if (pp = pCt->rb_wpriv) {
		pw = pp->rbc_next;
		pp->rbc_next = NULL;
		while (pw) {
			pn = pw->rbc_next;
			if (!m_alloc) Free(pw);
			pw = pn;
		}
	}
	if (!m_alloc) Free(pCt);
	return 0;
}

int akxs_rb_buf_free(pCt)
tdtRbCtl *pCt;
{
	char *p;
	char *(*m_alloc)();

	if (!pCt) return -1;

	m_alloc = pCt->rb_malloc;
	while (p=akxs_rb_get_n(pCt)) {
		if (!m_alloc) Free(p);
	}
	return 0;
}

int akxs_rb_all_free(pCt)
tdtRbCtl *pCt;
{
	int  iRc;

	if (!(iRc = akxs_rb_buf_free(pCt))) iRc = akxs_rb_free(pCt);

	return iRc;
}

char *akxs_rb_set_t(pCt, addr)
tdtRbCtl *pCt;
char *addr;
{
	tdtRbChain *pw, *pn, *pp;
	char *(*m_alloc)();

	if (!pCt || !addr) return NULL;
	if (!akxs_rb_get(pCt)) return akxs_rb_set_n(pCt,addr);
	
	pw = pCt->rb_waddr;
	while ((pp=pw->rbc_next) != pCt->rb_raddr) {
		pw = pp;
	}

	if (pw->rbc_buf) {
		if (m_alloc=pCt->rb_malloc) {
			if (!(pn = (tdtRbChain *)m_alloc(sizeof(tdtRbChain)))) return NULL;
		}
		else {
			if (!(pn = (tdtRbChain *)Malloc(sizeof(tdtRbChain)))) return NULL;
		}
		pw->rbc_next = pn;
		pn->rbc_next = pp;
		pw = pn;
		pCt->rb_num++;
	}
	pw->rbc_buf = addr;
	if (pCt->rb_raddr == pCt->rb_waddr) {
		pCt->rb_waddr = pw;
	}
	pCt->rb_raddr = pw;
	pCt->rb_used++;
	pCt->rb_cur = pCt->rb_raddr;
	pCt->rb_pos = 0;
	return addr;
}

char *akxs_rb_read(pCt, cmd)
tdtRbCtl *pCt;
int     cmd;
{
	tdtRbChain *pr;
	char *p=NULL;

	if (pCt) {
		if (!cmd) {
			pr = pCt->rb_raddr;
			pCt->rb_pos = 0;
		}
		else {
			if (pCt->rb_pos >= pCt->rb_used) return NULL;
			if (pCt->rb_pos) {
				pr = pCt->rb_cur;
				pCt->rb_cur = pr->rbc_next;
			}
			else pCt->rb_cur = pCt->rb_raddr;
			pr = pCt->rb_cur;
			pCt->rb_pos++;
		}
		p = pr->rbc_buf;
	}
	return p;
}

int akxs_rb_exchg(pCt1, pCt2, opt)
tdtRbCtl *pCt1,*pCt2;
int opt;
{
	tdtRbCtl tCtW;

	if (!pCt1 || !pCt2) return -1;
	tCtW  = *pCt1;
	*pCt1 = *pCt2;
	*pCt2 = tCtW;
	return 0;
}

int akxs_rb_used(pCt)
tdtRbCtl *pCt;
{
	if (!pCt) return -1;
	return pCt->rb_used;
}

char *akxs_rb_srch(pCt, addr, compar)
tdtRbCtl *pCt;
char *addr;
int (*compar)();
{
	int f;
	tdtRbChain *pr;
	char *p;

	if (!pCt || !addr) return NULL;
	if (!compar) compar = strcmp;
	pr = pCt->rb_raddr;
	while (p=pr->rbc_buf) {
		if (!compar(addr,p)) return p;
		pr = pr->rbc_next;
		if (pr == pCt->rb_waddr) break;
	}
	return NULL;
}

/************************************************/
/*												*/
/*		List									*/
/*												*/
/************************************************/
tdtRbCtl *akxs_list_new2(lBS,lRM,m_alloc)
int lBS,lRM;
char *(*m_alloc)();
{
	tdtRbCtl *pCt;

	if (m_alloc) {
		if (!(pCt = (tdtRbCtl *)m_alloc(sizeof(tdtRbCtl)))) return NULL;
	}
	else {
		if (!(pCt = (tdtRbCtl *)Malloc(sizeof(tdtRbCtl)))) return NULL;
	}
	memset(pCt,0,sizeof(tdtRbCtl));
	pCt->rb_bfsz = lBS;
	pCt->rb_max = lRM;
	pCt->rb_malloc = m_alloc;
	return pCt;
}

tdtRbCtl *akxs_list_new(lBS,lRM)
int lBS,lRM;
{
	return akxs_list_new2(lBS,lRM,NULL);
}

int akxs_list_free(pCt,free_func)
tdtRbCtl *pCt;
int (*free_func)();
{
	tdtRbChain *pw, *pn, *pp;
	char *p;
	char *(*m_alloc)();

	if (!pCt) return -1;
	m_alloc = pCt->rb_malloc;
	while (akxs_list_get(pCt,&p) > 0) {
		if (p) {
			if (free_func) free_func(p);
			else if (!m_alloc) Free(p);
		}
	}
	if (!m_alloc) Free(pCt);
	return 0;
}

int akxs_list_get(pCt,pp)
tdtRbCtl *pCt;
char **pp;
{
	tdtRbChain *pr;

	if (!pCt) return -1;
	
	if (pr = pCt->rb_raddr) {
		*pp = pr->rbc_buf;
		pCt->rb_raddr = pr->rbc_next;
		pCt->rb_used--;
		if (pr == pCt->rb_waddr) pCt->rb_waddr = NULL;
		Free(pr);
		return 1;
	}
	else return 0;
}

int akxs_list_set(pCt, addr)
tdtRbCtl *pCt;
char *addr;
{
	tdtRbChain *pw, *pn;
	char *(*m_alloc)();

	if (!pCt) return -1;

	if (m_alloc=pCt->rb_malloc) {
		if (!(pn = (tdtRbChain *)m_alloc(sizeof(tdtRbChain)))) return 0;
	}
	else {
		if (!(pn = (tdtRbChain *)Malloc(sizeof(tdtRbChain)))) return 0;
	}
	pn->rbc_buf = addr;
	pn->rbc_next = NULL;
	if (pw = pCt->rb_waddr) pw->rbc_next = pn;
	else pCt->rb_raddr = pn;
	pCt->rb_waddr = pn;
	pCt->rb_used++;
	return 1;
}

int akxs_list_srch(pCt, addr, compar, opt)
tdtRbCtl *pCt;
char *addr;
int (*compar)();
int opt;
{
	int f;
	tdtRbChain *pr,*pre;
	char *p;

	if (!pCt) return -1;
	pre = NULL;
	pr = pCt->rb_raddr;
	while (pr) {
		if (compar) f = !compar(addr,pr->rbc_buf);
		else f = (addr == pr->rbc_buf);
		if (f) {
			if (opt) {
				if (pre) pre->rbc_next = pr->rbc_next;
				else pCt->rb_raddr = pr->rbc_next;
				if (!pr->rbc_next) pCt->rb_waddr = pre;
				pCt->rb_used--;
			}
			pCt->rb_cur = pr;
			return 1;
		}
		pre = pr;
		pr = pr->rbc_next;
	}
	return 0;
}

int akxs_list_read(pCt, cmd, pp)
tdtRbCtl *pCt;
int     cmd;
char   **pp;
{
	tdtRbChain *pr;

	if (!pCt) return -1;

	if (!cmd) {
		pCt->rb_cur = NULL;
	}
	else {
		if (cmd > 0) {
			if (pr = pCt->rb_cur) pr = pr->rbc_next;
			else pr = pCt->rb_raddr;
		}
		else {
			if (!(pr = pCt->rb_cur)) pr = pCt->rb_raddr;
		}
		if (pr) {
			pCt->rb_cur = pr;
			*pp = pr->rbc_buf;
			return 1;
		}
	}
	return 0;
}
