/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractListTester;

@GwtCompatible
public abstract class AbstractListIndexOfTester<E>
extends AbstractListTester<E> {
    protected abstract int find(Object var1);

    protected abstract String getMethodName();

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testFind_yes() {
        AbstractListIndexOfTester.assertEquals((String)String.valueOf(this.getMethodName()).concat("(firstElement) should return 0"), (int)0, (int)this.find(this.getOrderedElements().get(0)));
    }

    public void testFind_no() {
        AbstractListIndexOfTester.assertEquals((String)String.valueOf(this.getMethodName()).concat("(notPresent) should return -1"), (int)-1, (int)this.find(this.samples.e3));
    }

    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testFind_nullNotContainedButSupported() {
        AbstractListIndexOfTester.assertEquals((String)String.valueOf(this.getMethodName()).concat("(nullNotPresent) should return -1"), (int)-1, (int)this.find(null));
    }

    @CollectionFeature.Require(absent={CollectionFeature.ALLOWS_NULL_VALUES})
    public void testFind_nullNotContainedAndUnsupported() {
        try {
            AbstractListIndexOfTester.assertEquals((String)String.valueOf(this.getMethodName()).concat("(nullNotPresent) should return -1 or throw"), (int)-1, (int)this.find(null));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testFind_nonNullWhenNullContained() {
        this.initCollectionWithNullElement();
        AbstractListIndexOfTester.assertEquals((String)String.valueOf(this.getMethodName()).concat("(notPresent) should return -1"), (int)-1, (int)this.find(this.samples.e3));
    }

    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testFind_nullContained() {
        this.initCollectionWithNullElement();
        String string = String.valueOf(String.valueOf(this.getMethodName()));
        int n = this.getNullLocation();
        AbstractListIndexOfTester.assertEquals((String)new StringBuilder(32 + string.length()).append(string).append("(null) should return ").append(n).toString(), (int)this.getNullLocation(), (int)this.find(null));
    }

    public void testFind_wrongType() {
        try {
            AbstractListIndexOfTester.assertEquals((String)String.valueOf(this.getMethodName()).concat("(wrongType) should return -1 or throw"), (int)-1, (int)this.find((Object)WrongType.VALUE));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

