package blackjack.card;

import blackjack.Card;

public class AceCard implements Card {
    private final int value;

    private AceCard(int value) {
        assert value == 1;
        this.value = value;
    }

    public static AceCard valueOf(int value) {
        return new AceCard(value);
    }

    @Override
    public int score() {
        return 11;
    }
}
