/*
 * IPRPC - Inter Process Remote Procedure Call
 *
 * Copyright (C) 2012-2013 by Hiroyuki KAJIURA. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 *     1:Redistributions of source code must retain the above copyright notice, 
 *       this list of conditions and the following disclaimer.
 *     2:Redistributions in binary form must reproduce the above copyright notice, 
 *       this list of conditions and the following disclaimer in the documentation 
 *       and/or other materials provided with the distribution.
 *     3:Neither the name of copyright owner nor the names of its contributors 
 *       may be used to endorse or promote products derived from this software 
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef IPCTYPE_H_
#define IPCTYPE_H_

#include	<string.h>
#include	<stdint.h>

/* SYSTEM CALL ERROR NUMBER */
#define	RPC_NO_ERROR				(0)
#define	RPC_ERR_EACCES				(1)
#define	RPC_ERR_EEXIST				(2)
#define	RPC_ERR_EINVAL				(3)
#define	RPC_ERR_ENOENT				(4)
#define	RPC_ERR_ENAMETOOLONG			(5)
#define	RPC_ERR_EFAULT				(6)
#define	RPC_ERR_ELOOP				(7)
#define	RPC_ERR_EISDIR				(8)
#define	RPC_ERR_ENOTDIR				(9)
#define	RPC_ERR_EPERM				(10)
#define	RPC_ERR_EROFS				(11)
#define	RPC_ERR_ETXTBSY				(12)
#define	RPC_ERR_EBADF				(13)
#define	RPC_ERR_ENODEV				(14)
#define	RPC_ERR_EOVERFLOW			(15)
#define	RPC_ERR_EMFILE				(16)
#define	RPC_ERR_ENFILE				(17)
#define	RPC_ERR_ENOMEM				(18)
#define	RPC_ERR_EINTR				(19)
#define	RPC_ERR_EIO				(20)
#define	RPC_ERR_EAGAIN				(21)
#define	RPC_ERR_EFBIG				(22)
#define	RPC_ERR_ENOSYS				(23)
#define	RPC_ERR_E2BIG				(24)
#define	RPC_ERR_ELIBBAD				(25)
#define	RPC_ERR_ENOEXEC				(26)
#define	RPC_ERR_ECHILD				(27)
#define	RPC_ERR_ETIMEDOUT			(28)
#define	RPC_ERR_OTHER				(99)

#if	0
typedef char			int8_t;
typedef short			int16_t;
typedef int			int32_t;
typedef long long		int64_t;
typedef unsigned char		uint8_t;
typedef unsigned short		uint16_t;
typedef unsigned int		uint32_t;
typedef unsigned long long	uint64_t;
#endif	/* 0 */

typedef enum {
	RPC_TRUE = 1,
	RPC_FALSE = 0,
	RPC_BOOL_MAX
} RpcBool_t;

typedef enum {
	RPC_ERROR_UNKNOWN = 0,
	RPC_SUCCESS = 1,
	RPC_FATAL_ERROR = -1,
	RPC_TIMEOUT_ERROR = -2,
	RPC_NO_MORE_RESOURCE = -3,
	RPC_PARAM_ERROR = -4,
	RPC_CAN_NOT_EXEC = -5,
	RPC_BUSY_ERROR = -6,
	RPC_INTERUPTTED = -7,
	RPC_LOCKING = -8,
	RPC_NOT_READY = -9,
	RPC_SYSCALL_ERROR = -10,
	RPC_ERROR_MAX
} RpcResult_t;

typedef enum {
	DEVICE_TYPE_UNKNOWN = 0,
	DEVICE_TYPE_OWN_DEV = 1,
	DEVICE_TYPE_ACTIVE = 2,
	DEVICE_TYPE_PASSIVE = 4,
	DEVICE_TYPE_MASTER = 8,
	DEVICE_TYPE_SLAVER = 16,
	DEVICE_TYPE_MANAGER = 32,
	DEVICE_TYPE_APPLICATION = 64,
	DEVICE_TYPE_OTHER_DEV = 4096,
	DEVICE_TYPE_MAX
} RpcDeviceType_t;

typedef enum {
	PROCESS_TYPE_UNKNOWN = 0,
	PROCESS_TYPE_SYSTEM = 2,
	PROCESS_TYPE_MANAGER = 4,
	PROCESS_TYPE_APPLICATION = 8,
	PROCESS_TYPE_DAEMON = 16,
	PROCESS_TYPE_TEST = 1024,
	PROCESS_TYPE_OWN_PRO = 4096,
	PROCESS_TYPE_OTHER_PRO = 8192,
	PROCESS_TYPE_MAX
} RpcProcessType_t;

typedef enum {
	RPC_TYPE_UNKNOWN = 0,
	RPC_INT_TYPE,
	RPC_UINT_TYPE,
	RPC_FLOAT_TYPE,
	RPC_STRING_TYPE,
	RPC_ENUM_TYPE,
	RPC_OTHER_TYPE,
	RPC_MAX_TYPE
} RpcParamType_t;

typedef struct {
	RpcParamType_t paramType;
	uint32_t paramLeng;
} RpcParamSpec_t;

typedef struct {
	RpcParamSpec_t paramSpec;
	uint8_t *paramData;
} RpcParamData_t;

typedef struct {
	uint32_t paramLength;
	uint32_t reserved;
} RpcParamHeader_t;

typedef enum {
	RPC_RESOURCE_UNKNOWN_STATE = 0,
	RPC_RESOURCE_IDLE_STATE = 1,
	RPC_RESOURCE_BUSY_STATE = 2,
	RPC_RESOURCE_MAX_STATE = 3
} RpcResourceState_t;

typedef struct _RpcListStruct_ {
	struct _RpcListStruct_ *next;
//	uint32_t entryId;
	void *entry;
} RpcList_t;

#endif /* IPCTYPE_H_ */
