/*
 * IPRPC - Inter Process Remote Procedure Call
 *
 * Copyright (C) 2012-2013 by Hiroyuki KAJIURA. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 *     1:Redistributions of source code must retain the above copyright notice, 
 *       this list of conditions and the following disclaimer.
 *     2:Redistributions in binary form must reproduce the above copyright notice, 
 *       this list of conditions and the following disclaimer in the documentation 
 *       and/or other materials provided with the distribution.
 *     3:Neither the name of copyright owner nor the names of its contributors 
 *       may be used to endorse or promote products derived from this software 
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef IPCSHMDB_H_
#define IPCSHMDB_H_

#ifdef	IPC_SHM_DB_MAIN
#define	extern
#endif	/* IPC_SHM_DB_MAIN */

#include	"ipcConf.h"
#include	"ipcType.h"
#include	"ipcSyscall.h"
#include	"ipcLib.h"
#include	"ipcShm.h"
#include	"ipcSkelton.h"

#define	IPC_SHM_DATABASE_GAP_SIZE				sizeof(IpcDBManage_t)

#ifdef	USE_MULTICAST_RPC

typedef struct {
	uint32_t processId;
	uint32_t funcId;
} IpcMltcstFuncEntry_t;

#endif	/* USE_MULTICAST_RPC */

extern RpcResult_t IPC_InitShmDB(RpcBool_t masterProcess);
//extern RpcResult_t IPC_RegisterFuncDBEntry(uint32_t funcID, uint32_t processID, uint16_t accessDevice,uint16_t accessProcess, IPC_SkeltonFunc_t func,IPC_SkeltonCancelFunc_t cancelFunc);
extern RpcResult_t IPC_RegisterFuncDBEntry(uint32_t funcID, uint32_t processID, IPC_SkeltonFunc_t func,IPC_SkeltonCancelFunc_t cancelFunc);
extern RpcResult_t IPC_SerachProcessIdFromFuncDB(uint32_t funcId,uint32_t *processId);
//extern RpcResult_t IPC_SearchFunctionFromFuncDB(uint32_t funcId,IPC_SkeltonFunc_t *func,IPC_SkeltonCancelFunc_t *cancelFunc,uint16_t *accessProcessType, uint16_t *accessDeviceType);
extern RpcResult_t IPC_SearchFunctionFromFuncDB(uint32_t funcId,IPC_SkeltonFunc_t *func,IPC_SkeltonCancelFunc_t *cancelFunc);
extern RpcResult_t IPC_DeleteFuncDBEntry(uint32_t funcId);
//extern RpcResult_t IPC_RegisterSkeltonDBEntry(uint32_t processId,uint32_t taskId, uint32_t queId,IpcProcessType processType);
extern RpcResult_t IPC_RegisterSkeltonDBEntry(uint32_t processId,uint32_t taskId, uint32_t queId);
extern RpcResult_t IPC_SearchSkeltonDB(uint32_t processId, uint32_t *taskId,uint32_t *queId);
extern RpcResult_t IPC_DeleteSkeltonDBEntry(uint32_t processId);
//extern RpcResult_t IPC_RegisterProcessData(uint32_t processId,IpcProcessType processType);
//extern RpcResult_t IPC_DelegateProcessData(uint32_t processId);
//extern RpcResult_t IPC_SearchProcessType(uint32_t processId, IpcProcessType *processType);

#ifdef	USE_MULTICAST_RPC

extern RpcResult_t IPC_RegisterMulticastFunc(uint32_t mltcstFuncId);
extern RpcResult_t IPC_UnregisterMulticastFunc(uint32_t mltcstFuncId);
extern RpcResult_t IPC_SignupMulticastFunc(uint32_t mltcstFuncId, uint32_t funcId);
extern RpcResult_t IPC_ResignMulticastFunc(uint32_t mltcstFuncId, uint32_t funcId);
extern RpcResult_t IPC_GetFuncListByMltcstFuncId(uint32_t mltcstFuncId, RpcList_t **funcList);
extern void IPC_FreeFuncList(RpcList_t *funcList);

#endif	/* USE_MULTICAST_RPC */

#endif /* IPCSHMDB_H_ */
